h06726
s 00014/00000/00923
d D 1.83 90/08/22 23:16:37 alan 83 82
c added fix for syscall and intr problem in magnify_cpu()
e
s 00004/00004/00919
d D 1.82 90/08/21 22:43:23 alan 82 81
c dust off lint
e
s 00010/00000/00913
d D 1.81 90/03/29 16:16:44 alan 81 80
c The hack to fix the DECmumble include file problem.
e
s 00011/00005/00902
d D 1.80 89/12/25 17:34:21 alan 80 79
c added more SMP stuff to V4.0 screen
e
s 00018/00000/00889
d D 1.79 89/04/19 11:33:54 alan 79 78
c enable magnification if only BUF, SWAP or NAMEI are turned on
e
s 00006/00002/00883
d D 1.78 89/03/11 16:00:12 alan 78 77
c changed the structure of mon_fork and the other changes that required
e
s 00006/00004/00879
d D 1.77 89/02/16 20:01:45 alan 77 76
c dust off some lint
e
s 00003/00004/00880
d D 1.76 89/02/16 19:03:29 alan 76 75
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00007/00003/00877
d D 1.75 89/02/15 19:28:54 alan 75 74
c properly set mon_flag in all records
e
s 00014/00010/00866
d D 1.74 89/01/15 20:42:45 alan 74 73
c changes for CPU and PAGE data structures
e
s 00011/00001/00865
d D 1.73 88/06/27 18:16:56 alan 73 72
c changed include of monitor.h and record.h
e
s 00025/00001/00841
d D 1.72 88/04/22 21:50:45 alan 72 71
c Increase the number of lines dumped in a screen dump when disk totals are
c turned on.
c 
e
s 00009/00009/00833
d D 1.71 87/11/18 16:40:07 alan 71 70
c V0.99 -> T1.0-1
e
s 00000/00000/00842
d D 1.70 87/11/17 16:16:40 alan 70 69
c The previous version should have been V0.97.
c 
e
s 00020/00014/00822
d D 1.69 87/11/17 15:43:34 alan 69 68
c V0.98 changes
e
s 00009/00000/00827
d D 1.68 87/09/14 18:56:09 alan 68 67
c see V0.96 in version.c for details
e
s 00044/00029/00783
d D 1.67 87/08/10 21:27:59 alan 67 66
c See commentary on V0.92 in version.c
e
s 00090/00071/00722
d D 1.66 87/05/25 13:11:42 alan 66 65
c I did an little bit of code clean up and added a table of <x,y>
c coordinates that I might use in the big Hack.
c 
e
s 00015/00000/00778
d D 1.65 87/05/21 10:10:10 alan 65 64
c A quick hack to fix the multiple session display problem.  To fix
c this properly I need rewrite the screen code and much of the magnification
c functions.  I wanted to get this now so that the bug would go away.
c 
e
s 00131/00109/00647
d D 1.64 87/05/20 17:16:33 alan 64 63
c changed all curses calls to use w... versions
e
s 00135/00097/00621
d D 1.63 87/04/17 15:46:11 alan 63 62
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00717
d D 1.62 87/04/03 14:30:18 alan 62 61
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00002/00003/00716
d D 1.61 87/03/03 17:09:18 alan 61 60
c 1.  Increase width of memory fields.
c 2.  Remove "ract" (active real memory) from memory fields to make
c     space for #1.
c 
e
s 00010/00011/00709
d D 1.60 87/03/03 15:41:06 alan 60 59
c see the commentary for V0.83 in version.c
e
s 00011/00041/00709
d D 1.59 87/02/05 16:29:48 alan 59 58
c See comment on V0.81 in version.c.
c 
e
s 00002/00002/00748
d D 1.58 87/01/30 20:49:02 alan 58 57
c see commentary for V0.77 in version.c
c 
e
s 00016/00006/00734
d D 1.57 87/01/30 16:08:42 alan 57 56
c See commenary on V0.76 in version.c
e
s 00011/00012/00729
d D 1.56 87/01/30 13:03:55 alan 56 55
c see commentary on V0.75 in version.c
e
s 00002/00004/00739
d D 1.55 87/01/30 10:16:23 alan 55 54
c fixes to delta_disk()
e
s 00004/00003/00739
d D 1.54 87/01/29 15:13:33 alan 54 53
c Changes to delta_netif(), V0.72
c 
e
s 00003/00002/00739
d D 1.53 87/01/29 13:09:18 alan 53 52
c changes to delta_fork(), V0.71
c 
e
s 00006/00002/00735
d D 1.52 87/01/28 21:05:52 alan 52 51
c V0.70
e
s 00004/00000/00733
d D 1.51 87/01/21 16:37:37 alan 51 50
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00010/00008/00723
d D 1.50 86/12/30 21:16:37 alan 50 49
c see commentary on V0.65
e
s 00027/00014/00704
d D 1.49 86/12/30 11:20:06 alan 49 48
c See commentary on V0.64 in version.c
e
s 00011/00002/00707
d D 1.48 86/12/24 23:31:26 alan 48 47
c See commentary on V0.63 in version.c.  Cpu.c may not have changed.
c 
e
s 00021/00004/00688
d D 1.47 86/12/12 15:37:05 alan 47 46
c see commentary on V0.61
e
s 00030/00019/00662
d D 1.46 86/12/07 22:21:26 alan 46 45
c See V0.57 in version.c
e
s 00020/00006/00661
d D 1.45 86/11/18 12:42:31 alan 45 44
c See commentary on V0.55 in version.c
c 
e
s 00003/00002/00664
d D 1.44 86/11/16 16:31:16 alan 44 43
c See comments for V0.51 in version.c
c 
e
s 00004/00002/00662
d D 1.43 86/11/02 16:15:52 alan 43 42
c See V0.50 in version.c
c 
e
s 00001/00001/00663
d D 1.42 86/09/29 20:12:24 alan 42 41
c fine tune 1200 baud sleep time
e
s 00001/00001/00663
d D 1.41 86/09/29 20:02:49 alan 41 40
c remove the lint
e
s 00043/00000/00621
d D 1.40 86/09/29 16:36:48 alan 40 39
c added code and mods for makeing the sleep time dependent on the output
c tty speed.
c 
e
s 00020/00002/00601
d D 1.39 86/08/26 17:01:05 alan 39 38
c added code for changeing window size and modified SccsId
c 
e
s 00020/00054/00583
d D 1.38 86/07/30 17:27:18 alan 38 37
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00009/00014/00628
d D 1.37 86/07/27 14:09:07 alan 37 36
c Convert CPU's to array's instead of linked lists.  I also cleaned up some
c lint in the process.  Disks and tapes will be next...
c 
e
s 00209/00000/00433
d D 1.36 86/07/13 15:09:17 alan 36 35
c merge format.c into screen.c
e
s 00003/00010/00430
d D 1.35 86/07/13 14:39:38 alan 35 34
c dust off even more lint
e
s 00003/00002/00437
d D 1.34 86/07/11 19:26:46 alan 34 33
c Dust off LOTS of lint...
c 
e
s 00014/00014/00425
d D 1.33 86/07/01 12:56:29 alan 33 32
c Since delta_fork and delta_tty always know where their data structure
c is, I removed the argument and replace it with the external reference.
c 
e
s 00004/00010/00435
d D 1.32 86/06/30 08:22:12 alan 32 31
c Added code for a generalized redraw_display function.
c 
e
s 00002/00005/00443
d D 1.31 86/06/29 15:27:21 alan 31 30
c Assorted work on the magnify function and general cleanup.
c 
e
s 00001/00000/00447
d D 1.30 86/06/24 17:30:02 alan 30 29
c add clrtoeol() to screen_prompt()
e
s 00002/00002/00445
d D 1.29 86/06/24 08:34:37 alan 29 28
c Move the various version of mon_etime into the sample record.
c 
e
s 00007/00005/00440
d D 1.28 86/06/13 15:49:08 alan 28 27
c Make printing of the load averages dependent on MON$N_LOADAVE.  If
c Ultrix ever provides a constant for this, it will change accordingly.
c 
e
s 00003/00002/00442
d D 1.27 86/06/13 15:37:02 alan 27 26
c remove 4th loadave
e
s 00051/00000/00393
d D 1.26 86/05/30 19:46:20 alan 26 25
c added to allow replaying multiple sessions
e
s 00001/00001/00392
d D 1.25 86/05/29 18:06:31 alan 25 24
c Moved the string for the TOTAL_LINE from screen.c to screen.h.
c 
e
s 00033/00029/00360
d D 1.24 86/05/29 17:45:41 alan 24 23
c Finished adding code that would print disk totals when opt_total was
c turned on.  There was also a bug in limit() which caused a and b to
c set to the same value if they had to changed and a > b.
c Changed the number of lines really available to reflect reality.
c 
e
s 00001/00001/00388
d D 1.23 86/05/29 11:25:31 alan 23 22
c moved the users field
e
s 00015/00022/00374
d D 1.22 86/05/26 15:52:43 alan 22 21
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00065/00064/00331
d D 1.21 86/05/26 14:10:47 alan 21 20
c Cleaned up the linked-list/array walks.
c 
e
s 00002/00018/00393
d D 1.20 86/05/26 13:39:14 alan 20 19
c Move to code that actually calculates interesting disk from screen.c to disk.c
c 
e
s 00098/00093/00313
d D 1.19 86/05/25 18:36:33 alan 19 18
c Added "smart" code to setup the format of the screen.
c format.c still needs work.  It is very ugly and don't run out screen
c space gracefully even though the most of the code is there.  (limit()
c is empty)
c 
e
s 00009/00008/00397
d D 1.18 86/05/24 19:35:55 alan 18 17
c I made some big changes to options.h and how options where being handled.
c The changes to these files reflect those.  Most of the changes were caused
c by changing the names of things.
c 
c Added note: this is probably the last version of gather.c because it
c is going to become live.c very soon.
c 
e
s 00013/00008/00392
d D 1.17 86/05/23 19:41:19 alan 17 16
c clean up for changes to delta_ functions
e
s 00000/00009/00400
d D 1.16 86/05/23 12:13:17 alan 16 15
c take out the call to readk()
e
s 00001/00000/00408
d D 1.15 86/05/23 09:09:05 alan 15 14
c added refresh() to screen_prompt()
e
s 00025/00005/00383
d D 1.14 86/05/22 10:21:38 alan 14 13
c changed init and uninit to open and close.
c Moved curses cleanup code into cleanup_screen()
c 
e
s 00065/00006/00323
d D 1.13 86/05/21 18:41:57 alan 13 12
c 1.  When replay read the disk, tape, interface and cpu data, it will be
c     read into array and the pointers to ...->mon_next will get overwritten
c     each time.  I added code so that if replay was in use the screen function
c     would simluate the array being a linked list.  It is untested at the
c     moment, but it didn't break the linked list code.
c 2.  I added very basic code for doing tapes.  Since the only tape data
c     available is the name and unit number, if tapes are turned they will
c     printed as part of the headings after the disk.  No other data will
c     be printed and code for it in screen() is commented out.
c 
e
s 00085/00055/00244
d D 1.12 86/05/19 15:52:00 alan 12 11
c replaced the ..._X, _Y, _HX and _HY with _X, _Y and _OFF.  This puts
c me into a better position to make the screen format "smart".
c 
e
s 00004/00015/00295
d D 1.11 86/05/19 12:25:53 alan 11 10
c 1.  Reorganize the output format.
c     screen.c - moved all formatting info into screen.h.
c     screen.h - move the fields around by adding and subtracting numbers
c     from the previous version.
c 
e
s 00002/00002/00308
d D 1.10 86/05/18 16:28:35 alan 10 9
c swaped _X and _Y for PAGE1 and 2.
e
s 00091/00018/00219
d D 1.9 86/05/18 14:15:27 alan 9 8
c 1.  Added call to dumpit() in monitor.c
c 2.  Added disk, netif and pageing data to screen function.
c 
e
s 00143/00049/00094
d D 1.8 86/05/12 20:22:28 alan 8 7
c Added a whole lot of code to make it look like "mon".  It does.
c Still need to add processing for netif, disk and pageing.
c 
e
s 00019/00017/00124
d D 1.7 86/05/08 12:31:18 alan 7 6
c I changed all the data references so that it would compile.  This is a Kludge.
c Since I am just working on the save() function at the moment I don't really
c care.  I fix it later.  Really.  I promise...
c 
e
s 00028/00017/00113
d D 1.6 86/05/07 10:45:16 alan 6 5
c replaced formats with ..._FORMAT in screen.h
e
s 00007/00007/00123
d D 1.5 86/05/04 16:50:13 alan 5 4
c merge in changes for addition of record.h and eventual data structure
e
s 00004/00004/00126
d D 1.4 86/04/23 17:23:04 alan 4 3
c Changed all occurances of "idle" to "monitor"
c 
e
s 00106/00001/00024
d D 1.3 86/04/23 16:07:14 alan 3 2
c And on the second day...
c 
e
s 00005/00000/00020
d D 1.2 86/04/22 15:28:03 alan 2 1
c assorted changes
e
s 00020/00000/00000
d D 1.1 86/04/22 10:16:01 alan 1 0
c date and time created 86/04/22 10:16:01 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 3
 *	%M% - 
E 3
I 3
D 45
 *	%M% - Print the data on the screen.  This is a curses(3) based
 *		version of the output function.  An X version will
 *		probably appear in window.c if I get that ambitious.
E 45
I 45
 *	%M% - Print the data on the screen.  This is a curses(3)
D 66
 *	based *	version of the output function.  An X version will
E 66
I 66
 *	based version of the output function.  An X version will
E 66
 *	probably appear in window.c if I get that ambitious.
E 45
I 36
 *
 *	The source for screen_format was merged from format.c V1.9.
E 36
E 3
 */
#ifndef	lint
D 39
static	char	SccsId[] = "%W% %G%" ;
E 39
I 39
D 43
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 43
I 43
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 43
E 39
#endif

I 73
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 74
 *
 * Jan. 5, 1989 -- arr
 *
 *	Fix references to the mon_meter data structure.
I 75
 *
 * Feb. 15, 1989 -- arr
 *
D 76
 *	Check to make sure that mon_flag is correctly set using MON$M_VALID.
E 76
I 76
 *	Check to make sure that mon_flag is correctly set using 
 *	MON$M_VALID.  Also removed the pgtok macros in favor of
 *	functions.
I 78
 *
 * March 11, 1989 -- arr
 *
 *	Changed needed for change to mon_fork structure in monitor.h.
I 81
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
I 83
 * Aug. 22, 1990 -- arr
 *
 *	Fix a problem for magnify_cpu() that was causeing the
 *	number of system calls and device interrupts to be too
 *	high.
E 83
E 81
E 78
E 76
E 75
E 74
 */

E 73
I 2
#include <nlist.h>
I 6
#include <stdio.h>
#include <signal.h>
#include <curses.h>

E 6
E 2
#include <sys/types.h>
I 51
D 52
#include <sys/devio.h>
E 52
I 52
D 57
#ifdef	V20
#	include <sys/devio.h>
#endif
E 57
E 52
E 51
I 2
D 6
#include <sys/vm.h>
E 6
I 6
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
I 39
#include <sys/ioctl.h>
E 39
E 6
#include <sys/dk.h>
I 51
#include <sys/param.h>
#include <sys/dir.h>
I 81

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 81
#include <sys/user.h>
E 51
I 3
D 6
#include <machine/param.h>
E 6
I 6
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 6
E 3

D 6
#include <curses.h>
E 6
I 6
#include <net/if.h>
#include <netinet/in.h>
E 6
E 2

D 4
#include "idle.h"
E 4
I 4
D 6
#include "monitor.h"
E 6
I 6
D 76
#include <machine/param.h>

E 76
I 73
#include "include.h"
E 73
I 57
D 59
#ifdef	V20
#	include <sys/devio.h>
#endif

E 59
E 57
E 6
E 4
D 62
#include "extern.h"
E 62
I 3
D 6
#include "options.h"
#include "screen.h"
E 6
I 6
#include "monitor.h"
D 73
#include "record.h"
E 73
I 7
#include "screen.h"
#include "options.h"
I 62
#include "extern.h"
I 66
D 76
#include "pgtok.h"
E 76
E 66
E 62
E 7
E 6
E 3

I 45
/*
D 66
 *	pgtok - Turn number of pages into Kilobytes.
E 66
 *	SPACE - Number of spaces between fields.
 */
E 45
I 8
D 12

E 12
D 66
#define	pgtok(a)	((a)*NBPG/1024)
E 66
I 36
#define	SPACE		(3)
E 36

E 8
I 3
/*
I 46
 *	Various functions used that don't return (int).
 */
I 52
D 53
double	delta_tty() ;
E 53
I 53
D 57
double	delta_tty(),
E 57
I 57
double	calculate_disk(),
	delta_tty(),
E 57
I 56
	delta_cpu(),
E 56
D 54
	delta_fork() ;
E 54
I 54
	delta_fork(),
	delta_netif() ;
E 54
E 53

I 83
void	delta_syscall_intr() ;

E 83
E 52
char	*strchr(),
	*ctime(),
	*str_data() ;

/*
E 46
I 45
D 66
 *	Module name for error functions.
E 66
I 66
 *	Module name for error functions.  This currently isn't being
 *	used.  If it isn't being used after I'm done hacking the
 *	screen code then it needs to go away.
E 66
 */
I 66
#ifndef	lint
E 66
static	char	*module = "screen" ;
I 66
#endif
E 66

/*
I 64
 *	Assorted externs.
 */
D 66
extern int	debug ;
extern OPTION	option ;
E 66
I 66
extern int	changed_size ;		/* flag to say that window has changed size */
extern int	lines ;			/* length of display being used */
extern WINDOW	*wp ;			/* default display window */
E 66

D 66
/*
 *	Display information.
 */
extern	int	lines ;
extern	int	width ;
extern	WINDOW	*wp ;
E 66
I 66
D 67
struct coordinates {
	int	y, x ;
} coord[] = {
		0,	   0,	/* first */
		0,	   0,	/* last */
		0,	   0,	/* sample */
		0, 	   0,	/* rectype3 */
E 66

I 66
	    CPU_Y,     CPU_X,	/* cpu */
	    TTY_Y,     TTY_X,	/* tty */
	   DISK_Y,    DISK_X,	/* disk */
	   FREE_Y,    FREE_X,	/* free */
	   FORK_Y,    FORK_X,	/* fork */
	   PAGE_Y,    PAGE_X,	/* page */
	   PROC_Y,    PROC_X,	/* proc */
		0,	   0,	/* swap */
		0,	   0,	/* tape */
	   USER_Y,    USER_X,	/* user */
	  NETIF_Y,   NETIF_X,	/* netif */
	 MEMORY_Y,  MEMORY_X,	/* memory */
	LOADAVE_Y, LOADAVE_X,	/* loadave */
		0,	   0,	/* pid */
		0,	   0,	/* panic */
} ;

E 67
E 66
/*
E 64
E 45
I 36
 *	<x,y> positions for the various fields.
 */
int	cpu_y = CPU_Y, cpu_x = CPU_X,
	tty_y = TTY_Y, tty_x = TTY_X,
	proc_y = PROC_Y, proc_x = PROC_X,
D 59
	tape_y = TAPE_Y, tape_x = TAPE_X,
E 59
	free_y = FREE_Y, free_x = FREE_X,
	fork_y = FORK_Y, fork_x = FORK_X,
	disk_y = DISK_Y, disk_x = DISK_X,
I 66
	user_y = USER_Y, user_x = USER_X,
E 66
	netif_y = NETIF_Y, netif_x = NETIF_X,
D 66
	page1_y = PAGE1_Y, page1_x = PAGE1_X,
E 66
I 66
	page_y = PAGE_Y, page_x = PAGE_X,
E 66
	page2_y = PAGE2_Y, page2_x = PAGE2_X,
D 66
	memory_y = MEMORY_Y, memory_x = MEMORY_X ;
E 66
I 66
	memory_y = MEMORY_Y, memory_x = MEMORY_X,
	loadave_y = LOADAVE_Y, loadave_x = LOADAVE_X ;
E 66
I 65

E 65
/*
 *	Line that the last ... will be on because of lack of space.
 */
D 59
int	last_disk, last_tape, last_cpu, last_netif ;
E 59
I 59
int	last_disk, last_cpu, last_netif ;
E 59

/*
I 39
D 66
 *	This will be set by catch_sigwinch(), checked and cleared by 
 *	redraw_screen() if the screen changed size.
 */
int	changed_size = 0 ;

/*
E 66
E 39
E 36
I 12
D 19
 *
 */
static	cpu_y = CPU_Y, cpu_x = CPU_X,
	tty_y = TTY_Y, tty_x = TTY_X,
	proc_y = PROC_Y, proc_x = PROC_X,
	free_y = FREE_Y, free_x = FREE_X,
	fork_y = FORK_Y, fork_x = FORK_X,
	disk_y = DISK_Y, disk_x = DISK_X,
	netif_y = NETIF_Y, netif_x = NETIF_X,
	page1_y = PAGE1_Y, page1_x = PAGE1_X,
	page2_y = PAGE2_Y, page2_x = PAGE2_X,
	memory_y = MEMORY_Y, memory_x = MEMORY_X,
	states_y = STATES_Y, states_x = STATES_X ;

/*
E 19
E 12
D 6
 *
E 6
I 6
 *	Do whatever needs to be done to initialize the screen.  I suggest
 *	turning on curses and printing the headers.
E 6
 */
D 8
init_screen()
E 8
I 8
D 14
init_screen(op)
E 14
I 14
open_screen(op)
OPTION	*op ;
E 14
E 8
{
I 39
D 64
	struct winsize window ;
E 64
I 64
D 66
	struct winsize window_data ;
E 66
I 66
	/*
	 *	Setup the screen for use with curses.
	 */
	setup_curses(op, -1, -1) ;
E 66
E 64

E 39
I 6
D 44
	using_curses = 1 ;

E 44
I 39
D 64
	if( getwindowsize(&window) != -1 ) {
		LINES = window.ws_row ;
		COLS = window.ws_col ;
	}

E 64
E 39
E 6
D 35
	initscr();
E 35
I 35
D 66
	if( initscr() == NULL )
D 45
		fatal("monitor: screen: can't initialize screen: %s.\n");
E 45
I 45
		fatal("can't initialize screen: %s.\n", module);
E 45

I 64
	if( getwindowsize(&window_data) != -1 ) {
		LINES = lines = window_data.ws_row ;
		COLS  = width = window_data.ws_col ;
	}
	else {
		lines = LINES ;
		width =  COLS ;
	}

	if((wp = newwin(lines, width, 0, 0)) == NULL )
		fatal("can't create window.\n", module) ;

E 64
I 44
	op->opt_curses = 1 ;

I 64
#ifdef	DEBUG
	if( debug )
		sleep(2) ;
#endif

E 64
E 44
E 35
	crmode();
	noecho();
I 12

E 66
I 40
	/*
	 *	Set the sleep time dependent on the terminal speed.
I 43
	 *	In REPLAY mode, the sleep time will be be used unless
	 *	set from the command line.
E 43
	 */
D 43
	if( op->sleep_set == 0 )
E 43
I 43
	if( !op->sleep_set && op->collect_mode != OPT_REPLAY )
E 43
		first.mon_sleep = op->opt_sleep = ttyspeed() ;

E 40
E 12
D 9
	screen_headings();
E 9
I 9
D 19
	screen_headings(op);
E 19
I 19
D 59
	screen_format(op, n_cpu, n_disk, n_tape, n_netif) ;
E 59
I 59
D 66
	screen_format(op, n_cpu, n_disk, n_netif) ;
E 66
I 66
	screen_format(op, first.mon_cpu, first.mon_disk, first.mon_netif) ;
E 66
E 59

I 79
	/*
	 *	If the -sample option is turned on then turn on the
	 *	sample data option.
	 */
E 79
D 32
	screen_headings(op) ;
E 32
I 32
D 48
	redraw_screen(op) ;
E 48
I 48
	if( op->opt_mag_sample )
		op->opt_sample = 1 ;
	else
		op->opt_sample = 0 ;

I 79
	/*
	 *	If PID is in the data, magnify it.
	 */
E 79
I 60
	if( op->opt_pid )
		op->opt_magnify |= MON$M_PID ;
I 79

	/*
	 *	If only SWAP, BUF or NAMEI are turned on, then
	 *	turn magnify it.
	 */
	if((op->opt_data & MON$M_ALL) == MON$M_SWAP )
		op->opt_magnify |= MON$M_SWAP ;
	else if((op->opt_data & MON$M_ALL) == MON$M_BUF )
		op->opt_magnify |= MON$M_BUF ;
	else if((op->opt_data & MON$M_ALL) == MON$M_NAMEI )
		op->opt_magnify |= MON$M_NAMEI ;
E 79

E 60
	if( op->opt_magnify )
		(void)select_function(op->opt_magnify, op) ;

	if( op->redraw_display )
		(*op->redraw_display)(op) ;
E 48
E 32
E 19
I 14
D 16
/*
 *	Prime the fork stats.
 */
	if( op->opt_fork ) {
		readk((long)namelist[NM_FORK].n_value, (char *)&fork.mon_fork,
			sizeof(fork.mon_fork));

		delta_fork(&fork);
	}
E 16
E 14
E 9
}

/*
D 6
 *
E 6
I 6
 *	Do whatever needs to be done to clean up.
I 14
 *
 *	close_screen() might be extended someday to actually use the
 *	option structure.  Because of this the cleanup function which
 *	has been used in the error functions was moved out by itself.
I 45
 *
 *	ARGSUSED
E 45
E 14
E 6
 */
I 34
D 45
/* ARGSUSED */
E 45
E 34
D 8
uninit_screen()
E 8
I 8
D 14
uninit_screen(op)
E 14
I 14
close_screen(op)
OPTION	*op ;
E 14
E 8
{
D 14
	mvprintw(LINES-1,0,"\n");
	refresh();
	endwin();
E 14
I 14
D 63
	cleanup_screen() ;
E 63
I 63
	/*
	 *	This will only need to be called in OPT_SCREEN mode.
	 */
D 64
	cleanup_screen(op) ;
E 64
I 64
	cleanup_screen() ;
E 64
D 66

	endwin() ;
E 66
E 63
}

D 63
cleanup_screen()
E 63
I 63
D 64
cleanup_screen(op)
OPTION	*op ;
E 64
I 64
cleanup_screen()
E 64
E 63
{
D 63
	mvprintw(LINES-1, 0, "\n");
	refresh() ;
	endwin() ;
E 63
I 63
D 64
	wmove(stdscr, LINES - 1, 0) ;
	wprintw(stdscr, "\n");
	wrefresh(stdscr) ;
E 64
I 64
D 66
	wmove(wp, lines - 1, 0) ;
E 66
I 66
	wmove(wp, LINES - 1, 0) ;
E 66
	wprintw(wp, "\n");
	wrefresh(wp) ;
I 66

	/*
	 *	endwin() should return the state of the world to
	 *	normal.
	 */
	endwin() ;
E 66
E 64
E 63
E 14
}

/*
I 9
D 60
 *	A macro to shorten the names of the pageing data.
 */
D 33
#define	Rate	page.mon_meter
E 33
I 33
#define	Page	page.mon_meter
E 33

/*
E 60
E 9
D 45
 *
E 45
I 45
 *	Format the data for output to the screen.
E 45
 */
E 3
D 8
screen()
E 8
I 8
screen(op)
OPTION	*op ;
E 8
{
I 28
	register i ;
I 46
D 54
	double	 etime = sample.mon_etime ;
E 54
I 54
	double	 etime ;
E 54
E 46

E 28
I 3
D 6
	static	DATA	current, previous ;
E 6
I 6
D 8
	static	struct mon_state current, previous ;
E 6
	double	tmp, total_time ;
	int	i ;
E 8
I 8
D 24
	int	cursor = 0 ;
I 13
D 19
	int	count ;
E 19
E 13
D 21
	struct	mon_disk *dp ;
I 19
	struct	mon_tape *tp ;
E 19
	struct	mon_netif *np ;
	struct	mon_state *sp ;
D 9
	double	total_time, cpu_time() ;
E 9
I 9
	double	total_time, cpu_time(), idle_time, xfer_time, words ;
E 21
I 21
	double	total_time, cpu_time(), idle_time, words ;
E 21
E 9
D 11
	static	old_in, old_out, old_fork, old_vfork ;
E 11
E 8

E 24
D 6
	current = data ;
E 6
I 6
D 7
	current = state ;
E 7
I 7
D 8
	current = *state ;
E 8
I 8
	print_semi_static() ;
E 8
E 7
E 6

D 8
	total_time = 0. ;
E 8
I 8
D 28
	if( op->opt_loadave )
		mvprintw(LOADAVE_Y, LOADAVE_X, LOADAVE_FORMAT,
D 27
			loadave.mon_loadave[0], loadave.mon_loadave[1],
			loadave.mon_loadave[2], loadave.mon_loadave[3]);
E 27
I 27
			loadave.mon_loadave[0],
			loadave.mon_loadave[1],
			loadave.mon_loadave[2]);
E 28
I 28
	if( op->opt_loadave ) {
D 63
		move(LOADAVE_Y, LOADAVE_X);
E 63
I 63
D 64
		wmove(stdscr, LOADAVE_Y, LOADAVE_X);
E 64
I 64
D 66
		wmove(wp, LOADAVE_Y, LOADAVE_X);
E 66
I 66
		wmove(wp, loadave_y, loadave_x);
E 66
E 64
E 63
		for(i = 0 ; i < MON$N_LOADAVE; i++)
D 63
			printw(LOADAVE_FORMAT, loadave.mon_loadave[i]);
E 63
I 63
D 64
			wprintw(stdscr, LOADAVE_FORMAT, loadave.mon_loadave[i]);
E 64
I 64
			wprintw(wp, LOADAVE_FORMAT, loadave.mon_loadave[i]);
E 64
E 63
	}
E 28
E 27
E 8

D 8
	for(i = 0; i < CPUSTATES; i++) {
D 6
		tmp = current.cpu_time[i] ;
		current.cpu_time[i] -= previous.cpu_time[i] ;
		previous.cpu_time[i] = tmp ;
		total_time += current.cpu_time[i] ;
E 6
I 6
D 7
		tmp = current.mon_cp_time[i] ;
		current.mon_cp_time[i] -= previous.mon_cp_time[i] ;
		previous.mon_cp_time[i] = tmp ;
		total_time += current.mon_cp_time[i] ;
E 7
I 7
		tmp = current.mon_time[i] ;
		current.mon_time[i] -= previous.mon_time[i] ;
		previous.mon_time[i] = tmp ;
		total_time += current.mon_time[i] ;
E 7
E 6
	}
E 8
I 8
D 63
	if( op->opt_user )
D 23
		mvprintw(USERS_Y, USERS_X, "%d user%s", user.mon_user,
E 23
I 23
D 60
		mvprintw(USERS_Y, USERS_X, "%3d user%s", user.mon_user,
E 23
			user.mon_user == 1 ? " " : "s");
E 60
I 60
		mvprintw(USERS_Y, USERS_X, "%3d user%s", mon_user.mon_user,
E 63
I 63
	if( op->opt_user ) {
D 64
		wmove(stdscr, USERS_Y, USERS_X) ;
		wprintw(stdscr, "%3d user%s", mon_user.mon_user,
E 64
I 64
D 66
		wmove(wp, USERS_Y, USERS_X) ;
E 66
I 66
		wmove(wp, user_y, user_x) ;
E 66
		wprintw(wp, "%3d user%s", mon_user.mon_user,
E 64
E 63
			mon_user.mon_user == 1 ? " " : "s");
I 63
	}
E 63
E 60
E 8

D 6
	print_info(&current, total_time);
E 6
I 6
D 8
	print_info(total_time);
E 8
I 8
D 57
	if( op->opt_proc )
E 57
I 57
	if( op->opt_proc ) {
		proc_ticks = sample.mon_ticks ;
E 57
D 12
		mvprintw(PROC_Y, PROC_X, PROC_FORMAT, proc.mon_rq,
E 12
I 12
D 60
		mvprintw(proc_y+1, proc_x+PROC_OFF, PROC_FORMAT, proc.mon_rq,
E 12
			proc.mon_dw, proc.mon_pw, proc.mon_sl, proc.mon_sw);
E 60
I 60
D 63
		mvprintw(proc_y+1, proc_x+PROC_OFF, PROC_FORMAT,
			mon_proc.mon_rq, mon_proc.mon_dw, mon_proc.mon_pw,
			mon_proc.mon_sl, mon_proc.mon_sw);
E 63
I 63

D 64
		wmove(stdscr, proc_y + 1, proc_x + PROC_OFF) ;
		wprintw(stdscr, PROC_FORMAT, mon_proc.mon_rq, mon_proc.mon_dw,
E 64
I 64
		wmove(wp, proc_y + 1, proc_x + PROC_OFF) ;
		wprintw(wp, PROC_FORMAT, mon_proc.mon_rq, mon_proc.mon_dw,
E 64
D 69
			mon_proc.mon_pw, mon_proc.mon_sl, mon_proc.mon_sw);
E 69
I 69
			mon_proc.mon_pw, mon_proc.mon_sl);
E 69
E 63
E 60
I 57
	}
E 57
E 8
E 6

D 8
	refresh();
}
E 8
I 8
D 12
	if( op->opt_memory )
		mvprintw(MEMORY_Y, MEMORY_X, MEMORY_FORMAT,
			pgtok(memory.mon_rm),
			pgtok(memory.mon_arm),
			pgtok(memory.mon_vm),
			pgtok(memory.mon_avm),
E 12
I 12
	if( op->opt_memory ) {
I 57
		memory_ticks = sample.mon_ticks ;

E 57
D 63
		mvprintw(memory_y+1, memory_x+MEMORY_OFF, MEMORY_FORMAT,
D 61
			pgtok(memory.mon_rm), pgtok(memory.mon_arm),
			pgtok(memory.mon_vm), pgtok(memory.mon_avm),
E 12
			pgtok(memory.mon_free)) ;
E 61
I 61
			pgtok(memory.mon_rm), pgtok(memory.mon_vm),
			pgtok(memory.mon_avm), pgtok(memory.mon_free)) ;
E 63
I 63
D 64
		wmove(stdscr, memory_y + 1, memory_x + MEMORY_OFF) ;
		wprintw(stdscr, MEMORY_FORMAT, pgtok(memory.mon_rm),
E 64
I 64
		wmove(wp, memory_y + 1, memory_x + MEMORY_OFF) ;
		wprintw(wp, MEMORY_FORMAT, pgtok(memory.mon_rm),
E 64
			pgtok(memory.mon_vm), pgtok(memory.mon_avm),
			pgtok(memory.mon_free)) ;
E 63
E 61
D 12
	else if( op->opt_free )
		mvprintw(FREE_Y, FREE_X, FREE_FORMAT, 
E 12
I 12
	}
	else if( op->opt_free ) {
I 57
		memory_ticks = sample.mon_ticks ;

E 57
D 63
		mvprintw(free_y+1, free_x+FREE_OFF, FREE_FORMAT, 
E 12
D 60
			pgtok(freemem.mon_freemem));
E 60
I 60
			pgtok(mon_free.mon_freemem));
E 63
I 63
D 64
		wmove(stdscr, free_y + 1, free_x + FREE_OFF) ;
		wprintw(stdscr, FREE_FORMAT, pgtok(mon_free.mon_freemem));
E 64
I 64
		wmove(wp, free_y + 1, free_x + FREE_OFF) ;
		wprintw(wp, FREE_FORMAT, pgtok(mon_free.mon_freemem));
E 64
E 63
E 60
I 12
	}
E 12
E 8

D 8
#define	pgtok(a)	((a)*NBPG/1024)
E 8
I 8
	if( op->opt_fork ) {
D 11
		register t ;
E 8

D 6
print_info(dp, total_time)
DATA	*dp ;
E 6
I 6
D 8
print_info(total_time)
E 6
double	total_time ;
{
	long	clock = time(0);
	char	*ctime(), *index(), *newline, *time_string ;
	char	hostname[BUFSIZ] ;
E 8
I 8
		t = fork.mon_fork.cntfork ; 
		    fork.mon_fork.cntfork -= old_fork ;
		    old_fork = t ;
		t = fork.mon_fork.cntvfork ; 
		    fork.mon_fork.cntvfork -= old_vfork ;
		    old_vfork = t ;
E 11
I 11
D 33
		delta_fork(&fork);
E 33
I 33
D 53
		delta_fork();
E 53
I 53
		etime = delta_fork(sample.mon_ticks);
E 53
E 33
E 11
		
D 12
		mvprintw(FORK_Y, FORK_X, FORK_FORMAT, fork.mon_fork.cntfork,
			fork.mon_fork.cntvfork);
E 12
I 12
D 63
		mvprintw(fork_y+1, fork_x+FORK_OFF, FORK_FORMAT, 
D 33
			fork.mon_fork.cntfork, fork.mon_fork.cntvfork);
E 33
I 33
D 46
			Fork.cntfork, Fork.cntvfork);
E 46
I 46
			Fork.cntfork / etime,
E 63
I 63
D 64
		wmove(stdscr, fork_y + 1, fork_x + FORK_OFF) ;
		wprintw(stdscr, FORK_FORMAT, Fork.cntfork / etime,
E 64
I 64
		wmove(wp, fork_y + 1, fork_x + FORK_OFF) ;
D 78
		wprintw(wp, FORK_FORMAT, Fork.cntfork / etime,
E 64
E 63
			Fork.cntvfork / etime);
E 78
I 78
		wprintw(wp, FORK_FORMAT, mon_fork.mon_fork / etime,
			mon_fork.mon_vfork / etime);
E 78
E 46
E 33
E 12
	}
E 8

D 8
	time_string = ctime(&clock);
	if((newline = index(time_string, '\n')) != NULL )
		*newline = '\0' ;
E 8
I 8
D 19
	if( op->opt_cpu )
E 19
I 19
D 22
	if( op->opt_cpu ) {
E 19
D 12
		mvprintw(CPU_Y, CPU_X, CPU_FORMAT, 
E 12
I 12
		mvprintw(cpu_y+1, cpu_x+CPU_OFF, CPU_FORMAT, 
E 12
D 11
			cpu.mon_intr - first.mon_hz,
			cpu.mon_syscall, cpu.mon_swtch);
E 11
I 11
			cpu.mon_swtch, cpu.mon_intr - first.mon_hz,
			cpu.mon_syscall);
I 19
	}
E 19
E 11

E 22
I 9
	if( op->opt_page ) {
I 57
		paging_ticks = sample.mon_ticks ;

E 57
D 10
		mvprintw(PAGE1_X, PAGE1_Y, PAGE1_FORMAT,
E 10
I 10
D 12
		mvprintw(PAGE1_Y, PAGE1_X, PAGE1_FORMAT,
E 12
I 12
D 63
		mvprintw(page1_y+1, page1_x+PAGE1_OFF, PAGE1_FORMAT,
E 63
I 63
D 64
		wmove(stdscr, page1_y + 1, page1_x + PAGE1_OFF) ;
		wprintw(stdscr, PAGE1_FORMAT,
E 64
I 64
D 66
		wmove(wp, page1_y + 1, page1_x + PAGE1_OFF) ;
E 66
I 66
		wmove(wp, page_y + 1, page_x + PAGE1_OFF) ;
E 66
		wprintw(wp, PAGE1_FORMAT,
E 64
E 63
E 12
E 10
D 33
			Rate.v_pgrec - (Rate.v_xsfrec + Rate.v_xifrec),
			Rate.v_xsfrec + Rate.v_xifrec,
D 12
			pgtok(Rate.v_pgpgin),
			pgtok(Rate.v_pgpgout),
E 12
I 12
			pgtok(Rate.v_pgpgin), pgtok(Rate.v_pgpgout),
E 33
I 33
D 74
			Page.v_pgrec - (Page.v_xsfrec + Page.v_xifrec),
			Page.v_xsfrec + Page.v_xifrec,
			pgtok(Page.v_pgpgin), pgtok(Page.v_pgpgout),
E 74
I 74
			mon_page.mon_pgrec - (mon_page.mon_xsfrec + mon_page.mon_xifrec),
			mon_page.mon_xsfrec + mon_page.mon_xifrec,
D 77
			pgtok(mon_page.mon_pgpgin), pgtok(mon_page.mon_pgpgout),
E 74
E 33
E 12
D 60
			pgtok(page.mon_deficit),
E 60
I 60
			pgtok(mon_page.mon_deficit),
E 77
I 77
			pgtok((int)mon_page.mon_pgpgin), 
			pgtok((int)mon_page.mon_pgpgout),
			pgtok((int)mon_page.mon_deficit),
E 77
E 60
D 12
			Rate.v_swpin,
			Rate.v_swpout,
			Rate.v_faults,
			Rate.v_pgfrec);
E 12
I 12
D 33
			Rate.v_swpin, Rate.v_swpout,
			Rate.v_faults, Rate.v_pgfrec);
E 33
I 33
D 74
			Page.v_swpin, Page.v_swpout,
			Page.v_faults, Page.v_pgfrec);
E 74
I 74
			mon_page.mon_swpin, mon_page.mon_swpout,
			mon_page.mon_faults, mon_page.mon_pgfrec);
E 74
E 33
E 12

D 10
		mvprintw(PAGE2_X, PAGE2_Y, PAGE2_FORMAT,
E 10
I 10
D 12
		mvprintw(PAGE2_Y, PAGE2_X, PAGE2_FORMAT,
E 12
I 12
D 63
		mvprintw(page2_y+1, page2_x+PAGE2_OFF, PAGE2_FORMAT,
E 63
I 63
D 64
		wmove(stdscr, page2_y + 1, page2_x + PAGE2_OFF) ;
		wprintw(stdscr, PAGE2_FORMAT,
E 64
I 64
		wmove(wp, page2_y + 1, page2_x + PAGE2_OFF) ;
		wprintw(wp, PAGE2_FORMAT,
E 64
E 63
E 12
E 10
D 33
			pgtok(Rate.v_pgin) + pgtok(Rate.v_pgout),
D 12
			pgtok(Rate.v_scan),
			pgtok(Rate.v_dfree),
			Rate.v_nexfod,
			Rate.v_exfod,
			Rate.v_nzfod,
			Rate.v_zfod,
			Rate.v_nvrfod,
			Rate.v_vrfod);
E 12
I 12
			pgtok(Rate.v_scan), pgtok(Rate.v_dfree),
			Rate.v_nexfod, Rate.v_exfod,
			Rate.v_nzfod, Rate.v_zfod,
			Rate.v_nvrfod, Rate.v_vrfod);
E 33
I 33
D 74
			pgtok(Page.v_pgin) + pgtok(Page.v_pgout),
			pgtok(Page.v_scan), pgtok(Page.v_dfree),
			Page.v_nexfod, Page.v_exfod,
			Page.v_nzfod, Page.v_zfod,
			Page.v_nvrfod, Page.v_vrfod);
E 74
I 74
D 77
			pgtok(mon_page.mon_pgin) + pgtok(mon_page.mon_pgout),
			pgtok(mon_page.mon_scan), pgtok(mon_page.mon_dfree),
E 77
I 77
			pgtok((int)mon_page.mon_pgin) + pgtok((int)mon_page.mon_pgout),
			pgtok((int)mon_page.mon_scan), 
			pgtok((int)mon_page.mon_dfree),
E 77
			mon_page.mon_nexfod, mon_page.mon_exfod,
			mon_page.mon_nzfod, mon_page.mon_zfod,
			mon_page.mon_nvrfod, mon_page.mon_vrfod);
E 74
E 33
E 12
	}

E 9
	if( op->opt_tty ) {
D 11
		register t ;
E 8

D 7
	if( gethostname(hostname, BUFSIZ) == -1 )
D 4
		fatal("idle: can't get hostname: %s.\n");
E 4
I 4
		fatal("monitor: can't get hostname: %s.\n");
E 7
I 7
D 8
	mvprintw(HOST_Y, HOST_X, HOST_FORMAT, HOST_LEN, HOST_LEN, 
		first.mon_hostname);
E 8
I 8
		t = tty.mon_ttyin; tty.mon_ttyin -= old_in ; old_in = t ;
		t = tty.mon_ttyout; tty.mon_ttyout -= old_out ; old_out = t ;
E 11
I 11
D 33
		delta_tty(&tty);
E 33
I 33
D 52
		delta_tty();
E 52
I 52
		etime = delta_tty(sample.mon_ticks);
E 52
E 33
E 11
		
D 12
		mvprintw(TTY_Y, TTY_X, TTY_FORMAT, 
E 12
I 12
D 63
		mvprintw(tty_y+1, tty_x+TTY_OFF, TTY_FORMAT, 
E 12
D 29
			tty.mon_ttyin / tty.mon_etime, 
			tty.mon_ttyout / tty.mon_etime);
E 29
I 29
D 46
			tty.mon_ttyin / sample.mon_etime, 
			tty.mon_ttyout / sample.mon_etime);
E 46
I 46
			tty.mon_ttyin / etime, 
E 63
I 63
D 64
		wmove(stdscr, tty_y + 1, tty_x + TTY_OFF) ;
		wprintw(stdscr, TTY_FORMAT, tty.mon_ttyin / etime, 
E 64
I 64
		wmove(wp, tty_y + 1, tty_x + TTY_OFF) ;
		wprintw(wp, TTY_FORMAT, tty.mon_ttyin / etime, 
E 64
E 63
			tty.mon_ttyout / etime);
E 46
E 29
	}
E 8
E 7
E 4

I 21
D 22
	if( op->opt_state ) {
		struct mon_state *sp = state ;
		cursor = states_y ;
E 22
I 22
	if( op->opt_cpu ) {
D 24
		struct mon_cpu *p = cpu ;
		cursor = cpu_y ;
E 24
I 24
D 37
		struct	mon_cpu *p = cpu ;
E 37
I 37
D 56
		register struct mon_cpu *cp = cpu ;
E 37
D 46
		double	total_time, cpu_time() ;
E 46
I 46
		double	total_time, delta_cpu() ;
E 56
I 56
		double	total_time ;
E 56
E 46
		int	cursor = cpu_y ;
I 83

		/*
		 *	This makes sure that we keep proper track of
		 *	the number of system calls and device interrupts
		 *	even though we're not interested in the data.
		 */
		delta_syscall_intr((int *)NULL, (int *)NULL) ;
E 83
E 24
E 22
E 21
I 19

D 21
	sp = op->opt_state ? state : NULL ;
	cursor = states_y ;
E 21
I 21
D 37
		for( ; ; ) {
E 37
I 37
D 56
		for(i = 0; i < first.mon_cpu ; i++, cp++) {
E 56
I 56
D 66
		for(i = 0; i < n_cpu ; i++) {
E 66
I 66
		for(i = 0; i < first.mon_cpu ; i++) {
E 66
E 56
E 37
			if( cursor++ == last_cpu )
				break ;
E 21

I 68
D 75
			if( cpu[i].mon_flag == 0 )
E 75
I 75
			if((cpu[i].mon_flag & MON$M_VALID)== 0 )
E 75
				continue ;

E 68
D 21
	for( ; ; ) {
		if( cursor++ == last_cpu )
			break ;
E 21
I 21
D 22
			total_time = cpu_time(sp);
E 22
I 22
D 37
			total_time = cpu_time(p);
E 37
I 37
D 46
			total_time = cpu_time(cpu+i);
E 46
I 46
D 56
			total_time = delta_cpu(cpu+i);
E 56
I 56
			etime = delta_cpu(i, sample.mon_ticks, &total_time);
E 56
E 46
E 37
E 22
E 21

D 21
		total_time = cpu_time(sp);
E 21
I 21
D 22
			mvprintw(cursor, states_x+STATES_OFF, STATES_FORMAT,
				100. * sp->mon_time[0] / total_time,
				100. * sp->mon_time[1] / total_time,
				100. * sp->mon_time[2] / total_time,
				100. * sp->mon_time[3] / total_time);
E 22
I 22
D 63
			mvprintw(cursor, cpu_x+CPU_OFF, CPU_FORMAT,
E 63
I 63
D 64
			wmove(stdscr, cursor, cpu_x + CPU_OFF) ;
			wprintw(stdscr, CPU_FORMAT,
E 64
I 64
			wmove(wp, cursor, cpu_x + CPU_OFF) ;
			wprintw(wp, CPU_FORMAT,
E 64
E 63
D 37
				100. * p->mon_time[0] / total_time,
				100. * p->mon_time[1] / total_time,
				100. * p->mon_time[2] / total_time,
				100. * p->mon_time[3] / total_time,
				p->mon_swtch, p->mon_intr - first.mon_hz,
				p->mon_syscall);
E 22
E 21

D 21
		mvprintw(cursor, states_x+STATES_OFF, STATES_FORMAT,
			100. * sp->mon_time[0] / total_time,
			100. * sp->mon_time[1] / total_time,
			100. * sp->mon_time[2] / total_time,
			100. * sp->mon_time[3] / total_time);

		if( op->collect_mode == OPT_REPLAY )
			sp++ ;
		else
			sp = sp->mon_next ;
E 21
I 21
			if( op->collect_mode == OPT_REPLAY )
D 22
				sp++ ;
E 22
I 22
				p++ ;
E 22
			else
D 22
				sp = sp->mon_next ;
E 22
I 22
				p = p->mon_next ;
E 37
I 37
D 56
				100. * cp->mon_time[0] / total_time,
				100. * cp->mon_time[1] / total_time,
				100. * cp->mon_time[2] / total_time,
				100. * cp->mon_time[3] / total_time,
D 46
				cp->mon_swtch, cp->mon_intr - first.mon_hz,
				cp->mon_syscall);
E 46
I 46
D 47
				cp->mon_swtch / etime,
				cp->mon_intr / etime - first.mon_hz,
				cp->mon_syscall / etime);
E 47
I 47
				cp->mon_swtch / etime) ;
E 56
I 56
				100. * cpu[i].mon_time[0] / total_time,
				100. * cpu[i].mon_time[1] / total_time,
				100. * cpu[i].mon_time[2] / total_time,
				100. * cpu[i].mon_time[3] / total_time,
				cpu[i].mon_swtch / etime) ;
E 56

D 56

E 56
D 63
			if( i == 0 ) 
				mvprintw(cursor, cpu_x+CPU_OFF_1, CPU_FORMAT_1,
D 48
					cp->mon_intr / etime - first.mon_hz,
E 48
I 48
D 56
					cp->mon_intr / etime,
E 48
					cp->mon_syscall / etime);
E 56
I 56
					cpu[0].mon_intr / etime,
E 63
I 63
D 80
			if( i == 0 ) {
D 64
				wmove(stdscr, cursor, cpu_x + CPU_OFF_1) ;
				wprintw(stdscr, CPU_FORMAT_1, cpu[0].mon_intr / etime,
E 64
I 64
				wmove(wp, cursor, cpu_x + CPU_OFF_1) ;
				wprintw(wp, CPU_FORMAT_1, cpu[0].mon_intr / etime,
E 64
E 63
					cpu[0].mon_syscall / etime);
I 63
			}
E 80
I 80
			/*
			 *	Before V4.0 only do the interrupts
			 *	and syscalls for the first CPU.
			 */
#ifndef V4_ULTRIX
			if( i != 0 )
				continue ;
#endif
			wmove(wp, cursor, cpu_x + CPU_OFF_1) ;
			wprintw(wp, CPU_FORMAT_1, cpu[i].mon_intr / etime,
				cpu[i].mon_syscall / etime);
E 80
E 63
E 56
E 47
E 46
E 37
E 22
		}
E 21
	}

D 21
	np = op->opt_netif ? netif : NULL ;
	cursor = netif_y ;
E 21
I 21
	if( op->opt_netif ) {
D 24
		struct mon_netif *np = netif ;
		cursor = netif_y ;
E 24
I 24
D 38
		struct	mon_netif *np = netif ;
E 38
		int	cursor = netif_y ;
E 24
E 21

D 21
	for( ; ; ) {
		if( cursor++ == last_netif )
			break ;
E 21
I 21
D 38
		for( ; ; ) {
E 38
I 38
D 66
		for(i = 0; i < n_netif; i++) {
E 66
I 66
		for(i = 0; i < first.mon_netif; i++) {
E 66
E 38
			if( cursor++ == last_netif )
				break ;
E 21

I 68
D 75
			if( netif[i].mon_flag == 0 )
E 75
I 75
			if((netif[i].mon_flag & MON$M_VALID) == 0 )
E 75
				continue ;

E 68
D 21
		delta_netif(np);
E 21
I 21
D 38
			delta_netif(np);
E 38
I 38
D 54
			delta_netif(netif + i);
E 54
I 54
			etime = delta_netif(i, sample.mon_ticks);
E 54
E 38
E 21

D 21
		mvprintw(cursor, netif_x+NETIF_OFF, NETIF_FORMAT,
			np->mon_ipackets, np->mon_ierrors,
			np->mon_opackets, np->mon_oerrors,
			np->mon_collisions);
E 21
I 21
D 63
			mvprintw(cursor, netif_x+NETIF_OFF, NETIF_FORMAT,
D 38
				np->mon_ipackets, np->mon_ierrors,
				np->mon_opackets, np->mon_oerrors,
				np->mon_collisions);
E 21

D 21
		if( op->collect_mode == OPT_REPLAY )
			np++ ;
		else
			np = np->mon_next ;
E 21
I 21
			if( op->collect_mode == OPT_REPLAY )
				np++ ;
			else
				np = np->mon_next ;
E 38
I 38
D 46
				netif[i].mon_ipackets, netif[i].mon_ierrors,
				netif[i].mon_opackets, netif[i].mon_oerrors,
				netif[i].mon_collisions);
E 46
I 46
				netif[i].mon_ipackets / etime,
E 63
I 63
D 64
			wmove(stdscr, cursor, netif_x + NETIF_OFF) ;
			wprintw(stdscr, NETIF_FORMAT, netif[i].mon_ipackets / etime,
E 64
I 64
			wmove(wp, cursor, netif_x + NETIF_OFF) ;
			wprintw(wp, NETIF_FORMAT, netif[i].mon_ipackets / etime,
E 64
E 63
				netif[i].mon_ierrors / etime,
				netif[i].mon_opackets / etime, 
				netif[i].mon_oerrors / etime,
				netif[i].mon_collisions / etime);
E 46
E 38
		}
E 21
	}

E 19
D 5
	mvprintw(HOST_Y, HOST_X, "%-*.*s", 12, 12, hostname);
E 5
I 5
D 7
	mvprintw(HOST_Y, HOST_X, HOST_FORMAT, HOST_LEN, HOST_LEN, hostname);
E 5

E 7
D 5
	mvprintw(LOADAVE_Y, LOADAVE_X, "%.2f %.2f %.2f %.2f\n",
E 5
I 5
D 8
	mvprintw(LOADAVE_Y, LOADAVE_X, LOADAVE_FORMAT,
E 5
D 7
		dp->loadave[0], dp->loadave[1],
		dp->loadave[2], dp->loadave[3]);
E 7
I 7
		loadave.mon_loadave[0], loadave.mon_loadave[1],
		loadave.mon_loadave[2], loadave.mon_loadave[3]);
E 8
I 8
D 21
	dp = op->opt_disk ? disk : NULL ;
D 12
	cursor = 0 ;
E 12
I 12
D 19
	cursor = 1 ;
I 17
	count = n_disk ;
E 19
I 19
	cursor = disk_y ;
E 21
I 21
	if( op->opt_disk ) {
D 24
		struct mon_disk *dp = disk ;
		cursor = disk_y ;
E 24
I 24
D 58
		double	kbps, tps, msps, tkbps = 0, ttps = 0 ;
D 38
		struct	mon_disk *dp = disk ;
E 38
		int	cursor = disk_y ;
E 58
I 58
		double	kbps, tps, tkbps = 0, ttps = 0 ;
		int	cursor = disk_y, msps ;
E 58
E 24
E 21
E 19
E 17
E 12
E 8
E 7

D 5
	mvprintw(DATE_Y, DATE_X, "%s", time_string);
E 5
I 5
D 8
	mvprintw(DATE_Y, DATE_X, DATE_FORMAT, time_string);
E 8
I 8
D 19
	while( dp ) {
E 19
I 19
D 21
	for( ; ; ) {
		if( cursor++ == last_disk )
			break ;
E 21
I 21
D 38
		for( ; ; ) {
E 38
I 38
D 55
		for(i = 0; i < first.mon_disk; i++) {
E 55
I 55
D 66
		for(i = 0; i < n_disk ; i++) {
E 66
I 66
		for(i = 0; i < first.mon_disk ; i++) {
E 66
E 55
E 38
			if( cursor++ == last_disk )
				break ;
I 68

D 75
			if( disk[i].mon_flag == 0 )
E 75
I 75
			if((disk[i].mon_flag & MON$M_VALID) == 0 )
E 75
				continue ;
E 68
E 21

E 19
I 13
D 17
		count = n_disk ;

E 17
E 13
D 12
		mvprintw(DISK_NAMEY+cursor, DISK_NAMEX, "%s%d", dp->mon_name,
			dp->mon_unit);
E 8
E 5

E 12
D 5
	mvprintw(STATES_Y, STATES_X, " %4.0f %4.0f %4.0f %4.0f\n",
E 5
I 5
D 8
	mvprintw(STATES_Y, STATES_X, STATES_FORMAT,
E 5
D 7
		100. * dp->cpu_time[0] / total_time,
		100. * dp->cpu_time[1] / total_time,
		100. * dp->cpu_time[2] / total_time,
		100. * dp->cpu_time[3] / total_time);
E 7
I 7
		100. * state->mon_time[0] / total_time,
		100. * state->mon_time[1] / total_time,
		100. * state->mon_time[2] / total_time,
		100. * state->mon_time[3] / total_time);
E 8
I 8
D 9
		mvprintw(DISK_Y+cursor, DISK_X, DISK_FORMAT, 0, 0, 0.0);
E 9
I 9
D 21
		delta_disk(dp);
E 21
I 21
D 38
			delta_disk(dp);
E 38
I 38
D 55
			delta_disk(disk + i);
E 38
E 21
E 9
E 8
E 7

I 9
D 20
		words = dp->mon_wds * 32.0 ;
#ifdef	sun
		xfer_time = words * 2 / dp->mon_bps ;
#else
		xfer_time = dp->mon_mspw * words ;
#endif
		idle_time = (dp->mon_time / first.mon_hz ) - xfer_time ;
E 20
I 20
D 21
		calculate_disk(dp, first.mon_hz, &words, &idle_time);
E 21
I 21
D 24
			calculate_disk(dp, first.mon_hz, &words, &idle_time);
E 24
I 24
D 38
			calculate_disk(dp, &kbps, &tps, &msps);
E 38
I 38
			calculate_disk(disk + i, &kbps, &tps, &msps);
E 55
I 55
D 57
			calculate_disk(i, &kbps, &tps, &msps);
E 57
I 57
			(void)calculate_disk(i, &kbps, &tps, &msps);
E 57
E 55
E 38
E 24
E 21
E 20

D 20
		if( xfer_time < 0 ) {
			idle_time += xfer_time ;
			xfer_time = 0 ;
		}

		if( idle_time < 0 ) {
			xfer_time += idle_time ;
			idle_time = 0 ;
		}

E 20
D 12
		mvprintw(DISK_Y+cursor, DISK_X, DISK_FORMAT,
E 12
I 12
D 19
		mvprintw(disk_y+cursor, disk_x+DISK_OFF, DISK_FORMAT,
E 19
I 19
D 21
		mvprintw(cursor, disk_x+DISK_OFF, DISK_FORMAT,
E 19
E 12
D 20
			words/512/dp->mon_etime, 
E 20
I 20
			words/512.0/dp->mon_etime, 
E 20
			(double)dp->mon_xfer/dp->mon_etime, 
			dp->mon_seek ? idle_time*1000./dp->mon_seek : 0.0);
E 21
I 21
D 63
			mvprintw(cursor, disk_x+DISK_OFF, DISK_FORMAT,
D 24
				words/512.0/dp->mon_etime, 
				(double)dp->mon_xfer/dp->mon_etime, 
				dp->mon_seek 
					? idle_time*1000./dp->mon_seek 
					: 0.0);
E 24
I 24
				kbps, tps, msps);
E 63
I 63
D 64
			wmove(stdscr, cursor, disk_x + DISK_OFF) ;
			wprintw(stdscr, DISK_FORMAT, kbps, tps, msps);
E 64
I 64
			wmove(wp, cursor, disk_x + DISK_OFF) ;
			wprintw(wp, DISK_FORMAT, kbps, tps, msps);
E 64
E 63
E 24
E 21

I 24
			if( op->opt_total ) {
				tkbps += kbps ;
				ttps  += tps ;
			}
D 38

E 24
E 9
D 5
	mvprintw(FREE_Y, FREE_X, "%5d", pgtok(dp->free));
E 5
I 5
D 7
	mvprintw(FREE_Y, FREE_X, FREE_FORMAT, pgtok(dp->free));
E 7
I 7
D 8
	mvprintw(FREE_Y, FREE_X, FREE_FORMAT, pgtok(freemem.mon_freemem));
E 7
E 5
}
E 8
I 8
D 13
		dp = dp->mon_next ;
E 13
D 19
		cursor++ ;
I 13

E 19
D 18
		if( op->opt_replay )
E 18
I 18
D 21
		if( op->collect_mode == OPT_REPLAY )
E 18
D 19
			dp = --count ? dp + 1 : NULL ;
E 19
I 19
			dp++ ;
E 19
		else
			dp = dp->mon_next ;
E 21
I 21
			if( op->collect_mode == OPT_REPLAY )
				dp++ ;
			else
				dp = dp->mon_next ;
E 38
		}
I 24

		/*
D 31
		 *	Print out the disk totals (eventually).
E 31
I 31
		 *	Print out the disk totals.
E 31
		 */
D 63
		if( op->opt_total )
			mvprintw(last_disk+2, disk_x+TOTAL_OFF, TOTAL_FORMAT,
				tkbps, ttps);
E 63
I 63
		if( op->opt_total ) {
D 64
			wmove(stdscr, last_disk + 2, disk_x + TOTAL_OFF) ;
			wprintw(stdscr, TOTAL_FORMAT, tkbps, ttps);
E 64
I 64
			wmove(wp, last_disk + 2, disk_x + TOTAL_OFF) ;
			wprintw(wp, TOTAL_FORMAT, tkbps, ttps);
E 64
		}
E 63
E 24
E 21
E 13
	}
E 8
D 63

I 21
D 49
	if( op->opt_tape ) {
D 24
		struct mon_tape *tp = tape ;
		cursor = tape_y ;
E 24
I 24
D 38
		struct	mon_tape *tp = tape ;
E 38
		int	cursor = tape_y ;
E 24
E 21
I 19

E 19
I 13
D 21
/*
 *	Put the tape code here...
D 19
 *
D 17
 *	while( tp ) {
 *		count = n_tape ;
E 17
I 17
 *	count = n_tape ;
E 17
 *
I 17
 *	while( tp ) {
E 17
D 18
 *		if( op->opt_replay )
E 18
I 18
 *		if( op->collect_mode == OPT_REPLAY )
E 18
 *			tp = --count ? tp + 1 : NULL ;
 *		else
 *			tp = tp->mon_next ;
 *	}
E 19
 */
I 19
	tp = op->opt_tape ? tape : NULL ;
	cursor = tape_y ;
E 21
I 21
D 38
		for( ; ; ) {
E 38
I 38
		for(i = 0; i < first.mon_tape; i++) {
E 38
			if( cursor++ == last_tape )
				break ;
E 21
E 19

E 13
D 8
/*
 *	mvprintw(_HY, _HX, "");
 */
screen_headings()
{
	mvprintw(MEMORY_HY, MEMORY_HX, "Mem: real  ract  virt  vact  free");
D 4
	mvprintw(STATES_HY, STATES_HX, "Time: user nice  sys idle");
E 4
I 4
	mvprintw(STATES_HY, STATES_HX, "Time: user nice  sys monitor");
E 4
	mvprintw(TTY_HY, TTY_HX, "Char: in    out");
	mvprintw(CPU_HY, CPU_HX, "CPU: ints  scall  csw");
E 8
I 8
D 19
	sp = op->opt_state ? state : NULL ;
D 12
	cursor = 0 ;
E 12
I 12
	cursor = 1 ;
I 17
	count = n_cpu ;
E 19
I 19
D 21
	for( ; ; ) {
		if( cursor++ == last_tape )
			break ;
E 19
E 17
E 12

D 19
	while( sp ) {
I 13
D 17
		count = n_cpu ;

E 17
E 13
		total_time = cpu_time(sp);

D 12
		mvprintw(STATES_Y+cursor, STATES_X, STATES_FORMAT,
E 12
I 12
		mvprintw(states_y+cursor, states_x+STATES_OFF, STATES_FORMAT,
E 12
			100. * sp->mon_time[0] / total_time,
			100. * sp->mon_time[1] / total_time,
			100. * sp->mon_time[2] / total_time,
			100. * sp->mon_time[3] / total_time);

D 13
		sp = sp->mon_next ;
E 13
		cursor++ ;
I 13

E 19
I 19
		mvprintw(cursor, tape_x+TAPE_OFF, TAPE_FORMAT); 
E 21
I 21
			mvprintw(cursor, tape_x+TAPE_OFF, TAPE_FORMAT); 
E 21
D 38
 
E 19
D 18
		if( op->opt_replay )
E 18
I 18
D 21
		if( op->collect_mode == OPT_REPLAY )
E 18
D 19
			sp = --count ? sp + 1 : NULL ;
E 19
I 19
			tp++ ;
E 19
		else
D 19
			sp = sp->mon_next ;
E 19
I 19
			tp = tp->mon_next ;
E 21
I 21
			if( op->collect_mode == OPT_REPLAY )
				tp++ ;
			else
				tp = tp->mon_next ;
E 38
		}
E 21
E 19
E 13
	}

E 49
D 19
	np = op->opt_netif ? netif : NULL ;
D 12
	cursor = 0 ;
E 12
I 12
	cursor = 1 ;
I 17
	count = n_netif ;
E 17
E 12

	while( np ) {
I 13
D 17
		count = n_netif ;

E 17
E 13
D 12
		mvprintw(NETIF_NAMEY+cursor, NETIF_NAMEX, "%s%d", np->mon_name,
			np->mon_unit);

E 12
I 9
		delta_netif(np);

E 9
D 12
		mvprintw(NETIF_Y+cursor, NETIF_X, NETIF_FORMAT,
E 12
I 12
		mvprintw(netif_y+cursor, netif_x+NETIF_OFF, NETIF_FORMAT,
E 12
D 9
			0, 0, 0, 0, 0);
E 9
I 9
			np->mon_ipackets, np->mon_ierrors,
			np->mon_opackets, np->mon_oerrors,
			np->mon_collisions);
E 9

D 13
		np = np->mon_next ;
E 13
		cursor++ ;
I 13

D 18
		if( op->opt_replay )
E 18
I 18
		if( op->collect_mode == OPT_REPLAY )
E 18
			np = --count ? np + 1 : NULL ;
		else
			np = np->mon_next ;
E 13
	}

E 19
E 8
	refresh();
E 63
}

D 7
screen_redraw()
E 7
I 7
D 32
screen_redraw(op)
OPTION	*op ;
E 7
{
	clear();
D 9
	screen_headings();
E 9
I 9
	screen_headings(op);
E 9
	refresh();
}

E 32
D 5
screen_prompt()
E 5
I 5
screen_prompt(op)
I 7
OPTION	*op ;
E 7
E 5
{
D 4
	mvprintw(LINES-1, 0, "idle> ");
E 4
I 4
D 5
	mvprintw(LINES-1, 0, "monitor> ");
E 5
I 5
D 63
	mvprintw(LINES-1, 0, op->opt_prompt);
I 44
	clrtoeol() ;
E 44
I 30
D 39
	clrtoeol() ;
E 39
E 30
I 15
	refresh() ;
E 63
I 63
D 64
	wmove(stdscr, LINES - 1, 0) ;
	wprintw(stdscr, op->opt_prompt);
	wclrtoeol(stdscr) ;
	wrefresh(stdscr) ;
E 64
I 64
	wmove(wp, LINES - 1, 0) ;
	wprintw(wp, op->opt_prompt);
	wclrtoeol(wp) ;
	wrefresh(wp) ;
E 64
E 63
E 15
I 8
}

D 34
print_semi_static(op)
OPTION	*op ;
E 34
I 34
print_semi_static()
E 34
{
	char	*time_string, *newline ;
D 46
	char	*ctime(), *index() ;
E 46
D 24
	struct	mon_netif *np ;
	struct	mon_tape *tp ;
	struct	mon_disk *dp ;
	int	i ;
E 24

D 63
	mvprintw(HOST_Y, HOST_X, HOST_FORMAT, HOST_LEN, HOST_LEN, 
		first.mon_hostname);
E 63
I 63
D 64
	wmove(stdscr, HOST_Y, HOST_X) ;
	wprintw(stdscr, HOST_FORMAT, HOST_LEN, HOST_LEN, first.mon_hostname);
E 64
I 64
	wmove(wp, HOST_Y, HOST_X) ;
	wprintw(wp, HOST_FORMAT, HOST_LEN, HOST_LEN, first.mon_hostname);
E 64
E 63

D 46
	time_string = ctime(&sample.mon_timestamp);
	if((newline = index(time_string, '\n')) != NULL )
E 46
I 46
	time_string = ctime((long *)&sample.mon_timestamp);
	if((newline = strchr(time_string, '\n')) != NULL )
E 46
		*newline = '\0' ;

D 63
	mvprintw(DATE_Y, DATE_X, DATE_FORMAT, time_string);
E 63
I 63
D 64
	wmove(stdscr, DATE_Y, DATE_X) ;
	wprintw(stdscr, DATE_FORMAT, time_string);
E 64
I 64
	wmove(wp, DATE_Y, DATE_X) ;
	wprintw(wp, DATE_FORMAT, time_string);
E 64
E 63
}

/*
 *	Print the heading for the various fields.  Should only print
 *	headings for fields that are turned on.
 */
D 9
screen_headings()
E 9
I 9
D 32
screen_headings(op)
E 32
I 32
redraw_screen(op)
E 32
OPTION	*op ;
E 9
{
I 38
	register i ;
I 39

	if( changed_size ) {
D 59
		screen_format(op, n_cpu, n_disk, n_tape, n_netif) ;
E 59
I 59
D 66
		screen_format(op, n_cpu, n_disk, n_netif) ;
E 66
I 66
		screen_format(op, first.mon_cpu, first.mon_disk, first.mon_netif) ;
E 66
E 59
		changed_size = 0 ;
	}
E 39

E 38
I 32
D 63
	clear() ;
E 63
I 63
D 64
	wclear(stdscr) ;
E 64
I 64
	wclear(wp) ;
E 64
E 63

E 32
I 12
D 13
	register cursor ;
E 13
I 13
D 19
	register cursor, count ;
E 19
I 19
D 24
	register cursor ;
E 19
E 13

E 24
E 12
D 9
	mvprintw(PROC_HY, PROC_HX, "Proc: rq dw pw sl sw");
	mvprintw(MEMORY_HY, MEMORY_HX, "Mem: real  ract  virt  vact  free");
	mvprintw(FORK_HY, FORK_HX, "Forks: fork vfork");
	mvprintw(STATES_HY, STATES_HX, "Time: user nice  sys idle");
	mvprintw(TTY_HY, TTY_HX, "Char: in   out");
	mvprintw(CPU_HY, CPU_HX, "CPU: ints  scall  csw");
E 9
I 9
D 63
	if( op->opt_proc )
D 12
		mvprintw(PROC_HY, PROC_HX, PROC_HEADING);
E 12
I 12
		mvprintw(proc_y, proc_x, PROC_HEADING);
E 63
I 63
	if( op->opt_proc ) {
D 64
		wmove(stdscr, proc_y, proc_x) ;
		wprintw(stdscr, PROC_HEADING);
E 64
I 64
		wmove(wp, proc_y, proc_x) ;
		wprintw(wp, PROC_HEADING);
E 64
	}
E 63
E 12
E 9

D 9
	mvprintw(PAGE1_HY, PAGE1_HX, 
		"Pageing: re  at pin pout  oprs  fr  def   sr");
	mvprintw(PAGE2_HY, PAGE2_HX, "nxf  xf  nzf  zf  nrf  rf  prf  swi swo");
E 9
I 9
D 63
	if( op->opt_memory )
D 12
		mvprintw(MEMORY_HY, MEMORY_HX, MEMORY_HEADING);
E 12
I 12
		mvprintw(memory_y, memory_x, MEMORY_HEADING);
E 63
I 63
	if( op->opt_memory ) {
D 64
		wmove(stdscr, memory_y, memory_x) ;
		wprintw(stdscr, MEMORY_HEADING);
E 64
I 64
		wmove(wp, memory_y, memory_x) ;
		wprintw(wp, MEMORY_HEADING);
E 64
	}
E 63
E 12
D 18
	else if( op->opt_free )
E 18
I 18

D 63
	if( op->opt_free )
E 18
D 12
		mvprintw(MEMORY_HY, MEMORY_HX, FREE_HEADING);
E 12
I 12
D 19
		mvprintw(memory_y, memory_x, FREE_HEADING);
E 19
I 19
		mvprintw(free_y, free_x, FREE_HEADING);
E 63
I 63
	if( op->opt_free ) {
D 64
		wmove(stdscr, free_y, free_x) ;
		wprintw(stdscr, FREE_HEADING);
E 64
I 64
		wmove(wp, free_y, free_x) ;
		wprintw(wp, FREE_HEADING);
E 64
	}
E 63
E 19
E 12
E 9

D 9
	mvprintw(DISK_HY, DISK_HX, "Disk: kbps tps msps");
	mvprintw(NETIF_HY, NETIF_HX, 
		"Net:    ipkts ierrs  opkts  oerrs collis");
E 9
I 9
D 63
	if( op->opt_fork )
D 12
		mvprintw(FORK_HY, FORK_HX, FORK_HEADING);
E 12
I 12
		mvprintw(fork_y, fork_x, FORK_HEADING);
E 63
I 63
	if( op->opt_fork ) {
D 64
		wmove(stdscr, fork_y, fork_x) ;
		wprintw(stdscr, FORK_HEADING);
E 64
I 64
		wmove(wp, fork_y, fork_x) ;
		wprintw(wp, FORK_HEADING);
E 64
	}
E 63
E 12

D 22
	if( op->opt_state )
D 12
		mvprintw(STATES_HY, STATES_HX, STATES_HEADING);
E 12
I 12
		mvprintw(states_y, states_x, STATES_HEADING);
E 22
I 22
D 47
	if( op->opt_cpu )
E 47
I 47
	if( op->opt_cpu ) {
		int	cursor = cpu_y ;

E 47
D 63
		mvprintw(cpu_y, cpu_x, CPU_HEADING);
E 63
I 63
D 64
		wmove(stdscr, cpu_y, cpu_x) ;
		wprintw(stdscr, CPU_HEADING);
E 64
I 64
		wmove(wp, cpu_y, cpu_x) ;
		wprintw(wp, CPU_HEADING);
E 64
E 63
I 47

		for(i = 0; i < first.mon_cpu; i++) {
			if( ++cursor > last_cpu )
				break ;

D 63
			mvprintw(cursor, cpu_x, "#%d", cpu[i].mon_cpu);
E 63
I 63
D 64
			wmove(stdscr, cursor, cpu_x) ;
			wprintw(stdscr, "#%d", cpu[i].mon_cpu);
E 64
I 64
			wmove(wp, cursor, cpu_x) ;
			wprintw(wp, "#%d", cpu[i].mon_cpu);
E 64
E 63
		}

D 63
		if((last_cpu-cpu_y) < n_cpu )
			mvprintw(LINES-1, NETIF_MORE, "<cpu>");
E 63
I 63
D 66
		if((last_cpu-cpu_y) < n_cpu ) {
D 64
			wmove(stdscr, LINES - 1, NETIF_MORE) ;
			wprintw(stdscr, "<cpu>") ;
E 64
I 64
			wmove(wp, lines - 1, NETIF_MORE) ;
E 66
I 66
		if((last_cpu-cpu_y) < first.mon_cpu ) {
			wmove(wp, LINES - 1, NETIF_MORE) ;
E 66
			wprintw(wp, "<cpu>") ;
E 64
		}
E 63
	}
E 47
E 22
E 12

D 63
	if( op->opt_tty )
D 12
		mvprintw(TTY_HY, TTY_HX, TTY_HEADING);
E 12
I 12
		mvprintw(tty_y, tty_x, TTY_HEADING);
E 63
I 63
	if( op->opt_tty ) {
D 64
		wmove(stdscr, tty_y, tty_x) ;
		wprintw(stdscr, TTY_HEADING);
E 64
I 64
		wmove(wp, tty_y, tty_x) ;
		wprintw(wp, TTY_HEADING);
E 64
	}
E 63
E 12
D 22

	if( op->opt_cpu )
D 12
		mvprintw(CPU_HY, CPU_HX, CPU_HEADING);
E 12
I 12
		mvprintw(cpu_y, cpu_x, CPU_HEADING);
E 22
E 12

	if( op->opt_page ) {
D 12
		mvprintw(PAGE1_HY, PAGE1_HX, PAGE1_HEADING);
		mvprintw(PAGE2_HY, PAGE2_HX, PAGE2_HEADING);
E 12
I 12
D 63
		mvprintw(page1_y, page1_x, PAGE1_HEADING);
		mvprintw(page2_y, page2_x, PAGE2_HEADING);
E 63
I 63
D 64
		wmove(stdscr, page1_y, page1_x) ;
		wprintw(stdscr, PAGE1_HEADING);
E 64
I 64
D 66
		wmove(wp, page1_y, page1_x) ;
E 66
I 66
		wmove(wp, page_y, page_x) ;
E 66
		wprintw(wp, PAGE1_HEADING);
E 64

D 64
		wmove(stdscr, page2_y, page2_x) ;
		wprintw(stdscr, PAGE2_HEADING);
E 64
I 64
		wmove(wp, page2_y, page2_x) ;
		wprintw(wp, PAGE2_HEADING);
E 64
E 63
E 12
	}

D 12
	if( op->opt_disk )
		mvprintw(DISK_HY, DISK_HX, DISK_HEADING);
E 12
I 12
	if( op->opt_disk ) {
D 24
		struct mon_disk *dp = disk ;
I 13
D 19
		count = n_disk ;
E 19
I 19
		cursor = disk_y ;
E 24
I 24
D 38
		struct	mon_disk *dp = disk ;
E 38
		int	cursor = disk_y ;
E 24
E 19
E 13
E 12

D 12
	if( op->opt_netif )
		mvprintw(NETIF_HY, NETIF_HX, NETIF_HEADING);
E 12
I 12
D 63
		mvprintw(disk_y, disk_x, DISK_HEADING);
E 63
I 63
D 64
		wmove(stdscr, disk_y, disk_x) ;
		wprintw(stdscr, DISK_HEADING);
E 64
I 64
		wmove(wp, disk_y, disk_x) ;
		wprintw(wp, DISK_HEADING);
E 64
E 63
D 19
	
		cursor = 1 ;
E 19

D 19
		while( dp ) {
			mvprintw(disk_y+cursor, disk_x, "%s%d", dp->mon_name,
E 19
I 19
D 38
		for( ; ; ) {
E 38
I 38
		for(i = 0; i < first.mon_disk; i++) {
E 38
			if( ++cursor > last_disk )
				break ;

D 38
			mvprintw(cursor, disk_x, "%s%d", dp->mon_name,
E 19
				dp->mon_unit);

D 19
			cursor++ ;
D 13
			dp = dp->mon_next ;
E 13
I 13

E 19
D 18
			if( op->opt_replay )
E 18
I 18
			if( op->collect_mode == OPT_REPLAY )
E 18
D 19
				dp = --count ? dp + 1 : NULL ;
E 19
I 19
				dp++ ;
E 19
			else
				dp = dp->mon_next ;
E 38
I 38
D 63
			mvprintw(cursor, disk_x, "%s%d", disk[i].mon_name,
				disk[i].mon_unit);
E 63
I 63
D 64
			wmove(stdscr, cursor, disk_x) ;
			wprintw(stdscr, "%s%d", disk[i].mon_name, disk[i].mon_unit);
E 64
I 64
			wmove(wp, cursor, disk_x) ;
			wprintw(wp, "%s%d", disk[i].mon_name, disk[i].mon_unit);
E 64
E 63
E 38
E 13
		}
I 19

I 24
D 63
		if( op->opt_total )
D 25
			mvprintw(last_disk+1, disk_x, "--------------------");
E 25
I 25
			mvprintw(last_disk+1, disk_x, TOTAL_LINE);
E 63
I 63
		if( op->opt_total ) {
D 64
			wmove(stdscr, last_disk + 1, disk_x) ;
			wprintw(stdscr, TOTAL_LINE);
E 64
I 64
			wmove(wp, last_disk + 1, disk_x) ;
			wprintw(wp, TOTAL_LINE);
E 64
		}
E 63
E 25

E 24
D 63
		if((last_disk-disk_y) < n_disk )
			mvprintw(LINES-1, NETIF_MORE, "<disk>");
E 63
I 63
D 66
		if((last_disk-disk_y) < n_disk ) {
D 64
			wmove(stdscr, LINES - 1, NETIF_MORE) ;
			wprintw(stdscr, "<disk>");
E 64
I 64
			wmove(wp, lines - 1, NETIF_MORE) ;
E 66
I 66
		if((last_disk-disk_y) < first.mon_disk ) {
			wmove(wp, LINES - 1, NETIF_MORE) ;
E 66
			wprintw(wp, "<disk>");
E 64
		}
E 63
E 19
	}

I 13
D 59
	if( op->opt_tape ) {
D 24
		struct mon_tape *tp = tape ;
D 19
		count = n_tape ;
E 19
I 19
		cursor = tape_y ;
E 24
I 24
D 38
		struct	mon_tape *tp = tape ;
E 38
		int	cursor = tape_y ;
E 24
E 19

D 19
		while( tp ) {
			mvprintw(disk_y+cursor, disk_x, "%s%d", tp->mon_name,
E 19
I 19
		mvprintw(tape_y, tape_x, TAPE_HEADING);
	
D 38
		for( ; ; ) {
E 38
I 38
		for(i = 0; i < first.mon_tape; i++) {
E 38
			if( ++cursor > last_tape )
				break ;

D 38
			mvprintw(cursor, tape_x, "%s%d", tp->mon_name,
E 19
				tp->mon_unit);

D 19
			cursor++ ;

E 19
D 18
			if( op->opt_replay )
E 18
I 18
			if( op->collect_mode == OPT_REPLAY )
E 18
D 19
				tp = --count ? tp + 1 : NULL ;
E 19
I 19
				tp++ ;
E 19
			else
				tp = tp->mon_next ;
E 38
I 38
			mvprintw(cursor, tape_x, "%s%d", tape[i].mon_name,
				tape[i].mon_unit);
E 38
		}
I 19
D 49

		if((last_tape-tape_y) < n_tape )
			mvprintw(LINES-1, NETIF_MORE, "<tape>");
E 49
E 19
	}

E 59
E 13
	if( op->opt_netif ) {
D 24
		struct mon_netif *np = netif ;
I 13
D 19
		count = n_netif ;
E 19
I 19
		cursor = netif_y ;
E 24
I 24
D 38
		struct	mon_netif *np = netif ;
E 38
		int	cursor = netif_y ;
E 24
E 19
E 13

D 63
		mvprintw(netif_y, netif_x, NETIF_HEADING);
E 63
I 63
D 64
		wmove(stdscr, netif_y, netif_x) ;
		wprintw(stdscr, NETIF_HEADING);
E 64
I 64
		wmove(wp, netif_y, netif_x) ;
		wprintw(wp, NETIF_HEADING);
E 64
E 63

D 19
		cursor = 1 ;
E 19
I 19
D 38
		for( ; ; ) {
E 38
I 38
D 66
		for(i = 0; i < n_netif; i++) {
E 66
I 66
		for(i = 0; i < first.mon_netif; i++) {
E 66
E 38
			if( ++cursor > last_netif )
				break ;
E 19

D 19
		while( np ) {
			mvprintw(netif_y+cursor, netif_x, "%s%d", np->mon_name,
E 19
I 19
D 38
			mvprintw(cursor, netif_x, "%s%d", np->mon_name,
E 19
				np->mon_unit);

D 19
			cursor++ ;
D 13
			np = np->mon_next ;
E 13
I 13

E 19
D 18
			if( op->opt_replay )
E 18
I 18
			if( op->collect_mode == OPT_REPLAY )
E 18
D 19
				np = --count ? np + 1 : NULL ;
E 19
I 19
				np++ ;
E 19
			else
				np = np->mon_next ;
E 38
I 38
D 63
			mvprintw(cursor, netif_x, "%s%d", netif[i].mon_name,
				netif[i].mon_unit);
E 63
I 63
D 64
			wmove(stdscr, cursor, netif_x) ;
			wprintw(stdscr, "%s%d", netif[i].mon_name, netif[i].mon_unit);
E 64
I 64
			wmove(wp, cursor, netif_x) ;
			wprintw(wp, "%s%d", netif[i].mon_name, netif[i].mon_unit);
E 64
E 63
E 38
E 13
		}
I 19

D 63
		if((last_netif-netif_y) < n_netif )
			mvprintw(LINES-1, NETIF_MORE, "<netif>");
E 63
I 63
D 66
		if((last_netif-netif_y) < n_netif ) {
D 64
			wmove(stdscr, LINES - 1, NETIF_MORE) ;
			wprintw(stdscr, "<netif>");
E 64
I 64
			wmove(wp, lines - 1, NETIF_MORE) ;
E 66
I 66
		if((last_netif-netif_y) < first.mon_netif ) {
			wmove(wp, LINES - 1, NETIF_MORE) ;
E 66
			wprintw(wp, "<netif>");
E 64
		}
E 63
E 19
	}
E 12
E 9
D 63

	refresh();
E 63
I 17
}

I 26
extern	char	*sys_siglist[] ;

/*
 *	Use curses to print out info about the "last" record.
D 63
 *
 *	This functions expects mvprintw() to not be a macro
 *	which might do funny things to the first argument.
E 63
 */
screen_last(y)
int	y ;
{
D 46
	char	*date, *ctime(), *newline, *index() ;
E 46
I 46
	char	*date, *newline ;
E 46

D 46
	date = ctime(&last.mon_edate);
	if((newline = index(date, '\n')) != NULL )
E 46
I 46
	date = ctime((long *)&last.mon_edate);
	if((newline = strchr(date, '\n')) != NULL )
E 46
		*newline = '\0' ;

D 63
	mvprintw(y++, 0, "This session ended at %s.", date);
E 63
I 63
D 64
	wmove(stdscr, y++, 0) ;
	wprintw(stdscr, "This session ended at %s.", date);
E 64
I 64
	wmove(wp, y++, 0) ;
	wprintw(wp, "This session ended at %s.", date);
E 64
E 63

	return y + 1 ;
}

I 45
/*
 *	This function is called when a "first" record has been
 *	found.
 */
E 45
screen_first(y)
{
D 46
	char	*date, *ctime(), *newline, *index(), *str_data() ;
E 46
I 46
	char	*date, *newline ;
E 46
	char	*word ;

D 46
	date = ctime(&first.mon_sdate);
	if((newline = index(date, '\n')) != NULL )
E 46
I 46
	date = ctime((long *)&first.mon_sdate);
	if((newline = strchr(date, '\n')) != NULL )
E 46
		*newline = '\0' ;

D 63
	mvprintw(y++, 0, "The next session was started on node %s at %s.",
E 63
I 63
D 64
	wmove(stdscr, y++, 0) ;
	wprintw(stdscr, "The next session was started on node %s at %s.",
E 64
I 64
	wmove(wp, y++, 0) ;
	wprintw(wp, "The next session was started on node %s at %s.",
E 64
E 63
		first.mon_hostname, date);

D 31
	word = ( first.mon_cpu == 1 && 
		 first.mon_disk == 1 && 
		 first.mon_tape == 1 && 
		 first.mon_netif == 1 ) ? "is" : "are" ;
E 31
I 31
	word = first.mon_disk == 1 ? "is" : "are" ;
E 31

D 63
	mvprintw(y++, 0, "The options are <%s>.", str_data(first.mon_options));
E 63
I 63
D 64
	wmove(stdscr, y++, 0) ;
	wprintw(stdscr, "The options are <%s>.", str_data(first.mon_options));
E 64
I 64
	wmove(wp, y++, 0) ;
	wprintw(wp, "The options are <%s>.", str_data(first.mon_options));
E 64
E 63

D 63
	mvprintw(y++, 0,
D 59
		"There %s %d disk%s, %d tape%s, %d cpu%s and %d netif%s.", word,
E 59
I 59
		"There %s %d disk%s, %d cpu%s and %d netif%s.", word,
E 59
			first.mon_disk, first.mon_disk != 1 ? "\'s" : "",
D 59
			first.mon_tape, first.mon_tape != 1 ? "\'s" : "",
E 59
			first.mon_cpu, first.mon_cpu != 1 ? "\'s" : "",
			first.mon_netif, first.mon_netif != 1 ? "\'s" : "");
E 63
I 63
D 64
	wmove(stdscr, y++, 0) ;
	wprintw(stdscr, "There %s %d disk%s, %d cpu%s and %d netif%s.", word,
E 64
I 64
	wmove(wp, y++, 0) ;
	wprintw(wp, "There %s %d disk%s, %d cpu%s and %d netif%s.", word,
E 64
		first.mon_disk, first.mon_disk != 1 ? "\'s" : "",
		first.mon_cpu, first.mon_cpu != 1 ? "\'s" : "",
		first.mon_netif, first.mon_netif != 1 ? "\'s" : "");
E 63
D 64

	return y ;
E 64
I 36
}

/*
 *	Attempt to rationally format the screen.  The "screen" is divided
 *	into 3 areas.  Area 0 is the first two lines of the screen, one
 *	for the hostname, loadave, date and users information and the other
 *	is left blank.  Area1 is most of the left side of the screen below
 *	Area0.  Area2 is the remainder of the right side of the screen below
 *	Area0.
 *
 *	Screen_format() will attempt to compress all the fixed data into
 *	the top of Area1, leaving the bottom of Area1 and as much of Area2
 *	as possible for data that can "grow".  The data options that can
D 59
 *	"grow" are disk, tape, netif and cpu.
E 59
I 59
 *	"grow" are disk, netif and cpu.
I 66
 *
 *	I'll figure this out one of these days.
 *
 *	Preferred areas:
 *
 *	Area 0 - loadave and users.
 *	Area 1 - Proc, memory, paging, CPU and Netif.
 *	Area 2 - Fork, TTY, Disk.
 *
 *	1.  Figure out where to put the stuff on the top line.  The load
 *	    averages come first followed by the number of users.  If the
 *	    load average isn't being displayed, put the users where load
 *	    average would have been.
 *
 *	2.  If paging, cpu or netif are being display disk will have to
 *	    live in area2.  If not we'll put disk in area1 and move the
 *	    others over a comfortable distance.
E 66
E 59
 */
D 59
screen_format(op, cpus, disks, tapes, netifs)
E 59
I 59
screen_format(op, cpus, disks, netifs)
E 59
D 67
OPTION	 *op ;
D 59
unsigned cpus, disks, tapes, netifs ;
E 59
I 59
unsigned cpus, disks, netifs ;
E 67
I 67
OPTION	*op ;
int	cpus, disks, netifs ;
E 67
E 59
{
	int	area1_y = PROC_Y ;
	int	area1_x = PROC_X ;
	int	area2_y = FORK_Y ;
D 64
	int	area1_len = LINES - 4 ;
	int	area2_len = LINES - 4 ;
E 64
I 64
D 66
	int	area1_len = lines - 4 ;
	int	area2_len = lines - 4 ;
E 66
I 66
	int	area1_len = LINES - 4 ;
	int	area2_len = LINES - 4 ;
E 66
E 64
	int	area_width = DISK_X - PROC_X - 1 ;
	int	area_lines ;
I 67
	int	last_lines[MON$N_RECORDS], i ;
E 67
I 65

/*
I 67
 *	Initialize the array of "last_lines".  This describes
 *	where the line that a particular piece of data ends
 *	on.
 */
	for(i = 0; i < MON$N_RECORDS; i++)
		last_lines[i] = 0 ;

/*
E 67
 *	Initialize all the screen locations.
 */
	cpu_y = CPU_Y ; cpu_x = CPU_X ;
	tty_y = TTY_Y ; tty_x = TTY_X ;
	proc_y = PROC_Y ; proc_x = PROC_X ;
	free_y = FREE_Y ; free_x = FREE_X ;
	fork_y = FORK_Y ; fork_x = FORK_X ;
	disk_y = DISK_Y ; disk_x = DISK_X ;
I 66
	page_y = PAGE_Y ; page_x = PAGE_X ;
	user_y = USER_Y ; user_x = USER_X ;
E 66
	netif_y = NETIF_Y ; netif_x = NETIF_X ;
D 66
	page1_y = PAGE1_Y ; page1_x = PAGE1_X ;
E 66
	page2_y = PAGE2_Y ; page2_x = PAGE2_X ;
	memory_y = MEMORY_Y ; memory_x = MEMORY_X ;
I 66
	loadave_y = LOADAVE_Y ; loadave_x = LOADAVE_X ;
E 66
E 65

	if( op->opt_proc ) {
		if( area_width >= PROC_LEN ) {
D 66
			proc_x = area1_x ;
E 66
			proc_y = area1_y ;
I 66
			proc_x = area1_x ;
E 66
			area1_x += (PROC_LEN + SPACE) ;
			area_width -= (PROC_LEN + SPACE) ;
		}
I 67

D 71
		last_lines[MON$K_PROC] = proc_y + 1 ;
E 71
I 71
		last_lines[MON$C_PROC] = proc_y + 1 ;
E 71
E 67
	}

	if( op->opt_memory ) {
		if( area_width >= MEMORY_LEN ) {
			memory_x = area1_x ;
			memory_y = area1_y ;
			area1_x += (MEMORY_LEN + SPACE) ;
			area_width -= (MEMORY_LEN + SPACE) ;
		}
I 67

D 71
		last_lines[MON$K_MEMORY] = memory_y + 1 ;
E 71
I 71
		last_lines[MON$C_MEMORY] = memory_y + 1 ;
E 71
E 67
	}
	else if( op->opt_free ) {
		if( area_width >= FREE_LEN ) {
			free_x = area1_x ;
			free_y = area1_y ;
			area1_x += (FREE_LEN + SPACE) ;
			area_width -= (FREE_LEN + SPACE) ;
		}
I 67

D 71
		last_lines[MON$K_FREE] = free_y + 1 ;
E 71
I 71
		last_lines[MON$C_FREE] = free_y + 1 ;
E 71
E 67
	}

	if( op->opt_fork ) {
		if( area_width < FORK_LEN ) {
			fork_y = area2_y ;
			area2_y += 3 ;
			area2_len -= 3 ;
		}
		else {
			fork_x = area1_x ;
			fork_y = area1_y ;
			area1_x += (FORK_LEN + SPACE) ;
			area_width -= (FORK_LEN + SPACE) ;
		}
I 67

D 71
		last_lines[MON$K_FORK] = fork_y + 1 ;
E 71
I 71
		last_lines[MON$C_FORK] = fork_y + 1 ;
E 71
E 67
	}

	if( op->opt_tty ) {
		if( area_width < TTY_LEN ) {
			tty_y = area2_y ;
			area2_y += 3 ;
			area2_len -= 3 ;
		}
		else {
			tty_x = area1_x ;
			tty_y = area1_y ;
			area1_x += (TTY_LEN + SPACE) ;
			area_width -= (TTY_LEN + SPACE) ;
		}
I 67

D 71
		last_lines[MON$K_TTY] = tty_y + 1 ;
E 71
I 71
		last_lines[MON$C_TTY] = tty_y + 1 ;
E 71
E 67
	}

	if( area1_x != PROC_X )
		area1_y += 3 ;

	if( op->opt_page ) {
D 66
		page1_y = area1_y ;
E 66
I 66
		page_y = area1_y ;
E 66
		page2_y = area1_y + 3 ;

		area1_x = PAGE1_LEN ;
		area1_y += 6 ;
		area1_len -= 6 ;
I 67
D 71
		last_lines[MON$K_PAGE] = page2_y + 1 ;
E 71
I 71
		last_lines[MON$C_PAGE] = page2_y + 1 ;
E 71
E 67
	}

	/*
 	 *	Figure out how many lines are available to display
	 *	CPU's and NETIF's.  If there are more CPU's and NETIF's
	 *	than lines, only display those that will fix and turn
	 *	on the approproiate "<more>" indicator.
	 */

	area_lines = area1_len - (op->opt_cpu ? 1 : 0 + op->opt_netif ? 1 : 0) ;

	if( op->opt_cpu && op->opt_netif )
		area_lines-- ;

	if((cpus + netifs) > area_lines )
		limit(area_lines, &cpus, &netifs);

	if( op->opt_cpu ) {
		cpu_y = area1_y ;
		area1_x = CPU_LEN ;
		area1_y += (2 + cpus) ;
		last_cpu = cpu_y + cpus ;
I 67
D 71
		last_lines[MON$K_CPU] = last_cpu ;
E 71
I 71
		last_lines[MON$C_CPU] = last_cpu ;
E 71
E 67
	}

	if( op->opt_netif ) {
		netif_y = area1_y ;
		area1_x = NETIF_LEN ;
		last_netif = netif_y + netifs ;
I 67
D 71
		last_lines[MON$K_NETIF] = last_netif ;
E 71
I 71
		last_lines[MON$C_NETIF] = last_netif ;
E 71
E 67
	}

	/*
 	 *	Do the same thing for disks, but also figure out if
	 *	we want to put them in area1.
I 69
	 *
	 *	This is seriously magical, but I'll try to explain
	 *	anyway.
	 *
	 *	If the area1 X coordinate hasn't changed then there isn't
	 *	anything in area1.  The number of lines left in that area
	 *	is (length - 1).  The -1 give one line blank line above the
 	 *	prompt.  The X coordinate of the disks is PROC_X.  "area2_y"
	 *	is used later.
	 *
	 *	If the area1 X coordinate hasn't changed we put the disk
	 *	data in the normal place.  Since there won't be anything
	 *	but error messages on the bottom line, we don't subtract
	 *	a line from those available.
E 69
	 */
D 69

E 69
	if( area1_x == PROC_X ) {
D 69
		area_lines = area1_len - 1;
E 69
I 69
		area_lines = area1_len - 1 ;
E 69
		area2_y = area1_y ;
		disk_x = PROC_X ;
D 59
		tape_x = PROC_X + DISK_LEN + SPACE ;
E 59
D 69

		if( disks > area_lines )
			disks = area_lines ;
E 69
D 59

		if( tapes > area_lines )
			tapes = area_lines ;
E 59
	}
	else {
D 59
		area_lines = area2_len - (op->opt_disk ? 1 : 0 + op->opt_tape ? 1 : 0) ;
E 59
I 59
D 69
		area_lines = area2_len - (op->opt_disk ? 1 : 0) ;
E 69
I 69
		area_lines = area2_len ;
		disk_x = DISK_X ;
	}
E 69
E 59

D 59
		if( op->opt_disk && op->opt_tape )
E 59
I 59
D 69
		if( op->opt_disk )
E 59
			area_lines-- ;

E 69
I 69
	if( op->opt_disk ) {
E 69
		if( op->opt_total )
			area_lines -= 2 ;

D 69
		disk_x = DISK_X ;
D 59
		tape_x = TAPE_X ;
E 59

E 69
D 59
		if((disks + tapes) > area_lines )
			limit(area_lines, &disks, &tapes) ;
E 59
I 59
		if( disks > area_lines )
			disks = area_lines ;
E 59
D 69
	}
E 69

D 69
	if( op->opt_disk ) {
E 69
		disk_y = area2_y ;
		last_disk = disk_y + disks ;

		if( disk_x != PROC_X ) {
			area2_y += (2 + disks) ;

			if( op->opt_total )
				area2_y += 2 ;
		}
I 67

D 71
		last_lines[MON$K_DISK] = last_disk ;
E 71
I 71
		last_lines[MON$C_DISK] = last_disk ;
E 71
E 67
D 59
	}

	if( op->opt_tape ) {
		tape_y = area2_y ;
		last_tape = tape_y + tapes ;
E 59
	}
I 67

D 72
	lines = max(last_lines, MON$N_RECORDS) + 2 ;
E 72
I 72
	/*
	 *	The number of lines to be printed on a screen dump is
	 *	the largest value in the array last_lines + 2.
	 */
	lines = max(last_lines, MON$N_RECORDS) ;

	/*
	 *	If disk totals are turned on one or two more lines
	 *	will be added to this.
	 */
	if( op->opt_total ) {
		int	diff = lines - last_lines[MON$C_DISK] ;

		if( diff == 0 )
			lines += 2 ;
		else if( diff == 1 )
			lines += 1 ;
		else
			;
	}

	/*
	 *	Two more for all cases.
	 */
	lines += 2 ;
E 72
E 67
}

/*
I 67
 *	Find the largest value in an array.
 */
max(array, n)
int	*array, n ;
{
D 82
	int	i, max = array[0] ;
E 82
I 82
	int	i, value = array[0] ;
E 82

	for(i = 1; i < n; i++)
D 82
		if( array[i] > max )
			max = array[i] ;
E 82
I 82
		if( array[i] > value )
			value = array[i] ;
E 82

D 82
	return max ;
E 82
I 82
	return value ;
E 82
}

/*
E 67
 *	Change the value of a and/or b so that their total is <= total.
 */
limit(total, a, b)
D 67
int	 total ;
unsigned *a, *b ;
E 67
I 67
int	 total, *a, *b ;
E 67
{
	if( *a > *b ) {
		*a = ((double)(*a)/(*a + *b)) * total ;
		*b = total - *a ;
	}
	else {
		*b = ((double)(*b)/(*a + *b)) * total ;
		*a = total - *b ;
	}
I 40
}

#include <sgtty.h>

static	int	Speeds[] = {
	 2,	/* 0 */
	15,	/* 50 */
	12,	/* 75 */
	12,	/* 110 */
	10,	/* 134.5 */
	10,	/* 150 */
	 8,	/* 200 */
	 8,	/* 300 */
	 5,	/* 600 */
D 42
	 4,	/* 1200 */
E 42
I 42
	 5,	/* 1200 */
E 42
	 4,	/* 1800 */
	 3,	/* 2400 */
	 3,	/* 4800 */
	 2,	/* 9600 */
	 2,	/* EXTA */
	 2,	/* EXTB */
};

/*
 *	From the above return a sleep time, which is likely to
 *	provide enough time between updates to have the cursor
 *	sit at the prompt.  (i.e. Don't spend all the time redraw-
 *	ing the screen.)
 */
ttyspeed()
{
	struct sgttyb buf ;

D 41
	if( ioctl(fileno(stdout), TIOCGETP, (char *)&buf) == -1 )
E 41
I 41
	if( ioctl(fileno(stdout), (int)TIOCGETP, (char *)&buf) == -1 )
E 41
		return 2 ;
	else
		return Speeds[buf.sg_ospeed] ;
I 49
}

/*
 *	Simple help for screen display.
 */
help_screen()
{
D 50
	if( LINES < 13 )
E 50
I 50
D 64
	if( LINES < 15 )
E 64
I 64
D 66
	if( lines < 15 )
E 66
I 66
	if( LINES < 15 )
E 66
E 64
E 50
		return ;

D 63
	clear() ;
E 63
I 63
D 64
	wclear(stdscr) ;
E 64
I 64
	wclear(wp) ;
E 64
E 63

D 63
	move(0, 0) ;
E 63
I 63
D 64
	wmove(stdscr, 0, 0) ;
E 64
I 64
	wmove(wp, 0, 0) ;
E 64
E 63

D 63
	printw("The commands recognized in screen mode are:\n\n") ;
E 63
I 63
D 64
	wprintw(stdscr, "The commands recognized in screen mode are:\n\n") ;
E 64
I 64
	wprintw(wp, "The commands recognized in screen mode are:\n\n") ;
E 64
E 63

D 50
	printw("\td - Dump copy of the screen to a file.\n") ;
	printw("\tq - Quit, which is the same as exit.\n") ;
	printw("\te - Exit, which is the same as quit.\n") ;
	printw("\tr - Redraw the screen.\n") ;
	printw("\t^L - Redraw the screen.\n") ;
	printw("\tm - \"Magnify\" a field.\n") ;
	printw("\tu - \"Unmagnify\", return to the default screen.\n\n") ;
E 50
I 50
D 63
	printw("\td  - Dump copy of the screen to a file.\n") ;
	printw("\tm  - \"Magnify\" a field.\n") ;
	printw("\tu  - \"Unmagnify\", return to the default screen.\n") ;
	printw("\tq  - Quit, which is the same as exit.\n") ;
	printw("\te  - Exit, which is the same as quit.\n") ;
	printw("\th  - This help screen.\n") ;
	printw("\t?  - This help screen.\n") ;
	printw("\tr  - Redraw the screen.\n") ;
	printw("\t^L - Redraw the screen.\n\n") ;
E 63
I 63
D 64
	wprintw(stdscr, "\td  - Dump copy of the screen to a file.\n") ;
	wprintw(stdscr, "\tm  - \"Magnify\" a field.\n") ;
	wprintw(stdscr, "\tu  - \"Unmagnify\", return to the default screen.\n") ;
	wprintw(stdscr, "\tq  - Quit, which is the same as exit.\n") ;
	wprintw(stdscr, "\te  - Exit, which is the same as quit.\n") ;
	wprintw(stdscr, "\th  - This help screen.\n") ;
	wprintw(stdscr, "\t?  - This help screen.\n") ;
	wprintw(stdscr, "\tr  - Redraw the screen.\n") ;
	wprintw(stdscr, "\t^L - Redraw the screen.\n\n") ;
E 64
I 64
	wprintw(wp, "\td  - Dump copy of the screen to a file.\n") ;
	wprintw(wp, "\tm  - \"Magnify\" a field.\n") ;
	wprintw(wp, "\tu  - \"Unmagnify\", return to the default screen.\n") ;
	wprintw(wp, "\tq  - Quit, which is the same as exit.\n") ;
	wprintw(wp, "\te  - Exit, which is the same as quit.\n") ;
	wprintw(wp, "\th  - This help screen.\n") ;
	wprintw(wp, "\t?  - This help screen.\n") ;
	wprintw(wp, "\tr  - Redraw the screen.\n") ;
	wprintw(wp, "\t^L - Redraw the screen.\n\n") ;
E 64
E 63
E 50

D 63
	printw("All commands cause the next sample to be taken and displayed.\n") ;
E 63
I 63
D 64
	wprintw(stdscr, "All commands cause the next sample to be taken and displayed.\n") ;
E 64
I 64
	wprintw(wp, "All commands cause the next sample to be taken and displayed.\n") ;
E 64
E 63

	continue_prompt() ;
E 49
E 40
E 36
D 35
}

E 26
message(s, arg1, arg2, arg3)
I 34
char	*s ;
E 34
{
	mvprintw(LINES-2, 0, s, arg1, arg2, arg3);
	clrtoeol();
	refresh();
	sleep(1);
E 35
E 17
E 8
E 5
E 4
E 3
}
E 1
