h33913
s 00010/00000/00319
d D 1.28 90/03/29 16:17:32 alan 28 27
c The hack to fix the DECmumble include file problem.
e
s 00003/00000/00316
d D 1.27 89/05/07 22:43:59 alan 27 26
c added rusage structure to LAST record
e
s 00003/00003/00313
d D 1.26 89/04/19 08:16:22 alan 26 25
c fix width problem for the DS3100 and NULL terminated the current_date string instead of new-line terminating it
e
s 00003/00003/00313
d D 1.25 89/02/25 09:57:03 alan 25 24
c editorial change to rec_ elements
e
s 00001/00001/00315
d D 1.24 89/02/17 18:53:48 alan 24 23
c added username and group strings to PID record.  Also fixed a big in sample.c that didn't write the elapsed time correctly
e
s 00000/00001/00316
d D 1.23 89/02/17 17:04:13 alan 23 22
c moved M_DATESIZE to include.h
e
s 00002/00001/00315
d D 1.22 89/02/17 16:00:07 alan 22 21
c dust off lint
e
s 00102/00009/00214
d D 1.21 89/02/17 13:34:01 alan 21 20
c changed format of sample display to match dump of first record.  Also moved control record dump functions from functions.c to sample.c
e
s 00058/00012/00165
d D 1.20 89/02/17 12:32:52 alan 20 19
c limit the width of strings based on screen width
e
s 00009/00001/00168
d D 1.19 88/06/27 18:16:40 alan 19 18
c changed include of monitor.h and record.h
e
s 00009/00001/00160
d D 1.18 88/03/17 14:34:25 alan 18 17
c fixed length problem of Ultrix version string
e
s 00001/00001/00160
d D 1.17 87/11/18 16:40:23 alan 17 16
c V0.99 -> T1.0-1
e
s 00002/00001/00159
d D 1.16 87/11/18 12:17:29 alan 16 15
c V0.98
e
s 00005/00000/00155
d D 1.15 87/08/10 21:27:31 alan 15 14
c See commentary on V0.92 in version.c
e
s 00028/00023/00127
d D 1.14 87/05/20 17:15:20 alan 14 13
c changed all curses calls to use w... versions
e
s 00019/00020/00131
d D 1.13 87/04/17 15:47:39 alan 13 12
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00009/00001/00142
d D 1.12 87/04/03 14:32:06 alan 12 11
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00004/00004/00139
d D 1.11 87/03/03 18:08:26 alan 11 10
c clean up some on lint on sprintf's
e
s 00000/00005/00143
d D 1.10 87/02/05 16:29:38 alan 10 9
c See comment on V0.81 in version.c.
c 
e
s 00032/00002/00116
d D 1.9 87/02/01 10:57:40 alan 9 8
c change format of elapsed time, V0.78
e
s 00017/00009/00101
d D 1.8 87/01/30 16:09:33 alan 8 7
c See commenary on V0.76 in version.c
e
s 00004/00000/00106
d D 1.7 87/01/21 16:37:26 alan 7 6
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00046/00020/00060
d D 1.6 86/12/07 22:23:27 alan 6 5
c See V0.57 in version.c
e
s 00001/00001/00079
d D 1.5 86/08/26 18:05:03 alan 5 4
c modify all SccsId strings
e
s 00000/00003/00080
d D 1.4 86/07/13 14:40:14 alan 4 3
c dust off even more lint
e
s 00009/00015/00074
d D 1.3 86/07/11 19:34:02 alan 3 2
c Dust off LOTS of lint...
c 
e
s 00029/00017/00060
d D 1.2 86/06/29 15:27:07 alan 2 1
c Assorted work on the magnify function and general cleanup.
c 
e
s 00077/00000/00000
d D 1.1 86/06/27 10:48:54 alan 1 0
c date and time created 86/06/27 10:48:54 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Code to magnify the sample record.
I 6
 *
 *	Print the headers and display the static data and other interesting
 *	data from the "first" record.
E 6
 */
#ifndef	lint
D 5
static	char	SccsId[] = "%W% %G%" ;
E 5
I 5
D 6
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 6
I 6
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 6
E 5
#endif

I 19
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of record.h to monitor.h.
I 20
 *
 * Feb. 15, 1989 -- arr
 *
 *	Added limits the width of strings that are printed and more
 *	data to the sample display.
I 21
 *
 * Feb. 17, 1989 -- arr
 *
 *	Moved f_first(), f_last(), f_sample() from functions.c.
I 28
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 28
E 21
E 20
 */

E 19
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 2
#include <curses.h>
E 2

#include <sys/types.h>
#include <sys/dk.h>
I 7
#include <sys/param.h>
#include <sys/dir.h>
I 28

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 28
#include <sys/user.h>
D 8
#include <sys/devio.h>
E 8
E 7
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 21
#include "include.h"
E 21
I 8
D 10
#ifdef	V20
#	include <sys/devio.h>
#endif

E 10
E 8
D 12
#include "extern.h"
E 12
D 14
#include "options.h"
E 14
D 19
#include "record.h"
E 19
I 19
#include "monitor.h"
I 21
#include "extern.h"
E 21
E 19

I 12
/*
D 21
 *	Data objects defined elsewhere.
 */
extern	struct mon_sample sample ;
extern	struct mon_first  first ;

/*
E 21
I 14
 *	Default display.
 */
I 15
extern	int	lines ;		/* length of screen being used */
I 20
extern	int	cols ;		/* width of screen being used */
E 20
E 15
extern	WINDOW	*wp ;

/*
E 14
 *	Functions that don't return an (int).
 */
E 12
I 3
char	*ctime(),
I 22
	*strncpy(),
E 22
I 21
	*str_arch(),
E 21
D 9
	*str_data() ;
E 9
I 9
	*str_data(),
	*format_time() ;
E 9

I 8
static	mag_ticks = 0 ;

E 8
E 3
/*
 *	Display the changing data.
 *
 *	(date and elapsed time)
I 6
 *
 *	Because all of the magnify functions print the same first
 *	two pieces of infromation, I've moved the common code into
 *	their own functions.
 *
 *	ARGSUSED
E 6
 */
I 3
D 6

/* ARGSUSED */

E 6
E 3
D 14
magnify_sample(op)
OPTION	*op ;
E 14
I 14
magnify_sample()
E 14
{
D 2
	mvprintw(2, 0, "%9s   %.2f   %24s",
		"vmblus", sample.mon_etime, ctime(&sample.mon_timestamp));
E 2
I 2
D 6
	mvprintw(12, 14, "%.2f\n", sample.mon_etime);
	mvprintw(13, 14, "%23s\n", ctime(&sample.mon_timestamp));
E 6
I 6
D 8
	sample_body(14) ;
E 8
I 8
	sample_body((double)(sample.mon_ticks - mag_ticks)/first.mon_hz);
E 8
E 6
E 2

I 8
	mag_ticks = sample.mon_ticks ;
D 13

E 8
	refresh() ;
E 13
}

I 15
D 16
#define	SAMPLE_LINES	(14)
E 16
I 16
D 20
#define	SAMPLE_LINES	(15)
E 20
I 20
D 21
#define	SAMPLE_LINES	(18)
E 21
I 21
#define	SAMPLE_LINES	(20)
E 21
D 23
#define	M_DATESIZE	(32)
E 23
E 20
E 16

E 15
/*
I 20
 *	This is arbitrarily chosen number that accounts for the 
 *	member headers and a couple of character at the end of the
 *	screen.
 */
#define	SAMPLE_WIDTH	(17)

/*
E 20
D 6
 *	Print the headers and display the static data and other interesting
 *	data from the "first" record.
E 6
I 6
 *	Print the header for the sample record.
 *
 *	ARGSUSED
E 6
D 3
 *
D 2
 *	() - Version:      %s
 *	() - Start date:   %s
 *	() - Hostname:     %s
 *	() - Physmem:      %d
 *	() - Hz:           %d
 *	() - Options:      %s
 *	() - Sleep time:   %s
 *	() - # of Netif's: %s
 *	() - # of Disks:   %s
 *	() - # of Tapes:   %s
 *	() - # of CPU's:   %s
E 2
I 2
 *	(0,-) - Version:      %s
 *	(1,-) - Start date:   %s
 *	(2,-) - Hostname:     %s
 *	(3,-) - Physmem:      %d
 *	(4,-) - Hz:           %d
 *	(5,-) - Options:      %s
 *	(6,-) - Sleep time:   %s
 *	(7,-) - # of Netif's: %s
 *	(8,-) - # of Disks:   %s
 *	(9,-) - # of Tapes:   %s
 *     (10,-) - # of CPU's:   %s
E 2
 *
D 2
 *	() - Elapsed time: %s
 *	() - Current time: %s
E 2
I 2
 *    (12,14) - Elapsed time: %s
 *    (13,14) - Current time: %.2f
E 3
E 2
 */
I 3
D 6

/* ARGSUSED */

E 6
E 3
D 14
open_sample(op)
OPTION	*op ;
E 14
I 14
open_sample()
E 14
{
I 18
	char	*newline, *strchr() ;
I 20
	char	boot_time[M_DATESIZE+1], start_time[M_DATESIZE+1] ;
	int	width ;
E 20

E 18
D 6
	clear() ;
E 6
I 6
	sample_header() ;
I 15

	lines = SAMPLE_LINES ;
I 20
	width = cols - SAMPLE_WIDTH ;
E 20
E 15
E 6

I 20
	boot_time[M_DATESIZE] = '\0' ;
	start_time[M_DATESIZE] = '\0' ;

E 20
D 2
	mvprintw(0, 0, "Options: %s\n", "<sample...>");
	printw("Hostname:   Elapsed time:   Date:");
E 2
I 2
D 6
	mvprintw(0, 0, "Version:      %s", first.mon_version);
	printw("Start date:   %s", ctime(&first.mon_sdate));
E 6
I 6
D 13
	printw("Version:      %s", first.mon_version);
	printw("Start date:   %s", ctime((long *)&first.mon_sdate));
E 6
	printw("Hostname:     %s\n", first.mon_hostname);
D 6
	printw("Physmem:      %d pages\n", first.mon_physmem);
	printw("Hz:           %d\n", first.mon_hz);
	printw("Options:      <%s>\n", str_data(first.mon_options));
E 6
	printw("Sleep time:   %d seconds\n", first.mon_sleep);
	printw("# of Netif's: %d\n", first.mon_netif);
	printw("# of Disks:   %d\n", first.mon_disk);
D 10
	printw("# of Tapes:   %d\n", first.mon_tape);
E 10
D 6
	printw("# of CPU's:   %d\n\n", first.mon_cpu);
	printw("Elapsed time:\n");
	printw("Current time:\n");
E 6
I 6
	printw("# of CPU's:   %d\n", first.mon_cpu);
	printw("Physmem:      %d pages\n", first.mon_physmem);
	printw("Hz:           %d\n", first.mon_hz);
	printw("Options:      <%s>\n", str_data(first.mon_options));
E 6
E 2

	refresh() ;
E 13
I 13
D 14
	wprintw(stdscr, "Version:      %s", first.mon_version);
	wprintw(stdscr, "Start date:   %s", ctime((long *)&first.mon_sdate));
	wprintw(stdscr, "Hostname:     %s\n", first.mon_hostname);
	wprintw(stdscr, "Sleep time:   %d seconds\n", first.mon_sleep);
	wprintw(stdscr, "# of Netif's: %d\n", first.mon_netif);
	wprintw(stdscr, "# of Disks:   %d\n", first.mon_disk);
	wprintw(stdscr, "# of CPU's:   %d\n", first.mon_cpu);
	wprintw(stdscr, "Physmem:      %d pages\n", first.mon_physmem);
	wprintw(stdscr, "Hz:           %d\n", first.mon_hz);
	wprintw(stdscr, "Options:      <%s>\n", str_data(first.mon_options));
E 14
I 14
D 18
	wprintw(wp, "Version:      %s", first.mon_version);
E 18
I 18
	/*
	 *	A quick little bandage for old data files.
	 */
	if((newline = strchr(first.mon_version, '\n')) != NULL )
		*newline = '\0' ;

D 20
	wprintw(wp, "Version:      %s\n", first.mon_version);
E 18
I 17
	wprintw(wp, "Boot Time:    %s", ctime((long *)&first.mon_boot.tv_sec)) ;
E 17
	wprintw(wp, "Start date:   %s", ctime((long *)&first.mon_sdate));
	wprintw(wp, "Hostname:     %s\n", first.mon_hostname);
E 20
I 20
	(void)strncpy(boot_time, ctime((long *)&first.mon_boot.tv_sec), M_DATESIZE) ;
	(void)strncpy(start_time, ctime((long *)&first.mon_sdate), M_DATESIZE) ;

	/*
	 *	Take the new lines off the dates.
	 */
	if((newline = strchr(boot_time, '\n')) != NULL )
		*newline = '\0' ;

	if((newline = strchr(start_time, '\n')) != NULL )
		*newline = '\0' ;

	wprintw(wp, "Version:      %-.*s\n", width, first.mon_version);
	wprintw(wp, "Boot Time:    %-.*s\n", width, boot_time) ;
	wprintw(wp, "Start date:   %-.*s\n", width, start_time);
I 21
	wprintw(wp, "Monitor:      V%d.%d\n", major(first.mon_record),
		minor(first.mon_record)) ;

	wprintw(wp, "Arch.:        %-.*s\n", width, str_arch(first.mon_arch)) ;
E 21
	wprintw(wp, "Hostname:     %-.*s\n", width, first.mon_hostname);
E 20
	wprintw(wp, "Sleep time:   %d seconds\n", first.mon_sleep);
D 20
	wprintw(wp, "# of Netif's: %d\n", first.mon_netif);
	wprintw(wp, "# of Disks:   %d\n", first.mon_disk);
	wprintw(wp, "# of CPU's:   %d\n", first.mon_cpu);
	wprintw(wp, "Physmem:      %d pages\n", first.mon_physmem);
E 20
I 20
D 21
	wprintw(wp, "# of Netif's: %d\n", first.mon_netif) ;
	wprintw(wp, "# of Disks:   %d\n", first.mon_disk) ;
E 21
	wprintw(wp, "# of CPU's:   %d\n", first.mon_cpu) ;
I 21
	wprintw(wp, "# of Disks:   %d\n", first.mon_disk) ;
	wprintw(wp, "# of Netif's: %d\n", first.mon_netif) ;
E 21
	wprintw(wp, "# of BUF's:   %d\n", first.mon_buf) ;
	wprintw(wp, "Physmem:      %d Kb.\n", pgtok(first.mon_physmem)) ;
E 20
	wprintw(wp, "Hz:           %d\n", first.mon_hz);
I 16
D 17
	wprintw(wp, "Boot Time:    %s", ctime((long *)&first.mon_boot.tv_sec)) ;
E 17
E 16
D 20
	wprintw(wp, "Options:      <%s>\n", str_data(first.mon_options));
E 20
I 20
	wprintw(wp, "NBPG:         %d\n", first.mon_nbpg) ;
	wprintw(wp, "DEV_BSIZE:    %d\n", first.mon_bsize) ;
	wprintw(wp, "Options:      <%-.*s>\n", width, str_data(first.mon_options));
E 20
E 14
E 13
I 6
}

/*
 *	The common code for all magnify headers.
 */
sample_header()
{
D 13
	clear() ;
E 13
I 13
D 14
	wclear(stdscr) ;
E 14
I 14
	wclear(wp) ;
E 14
E 13

D 13
	move(0, 0) ;
E 13
I 13
D 14
	wmove(stdscr, 0, 0) ;
E 14
I 14
	wmove(wp, 0, 0) ;
E 14
E 13

D 13
	printw("Elapsed time:\n");
	printw("Current time:\n\n");
E 13
I 13
D 14
	wprintw(stdscr, "Elapsed time:\n");
	wprintw(stdscr, "Current time:\n\n");
E 14
I 14
	wprintw(wp, "Elapsed time:\n");
	wprintw(wp, "Current time:\n\n");
E 14
E 13
}

I 8
#define	BODY_OFFSET	(14)
I 26
#define	DATE_WIDTH	(24)
E 26

E 8
/*
D 8
 *	The common code to print the elapsed tiem and current
 *	current time.  The 'x' offset is passed because the
 *	functions that call it align the fields differently.
E 8
I 8
 *	The common code to print the elapsed time and current
 *	current time.
E 8
 */
D 8
sample_body(offset)
int	offset ;
E 8
I 8
sample_body(etime)
double	etime ;
E 8
{
I 20
D 26
	register width = cols - SAMPLE_WIDTH ;
E 26
	char	 current_time[M_DATESIZE], *newline, *strchr() ;

	current_time[M_DATESIZE] = '\0' ;

	(void)strncpy(current_time, ctime((long *)&sample.mon_timestamp),
		M_DATESIZE) ;

	if((newline = strchr(current_time, '\n')) != NULL )
D 26
		*newline = '\n' ;
E 26
I 26
		*newline = '\0' ;
E 26

E 20
D 8
	mvprintw(0, offset, "%.2f\n", sample.mon_etime);
	mvprintw(1, offset, "%23s\n", ctime((long *)&sample.mon_timestamp));
E 8
I 8
D 9
	mvprintw(0, BODY_OFFSET, "%.2f\n", etime);
E 9
I 9
D 13
	mvprintw(0, BODY_OFFSET, "%s\n", format_time(etime));
E 9
	mvprintw(1, BODY_OFFSET, "%23s\n", ctime((long *)&sample.mon_timestamp));
E 13
I 13
D 14
	wmove(stdscr, 0, BODY_OFFSET) ;
	wprintw(stdscr, "%s\n", format_time(etime));
E 14
I 14
	wmove(wp, 0, BODY_OFFSET) ;
D 20
	wprintw(wp, "%s\n", format_time(etime));
E 20
I 20
D 24
	wprintw(wp, "%.*s", width, format_time(etime));
E 24
I 24
	wprintw(wp, "%s\n", format_time(etime));
E 24
E 20
E 14

D 14
	wmove(stdscr, 1, BODY_OFFSET) ;
	wprintw(stdscr, "%23s\n", ctime((long *)&sample.mon_timestamp));
E 14
I 14
	wmove(wp, 1, BODY_OFFSET) ;
D 20
	wprintw(wp, "%23s\n", ctime((long *)&sample.mon_timestamp));
E 20
I 20
D 26
	wprintw(wp, "%.*s", width, current_time) ;
E 26
I 26
	wprintw(wp, "%*.*s", DATE_WIDTH, DATE_WIDTH, current_time) ;
E 26
E 20
E 14
E 13
I 9
}

I 14
/*
 *	Turn an elapsed time into a readable string.
 */
E 14
char	*format_time(etime)
double	etime ;
{
	static	 char	buf[BUFSIZ] ;
	double	 fract ;
	register seconds, minutes, hours, days ;

	seconds = etime ;
	fract = (etime - seconds) + (seconds % 60) ;

	days = seconds / (24 * 60 * 60) ;
	seconds %= (24 * 60 * 60) ;
	hours = seconds / (60 * 60) ;
	seconds %= (60 * 60) ;
	minutes = seconds / 60 ;

	if( days )
D 11
		sprintf(buf, "%d %2d:%02.2d:%05.2f",
E 11
I 11
		(void)sprintf(buf, "%d %2d:%02.2d:%05.2f",
E 11
			days, hours, minutes, fract) ;
	else if( hours )
D 11
		sprintf(buf, "%d:%02.2d:%05.2f", hours, minutes, fract) ;
E 11
I 11
		(void)sprintf(buf, "%d:%02.2d:%05.2f", hours, minutes, fract) ;
E 11
	else if( minutes )
D 11
		sprintf(buf, "%d:%05.2f", minutes, fract) ;
E 11
I 11
		(void)sprintf(buf, "%d:%05.2f", minutes, fract) ;
E 11
	else
D 11
		sprintf(buf, "%.2f", fract) ;
E 11
I 11
		(void)sprintf(buf, "%.2f", fract) ;
E 11

	return buf ;
I 21
}

/*
 *	Dump the contents of the FIRST record.
 */
f_first(p)
struct mon_first *p ;
{
D 22
	char	*strchr(), *newline, *arch_string ;
E 22
I 22
	char	*strchr(), *newline ;
E 22

	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 25
	printf("%s.\n", records[MON$C_FIRST].rec_string) ;
E 25
I 25
	printf("%s.\n", records[MON$C_FIRST].string) ;
E 25

	/*
	 *	If the version string has a newline in it, replace it
	 *	with a NULL.  Otherwise force a NULL at the end of the
	 *	allocated space.
	 */
	if((newline = strchr(p->mon_version, '\n')) != NULL )
		*newline = '\0' ;
	else
		p->mon_version[MON$S_VERSION] = '\0' ;

	printf("\tversion:  %s\n", p->mon_version);
	printf("\tboot:     %s", ctime((long *)&p->mon_boot.tv_sec)) ;
	printf("\tsdate:    %s", ctime((long *)&p->mon_sdate));
	printf("\tmonitor:  V%d.%d\n", major(p->mon_record),
		minor(p->mon_record)) ;

	printf("\tarch:     %s\n", str_arch(p->mon_arch)) ;
	printf("\thostname: %s\n", p->mon_hostname);
	printf("\tsleep:    %d seconds\n", p->mon_sleep);
	printf("\tcpu:      %d\n", p->mon_cpu);
	printf("\tdisk:     %d\n", p->mon_disk);
	printf("\tnetif:    %d\n", p->mon_netif);
	printf("\tbuf:      %d\n", p->mon_buf);
	printf("\tphysmem:  %d Kb.\n", pgtok(p->mon_physmem));
	printf("\thz:       %d\n", p->mon_hz);
	printf("\tnbpg:     %d\n", p->mon_nbpg) ;
	printf("\tbsize:    %d\n", p->mon_bsize) ;
	printf("\tpid:      %d\n", p->mon_pid);

	printf("\toptions:  <%s>\n", str_data(p->mon_options));
}

/*
 *	Print the contents of the "last" record.
 */
f_last(p)
struct mon_last *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 25
	printf("%s.\n", records[MON$C_LAST].rec_string) ;
E 25
I 25
	printf("%s.\n", records[MON$C_LAST].string) ;
E 25

	printf("\tedate:   %s", ctime((long *)&p->mon_edate));
	printf("\tsignal:  %d\n", p->mon_signal);
	printf("\tcode:    %d\n", p->mon_code);
I 27

	printf("\tusage:\n") ;
	print_rusage(&p->mon_usage, "\t\t") ;
E 27
}

/*
 *	Print the contents of the sample record.
 */
f_sample(p)
struct mon_sample *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 25
	printf("%s.\n", records[MON$C_SAMPLE].rec_string) ;
E 25
I 25
	printf("%s.\n", records[MON$C_SAMPLE].string) ;
E 25

	printf("\ttimestamp: %s", ctime((long *)&p->mon_timestamp));
	printf("\tdatalen:   %d\n", p->mon_datalen);
	printf("\tticks:     %d ticks\n", p->mon_ticks) ;
}

char	*str_arch(arch)
int	arch ;
{
	if( arch == MON$C_VAX )
		return "VAX" ;
	else if( arch == MON$C_MIPS )
		return "MIPS" ;
	else
		return "Unknown archtecture." ;
E 21
E 9
E 8
E 6
}
D 4

close_sample()
{}
E 4
E 1
