h14296
s 00010/00000/00376
d D 1.45 90/03/29 16:16:50 alan 45 44
c The hack to fix the DECmumble include file problem.
e
s 00001/00001/00375
d D 1.44 89/05/18 14:46:42 alan 44 43
c fixed more error messages
e
s 00008/00008/00368
d D 1.43 89/02/25 09:57:17 alan 43 42
c editorial change to rec_ elements
e
s 00001/00001/00375
d D 1.42 89/02/13 18:41:28 alan 42 41
c fix a bug that caused space to be allocated for the BUF record based
c on the number of NETIF records.
c 
e
s 00001/00000/00375
d D 1.41 89/02/13 17:41:13 alan 41 40
c fixed bug that didn't set first.mon_buf
e
s 00014/00000/00361
d D 1.40 89/02/10 15:22:12 alan 40 39
c Change for new BUF record and RECONF record.
c 
e
s 00020/00000/00341
d D 1.39 89/01/18 16:55:30 alan 39 38
c added skeleton of FP conversion
e
s 00012/00002/00329
d D 1.38 88/06/27 18:16:27 alan 38 37
c changed include of monitor.h and record.h
e
s 00012/00012/00319
d D 1.37 87/11/18 16:41:21 alan 37 36
c V0.99 -> T1.0-1
e
s 00009/00009/00322
d D 1.36 87/08/12 15:27:10 alan 36 35
c error message clean up - V0.95
e
s 00000/00001/00331
d D 1.35 87/05/20 18:16:44 alan 35 34
c remove unneeded include file: screen.h
e
s 00012/00005/00320
d D 1.34 87/05/20 17:14:19 alan 34 33
c changed all curses calls to use w... versions
e
s 00005/00004/00320
d D 1.33 87/04/17 15:47:02 alan 33 32
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00001/00001/00323
d D 1.32 87/04/03 14:31:34 alan 32 31
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00033/00324
d D 1.31 87/03/06 10:41:52 alan 31 30
c see commenary on V0.86
e
s 00008/00000/00349
d D 1.30 87/03/03 15:42:35 alan 30 29
c see the commentary for V0.83 in version.c
e
s 00001/00014/00348
d D 1.29 87/02/05 16:29:29 alan 29 28
c See comment on V0.81 in version.c.
c 
e
s 00008/00000/00354
d D 1.28 87/02/04 16:23:55 alan 28 27
c see V0.80 in version.c
e
s 00004/00003/00350
d D 1.27 87/01/30 11:11:15 alan 27 26
c #2 and #3 of V0.75
e
s 00004/00000/00349
d D 1.26 87/01/21 16:37:17 alan 26 25
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00049/00036/00300
d D 1.25 86/12/30 11:20:58 alan 25 24
c See commentary on V0.64 in version.c
e
s 00014/00003/00322
d D 1.24 86/12/07 22:22:59 alan 24 23
c See V0.57 in version.c
e
s 00014/00015/00311
d D 1.23 86/11/18 12:42:18 alan 23 22
c See commentary on V0.55 in version.c
c 
e
s 00021/00007/00305
d D 1.22 86/11/17 18:42:12 alan 22 21
c See commentary on V0.54 in version.c
c 
e
s 00002/00002/00310
d D 1.21 86/11/16 16:31:53 alan 21 20
c See comments for V0.51 in version.c
c 
e
s 00002/00002/00310
d D 1.20 86/09/29 20:02:41 alan 20 19
c remove the lint
e
s 00011/00030/00301
d D 1.19 86/09/28 14:59:33 alan 19 18
c Fixed the 2nd session bug.  To simplify what was going on, I moved the
c record read functions to their own module (get_records.c).  The eventual
c fix was to have the FIRST case of replay return MON_CONTINUE, instead of
c normal.  You can still get strange results from turning off "eatit", but
c that is expected.
c 
e
s 00001/00001/00330
d D 1.18 86/08/26 18:04:30 alan 18 17
c modify all SccsId strings
e
s 00000/00008/00331
d D 1.17 86/08/01 14:18:12 alan 17 16
c 1.  Remove some lint caused by the addition of extra arguments on 
c     error function.  It has been reduced to a  mininium but is still
c     there.
c 2.  Make totals for disk and tapes static instead of dynamic.
c 3.  Merged stack.c code into uba.c and mba.c.  There were some pointers
c     that needed to be changed.
c 
c TODO: There is still a bug in multiple session replay that causes the
c first disk I/O data to be negitive numbers.  Wierd...
c 
e
s 00002/00001/00337
d D 1.16 86/07/31 14:07:43 alan 16 15
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00002/00001/00336
d D 1.15 86/07/31 13:20:23 alan 15 14
c 1.  Fixed bug that caused "unmagify" to produce a very off the wall error
c message and exit without cleaning up.
c 2.  Fixed bug in magnify that would cause a panic when selecting a non-
c existing function.
c 3.  Enhanced replay and options to remember what the original display
c functions for multi session save files.
c 
e
s 00009/00050/00328
d D 1.14 86/07/30 17:28:02 alan 14 13
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00020/00021/00358
d D 1.13 86/07/11 19:32:19 alan 13 12
c Dust off LOTS of lint...
c 
e
s 00002/00002/00377
d D 1.12 86/07/01 12:56:23 alan 12 11
c Since delta_fork and delta_tty always know where their data structure
c is, I removed the argument and replace it with the external reference.
c 
e
s 00003/00002/00376
d D 1.11 86/06/30 13:17:47 alan 11 10
c Change the function "we_want_more" (or whatever it was) to "next_session".
c The code itself is still ugly, but at least the name looks reasonable.
c 
e
s 00019/00007/00359
d D 1.10 86/06/30 13:11:46 alan 10 9
c Fix a bug in replay that was causing the fork and tty data to get
c hosed over when replaying the 2nd+ session.  I added a function
c init_statics() to delta.c and called it from replay.c
c 
e
s 00003/00004/00363
d D 1.9 86/06/29 15:27:16 alan 9 8
c Assorted work on the magnify function and general cleanup.
c 
e
s 00091/00023/00276
d D 1.8 86/05/30 19:46:13 alan 8 7
c added to allow replaying multiple sessions
e
s 00007/00007/00292
d D 1.7 86/05/26 15:53:43 alan 7 6
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00002/00002/00297
d D 1.6 86/05/26 14:12:46 alan 6 5
c Turn begin and end_replay into open and close_replay.
c 
e
s 00002/00007/00297
d D 1.5 86/05/24 19:36:01 alan 5 4
c I made some big changes to options.h and how options where being handled.
c The changes to these files reflect those.  Most of the changes were caused
c by changing the names of things.
c 
c Added note: this is probably the last version of gather.c because it
c is going to become live.c very soon.
c 
e
s 00258/00000/00046
d D 1.4 86/05/23 21:09:03 alan 4 3
c Massive changes, but it works now.
c 
c To be added.
c 1.  Handle appearance of FIRST and LAST records better.
c 2.  Be able to handle "disk=ra0,hp1" and "netif=de0,ci0" type options.
c 
e
s 00002/00002/00044
d D 1.3 86/05/22 10:20:48 alan 3 2
c changed open and close to begin and end
c 
e
s 00001/00000/00045
d D 1.2 86/05/21 13:41:48 alan 2 1
c added options.h to include files
e
s 00045/00000/00000
d D 1.1 86/05/21 11:16:26 alan 1 0
c date and time created 86/05/21 11:16:26 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to replay collected data.
 */
#ifndef	lint
D 18
static	char	SccsId[] = "%W% %G%" ;
E 18
I 18
D 21
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 21
I 21
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 21
E 18
#endif

I 38
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 39
 *
 * Jan. 16, 1989 -- arr
 *
 *	Added skeleton of code needed to do floating point
 *	conversion between architectures.
I 40
 *
 * Feb. 10, 1989 -- arr
 *
 *	Added code to allocate space for BUF records.
I 45
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 45
E 40
E 39
 */

E 38
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 8
#include <curses.h>
E 8

#include <sys/types.h>
#include <sys/buf.h>
I 26
D 27
#include <sys/devio.h>
E 27
E 26
I 4
#include <sys/uio.h>
E 4
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
I 26
#include <sys/param.h>
#include <sys/dir.h>
I 45

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 45
#include <sys/user.h>
E 26
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 27
D 29
#ifdef	V20
#	include <sys/devio.h>
#endif

E 29
E 27
D 32
#include "extern.h"
E 32
D 38
#include "monitor.h"
E 38
I 38
#include "include.h"
E 38
I 2
#include "options.h"
E 2
D 38
#include "record.h"
E 38
I 38
#include "monitor.h"
E 38
I 32
#include "extern.h"
I 34
D 35
#include "screen.h"
E 35
E 34
E 32

I 24
/*
 *	Functions which don't return (int).
 */
E 24
I 4
char	*calloc() ;
I 20
D 24
void	get_sample() ;
E 24
E 20
D 27

I 24
double	delta_cpu() ;
E 27

void	free(),
	get_sample() ;

E 24
/*
I 22
 *	Module name for error functions.
 */
static	char	*module = "replay" ;

/*
I 28
 *	The record structure version number.
 */
extern	dev_t	record_version ;

/*
I 34
 *	Display information.
 */
extern	int	lines ;
extern	WINDOW	*wp ;

/*
E 34
E 28
E 22
D 5
 *	This will eventually be setable with an option...
 */
int	eatit = 1 ;		/* eat the first sample of every session */

/*
E 5
D 17
 *	A convient typedef and global data local to this file.
 *
E 17
D 25
 *	fd	   - This is the file descriptor of the data file.
D 14
 *	iov	   - The array of iovec's used to read the sample record.
D 10
 *	n_records  - This is the number of different record types
 *		in the sample record (as based on the options).  It
 *		is also the number of iovec's.
E 10
I 10
 *	n_records  - This is the number of different record types in the 
 *		     sample record (as based on the options).  It is also 
 *		     the number of iovec's.
E 14
 *	found_last - We found a last record.  Nice to see, but of little
 *		     consequence.
E 25
I 25
 *	fd	    - This is the file descriptor of the data file.
 *	found_last  - We found a last record.  Nice to see, but of little
 *		      consequence.
 *	have_sample - Since the replay open function has to read the
 *		      first sample, to get device names, that record
 *		      was ordinarily lost.  By using this as a flag I
 *		      can now display that first record.  This makes the
 *		      "eatit" option obsolete.
E 25
E 10
 */
D 14
typedef	struct iovec IOVEC ;
E 14
D 22

E 22
static	int	fd ;
D 14
static	IOVEC	*iov = 0 ;
static	int	n_records ;
E 14
I 8
static	int	found_last = 0 ;
I 25
static	int	have_sample = 0 ;
E 25
E 8

/*
 *	Open the data file and read the first record of the file.
 */
E 4
D 3
open_replay(op)
E 3
I 3
D 6
begin_replay(op)
E 6
I 6
open_replay(op)
E 6
E 3
OPTION	*op ;
{
I 4
	if((fd = open(op->opt_file, O_RDONLY, 0)) == -1 )
D 16
		fatal("monitor: replay: can't open data file: %s.\n");
E 16
I 16
D 23
		fatal("monitor: replay: can't open data file: %s (%s).\n",
			op->opt_file);
E 23
I 23
D 36
		fatal("can't open data file: %s (%s).\n", module, op->opt_file);
E 36
I 36
		fatal("Can't open data file: %s (%s).\n", module, op->opt_file);
E 36
E 23
E 16

	if( read(fd, (char *)&first, MON$S_FIRST) == -1 )
D 13
		fatal("monitor: can't read first record: %s.\n");
E 13
I 13
D 23
		fatal("monitor: replay: can't read first record: %s.\n");
E 23
I 23
D 36
		fatal("can't read first record: %s.\n", module);
E 36
I 36
		fatal("Can't read first record: %s.\n", module);
E 36
I 28

	if( first.mon_record != record_version )
D 36
		fatal("record structure/data file version mismatch.\n", module) ;
E 36
I 36
		fatal("Record structure/data file version mismatch.\n", module) ;
E 36
E 28
E 23
E 13

D 37
	if( first.mon_type != MON$K_FIRST )
E 37
I 37
	if( first.mon_type != MON$C_FIRST )
E 37
D 13
		panic("monitor: first record is not the right type!\n");
E 13
I 13
D 22
		panic("monitor: replay: first record is not the right type!\n");
E 22
I 22
D 36
		panic("first record is not the right type!\n", module);
E 36
I 36
		panic("First record is not the right type!\n", module);
E 36
E 22
E 13

	/*
	 *	Do the standalone portion of replay startup.
	 */	
D 8
	init_first(fd, op) ;
E 8
I 8
D 19
	init_first(op) ;
E 19
I 19
	first_record(op) ;
E 19
E 8
E 4
}

I 4
/*
 *	Given that a valid first record has been found, allocate
 *	the various structures that will be needed to store records
 *	and initialize any other data structures that have to setup.
 *
 *	This function will be written to be callable from almost
 *	ANYWHERE to setup a new replay session.
 */
D 8
init_first(fd, op)
int	fd ;
E 8
I 8
D 19
init_first(op)
E 19
I 19
first_record(op)
E 19
E 8
OPTION	*op ;
{
D 8
	IOVEC	 *gather_iovec() ;
E 8
I 8
D 14
	IOVEC	 *allocate_iovec() ;
E 14
E 8
D 25
	register i ;

E 25
	n_cpu = first.mon_cpu ;
	n_disk = first.mon_disk ;
D 29
	n_tape = first.mon_tape ;
E 29
	n_netif = first.mon_netif ;
I 41
	n_buf = first.mon_buf ;
E 41

I 25
	/*
	 *	Turn off the sample record as part of the
	 *	the size calculations.  This no longer affects
	 *	magnification of the first/sample record.
	 */
E 25
	op->opt_data = first.mon_options & ~MON$M_SAMPLE ;
I 25

	/*
I 30
	 *	Disable magnify functions that don't have a correspond-
	 *	ing data option.  Starting a new sessions should reset
	 *	the magnify mask, from the original command line
	 *	options (I'll try to add this later).
	 */
	op->opt_magnify &= op->opt_data ;

	/*
E 30
	 *	If the sleep time hasn't been set from the command
	 *	line, set it to what was originally saved.
	 */
E 25
D 5
	if( !op->opt_sleep_set )
E 5
I 5
	if( !op->sleep_set )
E 5
		op->opt_sleep = first.mon_sleep ;

I 10
D 25
/*
 *	Initialize the tty and fork structures.  (paging may get included
 *	later)
 *
 *	Allocates structure for disk's, tape's, netif's and cpu's.
 *
 *	Setup an I/O vector for the readv(2) call, used in replay itself.
 */
E 25
I 25
	/*
	 *	Initialize the tty and fork structures.  (paging may 
	 *	get included later)
	 */
E 25
	init_statics(op);

I 25
	/*
D 29
	 *	Allocates structure for disk's, tape's, netif's and cpu's.
E 29
I 29
	 *	Allocates structure for netif's and cpu's.
E 29
	 */
E 25
E 10
	allocate_dynamics(op) ;

I 25
	/*
	 *	Setup an I/O vector for the readv(2) call, used in 
	 *	replay itself.
	 */
E 25
D 8
	iov = gather_iovec(op) ;
E 8
I 8
D 14
	iov = allocate_iovec(op) ;
E 14
I 14
	init_iovec(op);
E 14
E 8

D 10
	/*
	 *	Use replay() to read the first record of the file
	 *	because we need it to get the device names.
	 */
E 10
I 10
D 25
/*
D 19
 *	Use replay() to read the first record of the file
 *	because we need it to get the device names.
E 19
I 19
 *	Get the next record and hope that it is a sample.  If it is,
 *	then get the actual sample.
E 19
 */
E 25
I 25
	/*
	 *	Get the next record and hope that it is a sample.  If
	 *	it is, then get the actual sample.
	 */
E 25
E 10
D 19
	if( replay(op) == -1 )
E 19
I 19
D 37
	if( get_record(fd) != MON$K_SAMPLE )
E 37
I 37
	if( get_record(fd) != MON$C_SAMPLE )
E 37
E 19
D 13
		fatal("monitor: can't read first sample: %s.\n");
E 13
I 13
D 23
		fatal("monitor: replay: can't read first sample: %s.\n");
E 23
I 23
D 36
		fatal("can't read first sample: %s.\n", module);
E 36
I 36
		fatal("Can't read first sample: %s.\n", module);
E 36
E 23
E 13

I 19
	get_sample(fd, iov, n_records) ;

E 19
D 5
	if( eatit ) {
E 5
I 5
D 25
	if( op->opt_eatit ) {
E 5
		if( op->opt_fork )
D 12
			delta_fork(&fork);
E 12
I 12
			delta_fork();
E 12

I 24
		if( op->opt_tty )
			delta_tty();

E 24
		if( op->opt_netif )
			for(i = 0; i < n_netif; i++)
				delta_netif(netif + i);

		if( op->opt_disk )
			for(i = 0; i < n_disk; i++)
				delta_disk(disk + i);

D 24
		if( op->opt_tty )
D 12
			delta_tty(&tty);
E 12
I 12
			delta_tty();
E 24
I 24
		if( op->opt_cpu )
			for(i = 0; i < n_cpu; i++)
				(void)delta_cpu(cpu + i) ;
E 24
E 12
	}
E 25
I 25
	/*
I 39
	 *	If the architectures don't match do the floating
	 *	point conversions.
	 */
	if( architecture != first.mon_arch )
		convert_fp(op) ;

	/*
E 39
	 *	Set the sample flag so that replay() won't try to read one.
	 */
	have_sample = 1 ;
E 25
}

/*
 *	Read data samples to initialize the internal records.
 */
E 4
replay(op)
OPTION	*op ;
{
I 4
D 20
	struct 	mon_header header ;
	int	rc, type, size ;
E 20
I 20
	register type ;
E 20

I 25
	/*
	 *	Clear the sample flag and return.
	 */
	if( have_sample ) {
		have_sample = 0 ;
		return MON_NORMAL ;
	}

/*
 *	Read the next record.
 */
E 25
D 19
/*
 *	Read the header of the next record in the file.
 *
 *	If an error occurs (rc == -1) exit with a fatal error.
 *
D 8
 *	Otherwise if EOF is reached (rc == 0) set the killed flag
 *	and return.
E 8
I 8
 *	Otherwise if EOF is reached (rc == 0) and return with MON_EXIT.
E 8
 */
	if((rc = read(fd, (char *)&header, MON$S_HEADER)) == -1 )
D 13
		fatal("monitor: can't read record: %s.\n");
E 13
I 13
		fatal("monitor: replay: can't read record: %s.\n");
E 13
D 8
	else if( rc == 0 ) {
		killed = 1 ;
		return -1 ;
	}
E 8
I 8
	else if( rc == 0 )
E 19
I 19
	if((type = get_record(fd)) == -1 )
E 19
		return MON_EXIT ;
E 8

I 8
/*
D 19
 *	Save the record type and the (remainder of the) record size.
 *	Then read in the rest of that record.
 */
E 8
	type = header.mon_type ;
	size = header.mon_length - MON$S_HEADER ;

I 8
	if( read(fd, records[type].rec_addr + MON$S_HEADER, size) <= 0 )
D 13
		fatal("monitor: can't read rest of record: %s.\n");
E 13
I 13
		fatal("monitor: replay: can't read rest of record: %s.\n");
E 13

E 8
/*
E 19
 *	Depending on the type of record that we actually read:
 *
D 8
 *	Sample: read the rest of the record and then read the
 *	sample that occurs after it.
E 8
I 8
 *	Sample: Read the sample that occurs after it.
E 8
 *
D 8
 *	Last:   For now set the killed flag and return.  Later we'll
 *	try and read the next record which should be a "first" record
 *	or the end of the file.
E 8
I 8
D 9
 *	Last:   Make a node that we found the "last" record and
E 9
I 9
 *	Last:   Make a note that we found the "last" record and
E 9
 *	return with MON_CONTINUE.
E 8
 *
D 9
 *	First:	For now we print a warning message and set the killed
 *	flag.  Later we will give the user the option of replaying
 *	the session that follows.
E 9
I 9
 *	First:	We will give the user the option of replaying the 
 *	session that follows.
E 9
 *
 *	Anything else:  Panic!
 */
	switch( type ) {
D 37
	case MON$K_SAMPLE:
E 37
I 37
	case MON$C_SAMPLE:
E 37
D 8
		if( read(fd, records[type].rec_addr + MON$S_HEADER, size) <= 0 )
			fatal("monitor: can't read rest of record: %s.\n");

E 8
D 19
		if( readv(fd, iov, n_records) <= 0 )
D 13
			fatal("monitor: can't read sample: %s.\n");
E 13
I 13
			fatal("monitor: replay: can't read sample: %s.\n");
E 13

E 19
I 19
		get_sample(fd, iov, n_records) ;
I 39

		/*
		 *	If the architectures don't match do the floating
		 *	point conversions.
		 */
		if( architecture != first.mon_arch )
			convert_fp(op) ;

E 39
E 19
		break ;
D 37
	case MON$K_LAST:
E 37
I 37
	case MON$C_LAST:
E 37
I 8
		found_last = 1 ;
		return MON_CONTINUE ;
E 8
D 37
	case MON$K_FIRST:
E 37
I 37
	case MON$C_FIRST:
E 37
D 8
		killed = 1 ;
		return -1 ;
E 8
I 8
D 11
		if( !we_want_more())
E 11
I 11
		if( next_session(op) == 0 )
E 11
			return MON_EXIT ;

		found_last = 0 ;

D 22
		(*op->close_display)(op) ;
E 22
I 22
		if( op->close_display )
			(*op->close_display)(op) ;
E 22

		free_totals(op);
		free_dynamics(op);
D 13
		free(iov);
E 13
I 13
D 15
		free((char *)iov);
E 15
I 15

		restore_display(op);
E 15
E 13

D 19
		init_first(op) ;
E 19
I 19
		first_record(op) ;
E 19

D 22
		(*op->open_display)(op) ;
E 22
I 22
		if( op->open_display )
			(*op->open_display)(op) ;
E 22

E 8
D 19
		break ;
E 19
I 19
		return MON_CONTINUE ;
E 19
	default:
D 13
		panic("monitor: unexpected data record.\n");
E 13
I 13
D 22
		panic("monitor: replay: unexpected data record.\n");
E 22
I 22
D 36
		panic("unexpected data record.\n", module);
E 36
I 36
		panic("Unexpected data record!\n", module);
E 36
E 22
E 13
	}

D 8
	return 0 ;
E 8
I 8
	return MON_NORMAL ;
E 8
E 4
}

I 4
/*
 *	Free up virtual memory in reverse order from how it was
 *	allocated and generally clean up.
 */
E 4
D 3
close_replay(op)
E 3
I 3
D 6
end_replay(op)
E 6
I 6
close_replay(op)
E 6
E 3
OPTION	*op ;
{
I 4
	free_totals(op);

	free_dynamics(op) ;

	if( close(fd) == -1 )
D 13
		warning("monitor: replay(): can't close data file: %s.\n");
E 13
I 13
D 22
		warning("monitor: replay: can't close data file: %s.\n");
E 22
I 22
D 36
		warning("can't close data file: %s.\n", module);
E 36
I 36
		warning("Can't close data file: %s.\n", module);
E 36
E 22
E 13
}

/*
D 14
 *	Count the number of records, then allocate space for that
 *	many iovec's and set them to the initial values.
 */
D 8
IOVEC	*gather_iovec(op)
E 8
I 8
IOVEC	*allocate_iovec(op)
E 8
OPTION	*op ;
{
	register data = op->opt_data, iovcnt = 0, i ;
	IOVEC	 *iov ;

I 8
	n_records = 0 ;

E 8
	for(i = 0; i < sizeof(op->opt_data) * 8; i++)
		if( data & (1 << i))
			n_records++ ;

D 13
	if((iov = (IOVEC *)calloc(n_records, sizeof(IOVEC))) == NULL )
		fatal("monitor: replay: can't calloc iovec's: %s.\n");
E 13
I 13
	if((iov = (IOVEC *)calloc((unsigned)n_records, sizeof(IOVEC))) == NULL )
		fatal("monitor: replay: no space for iovec's: %s.\n");
E 13

	for(i = 0; i < sizeof(op->opt_data) * 8; i++)
		if( data & (1 << i)) {
			iov[iovcnt].iov_base = records[i].rec_addr ;
			iov[iovcnt].iov_len = records[i].rec_size ;
			iovcnt++ ;
		}

	return iov ;
}

/*
E 14
 *	Allocate space the dynamic records.
 */
allocate_dynamics(op)
OPTION	*op ;
{
	register char *p ;
D 13
	register int  i ;
E 13

D 7
	if( op->opt_state ) {
		if((p = calloc(n_cpu, MON$S_STATE)) == NULL )
E 7
I 7
	if( op->opt_cpu ) {
		if((p = calloc(n_cpu, MON$S_CPU)) == NULL )
E 7
D 13
			fatal("monitor: can't calloc space for cpu's: %s.\n");
E 13
I 13
D 23
			fatal("monitor: replay: no space for mon_cpu's: %s.\n");
E 23
I 23
D 36
			fatal("no space for mon_cpu's: %s.\n", module);
E 36
I 36
			fatal("Can't allocate space for CPU structures: %s.\n", module);
E 36
E 23
E 13

D 7
		state = (struct mon_state *)p ;
E 7
I 7
		cpu = (struct mon_cpu *)p ;
E 7

D 7
		records[MON$K_STATE].rec_addr = p ;
		records[MON$K_STATE].rec_size = n_cpu * MON$S_STATE ;
E 7
I 7
D 37
		records[MON$K_CPU].rec_addr = p ;
		records[MON$K_CPU].rec_size = n_cpu * MON$S_CPU ;
E 37
I 37
D 43
		records[MON$C_CPU].rec_addr = p ;
		records[MON$C_CPU].rec_size = n_cpu * MON$S_CPU ;
E 43
I 43
		records[MON$C_CPU].addr = p ;
		records[MON$C_CPU].size = n_cpu * MON$S_CPU ;
E 43
I 40
	}

	if( op->opt_buf ) {
D 42
		if((p = calloc(n_netif, MON$S_BUF)) == NULL )
E 42
I 42
		if((p = calloc(n_buf, MON$S_BUF)) == NULL )
E 42
D 44
			fatal("Can't allocate space for buf structures: %s.\n", module);
E 44
I 44
			fatal("Can't allocate space for BUF structures: %s.\n", module);
E 44

		mon_buf = (struct mon_buf *)p ;

D 43
		records[MON$C_BUF].rec_addr = p ;
		records[MON$C_BUF].rec_size = n_buf * MON$S_BUF ;
E 43
I 43
		records[MON$C_BUF].addr = p ;
		records[MON$C_BUF].size = n_buf * MON$S_BUF ;
E 43
E 40
E 37
E 7
	}

I 23
	if( op->opt_netif ) {
		if((p = calloc(n_netif, MON$S_NETIF)) == NULL )
D 36
			fatal("no space for mon_netif's: %s.\n", module);
E 36
I 36
			fatal("Can't allocate space for netif structures: %s.\n", module);
E 36

		netif = (struct mon_netif *)p ;

D 37
		records[MON$K_NETIF].rec_addr = p ;
		records[MON$K_NETIF].rec_size = n_netif * MON$S_NETIF ;
E 37
I 37
D 43
		records[MON$C_NETIF].rec_addr = p ;
		records[MON$C_NETIF].rec_size = n_netif * MON$S_NETIF ;
E 43
I 43
		records[MON$C_NETIF].addr = p ;
		records[MON$C_NETIF].size = n_netif * MON$S_NETIF ;
E 43
E 37
	}

E 23
I 14
/*
 *	addr can probably be initialized statically.
 */
E 14
	if( op->opt_disk ) {
D 14
		if((p = calloc(n_disk, MON$S_DISK)) == NULL )
D 13
			fatal("monitor: can't calloc space for disk's: %s.\n");
E 13
I 13
			fatal("monitor: replay: no space for mon_disk's: %s.\n");
E 13

		disk = (struct mon_disk *)p ;

		records[MON$K_DISK].rec_addr = p ;
E 14
I 14
D 37
		records[MON$K_DISK].rec_addr = (char *)disk ;
E 14
		records[MON$K_DISK].rec_size = n_disk * MON$S_DISK ;
E 37
I 37
D 43
		records[MON$C_DISK].rec_addr = (char *)disk ;
		records[MON$C_DISK].rec_size = n_disk * MON$S_DISK ;
E 43
I 43
		records[MON$C_DISK].addr = (char *)disk ;
		records[MON$C_DISK].size = n_disk * MON$S_DISK ;
E 43
E 37
D 29
	}

I 14
/*
 *	addr can probably be initialized statically.
 */
E 14
	if( op->opt_tape ) {
D 14
		if((p = calloc(n_tape, MON$S_TAPE)) == NULL )
D 13
			fatal("monitor: can't calloc space for tape's: %s.\n");
E 13
I 13
			fatal("monitor: replay: no space for mon_tape's: %s.\n");
E 13

		tape = (struct mon_tape *)p ;

		records[MON$K_TAPE].rec_addr = p ;
E 14
I 14
		records[MON$K_TAPE].rec_addr = (char *)tape ;
E 14
		records[MON$K_TAPE].rec_size = n_tape * MON$S_TAPE ;
E 29
D 23
	}

	if( op->opt_netif ) {
		if((p = calloc(n_netif, MON$S_NETIF)) == NULL )
D 13
			fatal("monitor: can't calloc space for netif's: %s.\n");
E 13
I 13
			fatal("monitor: replay: no space for mon_netif's: %s.\n");
E 13

		netif = (struct mon_netif *)p ;

		records[MON$K_NETIF].rec_addr = p ;
		records[MON$K_NETIF].rec_size = n_netif * MON$S_NETIF ;
E 23
	}

	allocate_totals(op);
}

/*
 *	Free the space allocated for records.
 */
free_dynamics(op)
OPTION	*op ;
{
D 7
	if( op->opt_state )
		free(state);
E 7
I 7
	if( op->opt_cpu )
D 13
		free(cpu);
E 13
I 13
		free((char *)cpu);
E 13
E 7
D 17

	if( op->opt_disk )
D 13
		free(disk);
E 13
I 13
		free((char *)disk);
E 13

	if( op->opt_tape )
D 13
		free(tape);
E 13
I 13
		free((char *)tape);
E 17
E 13

	if( op->opt_netif )
D 13
		free(netif);
E 13
I 13
		free((char *)netif);
E 13
I 8
}

/*
 *	It has been determined that another session exists after
 *	the one we just finished.  Ask the user if he wants it.
 */
D 11
we_want_more()
E 11
I 11
next_session(op)
OPTION	*op ;
E 11
{
	int	y = 0 ;

D 13
	if( using_curses )  {
E 13
I 13
D 21
	if( op->display_mode == OPT_SCREEN )  {
E 21
I 21
	if( op->opt_curses )  {
E 21
E 13
D 33
		clear() ;
E 33
I 33
D 34
		wclear(stdscr) ;
E 34
I 34
		wclear(wp) ;
E 34
E 33

		if( found_last )
			y = screen_last(y) ;

		screen_first(y) ;

D 33
		mvprintw(LINES-1, 0, "Do you want to continue? ");
E 33
I 33
D 34
		wmove(stdscr, LINES - 1, 0) ;
		wprintw(stdscr, "Do you want to continue? ");
		wrefresh(stdscr) ;
E 34
I 34
D 37
		wmove(wp, lines - 1, 0) ;
E 37
I 37
		wmove(wp, LINES - 1, 0) ;
E 37
		wprintw(wp, "Do you want to continue? ");
		wrefresh(wp) ;
E 34
E 33

D 33
		refresh() ;
		if( getch() == 'n' )
E 33
I 33
D 34
		if( wgetch(stdscr) == 'n' )
E 34
I 34
		if( wgetch(wp) == 'n' )
E 34
E 33
			return 0 ;
	}
D 22
	else {
E 22
I 22
D 31
	else if( op->opt_inter ) {
E 22
		char	buf[BUFSIZ], *fgets() ;
E 31

D 31
		print_last() ;

		print_first() ;

		printf("Do you want to continue? ");

		if( fgets(buf, BUFSIZ, stdin) == NULL )
			return 0 ;

		if( buf[0] == 'n' )
			return 0 ;
	}
I 22
	else
		return 1 ;
E 22

E 31
	return 1 ;
D 31
}

I 22
/*
 *	Say that we found a last record.
 */
E 22
print_last()
{
	printf("Poof, there was a 'last' record.\n");
}

I 22
/*
 *	Say that we found a first record.
 */
E 22
print_first()
{
	printf("Poof, there was a 'first' record.\n");
E 31
E 8
E 4
}
E 1
