h24654
s 00383/00017/00034
d D 1.2 87/02/02 12:25:31 alan 2 1
c Copied from screen.c with all calls to curses functions replaced by
c stubs or removed.
c 
e
s 00051/00000/00000
d D 1.1 86/11/02 16:25:34 alan 1 0
c date and time created 86/11/02 16:25:34 by alan
e
u
U
t
T
I 1
/*
D 2
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
E 2
I 2
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
E 2
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 2
 *	%M% - Display function which doesn't do anything.
 *
 *	As a matter of form all these display functions have been
 *	given their own entry point.  The purpose of these functions
 *	is to have a display function which doesn't do anything so
 *	the collection phase can be monitored.
E 2
I 2
 *	%M% - Do everything but the I/O of the screen function.
E 2
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

I 2
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include <machine/param.h>

#ifdef	V20
#	include <sys/devio.h>
#endif

#include "extern.h"
#include "monitor.h"
#include "record.h"
#include "screen.h"
#include "options.h"

E 2
/*
D 2
 *	Perform any initialization that is necessary.
E 2
I 2
 *	pgtok - Turn number of pages into Kilobytes.
 *	SPACE - Number of spaces between fields.
E 2
 */
D 2
open_nop()
E 2
I 2
#define	pgtok(a)	((a)*NBPG/1024)

/*
 *	Various functions used that don't return (int).
 */
double	calculate_disk(),
	delta_tty(),
	delta_cpu(),
	delta_fork(),
	delta_netif() ;

char	*strchr(),
	*ctime(),
	*str_data() ;

/*
 *	Module name for error functions.
 */
static	char	*module = "nop" ;

/*
 *	<x,y> positions for the various fields.
 */
extern	cpu_y, cpu_x,
	tty_y, tty_x,
	proc_y, proc_x,
	tape_y, tape_x,
	free_y, free_x,
	fork_y, fork_x,
	disk_y, disk_x,
	netif_y, netif_x,
	page1_y, page1_x,
	page2_y, page2_x,
	memory_y, memory_x ;
/*
 *	Line that the last ... will be on because of lack of space.
 */
extern last_disk, last_tape, last_cpu, last_netif ;

/*
 *	This will be set by catch_sigwinch(), checked and cleared by 
 *	redraw_nop() if the nop changed size.
 */
extern	changed_size ;

/*
 *	Do whatever needs to be done to initialize the nop.  I suggest
 *	turning on curses and printing the headers.
 */
open_nop(op)
OPTION	*op ;
E 2
{
I 2
	struct winsize window ;

	if( getwindowsize(&window) != -1 ) {
		LINES = window.ws_row ;
		COLS = window.ws_col ;
	}

	op->opt_curses = 0 ;

	/*
	 *	Set the sleep time dependent on the terminal speed.
	 *	In REPLAY mode, the sleep time will be be used unless
	 *	set from the command line.
	 */
	if( !op->sleep_set && op->collect_mode != OPT_REPLAY )
		first.mon_sleep = op->opt_sleep = ttyspeed() ;

	screen_format(op, n_cpu, n_disk, n_tape, n_netif) ;

	if( op->redraw_display )
		(*op->redraw_display)(op) ;
E 2
}

/*
D 2
 *	Perform any clean up that is necessary.
E 2
I 2
 *	Do whatever needs to be done to clean up.
 *
 *	close_nop() might be extended someday to actually use the
 *	option structure.  Because of this the cleanup function which
 *	has been used in the error functions was stubd out by itself.
 *
 *	ARGSUSED
E 2
 */
D 2
close_nop()
E 2
I 2
close_nop(op)
OPTION	*op ;
E 2
{
}

/*
D 2
 *	Do the actual work of the display
E 2
I 2
 *	A macro to shorten the names of the pageing data.
E 2
 */
D 2
display_nop()
E 2
I 2
#define	Page	page.mon_meter

/*
 *	Format the data for output to the nop.
 */
nop(op)
OPTION	*op ;
E 2
{
I 2
	register i ;
	double	 etime ;

	nop_semi_static() ;

	if( op->opt_loadave ) {
		stub(LOADAVE_Y, LOADAVE_X);
		for(i = 0 ; i < MON$N_LOADAVE; i++)
			stub(LOADAVE_FORMAT, loadave.mon_loadave[i]);
	}

	if( op->opt_user )
		stub(USERS_Y, USERS_X, "%3d user%s", user.mon_user,
			user.mon_user == 1 ? " " : "s");

	if( op->opt_proc ) {
		proc_ticks = sample.mon_ticks ;
		stub(proc_y+1, proc_x+PROC_OFF, PROC_FORMAT, proc.mon_rq,
			proc.mon_dw, proc.mon_pw, proc.mon_sl, proc.mon_sw);
	}

	if( op->opt_memory ) {
		memory_ticks = sample.mon_ticks ;

		stub(memory_y+1, memory_x+MEMORY_OFF, MEMORY_FORMAT,
			pgtok(memory.mon_rm), pgtok(memory.mon_arm),
			pgtok(memory.mon_vm), pgtok(memory.mon_avm),
			pgtok(memory.mon_free)) ;
	}
	else if( op->opt_free ) {
		memory_ticks = sample.mon_ticks ;

		stub(free_y+1, free_x+FREE_OFF, FREE_FORMAT, 
			pgtok(freemem.mon_freemem));
	}

	if( op->opt_fork ) {
		etime = delta_fork(sample.mon_ticks);
		
		stub(fork_y+1, fork_x+FORK_OFF, FORK_FORMAT, 
			Fork.cntfork / etime,
			Fork.cntvfork / etime);
	}

	if( op->opt_page ) {
		paging_ticks = sample.mon_ticks ;

		stub(page1_y+1, page1_x+PAGE1_OFF, PAGE1_FORMAT,
			Page.v_pgrec - (Page.v_xsfrec + Page.v_xifrec),
			Page.v_xsfrec + Page.v_xifrec,
			pgtok(Page.v_pgpgin), pgtok(Page.v_pgpgout),
			pgtok(page.mon_deficit),
			Page.v_swpin, Page.v_swpout,
			Page.v_faults, Page.v_pgfrec);

		stub(page2_y+1, page2_x+PAGE2_OFF, PAGE2_FORMAT,
			pgtok(Page.v_pgin) + pgtok(Page.v_pgout),
			pgtok(Page.v_scan), pgtok(Page.v_dfree),
			Page.v_nexfod, Page.v_exfod,
			Page.v_nzfod, Page.v_zfod,
			Page.v_nvrfod, Page.v_vrfod);
	}

	if( op->opt_tty ) {
		etime = delta_tty(sample.mon_ticks);
		
		stub(tty_y+1, tty_x+TTY_OFF, TTY_FORMAT, 
			tty.mon_ttyin / etime, 
			tty.mon_ttyout / etime);
	}

	if( op->opt_cpu ) {
		double	total_time ;
		int	cursor = cpu_y ;

		for(i = 0; i < n_cpu ; i++) {
			if( cursor++ == last_cpu )
				break ;

			etime = delta_cpu(i, sample.mon_ticks, &total_time);

			stub(cursor, cpu_x+CPU_OFF, CPU_FORMAT,
				100. * cpu[i].mon_time[0] / total_time,
				100. * cpu[i].mon_time[1] / total_time,
				100. * cpu[i].mon_time[2] / total_time,
				100. * cpu[i].mon_time[3] / total_time,
				cpu[i].mon_swtch / etime) ;

			if( i == 0 ) 
				stub(cursor, cpu_x+CPU_OFF_1, CPU_FORMAT_1,
					cpu[0].mon_intr / etime,
					cpu[0].mon_syscall / etime);
		}
	}

	if( op->opt_netif ) {
		int	cursor = netif_y ;

		for(i = 0; i < n_netif; i++) {
			if( cursor++ == last_netif )
				break ;

			etime = delta_netif(i, sample.mon_ticks);

			stub(cursor, netif_x+NETIF_OFF, NETIF_FORMAT,
				netif[i].mon_ipackets / etime,
				netif[i].mon_ierrors / etime,
				netif[i].mon_opackets / etime, 
				netif[i].mon_oerrors / etime,
				netif[i].mon_collisions / etime);
		}
	}

	if( op->opt_disk ) {
		double	kbps, tps, tkbps = 0, ttps = 0 ;
		int	cursor = disk_y, msps ;

		for(i = 0; i < n_disk ; i++) {
			if( cursor++ == last_disk )
				break ;

			(void)calculate_disk(i, &kbps, &tps, &msps);

			stub(cursor, disk_x+DISK_OFF, DISK_FORMAT,
				kbps, tps, msps);

			if( op->opt_total ) {
				tkbps += kbps ;
				ttps  += tps ;
			}
		}

		/*
		 *	Print out the disk totals.
		 */
		if( op->opt_total )
			stub(last_disk+2, disk_x+TOTAL_OFF, TOTAL_FORMAT,
				tkbps, ttps);
	}
E 2
}

I 2
nop_prompt(op)
OPTION	*op ;
{
	stub(LINES-1, 0, op->opt_prompt);
}

nop_semi_static()
{
	char	*time_string, *newline ;

	stub(HOST_Y, HOST_X, HOST_FORMAT, HOST_LEN, HOST_LEN, 
		first.mon_hostname);

	time_string = ctime((long *)&sample.mon_timestamp);
	if((newline = strchr(time_string, '\n')) != NULL )
		*newline = '\0' ;

	stub(DATE_Y, DATE_X, DATE_FORMAT, time_string);
}

E 2
/*
D 2
 *	Redraw the output.  Quite often this will be the open function.
E 2
I 2
 *	Print the heading for the various fields.  Should only print
 *	headings for fields that are turned on.
E 2
 */
D 2
redraw_nop()
E 2
I 2
redraw_nop(op)
OPTION	*op ;
E 2
{
I 2
	register i ;

	if( changed_size ) {
		screen_format(op, n_cpu, n_disk, n_tape, n_netif) ;
		changed_size = 0 ;
	}

	if( op->opt_proc )
		stub(proc_y, proc_x, PROC_HEADING);

	if( op->opt_memory )
		stub(memory_y, memory_x, MEMORY_HEADING);

	if( op->opt_free )
		stub(free_y, free_x, FREE_HEADING);

	if( op->opt_fork )
		stub(fork_y, fork_x, FORK_HEADING);

	if( op->opt_cpu ) {
		int	cursor = cpu_y ;

		stub(cpu_y, cpu_x, CPU_HEADING);

		for(i = 0; i < first.mon_cpu; i++) {
			if( ++cursor > last_cpu )
				break ;

			stub(cursor, cpu_x, "#%d", cpu[i].mon_cpu);
		}

		if((last_cpu-cpu_y) < n_cpu )
			stub(LINES-1, NETIF_MORE, "<cpu>");
	}

	if( op->opt_tty )
		stub(tty_y, tty_x, TTY_HEADING);

	if( op->opt_page ) {
		stub(page1_y, page1_x, PAGE1_HEADING);
		stub(page2_y, page2_x, PAGE2_HEADING);
	}

	if( op->opt_disk ) {
		int	cursor = disk_y ;

		stub(disk_y, disk_x, DISK_HEADING);

		for(i = 0; i < first.mon_disk; i++) {
			if( ++cursor > last_disk )
				break ;

			stub(cursor, disk_x, "%s%d", disk[i].mon_name,
				disk[i].mon_unit);
		}

		if( op->opt_total )
			stub(last_disk+1, disk_x, TOTAL_LINE);

		if((last_disk-disk_y) < n_disk )
			stub(LINES-1, NETIF_MORE, "<disk>");
	}

	if( op->opt_tape ) {
		int	cursor = tape_y ;

		stub(tape_y, tape_x, TAPE_HEADING);
	
		for(i = 0; i < first.mon_tape; i++) {
			if( ++cursor > last_tape )
				break ;

			stub(cursor, tape_x, "%s%d", tape[i].mon_name,
				tape[i].mon_unit);
		}
	}

	if( op->opt_netif ) {
		int	cursor = netif_y ;

		stub(netif_y, netif_x, NETIF_HEADING);

		for(i = 0; i < n_netif; i++) {
			if( ++cursor > last_netif )
				break ;

			stub(cursor, netif_x, "%s%d", netif[i].mon_name,
				netif[i].mon_unit);
		}

		if((last_netif-netif_y) < n_netif )
			stub(LINES-1, NETIF_MORE, "<netif>");
	}
E 2
}

/*
D 2
 *	A function to print help, if that suits the mode of display.
E 2
I 2
 *	VARARGS
E 2
 */
D 2
help_nop()
E 2
I 2
stub()
E 2
{
}
E 1
