h17678
s 00020/00018/00878
d D 1.23 90/08/21 22:43:18 alan 23 22
c dust off lint
e
s 00021/00005/00875
d D 1.22 90/03/29 16:16:23 alan 22 21
c The hack to fix the DECmumble include file problem.
e
s 00031/00013/00849
d D 1.21 89/12/29 00:35:39 alan 21 20
c added more firewalls
e
s 00001/00001/00861
d D 1.20 89/12/28 15:43:04 alan 20 19
c Changed uses of vmunix to op->opt_kernel and setup opt_kernel correctly.
c 
e
s 00024/00011/00838
d D 1.19 89/12/27 16:11:00 alan 19 18
c Clean up architecture and version differences
e
s 00000/00002/00849
d D 1.18 89/12/27 10:54:14 alan 18 17
c dust off lint
e
s 00205/00060/00646
d D 1.17 89/12/25 15:35:26 alan 17 16
c Merge in V4.0 changes to base code
e
s 00038/00007/00668
d D 1.16 89/01/04 10:45:38 alan 16 15
c V1.1 changes for MIPS support.  This is a check-point of the current
c support.
c 
e
s 00007/00003/00668
d D 1.15 88/09/22 17:48:51 alan 15 14
c fix bogus use of sizeof(DEV_SIZE)
e
s 00009/00001/00662
d D 1.14 88/06/27 18:15:16 alan 14 13
c changed include of monitor.h and record.h
e
s 00062/00001/00601
d D 1.13 87/11/18 12:17:15 alan 13 12
c V0.98
e
s 00052/00001/00550
d D 1.12 87/09/14 18:56:01 alan 12 11
c see V0.96 in version.c for details
e
s 00012/00008/00539
d D 1.11 87/08/12 15:26:13 alan 11 10
c error message clean up - V0.95
e
s 00175/00070/00372
d D 1.10 87/08/11 13:00:33 alan 10 9
c V0.93 - new names code
e
s 00007/00014/00435
d D 1.9 87/04/05 13:26:25 alan 9 8
c 1.  Modified uba.c and names.c to take advantage of V2 uba_device
c     structure and use the correct controller number for reporting
c     controller on bus.
c 2.  Fixed bug in iovec setup code that caused bad disk data to be
c     written out on a save.
c 
e
s 00014/00018/00435
d D 1.8 87/04/03 13:15:48 alan 8 7
c Removed V20 dependencies, generally cleaned things up and rearranged
c include files that they compile under VAXC.  For some reason they
c don't run.
c 
e
s 00008/00003/00445
d D 1.7 87/02/05 16:28:20 alan 7 6
c See comment on V0.81 in version.c.
c 
e
s 00020/00016/00428
d D 1.6 87/01/21 16:36:13 alan 6 5
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00012/00002/00432
d D 1.5 86/12/07 22:23:38 alan 5 4
c See V0.57 in version.c
e
s 00002/00002/00432
d D 1.4 86/11/18 12:41:51 alan 4 3
c See commentary on V0.55 in version.c
c 
e
s 00116/00013/00318
d D 1.3 86/11/17 18:42:35 alan 3 2
c See commentary on V0.54 in version.c
c 
e
s 00001/00001/00330
d D 1.2 86/11/16 16:32:08 alan 2 1
c See comments for V0.51 in version.c
c 
e
s 00331/00000/00000
d D 1.1 86/11/06 11:59:04 alan 1 0
c date and time created 86/11/06 11:59:04 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Functions to read kernel names.
 *
 *	Some of these functions duplicate code that is elsewhere in
 *	monitor, but because modification of the original function
 *	would make it unwieldy and look like it had been hacked,
 *	I have rewritten the code here.
 */
#ifndef	lint
D 2
static	char	SccsId[] = "%W% %G%" ;
E 2
I 2
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 2
#endif

I 14
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
I 15
 *
 * 22-Sept-1988 -- arr
 *
 *	Fix bogus use of sizeof(DEV_SIZE) in MASSBUS code.
I 16
 *
 * 29-November-1988 -- arr
 *
 *	Add #ifdef's for MIPS version.
 *
 * 27-December-1988 -- arr
 *
 *	Added code to give more detail about MIPS based systems.
I 22
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 22
E 16
E 15
 */

E 14
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 13
D 22
#include <time.h>
E 22
E 13

#include <sys/types.h>
I 6
D 7
#include <sys/devio.h>
E 7
E 6
#include <sys/dk.h>
I 22
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
E 22
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
I 22
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 22
D 17
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
I 8
#include <sys/cpudata.h>
E 17
I 10
#include <sys/config.h>
I 22
#include <sys/cpudata.h>
E 22
E 10
E 8

I 17
#ifdef	V4_ULTRIX
D 19
#	include <sys/smp_lock.h>
E 19
I 19
D 22
#	include	<sys/smp_lock.h>
E 22
I 22
#	include <sys/namei.h>
E 22
E 19
#endif
I 22
#ifdef	mips
#	include <sys/fixpoint.h>
#endif
E 22

D 22
#include <sys/cpudata.h>

E 22
E 17
#include <net/if.h>
#include <netinet/in.h>

D 22
#include <machine/param.h>
E 22
I 16
#include <machine/pte.h>
I 22
#include <machine/param.h>
E 22
E 16

D 16
#include <vax/pte.h>
E 16
I 16
D 17
#ifdef	vax
E 17
I 17
D 19
#if defined(V4_ULTRIX) || defined(vax)
E 17
#	include <vaxmba/mbavar.h>
#	include <vaxmba/mbareg.h>
E 16
D 17

E 17
D 16
#include <vaxmba/mbavar.h>
#include <vaxmba/mbareg.h>
E 16
I 16
#	include <vaxuba/ubavar.h>
D 17
#endif
#ifdef	mips
E 17
I 17
#elif mips
E 17
#	include <machine/hwconf.h>
I 17
#	include "mbavar.h"
#	include "mbareg.h"
#	include "ubavar.h"
E 19
I 19
#ifdef	V4_ULTRIX
#	ifdef	vax
#		include <io/mba/vax/mbavar.h>
#		include <io/mba/vax/mbareg.h>
#		include <io/uba/ubavar.h>
#	elif	mips
#		include <io/uba/ubavar.h>
#		include <machine/cpuconf.h>
#		include "mbavar.h"
#		include "mbareg.h"
#	endif
#else
#	ifdef	vax
#		include <vaxmba/mbavar.h>
#		include <vaxmba/mbareg.h>
#		include <vaxuba/ubavar.h>
#	elif	mips
#		include <machine/cpuconf.h>
#		include "mbavar.h"
#		include "mbareg.h"
#		include "ubavar.h"
#	endif
E 19
E 17
#endif
E 16

D 16
#include <vaxuba/ubavar.h>

E 16
I 10
#include "pgtok.h"
E 10
I 5
D 8
#ifdef	V20
#	include	<sys/cpudata.h>
#else
#	include "cpudata.h"	/* this will eventually be <sys/cpudata.h> */
#endif

E 8
E 5
D 14
#include "monitor.h"
E 14
I 14
#include "include.h"
E 14
D 8
#include "extern.h"
E 8
#include "options.h"
D 5
#include "cpudata.h"	/* this will eventually be <sys/cpudata.h> */
E 5

I 17
#ifndef	MAXCPU
#	define	MAXCPU	(32)
#endif

E 17
I 5
/*
I 17
 *	This is the set of kernel symbol used just by the
 *	names code.  By only using the ones needed the nlist(3)
 *	call should be faster.
 */
#define	NAMES_ADPT		(0)
#define	NAMES_BOOT		(1)
#define	NAMES_CPU		(2)
#define	NAMES_CPUDATA		(3)
#define	NAMES_CPU_SUBTYPE	(4)
#define	NAMES_CPU_SYSTYPE	(5)
#define	NAMES_DK_XFER		(6)
#define	NAMES_IFNET		(7)
#define	NAMES_MAXCPU		(8)
#define	NAMES_MBDINIT		(9)
#define	NAMES_MBSINIT		(10)
#define	NAMES_PHYSMEM		(11)
#define	NAMES_UBDINIT		(12)

struct nlist names_nm[] = {
	{ "_config_adpt" },
	{ "_boottime" },
	{ "_cpu" },
	{ "_cpudata" },
	{ "_cpu_subtype" },
	{ "_cpu_systype" },
	{ "_dk_xfer" },
	{ "_ifnet" },
	{ "_maxcpu" },
	{ "_mbdinit" },
	{ "_mbsinit" },
	{ "_physmem" },
	{ "_ubdinit" },
	{ 0 }
} ;


/*
E 17
I 8
 *	Data objects declared elsewhere, but used locally.
 */
extern	int	kmem ;
D 17
extern	struct 	nlist	namelist[] ;
E 17
I 17
extern  long	dk_xfer[DK_NDRIVE] ;
extern	char	dk_map[DK_NDRIVE] ;
E 17

/*
E 8
I 7
 *	Taken from <sys/devio.h>.
 */
#define	DEV_SIZE	8

/*
I 17
 *	Alias the names of the CPUdata structure members.
 */
#ifdef	V4_ULTRIX
#	define	c_state		cpu_state
#	define	c_cptime	cpu_cptime
#	define	c_ident		cpu_num
#endif

/*
E 17
I 8
D 10
 *
 */
#define	pgtok(x)	(((x)*NBPG)/1024)

/*
E 10
E 8
E 7
 *	Functions which don't return (int).
 */
E 5
I 3
char	*str_cpuid(),
D 10
	*str_netif() ;
E 10
I 10
	*str_netif(),
I 12
	*str_state(),
I 23
	*strcpy(),
E 23
E 12
	*calloc() ;
E 10

I 5
D 10
void	nlist() ;
E 10
I 10
void	nlist(),
	free() ;
E 10

E 5
/*
 *	Module name for error functions.
 */
static	char	*module = "names" ;

/*
D 8
 *	pgtom   - Macro to turn the number of pages in megabytes.
D 6
 *	DEVSIZE - a reasonable size for device names.
E 6
 */
E 3
#define	pgtom(x)	((double)(x)*NBPG/(1024*1024))
D 6
#define	DEVSIZE		(32)
E 6

/*
E 8
I 3
 *	Get the configuration information from the expect places.
 *	Someday we may need the option structure.
E 3
 *
I 3
 *	ARGSUSED
E 3
 */
D 3
/* ARGSUSED */
E 3
names(op)
OPTION	*op ;
{
I 17
	register i ;

	/*
	 *	Clear the dk_map[].
	 */
	for(i = 0; i < DK_NDRIVE; i++)
		dk_map[i] = 0 ;

	/*
	 *	Print out information about the CPU(s).
	 */
E 17
	cpu_names() ;

I 16
D 17
#ifdef	vax
E 17
I 17
	/*
	 *	Devices that are UNIBUS style.  This includes
	 *	all sorts of stuff that don't even get close to
	 *	a UNIBUS, but the name is historical.
	 */
E 17
E 16
	uba_names() ;

I 17
	/*
	 *	Get the names of MASSBUS devices.
	 */
E 17
	mba_names() ;
D 16

E 16
I 16
D 17
#endif
E 17
I 17

	/*
	 *	We'll play tricks with the _dk_xxx data structures
	 *	to get names of missing disks.
	 */
	scsi_names() ;

	/*
	 *	Print the names and stats on network interfaces.
	 */
E 17
E 16
	netif_names() ;

	return MON_EXIT ;
}

/*
D 17
 *	Set up the namelist and open the kernel so we can get
E 17
I 17
 *	Set up the names_nm and open the kernel so we can get
E 17
D 3
 *	to the names.
E 3
I 3
 *	to the names.  Someday we may need the option structure.
 *
 *	ARGSUSED
E 3
 */
D 3
/* ARGSUSED */
E 3
open_names(op)
I 3
OPTION	*op ;
E 3
{
	/*
D 17
	 *	Initialize the namelist, nlist(x) doesn't return
E 17
I 17
	 *	Initialize the names_nm, nlist(x) doesn't return
E 17
	 *	anything to signify an error.
	 */
D 5
	nlist("/vmunix", namelist) ;
E 5
I 5
D 17
	(void)nlist("/vmunix", namelist) ;
E 17
I 17
D 20
	(void)nlist("/vmunix", names_nm) ;
E 20
I 20
	(void)nlist(op->opt_kernel, names_nm) ;
E 20
E 17
E 5

	/*
	 *	Open memory.
	 */
	if((kmem = open("/dev/kmem", O_RDONLY, 0)) == -1 )
D 4
		fatal("monitor: names: can't open memory: %s.\n") ;
E 4
I 4
D 11
		fatal("can't open memory: %s.\n", module) ;
E 11
I 11
		fatal("Can't open /dev/kmem: %s.\n", module) ;
E 11
E 4
}

/*
D 3
 *	Try to close /dev/kmem.  I hope it works...
E 3
I 3
 *	Try to close /dev/kmem.  I hope it works :-)
 *	Someday we may need the option structure.
 *
 *	ARGSUSED
E 3
 */
D 3
/* ARGSUSED */
E 3
close_names(op)
{
	if( close(kmem) == -1 )
D 4
		fatal("monitor: live: can't close memory: %s.\n") ;
E 4
I 4
D 11
		fatal("can't close memory: %s.\n", module) ;
E 11
I 11
		fatal("Can't close /dev/kmem: %s.\n", module) ;
E 11
E 4
}

/*
D 3
 *	Print something about the CPU.
E 3
I 3
 *	Print something about the CPU.  This is for pre V2.0 systems.
E 3
 */
static	cpu_names()
{
D 6
	int	sid, physmem ;
E 6
I 6
D 7
	int	sid, physmem, subtype = -1 ;
E 7
I 7
D 12
	int	sid, physmem ;
E 12
I 12
D 23
	int	sid, physmem, maxcpu ;
E 23
I 23
	int	sid, physmem, mon_maxcpu ;
E 23
E 12
D 17
	long	subtype = -1 ;
E 17
I 17
	long	subtype = -1, sid_addr ;
E 17
E 7
E 6
	caddr_t	addr ;
I 13
	struct timeval boot ;
E 13

D 17
	sid = getsid() ;
E 17
I 17
#ifdef	vax
	sid_addr = (long)names_nm[NAMES_CPU].n_value ;
#elif	mips
	sid_addr = (long)names_nm[NAMES_CPU_SYSTYPE].n_value ;
#endif
E 17

I 17
	sid = getsid(sid_addr) ;

E 17
I 12
	/*
	 *	Get the amount of physical memory.
	 */
E 12
D 17
	if((addr = (caddr_t)namelist[NM_PHYSMEM].n_value) == 0 ) {
E 17
I 17
	if((addr = (caddr_t)names_nm[NAMES_PHYSMEM].n_value) == 0 ) {
E 17
D 3
		warning("monitor: names: can't get physical memory size.\n") ;
E 3
I 3
D 11
		warning("can't get physical memory size.\n", module) ;
E 11
I 11
		warning("Can't get physical memory size.\n", module) ;
E 11
E 3
		return ;
	}
I 13
	else
		readk((long)addr, (char *)&physmem, sizeof(physmem)) ;
E 13

D 13
	readk((long)addr, (char *)&physmem, sizeof(physmem)) ;
E 13
I 13
	/*
	 *	Get the boot time.
	 */
D 17
	if((addr = (caddr_t)namelist[NM_BOOT].n_value) == 0 ) {
E 17
I 17
	if((addr = (caddr_t)names_nm[NAMES_BOOT].n_value) == 0 ) {
E 17
		warning("Can't get boot time.\n", module) ;
		return ;
	}
	else
		readk((long)addr, (char *)&boot, sizeof(boot)) ;
E 13

I 16
#ifdef	vax
E 16
I 12
	/*
	 *	Get the CPU subtype.
	 */
E 12
I 6
D 17
	if((addr = (caddr_t)namelist[NM_CPU_SUBTYPE].n_value) == 0 )
E 17
I 17
	if((addr = (caddr_t)names_nm[NAMES_CPU_SUBTYPE].n_value) == 0 )
E 17
		subtype = -1 ;
	else
D 7
		readk((long)addr, (char *)&subtype, sizeof(int)) ;
E 7
I 7
		readk((long)addr, (char *)&subtype, sizeof(long)) ;
I 16
D 17
#endif
#ifdef	mips
E 17
I 17
#elif	mips
E 17
D 19
	subtype = GETCPUTYPE(sid) ;
E 19
I 19
	subtype = -1 ;
E 19
#endif
E 16
E 7

E 6
	printf("#\n") ;
	printf("#\tCPU information.\n") ;
	printf("#\n") ;
I 13

E 13
D 6
	printf("%s with %.2f Mb.\n", str_cpuid(sid), pgtom(physmem)) ;
E 6
I 6
D 8
	printf("%s with %.2f Mb.\n", str_cpuid(sid, subtype), pgtom(physmem)) ;
E 6

	/*
	 *	For V2.0 I'll add more code here to print out more
	 *	information about the CPU(s).
	 */
E 8
I 8
	printf("%s with %d bytes of memory.\n", str_cpuid(sid, subtype),
		physmem * NBPG) ;
I 13
	printf("The system was booted on %24.24s\n", ctime((long *)&boot.tv_sec)) ;
	uptime(boot.tv_sec) ;
E 13
I 12

	/*
	 *	Find out how many CPU's there should be.
	 */
D 17
	if( namelist[NM_MAXCPU].n_value == 0 ) {
		warning("Can't find 'maxcpu'.\n", module) ;
		return ;
	}
E 17
I 17
	if( names_nm[NAMES_MAXCPU].n_value == 0 )
D 23
		maxcpu = MAXCPU ;
E 23
I 23
		mon_maxcpu = MAXCPU ;
E 23
	else
D 23
		maxcpu = get_word((long)names_nm[NAMES_MAXCPU].n_value) ;
E 23
I 23
		mon_maxcpu = get_word((long)names_nm[NAMES_MAXCPU].n_value) ;
E 23
E 17

D 17
	readk((long)namelist[NM_MAXCPU].n_value, (char *)&maxcpu, sizeof(maxcpu)) ;

E 17
D 23
	print_cpu_data(maxcpu) ;
E 23
I 23
	print_cpu_data(mon_maxcpu) ;
E 23
D 17

E 17
E 12
E 8
}

I 12
/*
 *	Print something about each cpu.  I'd like to see state, ident and
 *	and time in CPU states.
I 17
D 18
 *
 *	TODO: Update for V4 cpudata structure setups.
E 18
E 17
 */
D 17
print_cpu_data(n)
int	n ;
E 17
I 17
D 23
print_cpu_data(maxcpu)
int	maxcpu ;
E 23
I 23
print_cpu_data(mon_maxcpu)
int	mon_maxcpu ;
E 23
E 17
{
D 17
	struct cpudata cpudata, *p ;
E 17
I 17
D 23
	struct cpudata cpudata, *cpuaddr, *array[MAXCPU] ;
E 23
I 23
	struct cpudata mon_cpudata, *cpuaddr, *array[MAXCPU] ;
E 23
E 17
	int	i, state ;
	double	total ;

D 17
	p = (struct cpudata *)namelist[NM_CPUDATA].n_value ;
E 17
I 17
	/*
	 *	Initialize the cpudata array.
	 */
	for(i = 0; i < MAXCPU; i++)
		array[i] = 0 ;
E 17

D 17
	for(i = 0; i < n; i++) {
		readk((long)(p + i), (char *)&cpudata, sizeof(cpudata)) ;
D 16

E 16
I 16
/*
 *	The compiled for the MIPS set the CPU state to "run".  Hopefully
 *	this will be fixed in a future release.
 */
E 17
I 17
	/*
	 *	Get the starting point of cpudata structures.  In
	 *	V4.0 this is an array of addresses, before that
	 *	it is the address of the first structure.
	 */
	if((cpuaddr = (struct cpudata *)names_nm[NAMES_CPUDATA].n_value) == 0 ) {
		warning("The CPU data is not available.\n", module) ;
		return ;
	}

	/*
	 *	Build an array of the addresses.
	 */
#ifdef	V4_ULTRIX
	readk((long)cpuaddr, array, sizeof(array[0]) * MAXCPU) ;
#else
D 23
	for(i = 0; i < maxcpu; i++)
E 23
I 23
	for(i = 0; i < mon_maxcpu; i++)
E 23
		array[i] = cpuaddr + i ;
#endif

	/*
	 *	Then for each member in the array that has a non-
	 *	zero address, print information about that CPU.
	 */
	for(i = 0; i < MAXCPU; i++) {
		if( array[i] == 0 )
			continue ;

D 23
		readk((long)array[i], (char *)&cpudata, sizeof(cpudata)) ;
E 23
I 23
		readk((long)array[i], (char *)&mon_cpudata,
			sizeof(mon_cpudata)) ;
E 23

	/*
	 *	The compiled for the MIPS set the CPU state to "run".  
	 *	Hopefully this will be fixed in a future release.
	 */
E 17
#ifdef	mips
D 23
		cpudata.c_state = CPU_RUN ;
E 23
I 23
		mon_cpudata.c_state = CPU_RUN ;
E 23
#endif
E 16
		for(state = 0, total = 0; state < CPUSTATES; state++)
D 23
			total += cpudata.c_cptime[state] ;
E 23
I 23
			total += mon_cpudata.c_cptime[state] ;
E 23

		if( total == 0 )
			total = 1 ;

		printf("CPU #%d (%x): %.0f%% user, %.0f%% nice, %.0f%% system, %.0f%% idle; state: <%s>\n",
D 23
			i, cpudata.c_ident,
			100. * cpudata.c_cptime[CP_USER] / total,
			100. * cpudata.c_cptime[CP_NICE] / total,
			100. * cpudata.c_cptime[CP_SYS]  / total,
			100. * cpudata.c_cptime[CP_IDLE] / total,
			str_state(cpudata.c_state)) ;
E 23
I 23
			i, mon_cpudata.c_ident,
			100. * mon_cpudata.c_cptime[CP_USER] / total,
			100. * mon_cpudata.c_cptime[CP_NICE] / total,
			100. * mon_cpudata.c_cptime[CP_SYS]  / total,
			100. * mon_cpudata.c_cptime[CP_IDLE] / total,
			str_state(mon_cpudata.c_state)) ;
E 23
	}
}
E 12

I 16
D 17
#ifdef	vax
E 17
E 16
/*
D 3
 *
E 3
I 3
 *	Print out the MASSBUS device and slave names.
E 3
 */
D 3
/* ARGSUSED */
E 3
static	mba_names()
{
	struct mba_device device, *md ;
	struct mba_slave  slave,  *ms ;
	struct mba_driver driver ;
D 6
	char	dname[DEVSIZE+1], sname[DEVSIZE+1] ;
E 6
I 6
	char	dname[DEV_SIZE+1], sname[DEV_SIZE+1] ;
I 10
	int	header_printed = 0 ;
E 10
E 6

D 6
	dname[DEVSIZE] = '\0' ;
	sname[DEVSIZE] = '\0' ;
E 6
I 6
	dname[DEV_SIZE] = '\0' ;
	sname[DEV_SIZE] = '\0' ;
E 6

I 3
	/*
	 *	Make sure this is a reasonable place to start.
	 */
E 3
D 17
	if((md = (struct mba_device *)namelist[NM_MBDINIT].n_value) == 0 )
E 17
I 17
	if((md = (struct mba_device *)names_nm[NAMES_MBDINIT].n_value) == 0 )
E 17
		return ;

D 10
	printf("#\n") ;
	printf("#\tMASSBUS information.\n") ;
	printf("#\n") ;
E 10

	for( ; ; ) {
I 3
		/*
		 *	Read the device structure.
		 */
E 3
		readk((long)md, (char *)&device, sizeof(device)) ;

I 3
		/*
		 *	If this is the last one in the list, stop.
		 */
E 3
		if( device.mi_driver == 0 )
			break ;

I 10
		if( !header_printed ) {
D 17
			printf("#\n") ;
			printf("#\tMASSBUS information.\n") ;
			printf("#\n") ;
E 17
I 17
			printf("#\n#\tMASSBUS information.\n#\n") ;
E 17
			header_printed = 1 ;
		}

E 10
I 3
		/*
		 *	Read the driver structure and the device name.
		 */
E 3
		readk((long)device.mi_driver, (char *)&driver, sizeof(driver)) ;

D 6
		readk((long)driver.md_dname, (char *)dname, sizeof(DEVSIZE)) ;
E 6
I 6
D 15
		readk((long)driver.md_dname, (char *)dname, sizeof(DEV_SIZE)) ;
E 15
I 15
D 21
		readk((long)driver.md_dname, (char *)dname, DEV_SIZE) ;
E 21
I 21
		if( driver.md_dname == 0 )
			(void)strcpy(dname, "master") ;
		else
			readk((long)driver.md_dname, (char *)dname, DEV_SIZE) ;
E 21
E 15
E 6

I 3
		/*
		 *	Print the information out and go to the next
		 *	next device structure.
		 */
E 3
		printf("%s%d on mba%d drive %d %s alive.\n",
			dname, device.mi_unit,
			device.mi_mbanum, device.mi_drive,
			device.mi_alive ? "is" : "is not") ;

I 17
		/*
		 *	Mark this device in the dk_map[].
		 */
		if( device.mi_dk >= 0 && device.mi_dk < DK_NDRIVE )
			dk_map[device.mi_dk] = 1 ;

E 17
		md++ ;
	}

I 3
	/*
	 *	See if the beginning of the slave list is a reasonable
	 *	place to start.
	 */
E 3
D 17
	if((ms = (struct mba_slave *)namelist[NM_MBSINIT].n_value) == 0 )
E 17
I 17
	if((ms = (struct mba_slave *)names_nm[NAMES_MBSINIT].n_value) == 0 )
E 17
		return ;

	for( ; ; ) {
I 3
		/*
		 *	Read the slave structure.
		 */
E 3
		readk((long)ms, (char *)&slave, sizeof(slave)) ;

I 3
		/*
		 *	If this is the last one, stop.
		 */
E 3
		if( slave.ms_driver == 0 )
			break ;

I 3
		/*
		 *	Read the driver structure, device name and
		 *	slave name.
		 */
E 3
		readk((long)slave.ms_driver, (char *)&driver, sizeof(driver)) ;

D 6
		readk((long)driver.md_dname, (char *)dname, sizeof(DEVSIZE)) ;
E 6
I 6
D 15
		readk((long)driver.md_dname, (char *)dname, sizeof(DEV_SIZE)) ;
E 15
I 15
D 21
		readk((long)driver.md_dname, (char *)dname, DEV_SIZE) ;
E 21
I 21
		if( driver.md_dname == 0 )
			(void)strcpy(dname, "master") ;
		else
			readk((long)driver.md_dname, (char *)dname, DEV_SIZE) ;
E 21
E 15
E 6

D 6
		readk((long)driver.md_sname, (char *)sname, sizeof(DEVSIZE)) ;
E 6
I 6
D 15
		readk((long)driver.md_sname, (char *)sname, sizeof(DEV_SIZE)) ;
E 15
I 15
D 21
		readk((long)driver.md_sname, (char *)sname, DEV_SIZE) ;
E 21
I 21
		if( driver.md_sname == 0 )
			(void)strcpy(sname, "slave") ;
		else
			readk((long)driver.md_sname, (char *)sname, DEV_SIZE) ;
E 21
E 15
E 6

I 3
		/*
		 *	Print the information out and go to the
		 *	next one.
		 */
E 3
		printf("%s%d on %s%d slave %d %s alive.\n",
			sname, slave.ms_slave,
			dname, slave.ms_ctlr, slave.ms_slave,
			slave.ms_alive ? "is" : "is not") ;

		ms++ ;
	}
}
I 16
D 17
#endif
E 17
E 16

/*
D 3
 *
E 3
I 3
 *	Print out information about network devices.
E 3
 */
D 3
/* ARGSUSED */
E 3
static	netif_names()
{
	off_t	firstif, ip ;
	struct ifnet ifnet ;
	char	interface[IFNAMSIZ+1] ;

I 3
	/*
	 *	Make sure there is a list...
	 */
E 3
D 17
	if((ip = (off_t)namelist[NM_IFNET].n_value) == 0 )
E 17
I 17
	if((ip = (off_t)names_nm[NAMES_IFNET].n_value) == 0 )
E 17
		return ;

	interface[IFNAMSIZ] = '\0' ;

	printf("#\n") ;
	printf("#\tNetwork interface information.\n") ;
	printf("#\n") ;

I 3
	/*
	 *	Read the address of the first one.
	 */
E 3
	readk((long)ip, (char *)&firstif, sizeof(firstif)) ;

	ip = firstif ;

	while( ip ) {
I 3
		/*
		 *	Read the ifnet structure and the
		 *	interface name.
		 */
E 3
		readk((long)ip, (char *)&ifnet, sizeof(ifnet)) ;

D 21
		readk((long)ifnet.if_name, (char *)interface, IFNAMSIZ) ;
E 21
I 21
		if( ifnet.if_name == 0 )
			(void)strcpy(interface, "ifnet") ;
		else
			readk((long)ifnet.if_name, (char *)interface, IFNAMSIZ) ;
E 21

I 3
		/*
		 *	Print something interesting about
		 *	the interface.
		 */
E 3
		print_if(interface, &ifnet) ;

I 3
		/*
		 *	Goto the next one.
		 */
E 3
		ip = (off_t)ifnet.if_next ;
	}
}

I 3
/*
 *	Print extended information about network devices.
 */
E 3
static	print_if(name, ifp)
char	*name ;
struct ifnet *ifp ;
{
	register total = 0, n ;

	total = ifp->if_ipackets + ifp->if_opackets + 
		ifp->if_ierrors + ifp->if_oerrors + 
		ifp->if_collisions ;

	printf("%s%d is <%s>, with:\n", name, ifp->if_unit,
		str_netif(ifp->if_flags)) ;

	if( n = ifp->if_ipackets )
		printf("%10d (%.0f%%) input packets\n", n, 100.0 * n/total) ;

	if( n = ifp->if_ierrors )
		printf("%10d (%.0f%%) input errors\n", n, 100.0 * n/total) ;

	if( n = ifp->if_opackets )
		printf("%10d (%.0f%%) output packets\n", n, 100.0 * n/total) ;

	if( n = ifp->if_oerrors )
		printf("%10d (%.0f%%) output errors\n", n, 100.0 * n/total) ;

	if( n = ifp->if_collisions )
		printf("%10d (%.0f%%) collisions\n", n, 100.0 * n/total) ;
}

I 16
D 17
#ifdef	vax
E 17
E 16
/*
 *	Print information about UNIBUS or Q-BUS devices.
 */
D 3
/* ARGSUSED */
E 3
static	uba_names()
{
D 6
	char	*controller, *drive, dname[DEVSIZE+1], *print_controller() ;
E 6
I 6
D 10
	char	*controller, *drive, dname[DEV_SIZE+1], *print_controller() ;
E 6
D 3

E 3
	struct uba_device device, *up ;
D 9
	struct uba_driver driver ;
E 9
	struct uba_ctlr   *prevc = 0 ;
E 10
I 10
	struct config_adpt *p, adpt ;
	char	parent[BUFSIZ] ;
	int	i, header_printed = 0 ;
E 10

D 6
	dname[DEVSIZE] = '\0' ;
E 6
I 6
D 10
	dname[DEV_SIZE] = '\0' ;
E 10
I 10
D 11
	if((p = (struct config_adpt *)namelist[NM_ADPT].n_value) == 0 )
		warning("no config_adpt", module) ;
E 11
I 11
D 17
	if((p = (struct config_adpt *)namelist[NM_ADPT].n_value) == 0 ) {
		warning("No I/O bus data available.\n", module) ;
E 17
I 17
	if((p = (struct config_adpt *)names_nm[NAMES_ADPT].n_value) == 0 )
E 17
		return ;
D 17
	}
E 17
E 11
E 10
E 6

I 3
D 10
	/*
	 *	Make sure there is a list of UNIBUS devices.
	 */
E 3
	if((up = (struct uba_device *)namelist[NM_UBDINIT].n_value) == 0 )
		return ;
E 10
I 10
D 11
	if( namelist[NM_UBDINIT].n_value == 0 )
		warning("no udbinit", module) ;
E 11
I 11
D 17
	if( namelist[NM_UBDINIT].n_value == 0 ) {
		warning("No UNIBUS data available.\n", module) ;
E 17
I 17
	if( names_nm[NAMES_UBDINIT].n_value == 0 )
E 17
		return ;
D 17
	}
E 17
E 11
E 10

D 10
	printf("#\n") ;
	printf("#\tUNIBUS or Q-BUS information.\n") ;
	printf("#\n") ;
E 10
I 10
D 17
	build_table((struct uba_device *)namelist[NM_UBDINIT].n_value) ;
E 17
I 17
	build_table((struct uba_device *)names_nm[NAMES_UBDINIT].n_value) ;
E 17
E 10

D 10
	for( ; ; ) {
I 3
		/*
		 *	Read the device structure.
		 */
E 3
		readk((long)up++, (char *)&device, sizeof(device)) ;
E 10
I 10
	for(i = 0; ; i++) {
I 21
		if((p + i) == 0 )
			break ;

E 21
		readk((long)(p + i), (char *)&adpt, sizeof(adpt)) ;
E 10

I 3
D 10
		/*
		 *	If this is the last one, stop.
		 */
E 3
		if( device.ui_driver == 0 )
E 10
I 10
		if( adpt.p_name == 0 )
E 10
			break ;

I 3
D 10
		/*
D 9
		 *	If this is a new controller get the
		 *	controller name.  It is VERY convient
		 *	that the controller entry is followed
		 *	by the devices on the controller.
E 9
I 9
		 *	If this is a new controller get the controller 
		 *	name.  It is VERY convient that devices on the
		 *	same controller follow each other.
E 9
		 */
E 3
		if( device.ui_mi && device.ui_mi != prevc ) {
			controller = print_controller(device.ui_mi) ;
			prevc = device.ui_mi ;
E 10
I 10
		if( adpt.c_ptr == 0 )
			continue ;

		if( !header_printed ) {
D 17
			printf("#\n") ;
			printf("#\tUNIBUS, Q-BUS, VAXBI information.\n") ;
			printf("#\n") ;
E 17
I 17
			printf("#\n#\tUNIBUS, Q-BUS, VAXBI information.\n#\n") ;
E 17
			header_printed = 1 ;
E 10
		}

I 3
		/*
D 10
		 *	Read the driver structure and device name.
E 10
I 10
		 *	Read the parent adapter name.
E 10
		 */
E 3
D 9
		readk((long)device.ui_driver, (char *)&driver, sizeof(driver)) ;
E 9
I 9
D 10
		readk((long)device.ui_devname, (char *)dname, DEV_SIZE) ;
E 10
I 10
		readk((long)adpt.p_name, parent, BUFSIZ) ;
E 10
E 9

D 6
		readk((long)driver.ud_dname, (char *)dname, DEVSIZE) ;
E 6
I 6
D 9
		readk((long)driver.ud_dname, (char *)dname, DEV_SIZE) ;
E 6

E 9
I 3
D 10
		/*
		 *	Figure out if it is a slave (tape) or drive
		 *	(disk).
		 */
E 3
		if( device.ui_dk == -1 )
			drive = "slave" ;
		else
			drive = "drive" ;

I 3
		/*
		 *	Print some device information.
		 */
E 3
		if( device.ui_mi )
			printf("%s%d at %s%d %s %d %s alive.\n",
				dname, device.ui_unit,
D 9
				device.ui_mi ? controller : "uba",
				device.ui_ubanum, drive, device.ui_slave,
E 9
I 9
				controller, device.ui_ctlr,
				drive, device.ui_slave,
E 9
				device.ui_alive ? "is" : "is not") ;
		else
			printf("%s%d at uba%d %s alive.\n",
				dname, device.ui_unit, device.ui_ubanum,
				device.ui_alive ? "is" : "is not") ;
E 10
I 10
		switch( adpt.c_type ) {
		case 'A':
			print_iobus(&adpt, parent, adpt.p_num) ;
			break ;
		case 'D':
			print_device((struct uba_device *)adpt.c_ptr,
				parent, adpt.p_num) ;
			break ;
		case 'C':
			print_controller((struct uba_ctlr *)adpt.c_ptr,
				parent, adpt.p_num) ;
			break ;
		default:
			printf("unknown bus type: %c\n", adpt.c_type) ;
			break ;
		} 
E 10
	}
I 10

	free_table() ;
E 10
}

I 10
print_iobus(ap, parent, unit)
struct config_adpt *ap ;
char	*parent ;
int	unit ;
{
	char	controller[BUFSIZ] ;

	if( ap->c_num < 0 )
		return ;

D 21
	readk((long)ap->c_name, controller, BUFSIZ) ;
E 21
I 21
	if( ap->c_name == 0 )
		(void)strcpy(controller, "iobus") ;
	else
		readk((long)ap->c_name, controller, BUFSIZ) ;
E 21

	if( strcmp(parent, "nexus") == 0 )
		printf("%s%d is a nexus.\n", controller, ap->c_num) ;
	else
		printf("%s%d at %s%d %s alive.\n",
			controller, ap->c_num, parent, unit,
			ap->c_ptr == (char *)CONFIG_ALIVE ? "is" : "is not") ;
}

E 10
/*
 *	Print information about a controller and return its name.
 */
D 10
char	*print_controller(p)
E 10
I 10
print_controller(p, parent, unit)
E 10
struct uba_ctlr *p ;
I 10
char	*parent ;
int	unit ;
E 10
{
	struct uba_ctlr ctlr ;
I 10
D 21
	struct uba_driver driver ;
	struct uba_device *dp ;
E 21
E 10
D 9
	struct uba_driver driver ;
E 9
D 6
	static char controller[DEVSIZE+1] ;
E 6
I 6
	static char controller[DEV_SIZE+1] ;
E 6

D 6
	controller[DEVSIZE] = '\0' ;
E 6
I 6
	controller[DEV_SIZE] = '\0' ;
E 6

I 3
	/*
	 *	Read the controller structure.
	 */
E 3
	readk((long)p, (char *)&ctlr, sizeof(ctlr)) ;

D 10
	if( ctlr.um_driver == 0 )
		return NULL ;

E 10
I 3
	/*
	 *	Read the driver structure and controller name.
	 */
E 3
D 9
	readk((long)ctlr.um_driver, (char *)&driver, sizeof(driver)) ;

D 6
	readk((long)driver.ud_mname, (char *)controller, DEVSIZE) ;
E 6
I 6
	readk((long)driver.ud_mname, (char *)controller, DEV_SIZE) ;
E 9
I 9
D 21
	readk((long)ctlr.um_ctlrname, (char *)controller, DEV_SIZE) ;
E 21
I 21
	if( ctlr.um_ctlrname == 0 )
		(void)strcpy(controller, "ctlr") ;
	else
D 23
		readk(ctlr.um_ctlrname, (char *)controller, DEV_SIZE) ;
E 23
I 23
		readk((long)ctlr.um_ctlrname, (char *)controller, DEV_SIZE) ;
E 23
E 21
E 9
E 6

I 3
	/*
	 *	Print something about the controller.
	 */
E 3
D 10
	printf("%s%d at uba%d %s alive.\n", controller, ctlr.um_ctlr,
		ctlr.um_ubanum, ctlr.um_alive ? "is" : "is not") ;
E 10
I 10
	printf("%s%d at %s%d %s alive.\n", controller, ctlr.um_ctlr,
		parent, unit, ctlr.um_alive ? "is" : "is not") ;
E 10
I 3

E 3
D 10
	return controller ;
E 10
I 10
D 21
	readk((long)ctlr.um_driver, (char *)&driver, sizeof(driver)) ;

	readk((long)driver.ud_dinfo, (char *)&dp, sizeof(dp)) ;

E 21
	find_devices(p, controller, ctlr.um_ctlr) ;

	return ;
}

/*
 *	Print device information.
 */
print_device(p, parent, unit)
struct uba_device *p ;
char	*parent ;
int	unit ;
{
	char	dev_name[DEV_SIZE+1] ;
	struct uba_device device ;
	
	dev_name[DEV_SIZE] = '\0' ;

	/*
	 *	Read the device structure.
	 */
	readk((long)p, (char *)&device, sizeof(struct uba_device)) ;
	
	/*
	 *	Read the device name.
	 */
D 21
	readk((long)device.ui_devname, dev_name, DEV_SIZE) ;
E 21
I 21
	if( device.ui_devname == 0 )
		(void)strcpy(dev_name, "device") ;
	else
		readk((long)device.ui_devname, dev_name, DEV_SIZE) ;
E 21

	if( device.ui_mi )
D 17
		printf("%s%d at %s%d %s %d %s alive.\n",
			dev_name, device.ui_unit, parent, unit, 
E 17
I 17
		printf("%s%d at %s%d %s %d %s alive.\n", dev_name, 
			device.ui_unit, parent, unit, 
E 17
			device.ui_dk == -1 ? "slave" : "drive", device.ui_slave, 
			device.ui_alive ? "is" : "is not") ;
	else
		printf("%s%d at %s%d %s alive.\n", dev_name, device.ui_unit, 
			parent, unit, device.ui_alive ? "is" : "is not") ;
I 17

	if( device.ui_dk >= 0 && device.ui_dk < DK_NDRIVE )
		dk_map[device.ui_dk] = 1 ;
E 17
}

/*
 *	Build of table of "interesting" device information.
 */
struct device_table {
	struct uba_device *d_ptr ;	/* address of device structure */
	struct uba_ctlr   *c_ptr ;	/* address of controller */
} ;

struct device_table *uba_device = NULL ;
int	n_devices = 0 ;

find_devices(p, name, unit)
struct uba_ctlr *p ;
char	*name ;
int	unit ;
{
	int	i ;

	for(i = 0; i < n_devices; i++) {
		if( uba_device[i].c_ptr == p )
			print_device(uba_device[i].d_ptr, name, unit) ;
	}
}

build_table(p)
struct uba_device *p ;
{
	struct uba_device device ;
	unsigned i ;

	for(i = 0; ; i++) {
		readk((long)(p + i), (char *)&device, sizeof(device)) ;

		if( device.ui_driver == 0 )
			break ;
	}

	n_devices = i ;

D 17
	if((uba_device = (struct device_table *)calloc(i, sizeof(uba_device))) == NULL )
E 17
I 17
	if((uba_device = (struct device_table *)calloc(i, sizeof(struct device_table))) == NULL )
E 17
D 11
		fatal("can't allocate space for table") ;
E 11
I 11
		fatal("Can't allocate space for device table: %s.\n", module) ;
E 11

	for(i = 0; i < n_devices; i++) {
		readk((long)(p + i), (char *)&device, sizeof(device)) ;

		uba_device[i].d_ptr = p + i ;
		uba_device[i].c_ptr = device.ui_mi ;
	}
}

free_table()
{	
	free((char *)uba_device) ;
I 13
}
I 16
D 17
#endif
E 17
E 16

I 16
/*
 *	Given a boot-time print the time the system has been up.
 */
E 16
uptime(boot)
long	boot ;
{
	long	time(), now ;
	int	days, hours, minutes, comma = 0 ;

	now = time((long *)0) ;

	if( now <= boot )
		printf("which is unreasonable, since it is now %24.24s.\n",
			ctime((long *)&now)) ;
	else {
		minutes = (now - boot) / 60 ;
		days = minutes / (24 * 60) ;
		minutes %= (24 * 60) ;
		hours = minutes / 60 ;
		minutes %= 60 ;

		printf("and has been up for") ;

		if( days ) {
			comma++ ;
			printf(" %d day%s", days, days == 1 ? "" : "s") ;
		}

		if( hours ) {
			if( comma++ )
				putchar(',') ;

			printf(" %d hour%s", hours, hours == 1 ? "" : "s") ;
		}

		if( minutes ) {
			if( comma++ )
				putchar(',') ;

			printf(" %d minute%s", minutes, minutes == 1 ? "" : "s") ;
		}

		if( days == 0 && hours == 0 && minutes == 0 )
			printf(" less than a minute.\n") ;
		else
			printf(".\n") ;
I 17
	}
}

/*
 *	Some versions (V3.x on DECstations) don't store the device 
 *	configuration, relying on a non-zero number transfers in the 
 *	_dk_xfer[] array.  We'll fake something something to at least
 *	acknowledge that there are other devices out there on the
 *	SCSI.
 */
scsi_names()
{
	register i, scsi_header_printed = 0 ;

	/*
	 *	Read the transfer list.
	 */
	readk((long)names_nm[NAMES_DK_XFER].n_value, (char *)dk_xfer, 
		sizeof(dk_xfer)) ;

	for(i = 0; i < DK_NDRIVE; i++) {
		if( dk_map[i] || dk_xfer[i] == 0 )
			continue ;

		if( scsi_header_printed == 0 ) {
			printf("#\n#\tOther Disk or SCSI devices.\n#\n") ;
			scsi_header_printed = 1 ;
		}

		printf("dk%d is alive.\n", i) ;
E 17
	}
E 13
E 10
}
E 1
