h60368
s 00327/00059/00818
d D 1.44 90/05/17 14:19:11 alan 44 43
c added MON_ack and MonitorAck versions of the constants
e
s 00023/00003/00854
d D 1.43 89/12/27 11:47:49 alan 43 42
c Changed names and declarations of elements.
c 
e
s 00008/00002/00849
d D 1.42 89/05/07 22:44:02 alan 42 41
c added rusage structure to LAST record
e
s 00004/00001/00847
d D 1.41 89/03/11 16:00:01 alan 41 40
c changed the structure of mon_fork and the other changes that required
e
s 00002/00000/00846
d D 1.40 89/02/24 14:56:23 alan 40 39
c added a size constant for the union
e
s 00002/00001/00844
d D 1.39 89/02/24 13:07:28 alan 39 38
c editorial change
e
s 00010/00004/00835
d D 1.38 89/02/17 18:53:49 alan 38 37
c added username and group strings to PID record.  Also fixed a big in sample.c that didn't write the elapsed time correctly
e
s 00013/00001/00826
d D 1.37 89/02/16 19:34:53 alan 37 36
c added mon_name to CPU
e
s 00003/00001/00824
d D 1.36 89/02/16 19:03:45 alan 36 35
c convert pgtok() and btok() macros to functions that uses data set in the FIRST record
e
s 00001/00001/00824
d D 1.35 89/02/13 18:42:06 alan 35 34
c changed the value of MON$N_RECORDS
c 
e
s 00137/00032/00688
d D 1.34 89/02/13 14:37:42 alan 34 33
c rewrote BUF structure and added KMEM structure
e
s 00035/00007/00685
d D 1.33 89/01/25 22:19:50 alan 33 32
c clean up in BUF record
e
s 00008/00000/00684
d D 1.32 89/01/19 12:35:46 alan 32 31
c added cache detail structure to buffer cache
e
s 00007/00007/00677
d D 1.31 89/01/16 18:55:27 alan 31 30
c change MON$C_MAXSWAP to 20 from 24.
c 
e
s 00127/00015/00557
d D 1.30 89/01/16 16:49:25 alan 30 29
c added Swap space, buffer cache and namei cache
e
s 00156/00126/00416
d D 1.29 87/11/18 16:36:55 alan 29 28
c V0.99 -> T1.0-1
e
s 00009/00005/00533
d D 1.28 87/11/18 12:17:42 alan 28 27
c V0.98
e
s 00006/00000/00532
d D 1.27 87/04/03 12:47:55 alan 27 26
c added constants for record.h version
e
s 00001/00001/00531
d D 1.26 87/03/03 15:42:02 alan 26 25
c see the commentary for V0.83 in version.c
e
s 00005/00022/00527
d D 1.25 87/02/05 16:29:16 alan 25 24
c See comment on V0.81 in version.c.
c 
e
s 00000/00001/00549
d D 1.24 87/02/02 16:22:01 alan 24 23
c V0.79 in version.c
e
s 00054/00012/00496
d D 1.23 87/01/21 16:37:05 alan 23 22
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00003/00007/00505
d D 1.22 86/12/07 22:22:13 alan 22 21
c See V0.57 in version.c
e
s 00006/00010/00506
d D 1.21 86/07/30 17:27:36 alan 21 20
c Much code changed.  Most of it involved turning disks and tapes into array
c instead of linked lists, and netif and cpu in dynamically allocated arrays.
c I also combined some of the I/O vector code into one place and changed all
c the various references.
c 
c The code at this point is reasonably lint free but needs a LOT of clean up
c work.  There is a lot of inconsistant usage of "first.mon_..." and "n_...".
c 
c TODO: All the code needs to looked over and cleaned up.  The "total"
c structure for disks and tapes need to become static instead of dynamic.
c I need to merge the stack code into the approproiate mba and uba code.
c 
c The multiple CPU code needs to be tested.  I can probably simulate a
c save file from a Multiple CPU run, but...
c 
e
s 00023/00041/00493
d D 1.20 86/07/15 11:22:49 alan 20 19
c remove MON$V_ define's
c 
e
s 00002/00004/00532
d D 1.19 86/07/11 19:27:12 alan 19 18
c Dust off LOTS of lint...
c 
e
s 00001/00004/00535
d D 1.18 86/06/24 08:34:45 alan 18 17
c Move the various version of mon_etime into the sample record.
c 
e
s 00001/00001/00538
d D 1.17 86/06/13 15:18:40 alan 17 16
c change MON$N_LOADAVE from 4 to 3.
c 
e
s 00002/00003/00537
d D 1.16 86/06/13 15:10:23 alan 16 15
c assume c_ident will be SID
e
s 00029/00012/00511
d D 1.15 86/06/12 13:19:15 alan 15 14
c First pass for adding Ultrix V2.0 multi-processor support to monitor.
c Most of the changes where restructureing the mon_cpu record.  I removed
c the address of the "per CPU" rate structure.
c 
e
s 00004/00000/00519
d D 1.14 86/05/30 15:17:54 alan 14 13
c Added MON$N_RECORDS, currently 17.
c 
e
s 00010/00004/00509
d D 1.13 86/05/28 15:57:19 alan 13 12
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00093/00058/00420
d D 1.12 86/05/26 19:23:35 alan 12 11
c 1.  Added mon_flag to all headers.
c 2.  Changed mon_flags in mon_netif to mon_if_flags.
c 3.  Added mon_disk, mon_tape, mon_netif to respective structures.  These
c     are intended to be device specific information.
c 4.  Added mon_etime and space for 4 longwords to mon_tape.  The longwords
c     are for possible future data.
c 
e
s 00028/00032/00450
d D 1.11 86/05/26 15:53:18 alan 11 10
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00001/00002/00481
d D 1.10 86/05/23 19:54:25 alan 10 9
c removed references to tot_ structures
e
s 00002/00000/00481
d D 1.9 86/05/16 09:17:24 alan 9 8
c changes for adding disk and netif data to screen function.
c 
e
s 00004/00000/00477
d D 1.8 86/05/12 14:53:25 alan 8 7
c added list count fields to first record
e
s 00000/00000/00477
d D 1.7 86/05/11 16:41:34 alan 7 6
c There has to be a better way to change a comment...  From 1.5 to 1.6 nothing
c changed.  The flags were added in 1.5 and the other two didn't change
c at all, even though I though they had.
c 
e
s 00000/00000/00477
d D 1.6 86/05/11 16:39:43 alan 6 5
c Modifed the mon_state and mon_disk structures.  Added "flags" to the
c mon_netif structure.
c 
e
s 00009/00005/00468
d D 1.5 86/05/11 14:21:58 alan 5 4
c 1.  Removed mon_total from mon_state structure.
c 2.  Changed comment on mon_etime for mon_disk and mon_tty.
c 3.  Added mon_flags to mon_netif structure.
c 
e
s 00016/00001/00457
d D 1.4 86/05/08 09:40:41 alan 4 3
c 1.  Added dynamic data to disk structure.
c 2.  Added address of _cp_time to state structure.
c 
e
s 00121/00014/00337
d D 1.3 86/05/07 12:49:01 alan 3 2
c 1.  Many changes.
c 2.  Move general CPU info from sample to first.
c 3.  Included constants for sizes of hostname and version string.
c 4.  remove the _tp, _dk, _if from the tape, disk and netif structures.
c 5.  Added bus and controller to tape and disk structures.
c 
e
s 00002/00000/00349
d D 1.2 86/05/04 14:58:21 alan 2 1
c taken from ../record version 1.4
c 
e
s 00349/00000/00000
d D 1.1 86/05/04 14:57:08 alan 1 0
c date and time created 86/05/04 14:57:08 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Record structures and defines.
I 2
 *
 *	Taken from the record test directory - Version 1.4.
E 2
 */

/*
I 30
 * Modification history.
 *
 *  Jan. 4, 1988 -- arr
 *
 *	Added architecture constants and field to FIRST.
 *
 *	Expanded size of version and node name string
 *	in FIRST.
 *
 *	Changed signal information in LAST to allow MIPS
 *	and VAX record to be the same size.  I took out the
 *	scp structure because it didn't contain much of
 *	interest.
 *
 *	Added padding to LOADAVE to allow MIPS and VAX
 *	record to be the same size.
 *
 *	Changed minor version number.
 *
 *  Jan. 5, 1988 -- arr
 *
 *	Changed PAGE to store only the data from vmmeter that
 *	it uses.
 *
 *	Changed MEMORY to store only the data from vmtotal that
 *	it uses. 
 *
 *	Added some field to CPU for the MIPS counters.
 *
 * Jan. 11 and 12 -- arr
 *
 *	Added body of the mon_swap data structure.
I 33
 *
 * Jan. 16, 1989 -- arr
 *
 *	change MON$C_MAXSWAP to 20 from 24.
 *
 *	added Swap space, buffer cache and namei cache.
 *
 * Jan. 19, 1989 -- arr
 *
 *	added cache detail structure to buffer cache.
 *
 * Jan. 25, 1989 -- arr
 *
 *	Removed extra long word from detail structure.
I 34
 *
 * Feb.  9, 1989 -- arr
 *
 *	Redesigned BUF structure.
I 37
 *
D 38
 * Feb. 15, 1989 -- arr
E 38
I 38
 * Week ending Feb. 18, 1989 -- arr
E 38
 *
 *	Added mon_nbpg and mon_bsize to FIRST record.
D 38
 *
 * Feb. 16, 1989 -- arr
 *
E 38
 *	Added mon_name to CPU record.
I 38
 *	Added text of username and group (real and effective) to PID.
I 42
 *
 * May 7, 1989 -- arr
 *
 *	Added rusage structure to LAST record.
I 43
 *
 * Dec. 27, 1989 -- arr
 *
 *	Changed the usage of ucred in the mon_pid structure
 *	to be mon_ucred.  This doesn't change size or format
 *	of monitor data, so I won't change the version number.
 *
 *	I made the change because V4.0 added a longword to the
 *	ucred structure.
 *
 *	I also changed the mon_cpunum elements in mon_tty and
 *	mon_nfs to mon_rffu.  This doesn't change the size
 *	either.
I 44
 *
 * May 16, 1990 -- arr
 *
 *	Added alternate constant names.  The usage of the
 *	constants isn't changed so this will not change the
 *	version number.  Once I decide which naming style
 *	is best I'll take out the extra ones.  A future
 *	version will use the alternate names, but the old
 *	will stay for a while.  Eventually the old names
 *	will go away.
E 44
E 43
E 42
E 38
E 37
E 34
E 33
 */

/*
E 30
I 23
D 25
 *	DEV_SIZE isn't defined in V1.2, so I'll define it here
 *	if it isn't already.
E 25
I 25
 *	This is the value of DEV_SIZE taken from <sys/devio.h>.
E 25
 */
D 25
#ifndef	DEV_SIZE
#	define	DEV_SIZE	(8)
#endif
E 25
I 25
#define	DEV_SIZE	(8)
E 25

/*
I 27
 *	The version number defined as constants.
 */
#define	MON$C_MAJOR	(1)
D 28
#define MON$C_MINOR	(26)
E 28
I 28
D 29
#define MON$C_MINOR	(27)
E 29
I 29
D 30
#define MON$C_MINOR	(28)
E 30
I 30
D 42
#define MON$C_MINOR	(29)
E 42
I 42
#define MON$C_MINOR	(30)
E 42
E 30
E 29
E 28

I 44
#define	MON_MAJOR	(MON$C_MAJOR)
#define	MON_MINOR	(MON$C_MINOR)

#define	MonitorRevMajor	(MON$C_MAJOR)
#define	MonitorRevMinor	(MON$C_MINOR)

E 44
/*
I 30
 *	Architecture constants.
 */
#define	MON$C_VAX	(1)
#define	MON$C_MIPS	(2)

I 44
#define	MON_VAX		(MON$C_VAX)
#define	MON_MIPS	(MON$C_MIPS)

#define	MonitorArchVAX	(MON$C_VAX)
#define	MonitorArchMIPS	(MON$C_MIPS)

E 44
/*
E 30
E 27
E 23
D 29
 *	The "monitor" data file will consist of a number of (different
 *	length) records with a common header format.  Each header will
 *	look like:
E 29
I 29
 *	The "monitor" data file consists of a number of (different
 *	length) records with a common header format.  Each header 
 *	looks like:
E 29
 *
 *		31				0
D 12
 *		+---------------+---------------+
 *		|    length 	|     type	|
 *		+---------------+---------------+
E 12
I 12
 *		+---------------+-------+-------+
 *		|    length 	|  flag | type	|
 *		+---------------+-------+-------+
E 12
 *
 *	The C structure of the header is:
 *
 *	struct mon_header {
D 12
 *		short	mon_type,
 *			mon_length ;
E 12
I 12
 *		char	mon_type,
 *			mon_flag ;
 *		short	mon_length ;
E 12
 *	};
 *
D 29
 *	Each record will contain other information that will be detailed
E 29
I 29
 *	Each record contains other information that will be detailed
E 29
 *	in the comments on that structure.
 */

/*
 *	This is the structure of the record header.  Each record will
 *	have this at the beginning.
 */
#define	MON$S_HEADER	(sizeof(struct mon_header))
I 44
#define	MON_HEADER_S	(MON$S_HEADER)
#define	MonitorHeaderSize (MON$S_HEADER)
E 44

I 34
/*
 *	Flag bits.
 */
#define	MON$M_VALID	(01)	/* data is valid */
I 44
#define	MON_VALID_M	(MON$M_VALID)
#define MonitorValidMask (MON$M_VALID)
E 44

E 34
struct	mon_header {
D 12
	short	mon_type,
		mon_length ;
E 12
I 12
	char	mon_type,		/* record type */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* record length */
E 12
};

/*
D 29
 *	There is method to the madness of the quadruple #defines for the
 *	records.
 *
 *	The MON$K_ #define is number of the record type.  It can (and will
D 20
 *	be used as an index into tables.  The MON$V_ #define represents
 *	the bit within the options field for that data type.  The control
 *	records aren't part of the options field, but space is set aside
 *	for them to make life easier in places.  The MON$M_ #define is
 *	the mask formed from shifting a one MON$V_ places (1 << MON$V_).
E 20
I 20
 *	be used as an index into tables.  It also represents the bit within 
E 29
I 29
 *	The MON$C_ #define is number of the record type.  It can be used 
 *	as an index into tables.  It also represents the bit within 
E 29
 *	the options field for that data type.  The control records aren't 
 *	part of the options field, but space is set aside for them to make 
 *	life easier in places.  The MON$M_ #define is the mask formed from 
D 29
 *	shifting a one MON$K_ places (1 << MON$K_).
E 29
I 29
 *	shifting a one MON$C_ places (1 << MON$C_).
E 29
E 20
 *
 *	The MON$S_ #define is the size of the associated structure
 *	"sizeof(struct mon_)"
 */

/*
 *	These are the control records.
 */

/*
 *	This record will be written each time the program starts
D 29
 *	running.  It should also contain static system information.
E 29
I 29
 *	running.  It also contains static system information.
E 29
 *
 *	It is possible for the data file to have more than one "first"
 *	record.  If the program is started again with the same output
 *	file, the "first" and "last" records can be used to figure out
 *	when, etc.  There should be only one copy of the program writting
 *	to a given file at a time.
 */
D 29
#define	MON$K_FIRST	0
D 20
#define	MON$V_FIRST	MON$K_FIRST
#define	MON$M_FIRST	(1 << MON$V_FIRST)
E 20
I 20
#define	MON$M_FIRST	(1 << MON$K_FIRST)
E 29
I 29
D 44
#define	MON$C_FIRST	0
#define	MON$M_FIRST	(1 << MON$C_FIRST)
E 29
E 20
#define	MON$S_FIRST	(sizeof(struct mon_first))
I 3
D 30
#define	MON$S_VERSION	(64)
#define	MON$S_HOSTNAME	(32)
E 30
I 30
#define	MON$S_VERSION	(128)
#define	MON$S_HOSTNAME	(128)
E 44
I 44
#define	MON$C_FIRST	(0)
#define	MON_FIRST	(MON$C_FIRST)
#define MonitorFirst	(MON$C_FIRST)
E 44
E 30
E 3

I 44
#define	MON$M_FIRST		(1 << MON$C_FIRST)
#define	MON_FIRST_M		(MON$M_FIRST)
#define MonitorFirstMask	(MON$M_FIRST)

#define	MON$S_FIRST		(sizeof(struct mon_first))
#define	MON_FIRST_S		(MON$C_FIRST)
#define MonitorFirstSize	(MON$C_FIRST)

#define	MON$S_VERSION		(128)
#define	MON_VERSION_S		(MON$S_VERSION)
#define	MonitorVersionSize	 (MON$S_VERSION)

#define	MON$S_HOSTNAME		(128)
#define	MON_HOSTNAME_S		(MON$S_HOSTNAME)
#define	MonitorHostnameSize	(MON$S_HOSTNAME)

E 44
struct	mon_first {
D 12
	short	mon_type,		/* MON$K_FIRST */
D 3
		mon_length ;		/* length */
	int	mon_sleep, 		/* time between samples for this run */
E 3
I 3
		mon_length ;		/* MON$S_FIRST */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_FIRST */
E 29
I 29
	char	mon_type,		/* MON$C_FIRST */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_FIRST */
I 34

E 34
E 12
	int	mon_sleep,		/* time between samples for this run */
E 3
		mon_options, 		/* the options mask of collected data */
D 3
		mon_pid ;		/* process id of the process */
	time_t	mon_sdate ;		/* Time monitor was firsted */
E 3
I 3
		mon_pid, 			/* process id of the process */
D 36
		mon_hz,				/* clock speed/frequency? */
E 36
I 36
		mon_hz,				/* clock speed/frequency */
		mon_nbpg,			/* bytes per page of memory */
		mon_bsize,			/* value of DEV_BSIZE */
E 36
		mon_physmem ;			/* physical memory */
D 22
	time_t	mon_sdate ;			/* Time monitor was firsted */
E 22
I 22
D 28
	long	mon_sdate ;			/* Time monitor was firsted */
E 28
I 28

	struct timeval mon_boot ;		/* When the system was booted */

	long	mon_sdate ;			/* Time monitor was started */
I 34

E 34
E 28
E 22
I 8
	int	mon_cpu,			/* number of CPU's */
		mon_disk,			/* number of disks */
D 25
		mon_tape,			/* number of tapes */
E 25
D 34
		mon_netif ;			/* number of interfaces */
E 34
I 34
		mon_netif,			/* number of interfaces */
		mon_buf ;			/* number of BUF's */
E 34
I 30

	int	mon_arch ;			/* architecture number */
E 30
I 23
	dev_t	mon_record ;			/* record.h version */
I 30

E 30
E 23
E 8
D 28
	char	mon_version[MON$S_VERSION] ;	/* version string */
	char	mon_hostname[MON$S_HOSTNAME] ;	/* host name */
E 28
I 28
	char	mon_version[MON$S_VERSION+1] ;	/* version string */
	char	mon_hostname[MON$S_HOSTNAME+1] ;	/* host name */
E 28
E 3
};

/*
 *	This record will be written if the program is given the
D 29
 *	opportunity to exit gracefully.  It would be nice if Ultrix
 *	in doing a "normal" shutdown should would send a SIGTERM to 
 *	all processes give 30-60 seconds grace time and then send them 
 *	a SIGKILL.
E 29
I 29
 *	opportunity to exit gracefully.
E 29
D 12
 *
 *	Can you say... "Please submit an SPR."...
E 12
 */
D 29
#define	MON$K_LAST	1
D 20
#define	MON$V_LAST	MON$K_LAST
#define	MON$M_LAST	(1 << MON$V_LAST)
E 20
I 20
#define	MON$M_LAST	(1 << MON$K_LAST)
E 29
I 29
D 44
#define	MON$C_LAST	1
#define	MON$M_LAST	(1 << MON$C_LAST)
E 29
E 20
#define	MON$S_LAST	(sizeof(struct mon_last))
E 44
I 44
#define	MON$C_LAST	(1)
#define	MON_LAST	(MON$C_LAST)
#define MonitorLast	(MON$C_LAST)
E 44

I 44
#define	MON$M_LAST		(1 << MON$C_LAST)
#define	MON_LAST_M		(MON$M_LAST)
#define MonitorLastMask		(MON$M_LAST)

#define	MON$S_LAST		(sizeof(struct mon_last))
#define	MON_LAST_S		(MON$S_LAST)
#define MonitorLastSize		(MON$S_LAST)

E 44
struct	mon_last {
D 12
	short	mon_type, 		/* MON$K_LAST */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type, 		/* MON$K_LAST */
E 29
I 29
	char	mon_type, 		/* MON$C_LAST */
E 29
		mon_flag ;		/* Other information */
D 44
	short	mon_length ;		/* length */
E 44
I 44
	short	mon_length ;		/* MON$C_LAST */
E 44
E 12
	int	mon_signal,		/* signal that kill the process */
		mon_code ;		/* code from signal handler */
D 22
	time_t	mon_edate ;		/* Time monitor stoped */
E 22
I 22
D 42
	long	mon_edate ;		/* Time monitor stoped */
E 42
I 42
	long	mon_edate ;		/* Time monitor stopped */

	struct rusage mon_usage ;	/* resource usage information */
E 42
E 22
D 30
	struct sigcontext mon_scp ;	/* Signal context structure */
E 30
};

/*
D 29
 *	This record is written before the each sample.  It contains
 *	the timestamp and sum of the length of the data records
 *	written.
E 29
I 29
 *	This record is written before each sample.  It contains
 *	the timestamp, sum of the length of the data records and
 *	the number of clock ticks since the system was booted.
E 29
 */
D 29
#define	MON$K_SAMPLE	2
D 20
#define	MON$V_SAMPLE	MON$K_SAMPLE
#define	MON$M_SAMPLE	(1 << MON$V_SAMPLE)
E 20
I 20
#define	MON$M_SAMPLE	(1 << MON$K_SAMPLE)
E 29
I 29
D 44
#define	MON$C_SAMPLE	2
#define	MON$M_SAMPLE	(1 << MON$C_SAMPLE)
E 29
E 20
#define	MON$S_SAMPLE	(sizeof(struct mon_sample))
E 44
I 44
#define	MON$C_SAMPLE		(2)
#define	MON_SAMPLE		(MON$C_SAMPLE)
#define MonitorSample		(MON$C_SAMPLE)
E 44

I 44
#define	MON$M_SAMPLE		(1 << MON$C_SAMPLE)
#define	MON_SAMPLE_M		(MON$M_SAMPLE)
#define MonitorSampleMask	(MON$M_SAMPLE)

#define	MON$S_SAMPLE		(sizeof(struct mon_sample))
#define	MON_SAMPLE_S		(MON$S_SAMPLE)
#define MonitorSampleSize	(MON$S_SAMPLE)

E 44
struct	mon_sample {
D 12
	short	mon_type,		/* MON$K_SAMPLE */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_SAMPLE */
E 29
I 29
	char	mon_type,		/* MON$C_SAMPLE */
E 29
		mon_flag ;		/* Other information */
D 44
	short	mon_length ;		/* length */
E 44
I 44
	short	mon_length ;		/* MON$S_SAMPLE */
E 44
I 34

E 34
E 12
	int	mon_datalen ;		/* sum of data structure lengths */
D 22
	time_t	mon_timestamp ;		/* time the sample taken */
E 22
I 22
	long	mon_timestamp ;		/* time the sample taken */
E 22
I 18
D 24
	double	mon_etime ;		/* elapsed time */
E 24
I 23
	int	mon_ticks ;		/* clock ticks since boot */
E 23
E 18
};

/*
D 34
 *	Reserved for future use.
E 34
I 34
 *	A Re-configuration structure.  One of these will appear when
 *	the number of CPU, disk, netif or buf's has changed.  Not
 *	implemented yet.
E 34
 */
D 29
#define	MON$K_RECTYPE3	3
D 20
#define	MON$V_RECTYPE3	MON$K_RECTYPE3
#define	MON$M_RECTYPE3	(1 << MON$V_RECTYPE3)
E 20
I 20
#define	MON$M_RECTYPE3	(1 << MON$K_RECTYPE3)
E 29
I 29
D 34
#define	MON$C_RECTYPE3	3
#define	MON$M_RECTYPE3	(1 << MON$C_RECTYPE3)
E 29
E 20
#define	MON$S_RECTYPE3	(sizeof(struct mon_rectype3))
E 34
I 34
D 44
#define	MON$C_RECONF	(3)
#define	MON$M_RECONF	(1 << MON$C_RECONF)
#define	MON$S_RECONF	(sizeof(struct mon_reconf))
E 44
I 44
#define	MON$C_RECONF		(3)
#define	MON_RECONF		(MON$C_RECONF)
#define MonitorReconf		(MON$C_RECONF)
E 44
E 34

I 44
#define	MON$M_RECONF		(1 << MON$C_RECONF)
#define	MON_RECONF_M		(MON$M_RECONF)
#define MonitorReconfMask	(MON$M_RECONF)

#define	MON$S_RECONF		(sizeof(struct mon_reconf))
#define	MON_RECONF_S		(MON$S_RECONF)
#define MonitorReconfSize	(MON$S_RECONF)

E 44
D 34
struct	mon_rectype3 {
D 12
	short	mon_type,		/* MON$K_RECTYPE3 */
		mon_length ;		/* MON$S_RECTYPE3 */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_RECTYPE3 */
E 29
I 29
	char	mon_type,		/* MON$C_RECTYPE3 */
E 34
I 34
struct	mon_reconf {
	char	mon_type,		/* MON$C_RECONF */
E 34
E 29
		mon_flag ;		/* Other information */
D 34
	short	mon_length ;		/* MON$S_RECTYPE3 */
E 34
I 34
	short	mon_length ;		/* MON$S_RECONF */

	int	mon_sleep,		/* time between samples for this run */
		mon_options ; 		/* the options mask of collected data */

	long	mon_rdate ;		/* date that monitor was reconfig'd */

	int	mon_cpu,		/* number of CPU's */
		mon_disk,		/* number of disks */
		mon_netif,		/* number of interfaces */
		mon_buf ;		/* number of BUF's */
E 34
E 12
};

/*
 *	And these are the data records.
 */

/*
D 11
 *	Assorted running CPU information, interrupts, system calls, etc.
E 11
I 11
 *	Assorted running CPU information, interrupts, system calls,
D 29
 *	time, in CPU states, cpuid, etc.
E 29
I 29
 *	time, in CPU states, cpuid, etc.  Some of the information is
 *	kept on a per CPU basis, the rest is kept globally.  The global
 *	data is stored in the first CPU record.
E 29
 *
D 15
 *	The mon_rate field is of special interest here.  Current all
 *	the paging/(cpu interrupt, etc) is kept in one structure
 *	(struct vmmeter) which has three version, sum, cnt and rate.
 *	Some of this data should be collected on a per CPU basis
 *	(syscalls, interrupts, context switches).  I am going to
 *	assume that there will be a per CPU copy of this information
 *	around someday and will store the address of it in mon_rate.
E 15
I 15
D 29
 *	Below is the comment made before I found out how multiple CPU's
 *	were really being done.  The only data kept on a per CPU basis
 *	is context switches and time in states.
E 29
I 29
 *	Per CPU data:
E 29
 *
D 29
 *		The mon_rate field is of special interest here.  Current all
 *		the paging/(cpu interrupt, etc) is kept in one structure
 *		(struct vmmeter) which has three version, sum, cnt and rate.
 *		Some of this data should be collected on a per CPU basis
 *		(syscalls, interrupts, context switches).  I am going to
 *		assume that there will be a per CPU copy of this information
 *		around someday and will store the address of it in mon_rate.
E 29
I 29
 *		mon_ident, mon_state, mon_cpu, mon_index, mon_time,
 *		mon_swtch, mon_subtype.
E 29
 *
D 29
 *	The other data that I was previously keeping on a "per CPU" basis
 *	will kept in the first CPU structure.
E 29
I 29
 *	Global CPU data:
 *
 *		mon_trap, mon_syscall, mon_intr, mon_pdma.
 *
I 30
D 44
 *	There are only of interest on the MIPS, but will be kept
E 44
I 44
 *	These are only of interest on the MIPS, but will be kept
E 44
 *	for the VAX to make the data structures compatable.
 *
I 44
 *		mon_tblpid, mon_soft.
 *
 *	Eventually I'll add the Interprocessor Interrupt stats
 *	that were added in V4 and will probably merge in the
 *	tty data since is collected per CPU.  I may also change
 *	the way the CPU type is stored.
E 44
E 30
E 29
E 15
E 11
 */
D 29
#define MON$K_CPU	4
D 20
#define	MON$V_CPU	MON$K_CPU
#define MON$M_CPU	(1 << MON$V_CPU)
E 20
I 20
#define MON$M_CPU	(1 << MON$K_CPU)
E 29
I 29
D 44
#define MON$C_CPU	4
E 44
I 44
#define MON$C_CPU	(4)
#define	MON_CPU		(MON$C_CPU)
#define MonitorCPU	(MON$C_CPU)

E 44
#define MON$M_CPU	(1 << MON$C_CPU)
I 44
#define	MON_CPU_M	(MON$M_CPU)
#define MonitorCPUMask	(MON$M_CPU)

E 44
E 29
E 20
#define	MON$S_CPU	(sizeof(struct mon_cpu))
I 44
#define	MON_CPU_S	(MON$S_CPU)
#define MonitorCPUSize	(MON$S_CPU)

E 44
I 37
#define	MON$S_CPUNAME	(64)
I 44
#define	MON_CPUNAME	(MON$S_CPUNAME)
#define MonitorCPUName	(MON$S_CPUNAME)
E 44
E 37

I 44

E 44
struct	mon_cpu {
D 3
	short	mon_type,		/* MON$K_CPU */
		mon_length ;
E 3
I 3
D 12
	short	 mon_type,		/* MON$K_CPU */
		 mon_length ;		/* MON$S_CPU */
E 12
I 12
D 29
	char	 mon_type,		/* MON$K_CPU */
E 29
I 29
	char	 mon_type,		/* MON$C_CPU */
E 29
		 mon_flag ;		/* Other information */
	short	 mon_length ;		/* MON$S_CPU */
I 13
D 15

E 13
E 12
D 11
	unsigned mon_swtch ;		/* context switchs */
	unsigned mon_trap ;		/* calls to trap() */
	unsigned mon_syscall ;		/* calls to syscall() */
	unsigned mon_intr ;		/* device interrupts */
	unsigned mon_pdma ;		/* pseudo-dma interrupts */
E 11
I 11
	long	 mon_time[CPUSTATES] ;	/* Time in CPU states */
D 13
	int	 mon_cpuid,		/* CPU id, SID register on VAX */
		 mon_cpu ;		/* index/counter */
E 13
I 13
	int	 mon_cpuid ;		/* CPU id, SID register on VAX */
E 15
I 15
/*
 *	Static CPU data.
 */
D 16
	int	 mon_cpuid,		/* CPU id, SID register on VAX */
		 mon_state,		/* State of this processor */
		 mon_ident ;		/* Processor specific identifier */
E 16
I 16
D 29
	int	 mon_ident,		/* CPU id, SID register on VAX (xxx) */
E 29
I 29
	int	 mon_ident,		/* CPU id */
E 29
		 mon_state ;		/* State of this processor */
I 30
	long	 mon_subtype ;		/* CPU subtype */
E 30
E 16
E 15
	short	 mon_cpu, 		/* system index/counter */
		 mon_index ; 		/* internal index/counter */
I 15
/*
 *	Dynamic CPU data.
 */
	long	 mon_time[CPUSTATES] ;	/* Time in CPU states */
E 15
E 13
	unsigned mon_swtch,		/* context switchs */
		 mon_trap,		/* calls to trap() */
		 mon_syscall,		/* calls to syscall() */
		 mon_intr,		/* device interrupts */
		 mon_pdma ;		/* pseudo-dma interrupts */
I 23
D 30
	long	 mon_subtype ;		/* CPU subtype */
E 30
E 23
D 15
	caddr_t	 mon_where,		/* address of cp_time data */
		 mon_rate ;		/* address of per cpu rate info */
E 15
I 15
/*
I 30
 *	MIPS stuff.
 */
	unsigned mon_tlbpid,		/* calls to new_tlbpid() */
		 mon_soft ;		/* software interrupts */
D 37
		
E 37
I 37
/*
 *	A copy of the CPU name.
 */
	char	 mon_name[MON$S_CPUNAME+1] ;
E 37
/*
E 30
 * 	Address of cp_time data or cpudata structure (cpudata + mon_index)
D 34
 *	for this cpu.
E 34
I 34
 *	for this cpu.  This is only interesting internal to monitor.
E 34
 */
I 21
D 23
	long	 mon_rffu[1] ;		/* used to be mon_next */
E 23
E 21
	caddr_t	 mon_where ;
E 15
D 21
	struct	 mon_cpu *mon_next ;	/* Next CPU in list */
E 21
E 11
E 3
};

/*
D 29
 *	TTY input and output counts.  It would be nice to have the data on
 *	on a per device basis.
E 29
I 29
 *	TTY input and output counts.
E 29
 */
D 29
#define MON$K_TTY	5
D 20
#define	MON$V_TTY	MON$K_TTY
#define MON$M_TTY	(1 << MON$V_TTY)
E 20
I 20
#define MON$M_TTY	(1 << MON$K_TTY)
E 29
I 29
D 44
#define MON$C_TTY	5
E 44
I 44
#define MON$C_TTY	(5)
#define	MON_TTY		(MON$C_TTY)
#define MonitorTTY	(MON$C_TTY)

E 44
#define MON$M_TTY	(1 << MON$C_TTY)
I 44
#define	MON_TTY_M	(MON$M_TTY)
#define MonitorTTYMask	(MON$M_TTY)

E 44
E 29
E 20
#define	MON$S_TTY	(sizeof(struct mon_tty))
I 44
#define	MON_TTY_S	(MON$S_TTY)
#define MonitorTTYSize	(MON$S_TTY)
E 44

struct	mon_tty {
D 12
	short	mon_type,		/* MON$K_TTY */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_TTY */
E 29
I 29
	char	mon_type,		/* MON$C_TTY */
E 29
		mon_flag ;		/* Other information */
D 44
	short	mon_length ;		/* length */
E 44
I 44
	short	mon_length ;		/* MON$S_TTY */
E 44
I 34

E 34
E 12
	int	mon_ttyin,		/* tty input */
D 34
		mon_ttyout ;		/* tty output */
E 34
I 34
		mon_ttyout,		/* tty output */
D 43
		mon_cpunum ;		/* Anticipating SMP */
E 43
I 43
		mon_rffu ;		/* Reserved */
E 43
E 34
D 3
	/* device specific info if available */
E 3
I 3
D 5
	double	mon_etime ;		/* state.mon_total / hz */
E 5
I 5
D 18
	double	mon_etime ;		/* elapsed clock seconds */
E 18
E 5
E 3
};

/*
D 29
 *	Disk I/O information, probably on a per disk basis.
E 29
I 29
 *	Disk I/O information, on a per disk basis.
E 29
 */
D 29
#define	MON$K_DISK	6
D 20
#define	MON$V_DISK	MON$K_DISK
#define MON$M_DISK	(1 << MON$V_DISK)
E 20
I 20
#define MON$M_DISK	(1 << MON$K_DISK)
E 29
I 29
D 44
#define	MON$C_DISK	6
E 44
I 44
#define	MON$C_DISK	(6)
#define	MON_DISK	(MON$C_DISK)
#define MonitorDisk	(MON$C_DISK)

E 44
#define MON$M_DISK	(1 << MON$C_DISK)
I 44
#define	MON_DISK_M	(MON$M_DISK)
#define MonitorDiskMask	(MON$M_DISK)

E 44
E 29
E 20
#define	MON$S_DISK	(sizeof(struct mon_disk))
I 44
#define	MON_DISK_S	(MON$S_DISK)
#define MonitorDiskSize	(MON$S_DISK)
E 44

I 3
struct	mon_disk {
D 12
	short	mon_type,		/* MON$K_DISK */
		mon_length ;		/* MON$S_DISK */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_DISK */
E 29
I 29
	char	mon_type,		/* MON$C_DISK */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_DISK */
E 12
I 4
/*
 *	Static data.
 */
E 4
D 23
	char	mon_name[32] ;		/* disk name */
E 23
I 23
	char	mon_name[DEV_SIZE+1] ;	/* disk name */
E 23
	short	mon_unit,		/* unit number */
D 13
		mon_dk,			/* disk number */
E 13
I 13
		mon_dk,			/* system disk number */
D 23
		mon_index,		/* internal index */
E 13
		mon_controller,		/* controller number */
		mon_bus ;		/* bus number */
E 23
I 23
		mon_index ;		/* internal index */
E 23
I 12
	long	mon_disk ;		/* device specific info */
D 22
#ifdef	sun
	float	mon_bps ;		/* dk_bps - static? */
#else
E 22
D 30
	float	mon_mspw ;		/* dk_mspw - static? */
E 30
I 30
	float	mon_mspw ;		/* dk_mspw - static */
E 30
D 22
#endif
E 22
E 12
I 4
/*
 *	Performance data.
 */
E 4
D 5
	double	mon_etime ;		/* state.mon_total / hz */
E 5
I 5
D 18
	double	mon_etime ;		/* elapsed clock seconds */
E 18
E 5
I 4
	long	mon_time,		/* dk_time */
		mon_seek,		/* dk_seek */
		mon_xfer,		/* dk_xfer */
		mon_wds ;		/* dk_wds */
D 5
	float	mon_mspw ;		/* dk_mspw */
E 5
I 5
D 12
#ifdef	sun
	float	mon_bps ;		/* dk_bps - static? */
#else
	float	mon_mspw ;		/* dk_mspw - static? */
#endif
E 12
E 5
/*
D 34
 *	next disk in list.
E 34
I 34
 *	Once upon a time this record was maintained as a linked list.
 *	The pointer to next record is now reserved for "future use".
E 34
 */
E 4
D 21
	struct	mon_disk *mon_next ;	/* next disk in list */
E 21
I 21
	long	mon_rffu[1] ;		/* reserved */
E 21
I 9
D 10
	struct	tot_disk *mon_total ;	/* A space for the "previous" data */
E 10
E 9
};

E 3
/*
 *	The number free memory pages.  The number of free pages is
D 29
 *	also kept in the MEMORY structure, but you are only interested
E 29
I 29
 *	also kept in the MEMORY structure, but if you are only interested
E 29
 *	in the free memory, you can use this record.
 */
D 29
#define	MON$K_FREE	7
D 20
#define	MON$V_FREE	MON$K_FREE
#define MON$M_FREE	(1 << MON$V_FREE)
E 20
I 20
#define MON$M_FREE	(1 << MON$K_FREE)
E 29
I 29
D 44
#define	MON$C_FREE	7
E 44
I 44
#define	MON$C_FREE	(7)
#define	MON_FREE	(MON$C_FREE)
#define MonitorFree	(MON$C_FREE)

E 44
#define MON$M_FREE	(1 << MON$C_FREE)
I 44
#define	MON_FREE_M	(MON$M_FREE)
#define MonitorFreeMask	(MON$M_FREE)

E 44
E 29
E 20
#define	MON$S_FREE	(sizeof(struct mon_free))
I 44
#define	MON_FREE_S	(MON$S_FREE)
#define MonitorFreeSize	(MON$S_FREE)
E 44

struct	mon_free {
D 12
	short	mon_type,		/* MON$K_FREE */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_FREE */
E 29
I 29
	char	mon_type,		/* MON$C_FREE */
E 29
		mon_flag ;		/* Other information */
D 44
	short	mon_length ;		/* length */
E 44
I 44
	short	mon_length ;		/* MON$S_FREE */
E 44
I 34

E 34
E 12
	int	mon_freemem ;		/* free memory in pages */
};

/*
 *	The fork stats.
 */
D 29
#define	MON$K_FORK	8
D 20
#define	MON$V_FORK	MON$K_FORK
#define MON$M_FORK	(1 << MON$V_FORK)
E 20
I 20
#define MON$M_FORK	(1 << MON$K_FORK)
E 29
I 29
D 44
#define	MON$C_FORK	8
E 44
I 44
#define	MON$C_FORK	(8)
#define	MON_FORK	(MON$C_FORK)
#define MonitorFork	(MON$C_FORK)

E 44
#define MON$M_FORK	(1 << MON$C_FORK)
I 44
#define	MON_FORK_M	(MON$M_FORK)
#define MonitorForkMask	(MON$M_FORK)

E 44
E 29
E 20
#define	MON$S_FORK	(sizeof(struct mon_fork))
I 44
#define	MON_FORK_S	(MON$S_FORK)
#define MonitorForkSize	(MON$S_FORK)
E 44

I 3
struct	mon_fork {
D 12
	short	mon_type,		/* MON$K_FORK */
		mon_length ;		/* MON$S_FORK */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_FORK */
E 29
I 29
	char	mon_type,		/* MON$C_FORK */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_FORK */
I 34

E 34
E 12
D 41
	struct forkstat mon_fork ;	/* <sys/vmsystm.h> */
E 41
I 41
	int	mon_fork,		/* number of forks */
		mon_fork_size, 		/* size of forks */
		mon_vfork,		/* number of vforks */
		mon_vfork_size ;	/* size of vforks */
E 41
};

E 3
/*
D 29
 *	Paging information.  I may divide the pageing/swapping info
 *	into two structures.  They will probably be called PAGE1 and
 *	PAGE2.  PAGE1 will be what I consider the most interesting.
 *	For example; the pagein, pageout and swap counts for useful 
 *	info, but how often do you need to know the number of zero fills.
I 3
 *
 *	For now I will glom onto all the paging info.
E 29
I 29
 *	Paging information.
E 29
E 3
 */
D 29
#define	MON$K_PAGE	9
D 20
#define	MON$V_PAGE	MON$K_PAGE
#define MON$M_PAGE	(1 << MON$V_PAGE)
E 20
I 20
#define MON$M_PAGE	(1 << MON$K_PAGE)
E 29
I 29
D 44
#define	MON$C_PAGE	9
E 44
I 44
#define	MON$C_PAGE	(9)
#define	MON_PAGE	(MON$C_PAGE)
#define MonitorPage	(MON$C_PAGE)

E 44
#define MON$M_PAGE	(1 << MON$C_PAGE)
I 44
#define	MON_PAGE_M	(MON$M_PAGE)
#define MonitorPageMask	(MON$M_PAGE)

E 44
E 29
E 20
#define	MON$S_PAGE	(sizeof(struct mon_page))
I 44
#define	MON_PAGE_S	(MON$S_PAGE)
#define MonitorPageSize	(MON$S_PAGE)
E 44

I 3
struct	mon_page {
D 12
	short	mon_type,		/* MON$K_PAGE */
		mon_length ;		/* MON$S_PAGE */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_PAGE */
E 29
I 29
	char	mon_type,		/* MON$C_PAGE */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PAGE */
I 34

E 34
E 12
D 30
	int	mon_deficit ;		/* _deficit */
I 23
	int	mon_freemem ;		/* _freemem */
E 23
	struct vmmeter mon_meter ;	/* everything - <sys/vmmeter.h> */
E 30
I 30
	int	mon_deficit,		/* _deficit */
		mon_freemem ;		/* _freemem */

	unsigned mon_pswpin,		/* pages swapped in */
		 mon_pswpout,		/* pages swapped out */
		 mon_pgin,		/* pageins */
		 mon_pgout,		/* pageouts */
		 mon_pgpgin,		/* pages paged in */
		 mon_pgpgout,		/* pages paged out */
		 mon_intrans,		/* intransit blocking page faults */
		 mon_pgrec,		/* total page reclaims */
		 mon_xsfrec,		/* in free list rather than on swapdev */
		 mon_xifrec,		/* in free list rather than in filsys */
		 mon_exfod,		/* pages filled on demand from a.out */
		 mon_zfod,		/* pages zero filled on demand */
		 mon_vrfod,		/* fills of pages mapped by vread() */
		 mon_nexfod,		/* number of exfod's created */
		 mon_nzfod,		/* number of zfod's created */
		 mon_nvrfod,		/* number of vrfod's created */
		 mon_pgfrec,		/* page reclaims from free list */
		 mon_faults,		/* total faults taken */
		 mon_scan,		/* scans in page out daemon */
		 mon_rev,		/* revolutions of the hand */
		 mon_seqfree,		/* pages taken from sequential programs */
		 mon_dfree,		/* pages freed by daemon */
		 mon_fastpgrec,		/* fast reclaims in locore */
		 mon_swpin,		/* swapins */
		 mon_swpout ;		/* swapouts */
E 30
};

E 3
/*
 *	The "number of process in various states" info.
 */
D 29
#define MON$K_PROC	10
D 20
#define	MON$V_PROC	MON$K_PROC
#define MON$M_PROC	(1 << MON$V_PROC)
E 20
I 20
#define MON$M_PROC	(1 << MON$K_PROC)
E 29
I 29
D 44
#define MON$C_PROC	10
E 44
I 44
#define MON$C_PROC	(10)
#define	MON_PROC	(MON$C_PROC)
#define MonitorProc	(MON$C_PROC)

E 44
#define MON$M_PROC	(1 << MON$C_PROC)
I 44
#define	MON_PROC_M	(MON$M_PROC)
#define MonitorProcMask	(MON$M_PROC)

E 44
E 29
E 20
#define	MON$S_PROC	(sizeof(struct mon_proc))
I 44
#define	MON_PROC_S	(MON$S_PROC)
#define MonitorProcSize	(MON$S_PROC)
E 44

I 3
struct	mon_proc {
D 12
	short	mon_type,		/* MON$K_PROC */
		mon_length ;		/* MON$S_PROC */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_PROC */
E 29
I 29
	char	mon_type,		/* MON$C_PROC */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PROC */
I 34

E 34
E 12
	short	mon_rq,			/* length of run queue */
		mon_dw,			/* jobs in "disk wait" */
		mon_pw,			/* jobs in page wait */
		mon_sl,			/* jobs sleeping in core */
		mon_sw ;		/* swaped jobs */
};

E 3
/*
D 44
 *	The physical swap space usage info.  Pstat(8) gets this from
D 29
 *	somewhere.
E 29
I 29
 *	somewhere.  Data collection for this record isn't implimented
D 30
 *	at this time.
E 30
I 30
 *	at this time.  The missing field of pstat(8) can be calculated
 *	from (total - (used + free)).
E 44
I 44
 *	The physical swap space usage info.
E 44
E 30
E 29
 */
D 29
#define	MON$K_SWAP	11
D 20
#define	MON$V_SWAP	MON$K_SWAP
#define MON$M_SWAP	(1 << MON$V_SWAP)
E 20
I 20
#define MON$M_SWAP	(1 << MON$K_SWAP)
E 29
I 29
D 44
#define	MON$C_SWAP	11
E 44
I 44
#define	MON$C_SWAP	(11)
#define	MON_SWAP	(MON$C_SWAP)
#define MonitorSwap	(MON$C_SWAP)

E 44
#define MON$M_SWAP	(1 << MON$C_SWAP)
I 44
#define	MON_SWAP_M	(MON$M_SWAP)
#define MonitorSwapMask	(MON$M_SWAP)

E 44
E 29
E 20
#define	MON$S_SWAP	(sizeof(struct mon_swap))
I 44
#define	MON_SWAP_S	(MON$S_SWAP)
#define MonitorSwapSize	(MON$S_SWAP)

E 44
I 30
D 31
#define	MON$C_MAXSWAP	(24)
E 31
I 31
#define	MON$C_MAXSWAP	(20)
I 44
#define	MON_MAXSWAP	(MON$C_MAXSWAP)
#define MonitorMaxSwap	(MON$C_MAXSWAP)
E 44
E 31
E 30

I 3
struct	mon_swap {
D 12
	short	mon_type,		/* MON$K_SWAP */
		mon_length ;		/* MON$S_SWAP */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_SWAP */
E 29
I 29
	char	mon_type,		/* MON$C_SWAP */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_SWAP */
I 30

I 44
	/*
 	 *	In V4.0 dmmin will be unused and the value of swapfrag
	 *	will be put in dmmax.
	 */
E 44
	int	mon_dmmin ;		/* the value of dmmin */
	int	mon_dmmax ;		/* the value of dmmax */
I 44
#define	mon_swapfrag	mon_dmmax
E 44

D 31
	int	mon_total ;		/* Total space available */
	int	mon_text ;		/* text space */
	int	mon_smem ;		/* shared memory */
	int	mon_free ;		/* space free */
	int	mon_used ;		/* Swap space in use */
	int	mon_wasted ;		/* space wasted */
E 31
I 31
	int	mon_total, 		/* Total space available */
		mon_text, 		/* text space */
		mon_smem, 		/* shared memory */
		mon_free, 		/* space free */
		mon_used, 		/* Swap space in use */
		mon_wasted ;		/* space wasted */
E 31

	/*
	 *	The usage of available space.  If you take the
	 *	index of a non-zero value of this array and
	 *	do a left of one with it (1 << index), that
D 44
	 *	the size in kilobytes of that entry.
E 44
I 44
	 *	the size in kilobytes of that entry.  V4.0
	 *	systems will only use one member of this array
	 *	but it will be the appropriate one.  A future
	 *	version of monitor that doesn't have to support
	 *	pre-V4.0 systems will just count swapfrag's.
E 44
	 */
	int	mon_avail[MON$C_MAXSWAP] ;
E 30
E 12
};

E 3
/*
D 25
 *	Tape I/O information, probably on a per tape basis.  I don't
 *	think this information is in Ultrix, but we can always hope.
E 25
I 25
D 44
 *	Tape I/O information.  This record isn't used.
E 44
I 44
 *	Tape I/O information.  This record isn't used.  Do I
 *	really think that tape stats will get added someday?
 *	Should I bother keeping it around?
 *
 *	Answer: Only until I need another record because of
 *	readv/writev vector limit.
E 44
E 25
 */
D 29
#define	MON$K_TAPE	12
D 20
#define	MON$V_TAPE	MON$K_TAPE
#define MON$M_TAPE	(1 << MON$V_TAPE)
E 20
I 20
#define MON$M_TAPE	(1 << MON$K_TAPE)
E 29
I 29
D 44
#define	MON$C_TAPE	12
E 44
I 44
#define	MON$C_TAPE	(12)
#define	MON_TAPE	(MON$C_TAPE)
#define MonitorTape	(MON$C_TAPE)

E 44
#define MON$M_TAPE	(1 << MON$C_TAPE)
I 44
#define	MON_TAPE_M	(MON$M_TAPE)
#define MonitorTapeMask	(MON$M_TAPE)

E 44
E 29
E 20
#define	MON$S_TAPE	(sizeof(struct mon_tape))
I 44
#define	MON_TAPE_S	(MON$S_TAPE)
#define MonitorTapeSize	(MON$S_TAPE)
E 44

I 3
struct	mon_tape {
D 12
	short	mon_type,		/* MON$K_TAPE */
		mon_length ;		/* MON$S_TAPE */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_TAPE */
E 29
I 29
	char	mon_type,		/* MON$C_TAPE */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_TAPE */
D 25
/*
 *	Static data.
 */
E 12
D 23
	char	mon_name[32] ;		/* tape name */
E 23
I 23
	char	mon_name[DEV_SIZE+1] ;	/* tape name */
E 23
	short	mon_unit,		/* tape unit number */
		mon_tp,			/* system wide tape number */
I 13
D 23
		mon_index,		/* internal tape number */
E 13
		mon_controller,		/* controller number */
		mon_bus ;		/* bus number */
E 23
I 23
		mon_index ;		/* internal tape number */
E 23
I 12
	long	mon_tape ;		/* device specific information */
/*
 *	Dynamic data.
 */
D 18
	double	mon_etime ;		/* elapsed time in clock ticks */
E 18
D 19
	long	: 32,			/* reserved for future use. */
		: 32,
		: 32,
		: 32 ;
E 19
I 19
D 21
	long	mon_rffu[4] ;		/* reserved for future use. */

E 19
/*
 *	Useful pointer.
 */
E 12
	struct	mon_tape *mon_next ;	/* next tape in list */
E 21
I 21
	long	mon_rffu[5] ;		/* reserved for future use. */
E 25
E 21
};

E 3
/*
D 29
 *	The number of users logged in.  Probably will be counted by 
 *	contents of /etc/wtmp.  That information should be kept in 
 *	memory anyway.
E 29
I 29
 *	The number of users logged in.
E 29
 */
D 29
#define MON$K_USER	13
D 20
#define	MON$V_USER	MON$K_USER
#define MON$M_USER	(1 << MON$V_USER)
E 20
I 20
#define MON$M_USER	(1 << MON$K_USER)
E 29
I 29
D 44
#define MON$C_USER	13
E 44
I 44
#define MON$C_USER	(13)
#define	MON_USER	(MON$C_USER)
#define MonitorUser	(MON$C_USER)

E 44
#define MON$M_USER	(1 << MON$C_USER)
I 44
#define	MON_USER_M	(MON$M_USER)
#define MonitorUserMask	(MON$M_USER)

E 44
E 29
E 20
#define	MON$S_USER	(sizeof(struct mon_user))
I 44
#define	MON_USER_S	(MON$S_USER)
#define MonitorUserSize	(MON$S_USER)
E 44

I 3
struct	mon_user {
D 12
	short	mon_type,		/* MON$K_USER */
		mon_length ;		/* MON$S_USER */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_USER */
E 29
I 29
	char	mon_type,		/* MON$C_USER */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_USER */
I 34

E 34
E 12
	int	mon_user ;		/* number of users logged on */
};

E 3
/*
D 29
 *	Network interface info, probably on a per interface basis.
E 29
I 29
 *	Network interface info, on a per interface basis.
I 44
 *
 *	In some future version I'll add byte counts in addition
 *	to packet counts since this is much more interesting.
E 44
E 29
 */
D 29
#define	MON$K_NETIF	14
D 20
#define	MON$V_NETIF	MON$K_NETIF
#define MON$M_NETIF	(1 << MON$V_NETIF)
E 20
I 20
#define MON$M_NETIF	(1 << MON$K_NETIF)
E 29
I 29
D 44
#define	MON$C_NETIF	14
#define MON$M_NETIF	(1 << MON$C_NETIF)
E 29
E 20
#define	MON$S_NETIF	(sizeof(struct mon_netif))
E 44
I 44
#define	MON$C_NETIF		(14)
#define	MON_NETIF		(MON$C_NETIF)
#define MonitorNetif		(MON$C_NETIF)
E 44

I 44
#define MON$M_NETIF		(1 << MON$C_NETIF)
#define	MON_NETIF_M		(MON$M_NETIF)
#define MonitorNetifMask	(MON$M_NETIF)

#define	MON$S_NETIF		(sizeof(struct mon_netif))
#define	MON_NETIF_S		(MON$S_NETIF)
#define MonitorNetifSize	(MON$S_NETIF)

E 44
I 3
struct	mon_netif {
E 3
/*
I 3
 *	Static data
 */
D 12
	short	mon_type,		/* MON$K_NETIF */
		mon_length ;		/* MON$S_NETIF */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_NETIF */
E 29
I 29
	char	mon_type,		/* MON$C_NETIF */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_NETIF */
E 12
D 28
	char	mon_name[IFNAMSIZ] ;	/* interface name 'lo' or 'de' */
E 28
I 28
	char	mon_name[IFNAMSIZ+1] ;	/* interface name 'lo' or 'de' */
E 28
D 12
	short	mon_unit ;		/* unit number */
I 10
	short	mon_if ;		/* like the "dk" number for disks */
E 12
I 12
	short	mon_unit,		/* unit number */
D 13
		mon_if ;		/* like the "dk" number for disks */
E 13
I 13
		mon_if,			/* like the "dk" number for disks */
		mon_index ;		/* internal netif number */
E 13
	long	mon_netif ;		/* device specific information */
E 12
E 10
/*
 *	Dynamic data
 */
I 5
D 12
	short	mon_flags ;		/* up/down, broadcase, etc */
E 5
	int	mon_ipackets ;		/* input packets */
	int	mon_ierrors;		/* input errors */
	int	mon_opackets;		/* output packets */
	int	mon_oerrors;		/* output errors */
	int	mon_collisions;		/* collisions */
E 12
I 12
	short	mon_if_flags ;		/* up/down, broadcast, etc */
	int	mon_ipackets,		/* input packets */
		mon_ierrors,		/* input errors */
		mon_opackets,		/* output packets */
		mon_oerrors,		/* output errors */
		mon_collisions ;	/* collisions */
I 21

	long	mon_rffu[1];		/* reserved */
E 21
I 13
D 18
	double	mon_etime ;		/* elapsed time */
E 18
E 13
E 12
/*
D 21
 *	Useful pointers.
E 21
I 21
 *	Useful pointer.
E 21
 */
D 5
	struct ifnet	*mon_ifnet ;	/* address of kernel ifnet struct */
E 5
I 5
	struct ifnet	 *mon_ifnet ;	/* address of kernel ifnet struct */
E 5
D 21
	struct mon_netif *mon_next ;	/* next network interface in list */
E 21
I 9
D 10
	struct tot_netif *mon_total ;	/* A place to store the old data */
E 10
E 9
};

/*
E 3
D 11
 *	Time in CPU states.  One for each CPU.
 */
#define	MON$K_STATE	15
#define	MON$V_STATE	MON$K_STATE
#define MON$M_STATE	(1 << MON$V_STATE)
#define	MON$S_STATE	(sizeof(struct mon_state))

struct	mon_state {
D 3
	short	mon_type,		/* MON$K_CPU */
		mon_length ;		/* length */
	long	mon_cp_time[CPUSTATES];	/* Time in CPU states */
	char	mon_cpu,	 	/* which cpu in multiple CPU systems */
		: 8,
		: 8,
		: 8 ;			/* alignment holders */
E 3
I 3
	short	mon_type,		/* MON$K_STATE */
		mon_length ;		/* MON$S_STATE */
D 4
	long	mon_time[CPUSTATES];	/* Time in CPU states */
E 4
I 4
	long	mon_time[CPUSTATES],	/* Time in CPU states */
		mon_where ;		/* address of cp_time data */
E 4
	int	mon_cpuid,		/* CPU id of each */
		mon_cpu ;	 	/* which cpu in multiple CPU systems */
D 5
	double	mon_total ;		/* total change in time */
E 5
	struct	mon_state *mon_next ;	/* next CPU in list */
E 3
};

/*
E 11
 *	All the memory info.
 */
D 11
#define	MON$K_MEMORY	16
E 11
I 11
D 29
#define	MON$K_MEMORY	15
E 11
D 20
#define	MON$V_MEMORY	MON$K_MEMORY
#define MON$M_MEMORY	(1 << MON$V_MEMORY)
E 20
I 20
#define MON$M_MEMORY	(1 << MON$K_MEMORY)
E 29
I 29
D 44
#define	MON$C_MEMORY	15
#define MON$M_MEMORY	(1 << MON$C_MEMORY)
E 29
E 20
#define	MON$S_MEMORY	(sizeof(struct mon_memory))
E 44
I 44
#define	MON$C_MEMORY		(15)
#define	MON_MEMORY		(MON$C_MEMORY)
#define MonitorMemory		(MON$C_MEMORY)
E 44
I 3

I 44
#define MON$M_MEMORY		(1 << MON$C_MEMORY)
#define	MON_MEMORY_M		(MON$M_MEMORY)
#define MonitorMemoryMask	(MON$M_MEMORY)

#define	MON$S_MEMORY		(sizeof(struct mon_memory))
#define	MON_MEMORY_S		(MON$S_MEMORY)
#define MonitorMemorySize	(MON$S_MEMORY)

E 44
struct	mon_memory {
D 12
	short	mon_type,		/* MON$K_MEMORY */
		mon_length ;		/* MON$S_MEMORY */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_MEMORY */
E 29
I 29
	char	mon_type,		/* MON$C_MEMORY */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_MEMORY */
I 34

E 34
E 12
	int	mon_vm,			/* total virtual memory */
		mon_avm,		/* active vitrual memory */
		mon_rm,			/* total real memory */
		mon_arm,		/* active real memory */
		mon_vmtxt,		/* virtual memory used by text */
		mon_avmtxt,		/* active vitrual memory used by text */
		mon_rmtxt,		/* real memory used by text */
		mon_armtxt,		/* active real memory used by text */
		mon_free ;		/* free memory */
};
E 3

/*
 *	The load averages.  It would be nice if Ultrix would #define
 *	the number of load averages, but I will do it for now.
 */
D 11
#define	MON$K_LOADAVE	17
E 11
I 11
D 29
#define	MON$K_LOADAVE	16
E 11
D 20
#define	MON$V_LOADAVE	MON$K_LOADAVE
#define MON$M_LOADAVE	(1 << MON$V_LOADAVE)
E 20
I 20
#define MON$M_LOADAVE	(1 << MON$K_LOADAVE)
E 29
I 29
D 44
#define	MON$C_LOADAVE	16
#define MON$M_LOADAVE	(1 << MON$C_LOADAVE)
E 29
E 20
#define	MON$S_LOADAVE	(sizeof(struct mon_loadave))
E 44
I 44
#define	MON$C_LOADAVE		(16)
#define	MON_LOADAVE		(MON$C_LOADAVE)
#define MonitorLoadave		(MON$C_LOADAVE)
E 44

D 17
#define	MON$N_LOADAVE	4	/* Number of load averages */
E 17
I 17
D 44
#define	MON$N_LOADAVE	3	/* Number of load averages */
E 44
I 44
#define MON$M_LOADAVE		(1 << MON$C_LOADAVE)
#define	MON_LOADAVE_M		(MON$M_LOADAVE)
#define MonitorLoadaveMask	(MON$M_LOADAVE)
E 44
E 17

I 44
#define	MON$S_LOADAVE		(sizeof(struct mon_loadave))
#define	MON_LOADAVE_S		(MON$S_LOADAVE)
#define MonitorLoadaveSize	(MON$S_LOADAVE)

#define	MON$N_LOADAVE		(3)	/* Number of load averages */
#define	MON_MAXLOADAVE		(MON$N_LOADAVE)
#define MonitorMaxLoadave	(MON$N_LOADAVE)

E 44
struct	mon_loadave {
D 12
	short	mon_type, 		/* MON$K_LOADAVE */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type, 		/* MON$K_LOADAVE */
E 29
I 29
	char	mon_type, 		/* MON$C_LOADAVE */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* length */
I 34

E 34
I 30
	int	mon_filler ;			/* padding for VAX */
E 30
E 12
	double	mon_loadave[MON$N_LOADAVE] ;	/* load averages */
};

/*
I 23
 *	Structure for storing per process information.
 */
D 29
#define	MON$K_PID	(17)
D 26
#define	MON$M_PID	(1 << MON$M_PID)
E 26
I 26
#define	MON$M_PID	(1 << MON$K_PID)
E 29
I 29
#define	MON$C_PID	(17)
I 44
#define	MON_PID		(MON$C_PID)
#define MonitorPID	(MON$C_PID)

E 44
#define	MON$M_PID	(1 << MON$C_PID)
I 44
#define	MON_PID_M	(MON$M_PID)
#define MonitorPIDMask	(MON$M_PID)

E 44
E 29
E 26
#define	MON$S_PID	(sizeof(struct mon_pid))
I 44
#define	MON_PID_S	(MON$S_PID)
#define MonitorPIDSize	(MON$S_PID)
E 44

I 38
#define	MON$S_USERNAME	(16)
D 44
#define	MON$S_GROUPNAME	(32)
E 44
I 44
#define	MON_USERNAME	(MON$S_USERNAME)
#define MonitorUsername	(MON$S_USERNAME)
E 44

I 44
#define	MON$S_GROUPNAME		(32)
#define	MON_GROUPNAME		(MON$S_GROUPNAME)
#define MonitorGroupname	(MON$S_GROUPNAME)

E 44
E 38
struct mon_pid {
D 44
	char	mon_type,		/* MON$M_PID */
E 44
I 44
	char	mon_type,		/* MON$C_PID */
E 44
D 29
		mon_flag ;		/* current undefined */
E 29
I 29
		mon_flag ;		/* currently unused */
E 29
D 44
	short	mon_length ;		/* sizeof(struct mon_pid) */
E 44
I 44
	short	mon_length ;		/* MON$S_PID */
E 44

	char	mon_comm[MAXNAMLEN+1],	/* command name */
		mon_stat,		/* process status */
		mon_pri,		/* priority, negative is high */
		mon_nice ;		/* How "nice" is the process */

	short	mon_pgrp,		/* process group */
		mon_pid ;		/* pid from the proc structure */
	dev_t	mon_ttyd ;		/* controlling tty */
I 28
	caddr_t	mon_wchan ;		/* the "wait channel" */
E 28

	size_t	mon_rssize ;		/* resident set size */

	int	mon_pflag,		/* process flags */
		mon_cpundx ;		/* index of CPU, from soft pcb */

D 43
	struct ucred	mon_cred ;	/* credential structure */
E 43
I 43
	struct mon_ucred {
		u_short	cr_ref ;
		short	cr_uid ;
		short	cr_gid ;
		int	cr_groups[NGROUPS] ;
		short	cr_ruid ;
		short	cr_rgid ;
	} mon_cred ;			/* credential structure */
E 43

	struct rusage	mon_self,	/* usage stats for self */
			mon_child ;	/* usage stats for children */

	struct proc 	*mon_proc ;	/* kernel address of proc structure */
I 38

	char	mon_username[MON$S_USERNAME+1],		/* Name of effective uid */
		mon_realuser[MON$S_USERNAME+1],		/* Name of real uid */
		mon_groupname[MON$S_GROUPNAME+1],	/* Name of effective gid */
		mon_realgroup[MON$S_GROUPNAME+1] ;	/* Name of real gid */
E 38
} ;

/*
I 29
D 30
 *	The next three record types are planned for future expansion.
 */

/*
E 30
 *	This record will be used to keep buffer cache information.
 */
#define MON$C_BUF	(18)
I 44
#define	MON_BUF		(MON$C_BUF)
#define MonitorBuf	(MON$C_BUF)

E 44
#define MON$M_BUF	(1 << MON$C_BUF)
I 44
#define	MON_BUF_M	(MON$M_BUF)
#define MonitorBufMask	(MON$M_BUF)

E 44
#define	MON$S_BUF	(sizeof(struct mon_buf))
I 44
#define	MON_BUF_S	(MON$S_BUF)
#define MonitorBufSize	(MON$S_BUF)
E 44
I 32
D 34
#define	MON$C_DETAIL	(32)
E 34
E 32

I 33
/*
 *	More detailed information about the fields.
 *
 *	The mon_bufpages field is the size of the buffer cache in 
D 34
 *	bytes.  The field mon_nused is the of buffers associated with 
 *	a device.  The field mon_bcount is the sum of the b_bcount 
E 34
I 34
 *	bytes.  The field mon_nused is the number of buffers associated 
 *	with a device.  The field mon_bcount is the sum of the b_bcount 
E 34
 *	element of the buffer headers.  The field mon_bufsize is the 
 *	sum of the b_bufsize element.  I have seen cases where these 
 *	were the same size and where they were different.  The field
 *	mon_cache is the number of buffers that had the B_CACHE bit
 *	set in their flag.
 *
 *	The same size appeared on a diskless DECstation 3100.  I don't
D 34
 *	if being DS3100 or being diskless was significant to this case.
E 34
I 34
 *	know if being DS3100 or being diskless was significant to this 
 *	case.
 *
 *	One BUF struct is allocated for each device that has buffers
 *	attached to it.  A few extra are allocated since monitor doesn't
 *	handle the number of a particular record type changing yet.  The
 *	result of this is that I allocate enough for all the potential
 *	devices and then use only that many.  The first BUF record will 
 *	contain the totals for all the buffer cache. 
E 34
 */
E 33
struct mon_buf {
	char	mon_type,		/* MON$C_BUF */
D 34
		mon_flag ;		/* unused */
E 34
I 34
		mon_flag ;		/* see values for flags above */
E 34
	short	mon_length ;		/* MON$S_BUF */
I 30

	int	mon_nbuf,		/* number of buffers */
		mon_bufpages,		/* pages allocated to buffers */
D 33
		mon_nused,		/* number of buffers used? */
		mon_memuse,		/* amount of memory in use? */
		mon_memalloc,		/* ? */
E 33
I 33
		mon_nused,		/* number of buffers used */
		mon_bcount,		/* amount of memory in use */
D 34
		mon_bufsize,		/* amount of memory allocated */
E 33
		mon_cache ;		/* Cache hits */
E 34
I 34
		mon_bufsize ;		/* amount of memory allocated */
E 34
I 32

D 33
	struct cache_detail {
E 33
I 33
D 34
	struct detail {
E 33
		dev_t	mon_device ;	/* which device */
D 33
		int	mon_count ;	/* number of buffers for this device */
		int	mon_cache ;	/* cache hits for this device */
		int	mon_filler ;	/* for future use */
E 33
I 33
		int	mon_count,	/* number of buffers for this device */
			mon_cache ;	/* cache hits for this device */
E 33
	} mon_detail[MON$C_DETAIL] ;
E 34
I 34
	/*
	 *	These count which of the b_flags are set.  The
	 *	choice was somewhat arbitrary.
	 */
	int	mon_cache,		/* The CACHE bit was set */
		mon_delwri,		/* The DELWRI bit was set */
		mon_read,		/* the READ bit was set */
		mon_busy,		/* the BUSY bit was set */
		mon_done,		/* the DONE bit was set */
		mon_inval,		/* the INVAL bit was set */
		mon_error,		/* the ERROR bit was set */
		mon_rffu[4] ;		/* save room for four other flags */
		
	dev_t	mon_device ;		/* which device */
					/* the compiler will probably pad here */

	int	mon_inode ;		/* "hot" {g,i}node.  For future use */

	char	mon_fsname[MAXPATHLEN+1] ;
E 34
E 32
E 30
};

/* 
D 30
 *	This record will be used to keep NFS information.
E 30
I 30
 *	This record will be used to keep NFS information.  This
D 44
 *	will probably be implemented in the version for Ultrix
 *	V3.2.
E 44
I 44
 *	will probably be implemented in version past the one for
 *	ULTRIX V4.0.
E 44
E 30
 */
#define MON$C_NFS	(19)
I 44
#define	MON_NFS		(MON$C_NFS)
#define MonitorNFS	(MON$C_NFS)

E 44
#define MON$M_NFS	(1 << MON$C_NFS)
I 44
#define	MON_NFS_M	(MON$M_NFS)
#define MonitorNFSMask	(MON$M_NFS)

E 44
#define	MON$S_NFS	(sizeof(struct mon_nfs))
I 44
#define	MON_NFS_S	(MON$S_NFS)
#define MonitorNFSSize	(MON$S_NFS)
E 44

struct mon_nfs {
	char	mon_type,		/* MON$C_NFS */
		mon_flag ;		/* unused */
	short	mon_length ;		/* MON$S_NFS */
I 34

E 34
I 30
D 43
	int	mon_cpunum ;		/* planning for V3.2 */
E 43
I 43
	int	mon_rffu ;		/* Reserved */
E 43
E 30
};

/* 
 *	This record will be used to keep namei cache information.
I 44
 *
 *	In V4.0 it doesn't appear that badhits and falsehits
 *	are counted.
E 44
 */
D 44
#define MON$C_NAMEI	(20)
#define MON$M_NAMEI	(1 << MON$C_NAMEI)
#define	MON$S_NAMEI	(sizeof(struct mon_namei))
E 44
I 44
#define MON$C_NAMEI		(20)
#define	MON_NAMEI		(MON$C_NAMEI)
#define MonitorNamei		(MON$C_NAMEI)
E 44

I 44
#define MON$M_NAMEI		(1 << MON$C_NAMEI)
#define	MON_NAMEI_M		(MON$M_NAMEI)
#define MonitorNameiMask	(MON$M_NAMEI)

#define	MON$S_NAMEI		(sizeof(struct mon_namei))
#define	MON_NAMEI_S		(MON$S_NAMEI)
#define MonitorNameiSize	(MON$S_NAMEI)

E 44
struct mon_namei {
	char	mon_type,		/* MON$C_NAMEI */
		mon_flag ;		/* unused */
	short	mon_length ;		/* MON$S_NAMEI */
I 30

D 34
	long	mon_goodhits;		/* hits that we can reall use */
	long	mon_badhits;		/* hits we must drop */
	long	mon_falsehits;		/* hits with id mismatch */
	long	mon_miss;		/* misses */
	long	mon_long;		/* long names that ignore cache */
	long	mon_pass2;		/* names found with passes == 2 */
	long	mon_2passes;		/* number of times we attempt it */
E 34
I 34
	long	mon_goodhits,		/* hits that we can reall use */
		mon_badhits,		/* hits we must drop */
		mon_falsehits,		/* hits with id mismatch */
		mon_miss,		/* misses */
		mon_long,		/* long names that ignore cache */
		mon_pass2,		/* names found with passes == 2 */
		mon_2passes ;		/* number of times we attempt it */
E 34
E 30
};

/*
I 34
 *	Statistics from the kernel memory allocator.  Reserved
 *	for future use.
 */
D 44
#define	MON$C_KMEM 	21	/* This record will never occur (normally) */
E 44
I 44
#define	MON$C_KMEM 	(21)
#define	MON_KMEM	(MON$C_KMEM)
#define MonitorKmem	(MON$C_KMEM)

E 44
#define	MON$M_KMEM 	(1 << MON$C_KMEM)
I 44
#define	MON_KMEM_M	(MON$M_KMEM)
#define MonitorKmemMask	(MON$M_KMEM)

E 44
#define	MON$S_KMEM 	(sizeof(struct mon_kmem))
I 44
#define	MON_KMEM_S	(MON$S_KMEM)
#define MonitorKmemSize	(MON$S_KMEM)
E 44

struct	mon_kmem {
	char	mon_type,		/* MON$C_KMEM */
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_KMEM */

	long	mon_rffu[16] ;		/* set aside some space */
};

/*
E 34
E 29
E 23
 *	This record might be used to mark the end of record types
 *	and/or as a place holder for unimplimented record types
 *	that might slip into the data file.
 *
 *	This record will never normally occur.  A "panic" is in order
 *	if we actually see one.
I 44
 *
 *	In a future version I'll define the union before the panic
 *	record and make the size of the buffer:
 *
 *		sizeof(union) - sizeof(header)
 *
 *	Doing it now would change the size and I don't want to do
 *	that right now.
E 44
 */
D 11
#define	MON$K_PANIC	18	/* This record will never occur (normally) */
E 11
I 11
D 23
#define	MON$K_PANIC	17	/* This record will never occur (normally) */
E 23
I 23
D 29
#define	MON$K_PANIC	18	/* This record will never occur (normally) */
E 23
E 11
D 20
#define	MON$V_PANIC	MON$K_PANIC
#define	MON$M_PANIC	(1 << MON$V_PANIC)
E 20
I 20
#define	MON$M_PANIC	(1 << MON$K_PANIC)
E 29
I 29
D 34
#define	MON$C_PANIC	21	/* This record will never occur (normally) */
E 34
I 34
D 44
#define	MON$C_PANIC	22	/* This record will never occur (normally) */
E 34
#define	MON$M_PANIC	(1 << MON$C_PANIC)
E 29
E 20
#define	MON$S_PANIC	(sizeof(struct mon_panic))
E 44
I 44
#define	MON$C_PANIC		(22)	/* This record will never occur (normally) */
#define	MON_PANIC		(MON$C_PANIC)
#define MonitorPanic		(MON$C_PANIC)
E 44

I 44
#define	MON$M_PANIC		(1 << MON$C_PANIC)
#define	MON_PANIC_M		(MON$M_PANIC)
#define MonitorPanicMask	(MON$M_PANIC)

#define	MON$S_PANIC		(sizeof(struct mon_panic))
#define	MON_PANIC_S		(MON$S_PANIC)
#define MonitorPanicSize	(MON$S_PANIC)

E 44
struct	mon_panic {
D 12
	short	mon_type,		/* MON$K_PANIC */
		mon_length ;		/* length */
E 12
I 12
D 29
	char	mon_type,		/* MON$K_PANIC */
E 29
I 29
	char	mon_type,		/* MON$C_PANIC */
E 29
		mon_flag ;		/* Other information */
	short	mon_length ;		/* MON$S_PANIC */
I 34

E 34
E 12
	char	mon_buffer[BUFSIZ] ;	/* some place to put the data */
};
I 34

E 34
I 14
/*
I 34
 *	A union of all the records in case somebody needs it.
 */
I 40
D 44
#define	MON$S_RECORD	(sizeof(union mon_record))
E 44
I 44
#define	MON$S_RECORD		(sizeof(union mon_record))
#define	MON_RECORD		(MON$C_RECORD)
#define MonitorRecord		(MON$C_RECORD)
E 44

I 44
/*
 *	I need to add mon_kmem to this.
 */
E 44
E 40
union	mon_record {
	struct mon_header  header ;
	struct mon_first   first ;
	struct mon_last	   last ;
	struct mon_sample  sample ;
	struct mon_reconf  reconf ;

	struct mon_cpu     cpu ;
	struct mon_tty     tty ;
	struct mon_disk    disk ;
	struct mon_free    free ;
	struct mon_fork    fork ;
	struct mon_page    page ;
	struct mon_proc    proc ;
	struct mon_swap    swap ;
	struct mon_tape    tape ;
	struct mon_user    user ;
	struct mon_netif   netif ;
	struct mon_memory  memory ;
	struct mon_loadave loadave ;
	struct mon_pid     pid ;
	struct mon_buf     buf ;
	struct mon_nfs     nfs ;
	struct mon_namei   namei ;

	struct mon_panic   panic ;
};

/*
E 34
 *	The number of record types.
 */
D 23
#define	MON$N_RECORDS	(17)
E 23
I 23
D 29
#define	MON$N_RECORDS	(18)
E 29
I 29
D 35
#define	MON$N_RECORDS	(21)
E 35
I 35
D 44
#define	MON$N_RECORDS	(22)
E 44
I 44
#define	MON$N_RECORDS		(22)
#define	MON_MAXRECORDS		(MON$N_RECORDS)
#define MonitorMaxRecords	(MON$N_RECORDS)
E 44
E 35
E 29
E 23
E 14

/*
 *	This is a summary of the record type numbers.
 *
 *	Control records
 *
D 29
 *	MON$K_FIRST	0	# the first record written to the file.
 *	MON$K_LAST	1	# hopefully the last record written
 *	MON$K_SAMPLE	2	# sample summary
 *	MON$K_RECTYPE3	3	# reserved for future use
E 29
I 29
 *	MON$C_FIRST	0	# the first record written to the file.
 *	MON$C_LAST	1	# hopefully the last record written
 *	MON$C_SAMPLE	2	# sample summary
D 34
 *	MON$C_RECTYPE3	3	# reserved for future use
E 34
I 34
 *	MON$C_RECONF	3	# reserved for future use
E 34
E 29
 *
 *	Data records
 *
D 11
 *	MON$K_CPU	4	# interrupts, system calls, etc 
E 11
I 11
D 29
 *	MON$K_CPU	4	# interrupts, system calls, time in states, etc
E 11
 *	MON$K_TTY	5	# tty I/O 
 *	MON$K_DISK	6	# disk I/O
 *	MON$K_FREE	7	# free memory
 *	MON$K_FORK	8	# fork data
 *	MON$K_PAGE	9	# paging data
 *	MON$K_PROC	10	# process data
D 25
 *	MON$K_SWAP	11	# swap space utilization
 *	MON$K_TAPE	12	# tape I/O (unimplimented in Ultrix)
E 25
I 25
 *	MON$K_SWAP	11	# swap space utilization (unused)
 *	MON$K_TAPE	12	# tape I/O (unused)
E 25
 *	MON$K_USER	13	# number of users
 *	MON$K_NETIF	14	# network interface data
D 11
 *	MON$K_STATE	15	# time in CPU states, one for each CPU
 *	MON$K_MEMORY	16	# all memory information
 *	MON$K_LOADAVE	17	# load averages
 *	MON$K_PANIC	18	# This record will never occur (normally)
E 11
I 11
 *	MON$K_MEMORY	15	# all memory information
 *	MON$K_LOADAVE	16	# load averages
D 23
 *	MON$K_PANIC	17	# This record will never occur (normally)
E 23
I 23
 *	MON$K_PID	17	# process by pid
 *	MON$K_PANIC	18	# This record will never occur (normally)
E 29
I 29
 *	MON$C_CPU	4	# interrupts, system calls, time in states, etc
 *	MON$C_TTY	5	# tty I/O 
 *	MON$C_DISK	6	# disk I/O
 *	MON$C_FREE	7	# free memory
 *	MON$C_FORK	8	# fork data
 *	MON$C_PAGE	9	# paging data
 *	MON$C_PROC	10	# process data
 *	MON$C_SWAP	11	# swap space utilization (unused)
 *	MON$C_TAPE	12	# tape I/O (unused)
 *	MON$C_USER	13	# number of users
 *	MON$C_NETIF	14	# network interface data
 *	MON$C_MEMORY	15	# all memory information
 *	MON$C_LOADAVE	16	# load averages
 *	MON$C_PID	17	# process by pid
 *	MON$C_BUF	18	# buffer cache
 *	MON$C_NFS	19	# NFS information
 *	MON$C_NAMEI	20	# namei cache
I 39
 *	MON$C_KMEM	21	# Kernel memory allocator stats.
E 39
 *
D 39
 *	MON$C_PANIC	21	# This record will never occur (normally)
E 39
I 39
 *	MON$C_PANIC	22	# This record will never occur (normally)
E 39
E 29
E 23
E 11
 */
E 1
