h06502
s 00010/00000/00092
d D 1.14 90/03/29 16:16:33 alan 14 13
c The hack to fix the DECmumble include file problem.
e
s 00002/00002/00090
d D 1.13 89/02/25 09:57:44 alan 13 12
c editorial change to rec_ elements
e
s 00008/00000/00084
d D 1.12 89/02/10 15:21:05 alan 12 11
c Change for new BUF record and RECONF record.
c 
e
s 00011/00001/00073
d D 1.11 88/06/27 18:14:36 alan 11 10
c changed include of monitor.h and record.h
e
s 00003/00003/00071
d D 1.10 87/11/18 16:39:26 alan 10 9
c V0.99 -> T1.0-1
e
s 00001/00001/00073
d D 1.9 87/04/05 13:26:21 alan 9 8
c 1.  Modified uba.c and names.c to take advantage of V2 uba_device
c     structure and use the correct controller number for reporting
c     controller on bus.
c 2.  Fixed bug in iovec setup code that caused bad disk data to be
c     written out on a save.
c 
e
s 00002/00002/00072
d D 1.8 87/04/03 14:32:11 alan 8 7
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00007/00009/00067
d D 1.7 87/03/03 15:43:10 alan 7 6
c see the commentary for V0.83 in version.c
e
s 00000/00005/00076
d D 1.6 87/02/05 16:27:50 alan 6 5
c See comment on V0.81 in version.c.
c 
e
s 00004/00000/00077
d D 1.5 87/01/21 16:35:32 alan 5 4
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00001/00001/00076
d D 1.4 86/08/26 18:05:14 alan 4 3
c modify all SccsId strings
e
s 00002/00000/00075
d D 1.3 86/07/30 19:12:14 alan 3 2
c fix bug causeing disk and tape iov_base not to be set
e
s 00002/00001/00073
d D 1.2 86/07/30 17:17:44 alan 2 1
c new code
e
s 00074/00000/00000
d D 1.1 86/07/30 15:39:16 alan 1 0
c date and time created 86/07/30 15:39:16 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Function(s) to manage the I/O vector.
 */
#ifndef	lint
D 4
static	char	SccsId[] = "%W% %G%" ;
E 4
I 4
D 8
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 8
I 8
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 8
E 4
#endif

I 11
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 12
 *
 * Feb. 10, 1989 -- arr
 *
 *	Added a case to the switch for the BUF records.
I 14
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 14
E 12
 */

E 11
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
I 5
D 6
#include <sys/devio.h>
E 6
E 5
#include <sys/dk.h>
I 5
#include <sys/param.h>
#include <sys/dir.h>
I 14

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 14
#include <sys/user.h>
E 5
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

D 8
#include "extern.h"
E 8
#include "options.h"
D 11
#include "record.h"
E 11
I 2
#include "monitor.h"
I 11
#include "include.h"
E 11
I 8
#include "extern.h"
E 8
E 2

/*
D 7
 *	Figure out how big a sample, count the number of records involved
 *	and initialize the I/O vector.
E 7
I 7
 *	Count the number of records and initialize the I/O vector.
E 7
 */
init_iovec(op)
register OPTION	*op ;
{
D 7
	register int i, size = 0, index = 0 ;
E 7
I 7
	register int i, index = 0 ;
E 7

D 7
	for(i = 0; i < sizeof(op->opt_data) * 8; i++) {
E 7
I 7
	for(i = 0; i < sizeof(op->opt_data) * NBBY; i++) {
E 7
D 2
		if( op->opt_data & (1 << i) == 0 )
E 2
I 2
		if((op->opt_data & (1 << i)) == 0 )
E 2
			continue ;

		switch( i ) {
D 10
		case MON$K_DISK:
E 10
I 10
		case MON$C_DISK:
E 10
D 7
			size += (iov[index].iov_len = MON$S_DISK * n_disk) ;
E 7
I 7
			iov[index].iov_len = MON$S_DISK * n_disk ;
E 7
I 3
D 6
			iov[index].iov_base = (caddr_t)records[i].rec_addr;
E 3
			break ;
		case MON$K_TAPE:
			size += (iov[index].iov_len = MON$S_TAPE * n_tape) ;
E 6
I 3
D 9
			iov[index].iov_base = (caddr_t)records[i].rec_addr;
E 9
I 9
			iov[index].iov_base = (caddr_t)disk ;
E 9
E 3
			break ;
D 10
		case MON$K_NETIF:
E 10
I 10
		case MON$C_NETIF:
E 10
D 7
			size += (iov[index].iov_len = MON$S_NETIF * n_netif) ;
E 7
I 7
			iov[index].iov_len = MON$S_NETIF * n_netif ;
E 7
			iov[index].iov_base = (caddr_t)netif ;
			break ;
D 10
		case MON$K_CPU:
E 10
I 10
		case MON$C_CPU:
E 10
D 7
			size += (iov[index].iov_len = MON$S_CPU * n_cpu) ;
E 7
I 7
			iov[index].iov_len = MON$S_CPU * n_cpu ;
E 7
			iov[index].iov_base = (caddr_t)cpu ;
I 12
			break ;
		case MON$C_BUF:
			iov[index].iov_len = MON$S_BUF * n_buf ;
			iov[index].iov_base = (caddr_t)mon_buf ;
E 12
			break ;
		default:
D 7
			size += (iov[index].iov_len = records[i].rec_size) ;
E 7
I 7
D 13
			iov[index].iov_len = records[i].rec_size ;
E 7
			iov[index].iov_base = (caddr_t)records[i].rec_addr;
E 13
I 13
			iov[index].iov_len = records[i].size ;
			iov[index].iov_base = (caddr_t)records[i].addr;
E 13
			break ;
		}

		index++ ;
	}

/*
 *	Set externals.
 */
	n_records = index ;
D 7
	sample.mon_datalen = size ;
E 7
}
E 1
