h00040
s 00080/00000/00000
d D 1.1 88/12/05 13:44:08 alan 1 0
c date and time created 88/12/05 13:44:08 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Read the interesting disk information.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

#include <stdio.h>
#include <nlist.h>
#include <sys/types.h>
#include <sys/buf.h>
#include <sys/dk.h>

struct nlist nl[] = {
#define	X_DK_TIME	(0)
	{ "_dk_time" },
#define	X_DK_XFER	(1)
	{ "_dk_xfer" },
#define	X_DK_WDS	(2)
	{ "_dk_wds" },
#define	X_DK_MSPW	(3)
	{ "_dk_mspw" },
	{ 0 }
};

long	dk_time[DK_NDRIVE] ;
long	dk_xfer[DK_NDRIVE] ;
long	dk_wds[DK_NDRIVE] ;
float	dk_mspw[DK_NDRIVE] ;

main()
{
	int	fd, i ;

	nlist("/vmunix", nl) ;

	if((fd = open("/dev/kmem", 0)) == -1 ) {
		perror("can't open /dev/kmem") ;
		exit(-1) ;
	}

	if( nl[X_DK_TIME].n_value != 0 ) {
		lseek(fd, (long)nl[X_DK_TIME].n_value, 0) ;
		read(fd, (char *)dk_time, sizeof(dk_time)) ;
	}
	else
		printf("%s is not available.\n", "time") ;

	if( nl[X_DK_XFER].n_value != 0 ) {
		lseek(fd, (long)nl[X_DK_XFER].n_value, 0) ;
		read(fd, (char *)dk_xfer, sizeof(dk_xfer)) ;
	}
	else
		printf("%s is not available.\n", "xfer") ;

	if( nl[X_DK_WDS].n_value != 0 ) {
		lseek(fd, (long)nl[X_DK_WDS].n_value, 0) ;
		read(fd, (char *)dk_wds, sizeof(dk_wds)) ;
	}
	else
		printf("%s is not available.\n", "wds") ;

	if( nl[X_DK_MSPW].n_value != 0 ) {
		lseek(fd, (long)nl[X_DK_MSPW].n_value, 0) ;
		read(fd, (char *)dk_mspw, sizeof(dk_mspw)) ;
	}
	else
		printf("%s is not available.\n", "mspw") ;

	for(i = 0; i < DK_NDRIVE; i++)
		printf("[%2d]: %10d %10d %10d %12.7f\n", i, dk_time[i], dk_wds[i],
			dk_xfer[i], dk_mspw[i]) ;

	close(fd) ;
}
E 1
