h27841
s 00054/00002/00227
d D 1.27 90/08/22 23:16:43 alan 27 26
c added fix for syscall and intr problem in magnify_cpu()
e
s 00011/00001/00218
d D 1.26 90/03/29 16:17:02 alan 26 25
c The hack to fix the DECmumble include file problem.
e
s 00004/00001/00215
d D 1.25 89/06/21 15:37:11 alan 25 24
c check total cpu ticks for a value of zero
e
s 00015/00001/00201
d D 1.24 89/02/17 22:07:43 alan 24 23
c added tlbpid and soft to display
e
s 00011/00001/00191
d D 1.23 88/06/27 18:14:11 alan 23 22
c changed include of monitor.h and record.h
e
s 00002/00002/00190
d D 1.22 87/08/12 15:25:36 alan 22 21
c error message clean up - V0.95
e
s 00002/00001/00190
d D 1.21 87/04/03 14:31:26 alan 21 20
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00004/00191
d D 1.20 87/02/05 16:27:14 alan 20 19
c See comment on V0.81 in version.c.
c 
e
s 00013/00009/00182
d D 1.19 87/01/30 13:04:24 alan 19 18
c see commentary on V0.75 in version.c
e
s 00008/00013/00183
d D 1.18 87/01/30 10:34:34 alan 18 17
c more fixes to delta_netif(), V0.74
e
s 00049/00041/00147
d D 1.17 87/01/29 15:13:55 alan 17 16
c Changes to delta_netif(), V0.72
c 
e
s 00003/00001/00185
d D 1.16 87/01/28 18:39:24 alan 16 15
c V0.70
e
s 00004/00000/00182
d D 1.15 87/01/21 16:35:05 alan 15 14
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00033/00004/00149
d D 1.14 86/12/07 22:22:54 alan 14 13
c See V0.57 in version.c
e
s 00008/00003/00145
d D 1.13 86/11/18 12:41:28 alan 13 12
c See commentary on V0.55 in version.c
c 
e
s 00001/00001/00147
d D 1.12 86/08/26 18:04:26 alan 12 11
c modify all SccsId strings
e
s 00001/00066/00147
d D 1.11 86/08/01 14:18:01 alan 11 10
c 1.  Remove some lint caused by the addition of extra arguments on 
c     error function.  It has been reduced to a  mininium but is still
c     there.
c 2.  Make totals for disk and tapes static instead of dynamic.
c 3.  Merged stack.c code into uba.c and mba.c.  There were some pointers
c     that needed to be changed.
c 
c TODO: There is still a bug in multiple session replay that causes the
c first disk I/O data to be negitive numbers.  Wierd...
c 
e
s 00023/00013/00190
d D 1.10 86/07/11 19:32:14 alan 10 9
c Dust off LOTS of lint...
c 
e
s 00007/00051/00196
d D 1.9 86/07/01 13:21:18 alan 9 8
c move out delta_fork(), delta_tty() and init_statics().
e
s 00017/00000/00230
d D 1.8 86/06/30 13:11:41 alan 8 7
c Fix a bug in replay that was causing the fork and tty data to get
c hosed over when replaying the 2nd+ session.  I added a function
c init_statics() to delta.c and called it from replay.c
c 
e
s 00004/00004/00226
d D 1.7 86/05/28 08:35:24 alan 7 6
c make consistant use of mon_index
e
s 00019/00022/00211
d D 1.6 86/05/27 10:36:44 alan 6 5
c It now allocates space for cpu and tape total structures.  It uses the
c CPU structures.  Since there isn't any tape data, it doesn't use those.
c 
e
s 00014/00014/00219
d D 1.5 86/05/26 15:53:37 alan 5 4
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00086/00003/00147
d D 1.4 86/05/23 19:53:15 alan 4 3
c Added code for doing totals as arrays of structures.  These structures
c are allocated once we know how many we need.  I still need to turn
c "prev" of the CPU time info, into one of these.
c 
e
s 00028/00000/00122
d D 1.3 86/05/22 09:16:10 alan 3 2
c moved cpu_time() from cpu.c
e
s 00061/00004/00061
d D 1.2 86/05/18 18:11:30 alan 2 1
c added code from stack.c and netif.c
e
s 00065/00000/00000
d D 1.1 86/05/18 17:44:05 alan 1 0
c date and time created 86/05/18 17:44:05 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - The functions here calculate the differences between
D 9
 *		the current copy of a data structure and the previous
 *		copy.
E 9
I 9
 *	the current copy of a data structure and the previous copy.
E 9
 *
D 9
 *	All the delta_() functions should go here eventually?
E 9
I 9
 *	The delta_ functions for tty's and fork's have moved into
 *	os.c.  The others will stay here, because pointers to "total"
 *	structure and their allocation functions need to be in
 *	one place.
E 9
 */
#ifndef	lint
D 12
static	char	SccsId[] = "%W% %G%" ;
E 12
I 12
D 13
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 13
I 13
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 13
E 12
#endif

I 23
/*
 * Modification History
D 26
 * 
E 26
I 26
 *
E 26
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 24
 *
 * Feb. 17, 1989 -- arr
 *
 *	Added mon_soft and mon_tlbpid to delta_cpu().
I 26
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
D 27
 * 
E 27
I 27
 *
 * Aug. 22, 1990 -- arr
 *
 *	Added delta_syscall_intr() that helps fix a problem for
 *	magnify_cpu() where the number of system calls and device
 *	interrupts is too high. 
E 27
E 26
E 24
 */

E 23
#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
I 15
D 16
#include <sys/devio.h>
E 16
I 16
D 18
#ifdef	V20
#	include <sys/devio.h>
#endif
E 18
E 16
E 15
#include <sys/socket.h>
#include <sys/dk.h>
I 15
#include <sys/param.h>
#include <sys/dir.h>
I 26

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 26
#include <sys/user.h>
E 15
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

I 18
D 20
#ifdef	V20
#	include <sys/devio.h>
#endif

E 20
E 18
D 21
#include "extern.h"
E 21
D 4
#include "monitor.h"
E 4
D 23
#include "record.h"
E 23
I 21
#include "monitor.h"
I 23
#include "include.h"
E 23
E 21
I 4
#include "options.h"
I 21
#include "extern.h"
E 21
E 4

I 13
/*
 *	Module name for error functions.
 */
static	char	*module = "delta" ;

I 14
/*
 *	Functions that don't return (int).
 */
void	free() ;

E 14
E 13
I 10
char	*calloc() ;

E 10
I 4
/*
 *	Define the structures and other convient names of the various
 *	total structures.
 */
D 11
typedef struct	tot_disk {
	int	t_xfer,
		t_seek,
		t_wds,
		t_time ;
} T_DISK ;

E 11
typedef	struct	tot_netif {
I 18
	int	t_ticks ;		/* clock ticks since last sample */
E 18
	int	t_ipackets,
		t_opackets,
		t_ierrors,
		t_oerrors,
		t_collisions ;
} T_NETIF ;

D 6
typedef	struct	tot_tape {
	int	t_xfer,
		t_wds,
		t_time ;
} T_TAPE ;

E 6
typedef	struct	tot_cpu {
I 19
	int	t_ticks ;		/* clock ticks since last sample */
E 19
D 14
	int	t_states[CPUSTATES] ;
I 11
	int	t_swtch ;
E 14
I 14
	int	t_states[CPUSTATES],
		t_swtch,
		t_trap,
		t_syscall,
		t_intr,
D 24
		t_pdma ;
E 24
I 24
		t_pdma,
		t_tlbpid,
		t_soft ;
E 24
E 14
E 11
} T_CPU ;

I 5
#define	TOT$S_CPU	(sizeof(T_CPU))
E 5
D 11
#define	TOT$S_DISK	(sizeof(T_DISK))
E 11
D 5
#define	TOT$S_NETIF	(sizeof(T_NETIF))
E 5
D 6
#define	TOT$S_TAPE	(sizeof(T_TAPE))
E 6
D 5
#define	TOT$S_CPU	(sizeof(T_CPU))
E 5
I 5
#define	TOT$S_NETIF	(sizeof(T_NETIF))
E 5

I 17
D 18
static	netif_ticks = 0 ;		/* clock ticks since previous sample */
E 18
E 17
E 4
D 9
static	old_ttyin = 0, old_ttyout = 0 ;
static	old_fork = 0, old_vfork = 0 ;

E 9
I 4
D 6
static	struct tot_netif *t_netif = 0 ;
E 6
I 6
static	struct tot_cpu *t_cpu = 0 ;
E 6
D 11
static	struct tot_disk *t_disk = 0 ;
static	struct tot_disk *t_tape = 0 ;
E 11
I 6
static	struct tot_netif *t_netif = 0 ;
E 6

I 8
D 9
/*
 *	Calculate the change in the interesting fork stats.
 */
E 8
E 4
delta_fork(p)
register struct mon_fork *p ;
{
	register t ;

D 2
	t = p->mon_p->cntfork ; 
	    p->mon_p->cntfork -= old_fork ;
E 2
I 2
	t = p->mon_fork.cntfork ; 
	    p->mon_fork.cntfork -= old_fork ;
E 2
	    old_fork = t ;

D 2
	t = p->mon_p->cntvfork ; 
	    p->mon_p->cntvfork -= old_vfork ;
E 2
I 2
	t = p->mon_fork.cntvfork ; 
	    p->mon_fork.cntvfork -= old_vfork ;
E 2
	    old_vfork = t ;
}

I 8
/*
 *	Initialize whatever static counters need to be initialized.
 *
 *	Currently there is only fork and tty.  I may add page later.
 */
init_statics(op)
{
	old_fork = old_vfork = 0 ;
	old_ttyin = old_ttyout = 0 ;
}

/*
 *	Calculate the change in the tty stats.
 */
E 8
delta_tty(p)
register struct mon_tty *p ;
{
	register t ;

	t = p->mon_ttyin; 
	    p->mon_ttyin -= old_ttyin ; 
	    old_ttyin = t ;

	t = p->mon_ttyout ; 
	    p->mon_ttyout -= old_ttyout ; 
	    old_ttyout = t ;
I 2
}

E 9
D 11
delta_disk(dp)
register struct mon_disk *dp ;
{
	register tmp ;
	register struct tot_disk *tp ;

D 4
	tp = dp->mon_total ;
E 4
I 4
D 7
	tp = t_disk + dp->mon_dk ;
E 7
I 7
	tp = t_disk + dp->mon_index ;
E 7
E 4

	tmp = dp->mon_xfer ;
	      dp->mon_xfer -= tp->t_xfer ;
	      tp->t_xfer = tmp ;

	tmp = dp->mon_seek ;
	      dp->mon_seek -= tp->t_seek ;
	      tp->t_seek = tmp ;

	tmp = dp->mon_wds ;
	      dp->mon_wds -= tp->t_wds ;
	      tp->t_wds = tmp ;

	tmp = dp->mon_time ;
	      dp->mon_time -= tp->t_time ;
	      tp->t_time = tmp ;
}

E 11
I 10
/*
D 11
 *	Due to the severe lack of useful tape information this function
 *	doesn't do anything.  The body of the function is commented out
 *	to keep lint happy.
 */
/* ARGSUSED */
E 10
I 4
delta_tape(p)
D 10
register struct mon_tape *p ;
E 10
I 10
struct mon_tape *p ;
E 10
{
I 6
D 10
	register tmp ;
	register struct tot_disk *tp ;

D 7
	tp = t_disk + p->mon_tp ;
E 7
I 7
	tp = t_disk + p->mon_index ;
E 10
I 10
/*
 *	register tmp ;
 *	register struct tot_disk *tp ;
 *
 *	tp = t_disk + p->mon_index ;
 */
E 10
E 7
E 6
}

E 4
/*
E 11
 *	How much did the network counters change...
I 17
D 18
 *
 *	The check on index assumes that index will be 0 the first
 *	time that delta_netif is called.  The functions that call
 *	delta_netif follow this rule.
E 18
E 17
 */
D 17
delta_netif(p)
register struct mon_netif *p ;
E 17
I 17
double	delta_netif(index, ticks)
register index, ticks ;
E 17
{
D 17
	register struct tot_netif *tp ;
E 17
	register tmp ;
I 17
D 18
	static	 double	 etime ;
E 18
I 18
	double	 etime ;
E 18
E 17

D 4
	tp = p->mon_total ;
E 4
I 4
D 7
	tp = t_netif + p->mon_if ;
E 7
I 7
D 17
	tp = t_netif + p->mon_index ;
E 17
I 17
D 18
	if( index == 0 ) {
		etime = (double)(ticks - netif_ticks)/first.mon_hz ;
		netif_ticks = ticks ;
	}
E 18
I 18
	etime = (double)(ticks - t_netif[index].t_ticks)/first.mon_hz ;
	t_netif[index].t_ticks = ticks ;
E 18
E 17
E 7
E 4

D 17
	tmp = p->mon_collisions ;
	      p->mon_collisions -= tp->t_collisions ;
	      tp->t_collisions = tmp ;
E 17
I 17
	tmp = netif[index].mon_collisions ;
	      netif[index].mon_collisions -= t_netif[index].t_collisions ;
	      t_netif[index].t_collisions = tmp ;
E 17

D 17
	tmp = p->mon_ipackets ;
	      p->mon_ipackets -= tp->t_ipackets ;
	      tp->t_ipackets = tmp ;
E 17
I 17
	tmp = netif[index].mon_ipackets ;
	      netif[index].mon_ipackets -= t_netif[index].t_ipackets ;
	      t_netif[index].t_ipackets = tmp ;
E 17

D 17
	tmp = p->mon_opackets ;
	      p->mon_opackets -= tp->t_opackets ;
	      tp->t_opackets = tmp ;
E 17
I 17
	tmp = netif[index].mon_opackets ;
	      netif[index].mon_opackets -= t_netif[index].t_opackets ;
	      t_netif[index].t_opackets = tmp ;
E 17

D 17
	tmp = p->mon_ierrors ;
	      p->mon_ierrors -= tp->t_ierrors ;
	      tp->t_ierrors = tmp ;
E 17
I 17
	tmp = netif[index].mon_ierrors ;
	      netif[index].mon_ierrors -= t_netif[index].t_ierrors ;
	      t_netif[index].t_ierrors = tmp ;
E 17

D 17
	tmp = p->mon_oerrors ;
	      p->mon_oerrors -= tp->t_oerrors ;
	      tp->t_oerrors = tmp ;
E 17
I 17
	tmp = netif[index].mon_oerrors ;
	      netif[index].mon_oerrors -= t_netif[index].t_oerrors ;
	      t_netif[index].t_oerrors = tmp ;

	return etime ;
E 17
E 2
}
I 3

D 6
#define	MAX_CPUS	(64)

static	long	prev[MAX_CPUS][CPUSTATES] ;

E 6
/*
 *	Calculate the total elapsed cpu time.
I 9
 *
D 14
 *	For V2.0 this may have to calculate the change in context switches.
E 14
I 14
 *	For V2.0 this does calculate the change in context switches.
E 14
E 9
 */
D 5
double	cpu_time(sp)
struct mon_state *sp ;
E 5
I 5
D 14
double	cpu_time(p)
E 14
I 14
D 19
double	delta_cpu(p)
E 14
struct mon_cpu *p ;
E 19
I 19
double	delta_cpu(index, ticks, dp)
int	index, ticks ;
double	*dp ;
E 19
E 5
{
I 17
D 19
	register index = p->mon_index ;
E 17
D 6
	register etime = 0, tmp, i, n ;
E 6
I 6
	register etime = 0, tmp, i ;
E 19
I 19
	register i, tmp, total = 0 ;
	double	 etime ;
E 19
D 17
	register T_CPU *tp ;
E 17
E 6

I 19
	etime = (double)(ticks - t_cpu[index].t_ticks) / first.mon_hz ;
	t_cpu[index].t_ticks = ticks ;

E 19
D 5
	n = sp->mon_cpu ;
E 5
I 5
D 6
	n = p->mon_cpu ;
E 6
I 6
D 7
	tp = t_cpu + p->mon_cpu ;
E 7
I 7
D 17
	tp = t_cpu + p->mon_index ;
E 7
E 6
E 5

E 17
	for(i = 0; i < CPUSTATES; i++) {
D 5
		tmp = sp->mon_time[i] ;
		sp->mon_time[i] -= prev[n][i] ;
E 5
I 5
D 17
		tmp = p->mon_time[i] ;
D 6
		p->mon_time[i] -= prev[n][i] ;
E 5
		prev[n][i] = tmp ;
E 6
I 6
		p->mon_time[i] -= tp->t_states[i] ;
		tp->t_states[i] = tmp ;
E 17
I 17
		tmp = cpu[index].mon_time[i] ;
		      cpu[index].mon_time[i] -= t_cpu[index].t_states[i] ;
		      t_cpu[index].t_states[i] = tmp ;
E 17
E 6

D 5
		etime += sp->mon_time[i] ;
E 5
I 5
D 17
		etime += p->mon_time[i] ;
E 17
I 17
D 19
		etime += cpu[index].mon_time[i] ;
E 19
I 19
		total += cpu[index].mon_time[i] ;
E 19
E 17
E 5
	}
I 14

I 19
D 25
	*dp = (double)total ;
E 25
I 25
	if( total == 0 )
		*dp = 1.0 ;
	else
		*dp = (double)total ;
E 25

E 19
D 17
	tmp = p->mon_swtch ;
	p->mon_swtch -= tp->t_swtch ;
	tp->t_swtch = tmp ;
E 17
I 17
	tmp = cpu[index].mon_swtch ;
	      cpu[index].mon_swtch -= t_cpu[index].t_swtch ;
	      t_cpu[index].t_swtch = tmp ;
E 17

D 17
	tmp = p->mon_trap ;
	p->mon_trap -= tp->t_trap ;
	tp->t_trap = tmp ;
E 17
I 17
	tmp = cpu[index].mon_trap ;
	      cpu[index].mon_trap -= t_cpu[index].t_trap ;
	      t_cpu[index].t_trap = tmp ;
E 17

D 17
	tmp = p->mon_syscall ;
	p->mon_syscall -= tp->t_syscall ;
	tp->t_syscall = tmp ;
E 17
I 17
	tmp = cpu[index].mon_syscall ;
	      cpu[index].mon_syscall -= t_cpu[index].t_syscall ;
	      t_cpu[index].t_syscall = tmp ;
E 17

D 17
	tmp = p->mon_intr ;
	p->mon_intr -= tp->t_intr ;
	tp->t_intr = tmp ;
E 17
I 17
	tmp = cpu[index].mon_intr ;
	      cpu[index].mon_intr -= t_cpu[index].t_intr ;
	      t_cpu[index].t_intr = tmp ;
E 17

D 17
	tmp = p->mon_pdma ;
	p->mon_pdma -= tp->t_pdma ;
	tp->t_pdma = tmp ;
E 17
I 17
	tmp = cpu[index].mon_pdma ;
	      cpu[index].mon_pdma -= t_cpu[index].t_pdma ;
	      t_cpu[index].t_pdma = tmp ;
I 24

	tmp = cpu[index].mon_tlbpid ;
	      cpu[index].mon_tlbpid -= t_cpu[index].t_tlbpid ;
	      t_cpu[index].t_tlbpid = tmp ;

	tmp = cpu[index].mon_soft ;
	      cpu[index].mon_soft -= t_cpu[index].t_soft ;
	      t_cpu[index].t_soft = tmp ;
E 24
E 17
E 14

D 19
	if( etime == 0 )
		etime = 1 ;

	return (double) etime ;
E 19
I 19
	return etime ;
E 19
I 4
}

/*
I 27
 *	Local data for delta_syscall_intr().
 */
static	int	prev_syscall = 0,
		prev_intr = 0 ;

/*
 *	This keeps track of the change in the total number
 *	of system calls and device interrupts.  We don't
 *	what the values are in screen(), so we'll check for
 *	NULL pointers.
 */
void	delta_syscall_intr(sp, ip)
int	*sp, *ip ;
{
	register i, total_syscall, total_intr, tmp ;

	total_syscall = 0 ;
	total_intr = 0 ;

	for(i = 0; i < first.mon_cpu; i++) {
		if((cpu[i].mon_flag & MON$M_VALID) == 0 )
			continue ;

		total_syscall += cpu[i].mon_syscall ;
		total_intr    += cpu[i].mon_intr ;
	}

	tmp = total_syscall ;
	      total_syscall -= prev_syscall ;
	      prev_syscall = tmp ;

	tmp = total_intr ;
	      total_intr -= prev_intr ;
	      prev_intr = tmp ;

	if( sp )
		*sp = total_syscall ;

	if( ip )
		*ip = total_intr ;
}

/*
E 27
 *	Allocate space for the various total structures.
 */
allocate_totals(op)
OPTION	*op ;
{
I 5
D 27
	if( op->opt_cpu )
E 27
I 27
	if( op->opt_cpu ) {
		prev_syscall = 0 ;
		prev_intr = 0 ;

E 27
D 6
		;
E 6
I 6
		if((t_cpu = (T_CPU *)calloc(n_cpu, TOT$S_CPU)) == NULL )
D 10
			fatal("monitor: can't calloc for cpu totals: %s.\n");
E 10
I 10
D 13
			fatal("monitor: delta: no space for cpu totals: %s.\n");
E 13
I 13
D 22
			fatal("no space for cpu totals: %s.\n", module);
E 22
I 22
			fatal("No space for cpu totals: %s.\n", module);
I 27
	}
E 27
E 22
E 13
E 10
E 6

E 5
D 11
	if( op->opt_disk )
		if((t_disk = (T_DISK *)calloc(n_disk, TOT$S_DISK)) == NULL )
D 6
			fatal("monitor: can't get space for disk total's: %s");
E 6
I 6
D 10
			fatal("monitor: can't calloc for disk totals: %s.\n");
E 10
I 10
			fatal("monitor: delta: no space for disk totals: %s.\n");
E 10
E 6

	if( op->opt_tape )
D 6
		;
E 6
I 6
		if((t_tape = (T_DISK *)calloc(n_tape, TOT$S_DISK)) == NULL )
D 10
			fatal("monitor: can't calloc for tape totals: %s.\n");
E 10
I 10
			fatal("monitor: delta: no space for tape totals: %s.\n");
E 10
E 6

E 11
D 5
	if( op->opt_state )
		;

E 5
	if( op->opt_netif )
		if((t_netif = (T_NETIF *)calloc(n_netif, TOT$S_NETIF)) == NULL )
D 6
			fatal("monitor: can't get space for netif total's: %s");
E 6
I 6
D 10
			fatal("monitor: can't calloc for netif total's: %s.\n");
E 10
I 10
D 13
			fatal("monitor: delta: no space for netif total's: %s.\n");
E 13
I 13
D 22
			fatal("no space for netif total's: %s.\n", module);
E 22
I 22
			fatal("No space for netif totals: %s.\n", module);
E 22
E 13
E 10
E 6
}

/*
 *	Free the space allocated in allocate_totals().
 */
free_totals(op)
OPTION	*op ;
{
I 5
	if( op->opt_cpu )
D 6
		;
E 6
I 6
D 10
		free(t_cpu);
E 10
I 10
		free((char *)t_cpu);
E 10
E 6
D 11

E 5
	if( op->opt_disk )
D 10
		free(t_disk);
E 10
I 10
		free((char *)t_disk);
E 10

	if( op->opt_tape )
D 5
		;

	if( op->opt_state )
E 5
D 6
		;
E 6
I 6
D 10
		free(t_tape);
E 10
I 10
		free((char *)t_tape);
E 11
E 10
E 6

	if( op->opt_netif )
D 10
		free(t_netif);
E 10
I 10
		free((char *)t_netif);
E 10
E 4
}
E 3
E 1
