h19157
s 00010/00027/00587
d D 1.60 90/08/22 23:16:41 alan 60 59
c added fix for syscall and intr problem in magnify_cpu()
e
s 00019/00017/00595
d D 1.59 90/08/21 22:43:29 alan 59 58
c dust off lint
e
s 00002/00004/00610
d D 1.58 90/05/17 14:18:46 alan 58 57
c fixed use of MON_CPU typedef
e
s 00021/00012/00593
d D 1.57 90/03/29 16:16:56 alan 57 56
c The hack to fix the DECmumble include file problem.
e
s 00048/00006/00557
d D 1.56 89/12/27 19:21:53 alan 56 55
c fixed formatting for additional V4.0 information
e
s 00008/00008/00555
d D 1.55 89/12/27 16:11:04 alan 55 54
c Clean up architecture and version differences
e
s 00153/00066/00410
d D 1.54 89/12/25 15:35:29 alan 54 53
c Merge in V4.0 changes to base code
e
s 00008/00000/00468
d D 1.53 89/05/13 16:38:54 alan 53 52
c fixed the way context switches on the PMAX were collected
e
s 00001/00001/00467
d D 1.52 89/02/25 09:57:11 alan 52 51
c editorial change to rec_ elements
e
s 00024/00014/00444
d D 1.51 89/02/17 22:07:45 alan 51 50
c added tlbpid and soft to display
e
s 00003/00001/00455
d D 1.50 89/02/16 20:54:52 alan 50 49
c dust off some lint
e
s 00040/00000/00416
d D 1.49 89/02/16 20:21:43 alan 49 48
c added mon_name to CPU record and moved f_cpu()
e
s 00006/00002/00410
d D 1.48 89/02/15 19:29:22 alan 48 47
c properly set mon_flag in all records
e
s 00049/00002/00363
d D 1.47 89/01/04 10:55:02 alan 47 46
c V1.1 changes for MIPS support.  This is a check-point of the support
e
s 00042/00076/00323
d D 1.46 88/06/28 00:13:39 alan 46 45
c seperate the code and data used to determine the CPU name
e
s 00005/00001/00394
d D 1.45 88/06/27 18:13:54 alan 45 44
c changed include of monitor.h and record.h
e
s 00010/00006/00385
d D 1.44 88/06/27 17:35:14 alan 44 43
c Moved OS dependent strings into string_data.c
c 
e
s 00008/00000/00383
d D 1.43 88/03/16 13:15:47 alan 43 42
c added CVAX cpu type
e
s 00001/00001/00382
d D 1.42 87/11/18 16:41:03 alan 42 41
c V0.99 -> T1.0-1
e
s 00008/00000/00375
d D 1.41 87/09/14 18:56:23 alan 41 40
c see V0.96 in version.c for details
e
s 00001/00001/00374
d D 1.40 87/08/12 15:26:57 alan 40 39
c error message clean up - V0.95
e
s 00006/00001/00369
d D 1.39 87/08/10 21:27:41 alan 39 38
c See commentary on V0.92 in version.c
e
s 00026/00021/00344
d D 1.38 87/05/20 17:16:07 alan 38 37
c changed all curses calls to use w... versions
e
s 00036/00021/00329
d D 1.37 87/04/17 15:46:40 alan 37 36
c Changed all calls to curses to use the 'w' version of the function.  Currently
c all of these write to the 'stdscr'.  This will changed in the next delta.
c 
e
s 00040/00136/00310
d D 1.36 87/04/03 13:15:24 alan 36 35
c Removed V20 dependencies, generally cleaned things up and rearranged
c include files that they compile under VAXC.  For some reason they
c don't run.
c 
e
s 00000/00005/00446
d D 1.35 87/03/03 15:42:11 alan 35 34
c see the commentary for V0.83 in version.c
e
s 00000/00001/00451
d D 1.34 87/02/05 16:26:58 alan 34 33
c See comment on V0.81 in version.c.
c 
e
s 00002/00002/00450
d D 1.33 87/01/30 16:09:01 alan 33 32
c See commenary on V0.76 in version.c
e
s 00004/00005/00448
d D 1.32 87/01/30 13:04:12 alan 32 31
c see commentary on V0.75 in version.c
e
s 00142/00013/00311
d D 1.31 87/01/21 16:34:49 alan 31 30
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00001/00001/00323
d D 1.30 86/12/24 23:32:09 alan 30 29
c See commentary on V0.63 in version.c.  Cpu.c may not have changed.
c 
e
s 00001/00000/00323
d D 1.29 86/12/12 15:37:23 alan 29 28
c see commentary on V0.61
e
s 00041/00035/00282
d D 1.28 86/12/07 22:22:24 alan 28 27
c See V0.57 in version.c
e
s 00021/00010/00296
d D 1.27 86/11/18 12:41:20 alan 27 26
c See commentary on V0.55 in version.c
c 
e
s 00014/00006/00292
d D 1.26 86/10/30 13:00:01 alan 26 25
c 1.  Modify getsid() to build something which looks like an SID.
c 2.  Modify str_cpuid() to understand what was built by getsid().
c 
e
s 00001/00001/00297
d D 1.25 86/08/26 18:03:50 alan 25 24
c modify all SccsId strings
e
s 00002/00001/00296
d D 1.24 86/08/04 15:59:14 alan 24 23
c move cpudata.h into local directory
e
s 00001/00004/00296
d D 1.23 86/07/29 13:51:43 alan 23 22
c turn cpu, disk and tape into arrays
e
s 00070/00097/00230
d D 1.22 86/07/27 14:09:16 alan 22 21
c Convert CPU's to array's instead of linked lists.  I also cleaned up some
c lint in the process.  Disks and tapes will be next...
c 
e
s 00029/00005/00298
d D 1.21 86/07/25 14:51:20 alan 21 20
c Fixed bug that was causeing magnify function to walk off the end of the
c arrays in replay-mode.
c 
c This is bug is another example of why I should rewrite the disk, tape, netif
c and cpu lists to be array's everywhere.  For disk and tape I can statically
c allocate space for the data structures, for cpu's I can dynamically allocate
c based on the size of _cpudata and for netif's I can make two passes on the
c internal list, one quick pass to size the list and the other to fill the
c static info.
c 
e
s 00015/00014/00288
d D 1.20 86/07/11 19:27:19 alan 20 19
c Dust off LOTS of lint...
c 
e
s 00003/00003/00299
d D 1.19 86/07/11 13:18:23 alan 19 18
c modify error messages
e
s 00001/00001/00301
d D 1.18 86/07/01 17:12:42 alan 18 17
c use LINES to determine end of screen instead of COLS
e
s 00069/00000/00233
d D 1.17 86/07/01 16:29:01 alan 17 16
c Added prototype function for magnify and later filled out.
c 
e
s 00005/00015/00228
d D 1.16 86/06/29 15:47:44 alan 16 15
c Changed the handleing of "word=value" lists.
c 
e
s 00006/00000/00237
d D 1.15 86/06/23 13:25:30 alan 15 14
c Fix bug that caused "cpu=1" to dump core
c 
e
s 00055/00000/00182
d D 1.14 86/06/14 18:04:55 alan 14 13
c More first pass of adding multi-processor support.  I moved the code
c for collecting live CPU data from live.c to cpu.c.  I also added
c a check on "maxcpu" to determine if this is a pre-V1.2 system or V2.0
c system.
c 
e
s 00131/00024/00051
d D 1.13 86/06/13 16:30:19 alan 13 12
c complete first pass of adding multiple CPU support
e
s 00000/00001/00075
d D 1.12 86/06/12 14:19:56 alan 12 11
c Continued first pass of adding multi-processor code.
c 1.  Removed references to mon_rate.
c 
e
s 00001/00000/00075
d D 1.11 86/05/30 11:25:26 alan 11 10
c Added initial value of "mon_flag" to all the data records.  This will be
c used to dynamically add and remove data from a display.
c 
e
s 00001/00001/00074
d D 1.10 86/05/28 18:11:47 alan 10 9
c turned read in getsid() into readk()
e
s 00020/00013/00055
d D 1.9 86/05/28 15:57:28 alan 9 8
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00016/00017/00052
d D 1.8 86/05/26 15:53:26 alan 8 7
c I combined the mon_state and mon_cpu structures into one (mon_cpu) which
c is supposed to be all the system data that is kept on a per CPU basis.
c See record.h for more info.  Most of the changes that occured in the files
c were a result of removing references to mon_state and opt_state.
c 
c Other changes unrelated to this:
c 1.  Changed NM_PAGE to NM_RATE.  This was in three files, monitor.h and
c     two of the others.
c 2.  I added loop for the collecting the "tape" data to save.c.  This is
c     a very short loop since there is no tape data in the system.
c 
e
s 00010/00005/00059
d D 1.7 86/05/26 14:17:32 alan 7 6
c Get the cputype from a function called getsid().  Getsid() calls makes
c the same call as before.
c 
e
s 00000/00028/00064
d D 1.6 86/05/22 09:15:35 alan 6 5
c Moved cpu_time() to delta.c
c 
e
s 00021/00005/00071
d D 1.5 86/05/12 20:23:53 alan 5 4
c 1.  Fleshed out cpu_time() to calculate deltas and total.
c 2.  Fixed bug that it was not giving the total as sum of the deltas.
c     This may have been because a register was retaining its value.
c 
e
s 00012/00000/00064
d D 1.4 86/05/10 15:34:01 alan 4 3
c added minimal body of cpu_time()
e
s 00002/00000/00062
d D 1.3 86/05/08 18:00:08 alan 3 2
c initialized mon_type and mon_length
e
s 00044/00003/00018
d D 1.2 86/05/07 17:01:37 alan 2 1
c add code give the function body
e
s 00021/00000/00000
d D 1.1 86/05/07 10:42:54 alan 1 0
c date and time created 86/05/07 10:42:54 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 22
 *	%M% - Figure out how many CPU's there are and link together
D 8
 *		a list of CPU state structures.  Not knowing how
E 8
I 8
D 13
 *		a list of CPU cpu structures.  Not knowing how
E 8
 *		UEG plans to impliment the 8300 and 8800, I'll
 *		just do the code for one CPU here.
E 13
I 13
 *		a list of mon_cpu structures.  
E 22
I 22
D 27
 *	%M% - Figure out how many CPU's there are and allocate an array
 *		large enough for all of them.
E 27
I 27
 *	%M% - Figure out how many CPU's there are and allocate 
 *	an array large enough for all of them.
E 27
E 22
 *
D 27
 *	I now have information about multi-processor systems.
E 27
I 27
D 46
 *	I now have information about multi-processor systems.  Since
 *	I don't have a V2.0 system to do testing this is a best
 *	guess.
E 27
 *
E 46
D 27
 *	If the array _cpudata exists this is the per-CPU structure.
D 22
 *	If _maxcpu or _activeacpu is greater than 1 then we are on
 *	multi-processor system.
E 22
 *
 *	The way that I will do it:
 *
E 27
D 54
 *	If _cpudata exists in the kernel then we are a n-processor
 *	system (n may be 1).  At any given time we can't assume that
 *	all processors will be active.   Data will be collected for
 *	every processor configured.  Only the data for active processors
 *	will be used.
E 54
I 54
D 60
 *	I only thought this complicated when we added multi-
E 60
I 60
 *	I only thought this was complicated when we added multi-
E 60
 *	processor support, but SMP is a real bear.
E 54
D 46
 *
 *	If _cpudata doesn't exist then we are on an pre V2.0 system and
 *	one structure will be setup quickly.
 *
 *	For later reference: If we are on a pre V2.0 system then maxcpu
 *	will be set to 0.  Otherwise it will be the number of CPU's
 *	configured.
E 46
E 13
 */
#ifndef	lint
D 25
static	char	SccsId[] = "%W% %G%" ;
E 25
I 25
D 26
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 26
I 26
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 26
E 25
#endif

I 44
/*
 * Modification History
 *
I 54
D 57
 * Dec. 25, 1989 -- arr
E 57
I 57
 * 27-June-1988 - arr
E 57
 *
D 57
 *	Change the way getsid works and is used.
E 57
I 57
 *	Moved the string data for bits into a new source file
 *	string_data.c.
E 57
 *
I 57
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 *	Use a data table instead of switch table to determine the
 *	cpu name.
 *
E 57
 * Beginning Nov. 16, 1989 -- arr
 *
 *	Fix support for SMP.  To complicate matters the SMP
 *	support keeps changing, but this varient should be
 *	stable and still work on pre-V4.0 with #ifdef's.
 *
I 57
 * Dec. 25, 1989 -- arr
 *
 *	Change the way getsid works and is used.
 *
E 57
 * Feb. 16, 1989 -- arr
 *
 *	Added mon_name to CPU record and moved f_cpu() from functions.c
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
 *
E 54
D 57
 * 27-June-1988 - arr
E 57
I 57
 * Mar. 26, 1990 -- arr
E 57
 *
D 57
 *	Moved the string data for bits into a new source file
 *	string_data.c.
E 57
I 57
 *	Added hack to work-around DECmumble include file problem.
E 57
I 45
 *
I 60
 * Aug. 22, 1990 -- arr
 *
 *	Fix a problem in magnify_cpu() where the number of system
 *	calls and interrupts is too high.
E 60
D 57
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 46
 *
 *	Use a data table instead of switch table to determine the
 *	cpu name.
I 48
 *
E 57
D 54
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
I 49
 *
 * Feb. 16, 1989 -- arr
 *
 *	Added mon_name to CPU record and moved f_cpu() from functions.c
E 54
E 49
E 48
E 46
E 45
 */

E 44
D 2
extern	int	n_cpu ;
E 2
I 2
#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 17
#include <curses.h>
E 17
E 2

I 2
#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
I 31
D 32
#include <sys/devio.h>
E 32
E 31
#include <sys/dk.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
D 26

E 26
I 13
#include <sys/param.h>
I 31
#include <sys/dir.h>
I 57

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 57
#include <sys/user.h>
E 31
#include <sys/time.h>
#include <sys/proc.h>
I 54

D 55
#ifdef	V4_ULTRIX
#	include <sys/smp_lock.h>
#endif

E 55
E 54
I 36
#include <sys/cpudata.h>
E 36
D 24
#include <sys/cpudata.h>
E 24

E 13
D 7
#include <machine/cpu.h>

E 7
#include <net/if.h>
#include <netinet/in.h>

I 26
D 47
#include <machine/cpu.h>
E 47
I 47
#ifdef	vax
#	include <machine/cpu.h>
I 55
#elif	mips
#	include <machine/cpuconf.h>
E 55
#endif
D 55
#ifdef	mips
#	include <machine/hwconf.h>
#endif
E 55
E 47

I 31
D 36
/*
 *	If VAX_8800 isn't defined by <machine/cpu.h> we'll define it.
 */
#ifndef	VAX_8800
#	define	VAX_8800	(6)
#endif

/*
 *	Make the gross assumption that if SID_EXT is defined
 *	the various values for subtype will also be defined.
 */
#ifndef SID_EXT
#	define	ST_MVAXII	(1)
#	define	ST_VAXSTAR	(4)
#	define	ST_8200		(5)
#	define	ST_8300		(6)
#	define	ST_8400		(7)
#	define	ST_8500		(8)
#	define	ST_8550		(9)
#	define	ST_8700		(0xa)
#	define	ST_8800		(0xb)
#endif

E 31
I 28
#ifdef	V20
#	include <sys/cpudata.h>
I 32
D 34
#	include <sys/devio.h>
E 34
E 32
#else
#	include "cpudata.h"
#endif

E 28
E 26
#include "extern.h"
#include "monitor.h"
E 36
D 45
#include "record.h"
E 45
I 36
#include "monitor.h"
I 45
#include "include.h"
E 45
E 36
I 17
#include "options.h"
I 36
#include "extern.h"
E 36
I 24

D 28
#include "cpudata.h"
E 28
E 24
E 17
D 46

E 46
I 27
/*
I 54
 *	Aliases for CPudata structure names changed in V4.0.
 */
#ifdef	V4_ULTRIX
#	define	c_state		cpu_state
#	define	c_cptime	cpu_cptime
#	define	c_switch	cpu_switch
#endif

/*
 *	Set aside enough space for the array of CPU pointers.
 */
#ifndef	MAXCPU
#	define	MAXCPU	(DK_NDRIVE)
#endif
/*
E 54
 *	Module name for error functions.
 */
static	char	*module = "cpu" ;

E 27
D 8
static	struct mon_state *current_state = NULL ;
E 8
I 8
D 20
static	struct mon_cpu *current_cpu = NULL ;
E 20
I 20
D 22
char	*malloc(), *str_state() ;
E 22
I 22
D 28
char	*calloc(), *str_state() ;
E 28
I 28
/*
 *	Functions that don't return (int).
 */
char	*calloc(),
I 50
	*strncpy(),
E 50
D 31
	*str_state() ;
E 31
I 31
	*str_state(),
I 49
	*str_cpuid(),
E 49
	*str_generic() ;
E 31
E 28
E 22
E 20
E 8

I 60
void	delta_syscall_intr() ;

E 60
I 38
/*
 *	Default display.
 */
I 39
extern	int	lines ;			/* length of screen being used */
E 39
extern	WINDOW	*wp ;

E 38
I 22
D 58
typedef	struct mon_cpu MON_CPU ;

E 58
E 22
I 13
D 16
char	*p, *sprintf(), buf[BUFSIZ] ;

E 16
/*
 *	Determine what version of Ultrix we are on and set up the
 *	CPU list accordingly.
 */
E 13
E 2
D 54
cpus()
E 54
I 54
config_cpus()
E 54
D 2
{	
	n_cpu = 1 ;
E 2
I 2
{
I 22
D 36
	if( namelist[NM_MAXCPU].n_value )
		readk((long)namelist[NM_MAXCPU].n_value, (char *)&maxcpu,
			sizeof(maxcpu));
	else
		maxcpu = 1 ;		/* This will be reset later */

D 28
	if((cpu = (MON_CPU *)calloc((unsigned)maxcpu, sizeof(MON_CPU))) == NULL )
E 28
I 28
	if((cpu = (MON_CPU *)calloc((unsigned)maxcpu, MON$S_CPU)) == NULL )
E 28
D 27
		fatal("monitor: cpu: no space for mon_cpu: %s.\n");
E 27
I 27
		fatal("no space for mon_cpu: %s.\n", module);
E 27

E 22
D 9
	int	cpu_type ;
D 8
	struct	mon_state *sp ;
E 8
I 8
	struct	mon_cpu *p ;
E 9
I 9
D 13
	int	cpu_type, cmp() ;
	struct	mon_cpu *cp ;
	char	buf[BUFSIZ], *p, *sprintf() ;
E 13
I 13
	if( namelist[NM_CPUDATA].n_value == 0 )
		one_cpu() ;
	else
		many_cpus() ;
}
E 13
E 9
E 8

I 13
/*
D 22
 *	Local version of a system call to get the contents of the SID
 *	register.
 */
getsid()
{
	int	cpuid ;

D 20
	readk(namelist[NM_CPU].n_value, &cpuid, sizeof(cpuid)) ;
E 20
I 20
	readk((long)namelist[NM_CPU].n_value, (char *)&cpuid, sizeof(cpuid)) ;
E 20

	return cpuid ;
}

/*
E 22
 *	This is a pre V2.0 system.  Setup the list for 1 CPU.
 */
one_cpu()
{
D 16
	int	cmp() ;
E 16
I 16
D 20
	if( find_value(&cpu_list, "", n_cpu) == 0 )
E 20
I 20
D 22
	if( find_value(&cpu_list, "", (int)n_cpu) == 0 )
E 22
I 22
	if( find_value(&cpu_list, "", 0) == 0 )
E 22
E 20
		return ;
E 16

E 13
D 8
	n_cpu++ ;
E 8
I 8
D 9
	if((p = (struct mon_cpu *)malloc(MON$S_CPU)) == NULL )
E 9
I 9
D 16
	if( cpu_nel ) {
		p = sprintf(buf, "%d", n_cpu);
		if( !bsearch(&p, cpu_base, cpu_nel, KEY_SIZE, cmp))
			return ;
	}

E 16
D 13
	if((cp = (struct mon_cpu *)malloc(MON$S_CPU)) == NULL )
E 13
I 13
D 20
	if((cpu = (struct mon_cpu *)malloc(MON$S_CPU)) == NULL )
E 13
E 9
D 19
		fatal("monitor: can't allocate space for cpu: %s.\n");
E 19
I 19
		fatal("monitor: cpu: can't malloc space for cpu: %s.\n");
E 20
I 20
D 22
	if((cpu = (struct mon_cpu *)malloc((unsigned)MON$S_CPU)) == NULL )
		fatal("monitor: cpu: no space for mon_cpu: %s.\n");
E 20
E 19
E 8

E 22
D 7
	readk(namelist[NM_CPU].n_value, &cpu_type, sizeof(cpu_type));

E 7
D 8
	if((sp = (struct mon_state *)malloc(MON$S_STATE)) == NULL )
		fatal("monitor: can't allocate space for state: %s.\n");
E 8
I 8
D 9
	p->mon_type = MON$K_CPU ;
	p->mon_length = MON$S_CPU ;
	p->mon_cpuid = getsid() ;
	p->mon_cpu = n_cpu++ ;
	p->mon_next = NULL ;
	p->mon_where = (caddr_t)namelist[NM_STATES].n_value ;
	p->mon_rate = (caddr_t)namelist[NM_RATE].n_value ;
E 9
I 9
D 13
	cp->mon_type   = MON$K_CPU ;
I 11
	cp->mon_flag   = 1 ;
E 11
	cp->mon_length = MON$S_CPU ;
	cp->mon_cpuid  = getsid() ;
	cp->mon_index  = cp->mon_cpu = n_cpu++ ;
	cp->mon_next   = NULL ;
	cp->mon_where  = (caddr_t)namelist[NM_STATES].n_value ;
E 13
I 13
	n_cpu = 1 ;
E 13
D 12
	cp->mon_rate   = (caddr_t)namelist[NM_RATE].n_value ;
E 12
E 9
E 8

I 3
D 8
	sp->mon_type = MON$K_STATE ;
	sp->mon_length = MON$S_STATE ;
E 3
D 7
	sp->mon_cpuid = cpu_type ;
E 7
I 7
	sp->mon_cpuid = getsid() ;
E 7
	sp->mon_cpu = n_cpu ;
	sp->mon_next = NULL ;
	sp->mon_where = (long)namelist[NM_STATES].n_value ;

	if( state == NULL )
		state = current_state = sp ;
E 8
I 8
D 13
	if( cpu == NULL )
D 9
		cpu = current_cpu = p ;
E 9
I 9
		cpu = current_cpu = cp ;
E 9
E 8
	else {
D 8
		current_state->mon_next = sp ;
		current_state = sp ;
E 8
I 8
D 9
		current_cpu->mon_next = p ;
		current_cpu = p ;
E 9
I 9
		current_cpu->mon_next = cp ;
		current_cpu = cp ;
E 9
E 8
	}
E 13
I 13
D 31
	cpu->mon_type   = MON$K_CPU ;
	cpu->mon_flag   = 1 ;
	cpu->mon_length = MON$S_CPU ;
	cpu->mon_ident  = getsid() ;
I 17
	cpu->mon_state  = 1 ;
E 17
	cpu->mon_index  = cpu->mon_cpu = 0 ;
D 22
	cpu->mon_next   = NULL ;
E 22
	cpu->mon_where  = (caddr_t)namelist[NM_STATES].n_value ;
E 31
I 31
	cpu->mon_type    = MON$K_CPU ;
	cpu->mon_flag    = 1 ;
	cpu->mon_length  = MON$S_CPU ;
	cpu->mon_ident   = getsid() ;
	cpu->mon_state   = 1 ;
	cpu->mon_index   = cpu->mon_cpu = 0 ;
	cpu->mon_subtype = -1 ;
	cpu->mon_where   = (caddr_t)namelist[NM_STATES].n_value ;
E 31

	maxcpu = 0 ;
E 13
I 7
}

D 13
getsid()
E 13
I 13
/*
 *	We have determined that there is at least one CPU configured.
 *	The array _cpudata in the kernel has the information about
 *	each.  Collect all available data and setup the structures
 *	according to the user's wishes.
 */
many_cpus()
E 13
{
E 36
D 13
	int	cpuid ;
E 13
I 13
	register state, i ;
D 22
	register struct	mon_cpu *cp ;
E 22
I 22
D 36
	register struct	mon_cpu *cp = cpu ;
E 36
D 54
	register struct cpudata *array ;
	struct cpudata cpudata ;
E 54
I 54
D 59
	struct cpudata *array[MAXCPU], *cpuaddr, cpudata ;
E 59
I 59
	struct cpudata *array[MAXCPU], *cpuaddr, mon_cpudata ;
E 59
E 54
I 31
	int	subtype ;
I 54
	long	sid_addr ;
E 54
E 31
E 22
E 13

I 31
D 36
/*
 *	Get the CPU subtype.
 */
	readk((long)namelist[NM_CPU_SUBTYPE].n_value, (char *)&subtype,
		sizeof(subtype)) ;
E 36
I 36
D 54
	readk((long)namelist[NM_MAXCPU].n_value, (char *)&maxcpu, sizeof(maxcpu)) ;
E 54
I 54
	/*
	 *	Initialize the array of cpudata indexes.
	 */
	for(i = 0; i < MAXCPU; i++)
		array[i] = 0 ;
E 54
E 36

I 54
	/*
	 *	Arrange to use the right namelist entry for the
	 *	"sid".
	 */
#ifdef	vax
	sid_addr = (long)namelist[NM_CPU].n_value ;
#endif
#ifdef	mips
	sid_addr = (long)namelist[NM_CPU_SYSTYPE].n_value ;
#endif

	if( namelist[NM_MAXCPU].n_value )
		maxcpu = get_word((long)namelist[NM_MAXCPU].n_value) ;
	else
		maxcpu = MAXCPU ;

	if( maxcpu > MAXCPU ) {
		info("The CPU array isn't big enough for the number of CPUs in the system.\n", module) ;
		info("Some CPUs may be missing.\n", module) ;
		maxcpu = MAXCPU ;
	}

E 54
I 36
D 58
	if((cpu = (MON_CPU *)calloc((unsigned)maxcpu, MON$S_CPU)) == NULL )
E 58
I 58
	if((cpu = (struct mon_cpu *)calloc((unsigned)maxcpu, MON$S_CPU)) == NULL )
E 58
D 40
		fatal("no space for mon_cpu: %s.\n", module);
E 40
I 40
		fatal("Can't allocate space for CPU structures: %s.\n", module);
E 40

	/*
	 *	Get the CPU subtype.
	 */
	if( namelist[NM_CPU_SUBTYPE].n_value )
		readk((long)namelist[NM_CPU_SUBTYPE].n_value, (char *)&subtype,
			sizeof(subtype)) ;

E 36
E 31
D 10
	read(namelist[NM_CPU].n_value, &cpuid, sizeof(cpuid)) ;
E 10
I 10
D 13
	readk(namelist[NM_CPU].n_value, &cpuid, sizeof(cpuid)) ;
E 13
I 13
D 16
	int	cmp(), data_size, cpu_size ;
E 16
I 16
D 22
	int	data_size, cpu_size ;
E 16
	struct	cpudata *array ;
E 13
E 10

D 13
	return cpuid ;
E 13
I 13
D 20
	readk(namelist[NM_MAXCPU].n_value, &maxcpu, sizeof(maxcpu));
E 20
I 20
	readk((long)namelist[NM_MAXCPU].n_value, (char *)&maxcpu, sizeof(maxcpu));
E 20

	data_size = maxcpu * sizeof(struct cpudata) ;
	cpu_size  = maxcpu * sizeof(struct mon_cpu) ;

D 20
	if((array = (struct cpudata *)malloc(data_size)) == NULL )
D 19
		fatal("monitor: can't read cpudata: %s.\n");
E 19
I 19
		fatal("monitor: cpu: can't malloc space for _cpudata: %s.\n");
E 20
I 20
	if((array = (struct cpudata *)malloc((unsigned)data_size)) == NULL )
		fatal("monitor: cpu: no space for _cpudata: %s.\n");
E 20
E 19

D 20
	readk(namelist[NM_CPUDATA].n_value, array, data_size);
E 20
I 20
	readk((long)namelist[NM_CPUDATA].n_value, (char *)array, data_size);
E 20

D 20
	if((cp = cpu = (struct mon_cpu *)malloc(cpu_size)) == NULL )
D 19
		fatal("monitor: can't allocate space for cpu: %s.\n");
E 19
I 19
		fatal("monitor: cpu: can't malloc space for cpu: %s.\n");
E 20
I 20
	if((cp = cpu = (struct mon_cpu *)malloc((unsigned)cpu_size)) == NULL )
		fatal("monitor: cpu: no space for mon_cpu: %s.\n");
E 22
I 22
D 54
	array = (struct cpudata *)namelist[NM_CPUDATA].n_value ;
E 54
I 54
	/*
	 *	Before V4.0 this was address of the array itself.  In
	 *	V4.0 it is the address of an array of addresses of
	 *	CPU data structures. So we have arrange to do the
	 *	right thing.
	 *
	 *	In V4.0 we'll read the array of addresses directly,
	 *	otherwise we'll fake it.
	 *	
	 */
	cpuaddr = (struct cpudata *)namelist[NM_CPUDATA].n_value ;
E 54
I 31

I 54
#ifdef	V4_ULTRIX
	readk((long)cpuaddr, array, sizeof(array[0]) * MAXCPU) ;
#else
	for(i = 0; i < maxcpu; i++)
		array[i] = cpuaddr + i ;
#endif

E 54
E 31
E 22
E 20
E 19
D 36
/*
D 22
 *	For every cpu in the array.
E 22
I 22
 *	For every cpu in the array {
E 22
 *
 *		If ( we don't want this cpu ) continue ;
D 22
 *
 *		add this CPU to the list.
E 22
I 22
 * 
 *		save the data for this cpu.
 *	}
E 22
 */
E 36
I 36
	/*
	 *	For every cpu in the array {
	 *
	 *		If ( we don't want this cpu ) continue ;
	 * 
	 *		save the data for this cpu.
	 *	}
	 */
E 36
D 54
	for(i = 0, n_cpu = 0; i < maxcpu; i++) {
D 16
		if( cpu_nel ) {
			p = sprintf(buf, "%d", n_cpu);
			if( !bsearch(&p, cpu_base, cpu_nel, KEY_SIZE, cmp))
				continue ;
		}
E 16
I 16
D 20
		if( find_value(&cpu_list, "", n_cpu) == 0 )
E 20
I 20
D 22
		if( find_value(&cpu_list, "", (int)n_cpu) == 0 )
E 22
I 22
		if( find_value(&cpu_list, "", (int)n_cpu) == 0 ) {
			array++ ;
E 54
I 54
	for(i = 0, n_cpu = -1; i < MAXCPU; i++) {
		if( find_value(&cpu_list, "", (int)n_cpu) == 0 )
E 54
E 22
E 20
			continue ;
I 22
D 54
		}
E 54
E 22
E 16

I 22
D 54
		readk((long)array, (char *)&cpudata, sizeof(cpudata));
E 54
I 54
		if( array[i] == 0 )
			continue ;
E 54

E 22
D 36
		cp->mon_type   = MON$K_CPU ;
		cp->mon_length = MON$S_CPU ;
E 36
I 36
D 42
		cpu[i].mon_type   = MON$K_CPU ;
E 42
I 42
D 54
		cpu[i].mon_type   = MON$C_CPU ;
E 42
		cpu[i].mon_length = MON$S_CPU ;
E 54
I 54
		n_cpu++ ;
E 54
E 36

D 22
		cp->mon_ident  = array[i].c_ident ;
		cp->mon_state  = array[i].c_state ;
		cp->mon_index  = n_cpu ;
E 22
I 22
D 28
		cp->mon_ident  = cpudata.c_ident ;
E 28
I 28
D 31
		cp->mon_ident  = getsid() ;
E 28
		cp->mon_state  = cpudata.c_state ;
		cp->mon_index  = n_cpu++ ;
E 22
		cp->mon_cpu    = i ;
D 22
		cp->mon_next   = cpu + i ;
		cp->mon_where  = (caddr_t)namelist[NM_CPUDATA].n_value + i ;
E 22
I 22
		cp->mon_where  = (caddr_t)array ;
E 31
I 31
D 36
		cp->mon_ident   = getsid() ;
		cp->mon_state   = cpudata.c_state ;
		cp->mon_index   = n_cpu++ ;
		cp->mon_cpu     = i ;
		cp->mon_where   = (caddr_t)array ;
		cp->mon_subtype = subtype ;
E 36
I 36
D 54
		cpu[i].mon_ident   = getsid() ;
D 47
		cpu[i].mon_state   = cpudata.c_state ;
E 47
		cpu[i].mon_index   = n_cpu++ ;
		cpu[i].mon_cpu     = i ;
		cpu[i].mon_where   = (caddr_t)array ;
		cpu[i].mon_subtype = subtype ;
I 47
#ifdef	vax
		cpu[i].mon_state   = cpudata.c_state ;
E 54
I 54
D 59
		readk((long)array[i], (char *)&cpudata, sizeof(cpudata));
E 59
I 59
		readk((long)array[i], (char *)&mon_cpudata,
			sizeof(mon_cpudata));
E 59

		cpu[n_cpu].mon_type    = MON$C_CPU ;
		cpu[n_cpu].mon_length  = MON$S_CPU ;
		cpu[n_cpu].mon_ident   = getsid(sid_addr) ;
		cpu[n_cpu].mon_index   = n_cpu ;
		cpu[n_cpu].mon_where   = (caddr_t)array[i] ;
		cpu[n_cpu].mon_subtype = subtype ;

#ifdef	V4_ULTRIX
D 59
		cpu[n_cpu].mon_cpu     = cpudata.cpu_num ;
		cpu[n_cpu].mon_state   = cpudata.cpu_state ;
E 59
I 59
		cpu[n_cpu].mon_cpu     = mon_cpudata.cpu_num ;
		cpu[n_cpu].mon_state   = mon_cpudata.cpu_state ;
E 59
#else
#	ifdef	vax
D 59
		cpu[n_cpu].mon_state   = cpudata.c_state ;
E 59
I 59
		cpu[n_cpu].mon_state   = mon_cpudata.c_state ;
E 59
#	endif
#	ifdef	mips
		cpu[n_cpu].mon_state   = CPU_RUN ;
#	endif
		cpu[n_cpu].mon_cpu     = i ;
E 54
#endif
D 54
#ifdef	mips
		cpu[i].mon_state   = CPU_RUN ;
#endif
E 54
E 47
E 36
E 31
E 22

D 36
		if((cp->mon_flag = ( cp->mon_state & CPU_RUN ) ? 1 : 0) == 0 )
E 36
I 36
D 48
		if((cpu[i].mon_flag = ( cpu[i].mon_state & CPU_RUN ) ? 1 : 0) == 0 )
E 48
I 48
D 54
		if((cpu[i].mon_flag = (cpu[i].mon_state & CPU_RUN) ? MON$M_VALID : 0) == 0 )
E 54
I 54
		if( cpu[n_cpu].mon_state & CPU_RUN )
			cpu[n_cpu].mon_flag |= MON$M_VALID ;
		else
E 54
E 48
E 36
			continue ;

I 53
/*
D 54
 * 	This is gotten from the "_sum" structure on the
 *	MIPS.
E 54
I 54
 *	On V4.0 we can get lots more things from cpudata structure
 *	that we have get elsewhere in earlier version.
E 54
 */
D 54
#ifdef	vax
E 53
D 22
		cp->mon_swtch  = array[i].c_switch ;
E 22
I 22
D 36
		cp->mon_swtch  = cpudata.c_switch ;
E 36
I 36
		cpu[i].mon_swtch  = cpudata.c_switch ;
E 54
I 54
#if	defined(V4_ULTRIX) || defined(vax)
D 59
		cpu[n_cpu].mon_swtch  = cpudata.c_switch ;
E 59
I 59
		cpu[n_cpu].mon_swtch  = mon_cpudata.c_switch ;
E 59
E 54
I 53
#endif
E 53
E 36
E 22

I 54
#ifdef	V4_ULTRIX
D 59
		cpu[n_cpu].mon_syscall = cpudata.cpu_syscall ;
		cpu[n_cpu].mon_trap    = cpudata.cpu_trap ;
		cpu[n_cpu].mon_intr    = cpudata.cpu_intr ;
E 59
I 59
		cpu[n_cpu].mon_syscall = mon_cpudata.cpu_syscall ;
		cpu[n_cpu].mon_trap    = mon_cpudata.cpu_trap ;
		cpu[n_cpu].mon_intr    = mon_cpudata.cpu_intr ;
E 59
#endif

E 54
		for(state = 0; state < CPUSTATES; state++)
D 22
			cp->mon_time[state] = array[i].c_cptime[state] ;
E 22
I 22
D 36
			cp->mon_time[state] = cpudata.c_cptime[state] ;
E 36
I 36
D 54
			cpu[i].mon_time[state] = cpudata.c_cptime[state] ;
E 54
I 54
D 59
			cpu[n_cpu].mon_time[state] = cpudata.c_cptime[state] ;
E 59
I 59
			cpu[n_cpu].mon_time[state] = mon_cpudata.c_cptime[state] ;
E 59
E 54
E 36
E 22

I 49
D 50
		strncpy(cpu[i].mon_name, str_cpuid(cpu[i].mon_ident, cpu[i].mon_subtype),
E 50
I 50
D 54
		(void)strncpy(cpu[i].mon_name, 
			str_cpuid(cpu[i].mon_ident, cpu[i].mon_subtype),
E 54
I 54
		(void)strncpy(cpu[n_cpu].mon_name, 
			str_cpuid(cpu[n_cpu].mon_ident, cpu[n_cpu].mon_subtype),
E 54
E 50
			MON$S_CPUNAME);
D 54

E 49
D 36
		cp++ ;
E 36
I 29
		array++ ;
E 54
E 29
D 22
		n_cpu++ ;
E 22
	}
I 54

	n_cpu++ ;
E 54
D 22

	cpu[n_cpu-1].mon_next = NULL ;

D 20
	free(array);
E 20
I 20
	free((char *)array);
E 22
E 20
E 13
E 7
E 2
}
I 14

/*
 *	The function(s) to collect data from a running system.  The are two
 *	ways of collecting the data depending on the value of maxcpu.
 */

/*
 *	The loop here will collect the per CPU data.  Another
 *	function sets up the linked list of CPU's.  It will have
 *	worry about the true implimentation of multiple CPU machines.
 */
D 28
live_cpu(Rate)
register struct vmmeter *Rate ;
E 28
I 28
D 36
live_cpu(Sum)
register struct vmmeter *Sum ;
E 36
I 36
live_cpu()
E 36
E 28
{
D 22
	register struct mon_cpu *cp = cpu ;
D 20
	register state, running ;
E 20
I 20
	register running ;
E 22
I 22
D 36
	register MON_CPU *cp = cpu ;
	register running, i ;
E 36
I 36
	register i, state ;
E 36
E 22
E 20
D 59
	struct   cpudata cpudata ;
E 59
I 59
	struct   cpudata mon_cpudata ;
E 59

	/*
I 15
 	 *	If the list is empty don't bother.
	 */
D 22
	if( cp == (struct mon_cpu *)NULL )
E 22
I 22
D 36
	if( cp == (MON_CPU *)NULL )
E 36
I 36
D 58
	if( cpu == (MON_CPU *)NULL )
E 58
I 58
	if( cpu == (struct mon_cpu *)NULL )
E 58
E 36
E 22
		return ;

I 41
	/*
	 *	Collect the current data foreach cpu.  Do this even
	 *	if the CPU isn't running because we want to get the
	 *	CPU state.
	 */
E 41
D 36
	/*
E 15
 	 *	The first CPU structure will hold the misc. CPU
	 *	info.
	 */
D 28
	cp->mon_trap    = Rate->v_trap ;
	cp->mon_syscall = Rate->v_syscall ;
	cp->mon_intr    = Rate->v_intr ;
	cp->mon_pdma    = Rate->v_pdma ;
E 28
I 28
	cp->mon_trap    = Sum->v_trap ;
	cp->mon_syscall = Sum->v_syscall ;
	cp->mon_intr    = Sum->v_intr ;
	cp->mon_pdma    = Sum->v_pdma ;
E 36
I 36
D 54
	for(i = 0; i < first.mon_cpu ; i++) {
E 54
I 54
	for(i = 0; i < n_cpu; i++) {
E 54
D 59
		readk((long)cpu[i].mon_where, (char *)&cpudata, sizeof(cpudata));
E 59
I 59
		readk((long)cpu[i].mon_where, (char *)&mon_cpudata,
			sizeof(mon_cpudata));
E 59
E 36
E 28

D 36
	if( maxcpu == 0 ) {
		readk((long)cp->mon_where, (char *)cp->mon_time,
			sizeof(cp->mon_time));

D 28
		cp->mon_swtch   = Rate->v_swtch ;
E 28
I 28
		cp->mon_swtch   = Sum->v_swtch ;
E 28
I 22

		return ;
E 22
	}
D 22
	else {
		while( cp ) {
			register state ;
E 22

D 22
			readk((long)cp->mon_where, (char *)&cpudata,
				sizeof(cpudata));
E 22
I 22
	for(i = 0; i < first.mon_cpu ; i++, cp++) {
		register state ;
E 22

D 22
			cp->mon_state = cpudata.c_state ;
E 22
I 22
		readk((long)cp->mon_where, (char *)&cpudata, sizeof(cpudata));
E 22

D 22
			running = cp->mon_state & CPU_RUN ;
E 22
I 22
		running = (cp->mon_state = cpudata.c_state) & CPU_RUN ;
E 22

E 36
D 22
			for(state = 0; state < CPUSTATES; state++)
				cp->mon_time[state] = running 
					? cpudata.c_cptime[state] 
					: 0 ;
E 22
I 22
		for(state = 0; state < CPUSTATES; state++)
D 36
			if( running )
				cp->mon_time[state] = cpudata.c_cptime[state] ;
			else
				cp->mon_time[state] = 0 ;
E 36
I 36
D 59
			cpu[i].mon_time[state] = cpudata.c_cptime[state] ;
E 59
I 59
			cpu[i].mon_time[state] = mon_cpudata.c_cptime[state] ;
E 59
E 36
E 22

I 53
D 54
#ifdef	vax
E 54
I 54
#if	defined(V4_ULTRIX) || defined(vax)
E 54
E 53
D 22
			cp->mon_swtch = running ? cpudata.c_switch : 0 ;

			cp = cp->mon_next ;
		}
E 22
I 22
D 36
		cp->mon_swtch = running ? cpudata.c_switch : 0 ;
E 36
I 36
D 59
		cpu[i].mon_swtch = cpudata.c_switch ;
E 59
I 59
		cpu[i].mon_swtch = mon_cpudata.c_switch ;
E 59
I 53
#endif
I 54

#ifdef	V4_ULTRIX
D 59
		cpu[i].mon_syscall = cpudata.cpu_syscall ;
		cpu[i].mon_intr    = cpudata.cpu_intr ;
		cpu[i].mon_trap    = cpudata.cpu_trap ;
E 59
I 59
		cpu[i].mon_syscall = mon_cpudata.cpu_syscall ;
		cpu[i].mon_intr    = mon_cpudata.cpu_intr ;
		cpu[i].mon_trap    = mon_cpudata.cpu_trap ;
E 59
#endif
E 54
E 53
E 36
E 22
I 17
	}
}

#define	HALF	(COLS / 2)

I 37
#define	CPU_INTR	 (3)
#define CPU_PDMA	 (4)
D 51
#define	CPU_OFFSET	 (23)
#define	CPU_STATE	 (7)
E 51
I 51
#define	CPU_OFFSET	 (25)
#define	CPU_STATE	 (8)
E 51
#define	CPU_OFFSET_STATE (5)

I 39
D 51
#define	CPU_BASE_LINES	(8)		/* + 1 per CPU */
E 51
I 51
#define	CPU_BASE_LINES	(9)		/* + 1 per CPU */
E 51

E 39
E 37
I 20
D 27
/* ARGSUSED */
E 27
I 27
/*
 *	Print headers for the CPU magnify function.
 *
 *	ARGSUSED
 */
E 27
E 20
open_cpu(op)
OPTION	*op ;
{
I 21
D 22
	register struct mon_cpu *cp = cpu ;
	register n_cpu = 0, y ;
E 22
I 22
D 37
	register y, i ;
E 37
I 37
	register i ;
E 37
E 22

I 39
	lines = CPU_BASE_LINES ;

E 39
E 21
D 28
	clear() ;
E 28
I 28
	sample_header() ;
E 28

D 28
	move(0, 0);

	printw("Elapsed Time:\n");
	printw("Timestamp:\n\n");

E 28
D 37
	printw("Calls to trap():\n");
	printw("Calls to syscall():\n");
	mvprintw(3, HALF, "Device Interrupts:");
	mvprintw(4, HALF, "Pseudo-dma interrupts:");
E 37
I 37
D 38
	wprintw(stdscr, "Calls to trap():\n");
	wprintw(stdscr, "Calls to syscall():\n");
E 38
I 38
D 51
	wprintw(wp, "Calls to trap():\n");
	wprintw(wp, "Calls to syscall():\n");
E 51
I 51
	wprintw(wp, "Calls to trap():\n") ;
	wprintw(wp, "Calls to syscall():\n") ;
	wprintw(wp, "Calls to new_tlbpid():\n") ;
E 51
E 38
E 37

D 37
	move(6, 0);
E 37
I 37
D 38
	wmove(stdscr, CPU_INTR, HALF) ;
	wprintw(stdscr, "Device Interrupts:");
E 38
I 38
	wmove(wp, CPU_INTR, HALF) ;
D 51
	wprintw(wp, "Device Interrupts:");
E 51
I 51
	wprintw(wp, "Device Interrupts:") ;
E 51
E 38
E 37

D 21
	printw("CPU:  %%user   %%nice %%system   %%idle  swtch  state");
	
E 21
I 21
D 37
	printw("CPU:  %%user   %%nice %%system   %%idle  swtch  state\n");
E 37
I 37
D 38
	wmove(stdscr, CPU_PDMA, HALF) ;
	wprintw(stdscr, "Pseudo-dma interrupts:");
E 38
I 38
D 51
	wmove(wp, CPU_PDMA, HALF) ;
	wprintw(wp, "Pseudo-dma interrupts:");
E 51
I 51
	wmove(wp, CPU_INTR+1, HALF) ;
	wprintw(wp, "Pseudo-dma interrupts:") ;
E 51
E 38
E 37

I 51
	wmove(wp, CPU_INTR+2, HALF) ;
	wprintw(wp, "Software interrupts:") ;

E 51
I 37
D 38
	wmove(stdscr, CPU_STATE-1, 0);
	wprintw(stdscr, "CPU:  %%user   %%nice %%system   %%idle  swtch  state\n");
E 38
I 38
	wmove(wp, CPU_STATE-1, 0);
I 56
#ifdef	V4_ULTRIX
	wprintw(wp, "CPU:  %%user   %%nice %%system   %%idle  swtch   intr  scall  state\n");
#else
E 56
	wprintw(wp, "CPU:  %%user   %%nice %%system   %%idle  swtch  state\n");
I 56
#endif
E 56
E 38

E 37
	if( cpu == NULL )
		return ;

D 37
	y = 7 ;

E 37
D 22
	while( cp ) {
		if( n_cpu++ == first.mon_cpu )
			break ;
E 22
I 22
D 39
	for(i = 0; i < first.mon_cpu; i++) {
E 39
I 39
	for(i = 0; i < first.mon_cpu; i++, lines++) {
E 39
D 37
		mvprintw(y++, 0, "#%d", cpu[i].mon_cpu);
E 37
I 37
D 38
		wmove(stdscr, CPU_STATE+i, 0) ;
		wprintw(stdscr, "#%d", cpu[i].mon_cpu);
E 38
I 38
		wmove(wp, CPU_STATE+i, 0) ;
		wprintw(wp, "#%d", cpu[i].mon_cpu);
E 38
E 37
E 22

D 22
		mvprintw(y++, 0, "#%d", cp->mon_cpu);

		if( op->collect_mode == OPT_REPLAY )
			cp++ ;
		else
			cp = cp->mon_next ;

E 22
D 37
		if( y == (LINES - 1))
E 37
I 37
		if((CPU_STATE + i) == (LINES - 1))
E 37
			break ;
	}
E 21
}

I 56
/*
D 60
 *	Local data for calculating the differences in the total
 *	number of system calls and device interrupts.
 */
static	int	prev_syscall = 0,
		prev_intr = 0 ;

/*
E 60
 *	We'll use this later...
 */
#define	DELTA(current, previous)	{ tmp = current ; \
					  current -= previous ; \
					  previous = tmp ; \
					}
E 56
I 22
D 27
/* ARGSUSED */
E 27
I 27
/* 
 *	"Magnify" the CPU information.
 *
 *	ARGSUSED
 */
E 27
E 22
magnify_cpu(op)
OPTION	*op ;
{
D 22
	struct mon_cpu *p = cpu ;
	double	total_time, cpu_time() ;
D 21
	register y ;
E 21
I 21
	register y, n_cpu = 0 ;
E 22
I 22
D 28
	register MON_CPU *p = cpu, *lastp ;
	double	 total_time, cpu_time() ;
	register y ;
E 28
I 28
	double	 total_time, delta_cpu(), etime ;
D 37
	register y, i ;
E 37
I 37
D 56
	register i ;
E 56
I 56
D 60
	register i, total_syscall, total_intr, tmp ;
E 60
I 60
	register i ;
	int	 total_syscall, total_intr ;
E 60
E 56
E 37
E 28
E 22
E 21

I 56
D 60
	total_syscall = 0 ;
	total_intr = 0 ;

E 56
D 28
	mvprintw(0, 14, "%.2f", sample.mon_etime);
	mvprintw(1, 14, "%24.24s", ctime(&sample.mon_timestamp));
E 28
I 28
D 32
	etime = sample.mon_etime ;
E 28

E 32
D 23
	if( cpu == NULL )
		return ;

E 23
D 28
	mvprintw(3, 23, "%6d", p->mon_trap);
	mvprintw(4, 23, "%6d", p->mon_syscall);
	mvprintw(3, HALF+23, "%6d", p->mon_intr);
	mvprintw(4, HALF+23, "%6d", p->mon_pdma);
E 28
I 28
D 33
	sample_body(14) ;
E 28

E 33
D 28
	y = 7 ;
E 28
I 28
D 37
	for(i = 0, y = 7; i < first.mon_cpu; i++) {
E 37
I 37
	for(i = 0; i < first.mon_cpu; i++) {
I 41
D 48
		if( cpu[i].mon_flag == 0 )
E 48
I 48
		if((cpu[i].mon_flag & MON$M_VALID) == 0 )
E 48
			continue ;

I 56
		total_syscall += cpu[i].mon_syscall ;
		total_intr    += cpu[i].mon_intr ;
	}

	tmp = total_syscall ;
	      total_syscall -= prev_syscall ;
	      prev_syscall = tmp ;

	tmp = total_intr ;
	      total_intr -= prev_intr ;
	      prev_intr = tmp ;
E 60
I 60
	delta_syscall_intr(&total_syscall, &total_intr) ;
E 60

	for(i = 0; i < first.mon_cpu; i++) {
		if((cpu[i].mon_flag & MON$M_VALID) == 0 )
			continue ;

E 56
E 41
E 37
D 32
		total_time = delta_cpu(cpu + i) ;
E 32
I 32
		etime = delta_cpu(i, sample.mon_ticks, &total_time) ;
E 32
E 28

D 22
	while( p ) {
I 21
		if( n_cpu++ == first.mon_cpu )
			break ;

E 22
I 22
D 23
	for(lastp = cpu; p < lastp; p++) {
E 23
I 23
D 28
	for(lastp = cpu + first.mon_cpu; p < lastp; p++) {
E 23
E 22
E 21
		total_time = cpu_time(p) ;
E 28
I 28
		if( i == 0 ) {
D 37
			mvprintw(3, 23, "%6.0f", cpu[0].mon_trap / etime);
			mvprintw(4, 23, "%6.0f", cpu[0].mon_syscall / etime);
			mvprintw(3, HALF+23, "%6.0f",
D 30
				cpu[0].mon_intr / etime - first.mon_hz);
E 30
I 30
				cpu[0].mon_intr / etime);
E 30
			mvprintw(4, HALF+23, "%6.0f", cpu[0].mon_pdma / etime);
E 37
I 37
D 38
			wmove(stdscr, CPU_INTR, CPU_OFFSET) ;
			wprintw(stdscr, "%6.0f", cpu[0].mon_trap / etime);
E 38
I 38
			wmove(wp, CPU_INTR, CPU_OFFSET) ;
D 51
			wprintw(wp, "%6.0f", cpu[0].mon_trap / etime);
E 51
I 51
			wprintw(wp, "%8.1f", cpu[0].mon_trap / etime);
E 51
E 38

D 38
			wmove(stdscr, CPU_PDMA, CPU_OFFSET) ;
			wprintw(stdscr, "%6.0f", cpu[0].mon_syscall / etime);
E 38
I 38
D 51
			wmove(wp, CPU_PDMA, CPU_OFFSET) ;
			wprintw(wp, "%6.0f", cpu[0].mon_syscall / etime);
E 51
I 51
			wmove(wp, CPU_INTR+1, CPU_OFFSET) ;
D 56
			wprintw(wp, "%8.1f", cpu[0].mon_syscall / etime);
E 56
I 56
			wprintw(wp, "%8.1f", total_syscall / etime);
E 56
E 51
E 38

I 51
			wmove(wp, CPU_INTR+2, CPU_OFFSET) ;
			wprintw(wp, "%8.1f", cpu[0].mon_tlbpid / etime);

E 51
D 38
			wmove(stdscr, CPU_INTR, HALF+CPU_OFFSET) ;
			wprintw(stdscr, "%6.0f", cpu[0].mon_intr / etime);
E 38
I 38
			wmove(wp, CPU_INTR, HALF+CPU_OFFSET) ;
D 51
			wprintw(wp, "%6.0f", cpu[0].mon_intr / etime);
E 51
I 51
D 56
			wprintw(wp, "%8.1f", cpu[0].mon_intr / etime);
E 56
I 56
			wprintw(wp, "%8.1f", total_intr / etime);
E 56
E 51
E 38

D 38
			wmove(stdscr, CPU_PDMA, HALF+CPU_OFFSET) ;
			wprintw(stdscr, "%6.0f", cpu[0].mon_pdma / etime);
E 38
I 38
D 51
			wmove(wp, CPU_PDMA, HALF+CPU_OFFSET) ;
			wprintw(wp, "%6.0f", cpu[0].mon_pdma / etime);
E 51
I 51
			wmove(wp, CPU_INTR+1, HALF+CPU_OFFSET) ;
			wprintw(wp, "%8.1f", cpu[0].mon_pdma / etime);

			wmove(wp, CPU_INTR+2, HALF+CPU_OFFSET) ;
			wprintw(wp, "%8.1f", cpu[0].mon_soft / etime);
E 51
E 38
E 37
		}
E 28

D 21
		mvprintw(y++, 0, "#%2d  %6.0f  %6.0f  %6.0f  %6.0f  %5d  <%s>",
			p->mon_cpu,
E 21
I 21
D 28
		mvprintw(y++, 5, "%6.0f  %6.0f  %6.0f  %6.0f  %5d  <%s>",
E 21
			100. * p->mon_time[0] / total_time,
			100. * p->mon_time[1] / total_time,
			100. * p->mon_time[2] / total_time,
			100. * p->mon_time[3] / total_time,
			p->mon_swtch, str_state(p->mon_state));
E 28
I 28
D 37
		mvprintw(y++, 5, "%6.0f  %6.0f  %6.0f  %6.0f  %5.0f  <%s>",
E 37
I 37
D 38
		wmove(stdscr, CPU_STATE + i, CPU_OFFSET_STATE) ;
		wprintw(stdscr, "%6.0f  %6.0f  %6.0f  %6.0f  %5.0f  <%s>",
E 38
I 38
		wmove(wp, CPU_STATE + i, CPU_OFFSET_STATE) ;
I 56
#ifdef	V4_ULTRIX
		wprintw(wp, "%6.0f  %6.0f  %6.0f  %6.0f  %5.0f  %5.0f  %5.0f  <%s>",
#else
E 56
		wprintw(wp, "%6.0f  %6.0f  %6.0f  %6.0f  %5.0f  <%s>",
I 56
#endif
E 56
E 38
E 37
			100. * cpu[i].mon_time[0] / total_time,
			100. * cpu[i].mon_time[1] / total_time,
			100. * cpu[i].mon_time[2] / total_time,
			100. * cpu[i].mon_time[3] / total_time,
			cpu[i].mon_swtch / etime,
I 56
#ifdef	V4_ULTRIX
			cpu[i].mon_intr / etime,
			cpu[i].mon_syscall / etime,
#endif
E 56
			str_state(cpu[i].mon_state));
E 28

D 37
		clrtoeol() ;
E 37
I 37
D 38
		wclrtoeol(stdscr) ;
E 38
I 38
		wclrtoeol(wp) ;
E 38
E 37

D 22
		if( op->collect_mode == OPT_REPLAY )
			p++ ;
		else
			p = p->mon_next ;

E 22
D 18
		if( y == (COLS - 1))
E 18
I 18
D 37
		if( y == (LINES - 1))
E 37
I 37
		if((CPU_STATE + i) == (LINES - 1))
E 37
E 18
			break ;
E 17
	}
I 33

	sample_body(etime) ;
E 33
I 22
}

/*
 *	Local version of a system call to get the contents of the SID
D 26
 *	register.
E 26
I 26
 *	register.  This function constructs a number which looks like
 *	the contents of a CPU SID register.
 *
 *	It is a feature of the MicroVAX architecture that this function
 *	will always return the correct SID.
I 54
 *
 *	It tries real hard to do the right thing on VAX and RISC
 *	systems for V3.x and V4.0.
E 54
E 26
 */
D 54
getsid()
E 54
I 54
getsid(addr)
long	addr ;
E 54
{
I 47
/*
D 54
 *	Data for the two architectures.
E 54
I 54
 *	The union used to construct an SID look-alike.
E 54
 */
#ifdef	vax
E 47
D 26
	int	cpuid ;
E 26
I 26
D 54
	int	nm_cpu ;
	union	cpusid cpu ;
E 54
I 54
	union	cpusid cpu_sid ;
E 54
I 47
#endif
D 54
#ifdef	mips
E 54
E 47
E 26

I 47
D 54
	int	cpu_systype ;
#endif

E 54
/*
D 54
 *	The architecture depend code.
E 54
I 54
 *	The architecture dependent code.
E 54
 */
#ifdef	vax
E 47
D 26
	readk((long)namelist[NM_CPU].n_value, (char *)&cpuid, sizeof(cpuid)) ;
E 26
I 26
D 54
	readk((long)namelist[NM_CPU].n_value, (char *)&nm_cpu, sizeof(nm_cpu)) ;
E 54
I 54
	cpu_sid.cpuany.cp_type = get_word(addr) ;
E 54
E 26

D 26
	return cpuid ;
E 26
I 26
D 54
	cpu.cpuany.cp_type = nm_cpu ;

	return cpu.cpusid ;
E 54
I 54
	return cpu_sid.cpusid ;
E 54
I 47
#endif

#ifdef	mips
D 54
	readk((long)namelist[NM_CPU_SYSTYPE].n_value, (char *)&cpu_systype,
		sizeof(cpu_systype)) ;

	return cpu_systype ;
E 54
I 54
	return get_word(addr) ;
E 54
#endif
E 47
I 31
}

D 46

E 46
/*
D 46
 *	"A rose by any other name..." - W.S.
E 46
I 46
 *	Functions and data to take the CPU state bits and turn them into
 *	something "meaningful".
E 46
 */
D 46
#define	MACRO(s)	{ s, sizeof(s) - 1, }
E 46
I 46
extern struct bit_names state_names[] ;
E 46

I 46
char	*str_state(state)
int	state ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(state, buf, state_names) ;
}

extern struct cpu_type cpu_types[] ;

E 46
D 35
struct	bit_names {			/* names of things */
	char	*string ;
	int	length ;
};

E 35
/*
 *	Functions and data to take the CPU id and turn it into something
 *	"meaningful".  Another part of monitor takes the cpu type and 
 *	turns it into something that looks a little like the CPU id.
 */
char	*str_cpuid(ident, subtype)
D 32
int	ident, subtype ;
E 32
I 32
int	ident ;
long	subtype ;
E 32
{
I 47
#ifdef	vax
E 47
D 54
	union cpusid cpu ;
E 54
I 54
	union cpusid zounds ;
E 54
I 47
#endif
E 47
	int	type ;
I 46
	struct cpu_type *sp, *tp ;
E 46

I 46
	tp = &cpu_types[0] ;
I 47

/*
 *	This is the VAX version of how to turn the system
 *	id into a system name.
 */
#ifdef	vax
E 47
E 46
D 54
	cpu.cpusid = ident ;
	type = cpu.cpuany.cp_type ;
E 54
I 54
	zounds.cpusid = ident ;
	type = zounds.cpuany.cp_type ;
E 54
I 47
#endif

/*
 *	On the mips we can get everything from the cpu_systype.
I 55
 *	This will ignore the value of subtype passed to us.
E 55
 */
#ifdef	mips
D 55
	type = GETSYSTYPE(ident) ;
E 55
I 55
	type    = GETCPUTYPE(ident) ;
	subtype = GETSYSTYPE(ident) ;
E 55
#endif
E 47

I 55
D 56
	printf("ident: %x, subtype: %d, type: %d\n", ident, subtype, type) ;

E 56
E 55
D 46
	switch( type ) {
	case VAX_780:
		return "VAX 11/780 or 11/785" ;
	case VAX_750:
		return "VAX 11/750 or 11/751" ;
	case VAX_730:
		return "VAX 11/730 or 11/725" ;
	case VAX_8600:
		return "VAX 8600/8650" ;
	case VAX_8200:
		switch( subtype ) {
		case ST_8200:
			return "VAX 8200" ;
		case ST_8300:
			return "VAX 8300" ;
		default:
			return "VAX 8200/8300" ;
		}
E 46
I 46
	while( tp->string != NULL ) {
I 55
D 56
		printf("string: %s, type: %d\n", tp->string, tp->type) ;
E 56
E 55
		if( tp->type == type ) {
			/*
			 *	If there isn't a subtype list return
			 *	the string for the type.
			 */
			if((sp = tp->subtype) == NULL )
				return tp->string ;
E 46

D 46
	case VAX_8800:
		switch( subtype ) {
		case ST_8500:
			return "VAX 8500" ;
		case ST_8550:
			return "VAX 8550" ;
		case ST_8700:
			return "VAX 8700" ;
		case ST_8800:
			return "VAX 8800" ;
		default:
			return "VAX 8800/8700/8550/8500" ;
		}
E 46
I 46
			/*
			 *	Else...  Walk the the subtype list
			 *	looking for a matching subtype.
			 */
			while( sp->string != NULL ) {
				if( sp->type == subtype )
					return sp->string ;
E 46

D 46
	case MVAX_I:
		return "MicroVAX I" ;
	case MVAX_II:
		switch( subtype ) {
		case ST_VAXSTAR:
			return "MicroVAX 2000" ;
		default:
			return "MicroVAX II" ;
		}
E 46
I 46
				sp++ ;
			}
E 46

I 43
D 46
	case C_VAX:
		switch( subtype ) {
		case ST_KA650:
			return "MicroVAX/VAXstation 3200/3500/3600/3602" ;
		default:
			return "Unknown CVAX" ;
E 46
I 46
			/*
			 *	If there isn't a subtype match return
			 *	the type string.
			 */
			return tp->string ;
E 46
		}

E 43
D 46
	default:
		return "reserved for future use" ;
E 46
I 46
		tp++ ;
E 46
	}
D 46
}
E 46

D 46
/*
 *	Functions and data to take the CPU state bits and turn them into
 *	something "meaningful".
 */
D 44
struct bit_names state_names[] = {
	MACRO("run"),
	MACRO("tbi"),
	MACRO("panic"),
	0, 0,
};
E 44
I 44
extern struct bit_names state_names[] ;
E 44

char	*str_state(state)
int	state ;
{
	static	char	buf[BUFSIZ] ;

	return str_generic(state, buf, state_names) ;
E 46
I 46
	return "Unknown CPU type" ;
I 49
}

/*
 *	Function to dump the CPU record.
 */
f_cpu(p)
struct mon_cpu *p ;
{
	register state ;

	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

D 52
	printf("%s.\n", records[MON$C_CPU].rec_string) ;
E 52
I 52
	printf("%s.\n", records[MON$C_CPU].string) ;
E 52

	printf("\tname:    %s\n", p->mon_name) ;
	printf("\tident:   0x%x\n", p->mon_ident, p->mon_ident) ;
	printf("\tsubtype: 0x%x\n", p->mon_subtype, p->mon_subtype) ;

	for(state = 0 ; state < CPUSTATES; state++)
		printf("\t[%d]:     %d ticks\n", state, p->mon_time[state]);

	printf("\tstate:   <%s>\n", str_state(p->mon_state)) ;
	printf("\tcpu:     %d\n", p->mon_cpu) ;
	printf("\tindex:   %d\n", p->mon_index) ;
	printf("\tswtch:   %u\n", p->mon_swtch) ;
	printf("\ttrap:    %u\n", p->mon_trap) ;
	printf("\tsyscall: %u\n", p->mon_syscall) ;
	printf("\tintr:    %u\n", p->mon_intr) ;
	printf("\tpdma:    %u\n", p->mon_pdma) ;
	printf("\ttlbpid:  %u\n", p->mon_tlbpid) ;
	printf("\tsoft:    %u\n", p->mon_soft) ;
E 49
E 46
E 31
E 26
E 22
}
E 14
I 4
D 6

D 5
static	int	first_time = 1 ;
E 5
I 5
#define	MAX_CPUS	(64)

static	long	prev[MAX_CPUS][CPUSTATES] ;

E 5
/*
 *	Calculate the total elapsed cpu time.
 */
D 5
double	cpu_time()
E 5
I 5
double	cpu_time(sp)
struct mon_state *sp ;
E 5
{
D 5
	if( first_time )
		first_time = 0 ;
E 5
I 5
	register etime = 0, tmp, i, n ;
E 5

D 5
	return -1.0 ;
E 5
I 5
	n = sp->mon_cpu ;

	for(i = 0; i < CPUSTATES; i++) {
		tmp = sp->mon_time[i] ;
		sp->mon_time[i] -= prev[n][i] ;
		prev[n][i] = tmp ;

		etime += sp->mon_time[i] ;
	}

	if( etime == 0 )
		etime = 1 ;

	return (double) etime ;
E 5
}
E 6
E 4
E 1
