h32576
s 00043/00018/00426
d D 1.8 90/08/22 21:53:01 alan 8 7
c fixed mis-feature that allowed device to occur twice in a disk list on V4.0 DECstations
e
s 00010/00000/00434
d D 1.7 90/03/29 16:17:06 alan 7 6
c The hack to fix the DECmumble include file problem.
e
s 00021/00009/00413
d D 1.6 89/12/27 16:11:08 alan 6 5
c Clean up architecture and version differences
e
s 00143/00117/00279
d D 1.5 89/12/25 16:57:55 alan 5 4
c Change the disk setup functions to work on both architectures.  This
c required moving copies of the mba and uba include files to the build
c directory for the V3.0 DECstations.
c 
e
s 00003/00003/00393
d D 1.4 89/02/25 10:10:52 alan 4 3
c editorial change to list_ elements
e
s 00007/00003/00389
d D 1.3 89/02/15 19:29:49 alan 3 2
c properly set mon_flag in all records
e
s 00013/00008/00379
d D 1.2 89/01/04 10:55:11 alan 2 1
c V1.1 changes for MIPS support.  This is a check-point of the support
e
s 00387/00000/00000
d D 1.1 88/12/03 23:51:04 alan 1 0
c date and time created 88/12/03 23:51:04 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Look at the various available data structures and
 *	figure out what disks are available to collect information
 *	on.
 */
#ifndef	lint
static	char	SccsId[] = "%W% (monitor) %G%" ;
#endif

/*
 * 2-December-1988 -- arr
 *
 *	New file.  A merger of parts of live.c, uba.c and mba.c.  The
 *	last two should go away as a result of this.
I 3
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
I 5
 *
 * Dec. 25, 1989 -- arr
 *
 *	Attempt to resolve all the different device naming
 *	conventions between V3.0, V3.1{A,B,C} and V4.0.
I 7
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
I 8
 * Aug. 22, 1990 -- arr
 *
 *	I found a curious bug on a V4.0 DECstation that the command
 *	line:
 *		monitor disk=rz0,rz3 disk=rz3
 *
 *	caused data for an rz3 to be collected twice.  Now I only
 *	allow any given device name once.
E 8
E 7
E 5
E 3
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
I 5
#include <time.h>
#include <ctype.h>
E 5

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
D 5
#include <sys/dir.h>
#include <sys/user.h>
E 5
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
D 5
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 5
I 5
#include <sys/dir.h>
I 7

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 7
#include <sys/user.h>
E 5

I 5
#ifdef	V4_ULTRIX
#	include <sys/smp_lock.h>
#endif

E 5
#include <net/if.h>
#include <netinet/in.h>

D 5
#ifdef	vax
#	include <vaxuba/ubavar.h>
#	include <machine/pte.h>
E 5
I 5
#include <machine/param.h>
#include <machine/pte.h>

D 6
#if defined(V4_ULTRIX) || defined(vax)
E 5
#	include <vaxmba/mbavar.h>
#	include <vaxmba/mbareg.h>
I 5
#	include <vaxuba/ubavar.h>
#elif mips
#	include <machine/hwconf.h>
#	include "mbavar.h"
#	include "mbareg.h"
#	include "ubavar.h"
E 6
I 6
#ifdef	V4_ULTRIX
#	ifdef	vax
#		include <io/mba/vax/mbavar.h>
#		include <io/mba/vax/mbareg.h>
#		include <io/uba/ubavar.h>
#	elif	mips
#		include "mbavar.h"
#		include "mbareg.h"
#		include <io/uba/ubavar.h>
#	endif
#else
#	ifdef	vax
#		include <vaxmba/mbavar.h>
#		include <vaxmba/mbareg.h>
#		include <vaxuba/ubavar.h>
#	elif	mips
#		include <machine/hwconf.h>
#		include "mbavar.h"
#		include "mbareg.h"
#		include "ubavar.h"
#	endif
E 6
E 5
#endif

#include "include.h"
#include "options.h"
#include "monitor.h"
#include "extern.h"

I 2
D 5
#ifdef	mips
E 5
E 2
/*
D 2
 *	The module name for the error functions.
E 2
I 2
 *	The module name for the error functions.  It's only used 
 *	in the PMAX code so I'll make it conditional to keep lint 
 *	happy.
E 2
 */
static	char	*module = "collect_disk" ;
I 2
D 5
#endif
E 5
E 2

/*
 *	Declarations for function that don't return (int).
 */
char	*strcpy() ;
D 5

E 5
void	exit() ;

I 2
D 5
#ifdef	mips
E 5
E 2
/*
D 2
 *	Most of the kernel data will be read directly into the
 *	mon_... structures.  However some of it needs to shuffled
 *	off to a variety of places.  These are the objects for that
 *	info.
E 2
I 2
D 5
 *	On the PMAX we use the number of transfers to determine
 *	if a disk is alive.  Since we already have space allocated
 *	for this elsewhere, we'll use it.  Instead of taking up
 *	more.
E 5
I 5
 *	dk_map has already been declared for the names()
 *	code, so we'll reuse it here to save some space.
 *	After wandering down the UNIBUS-like and MASSBUS
 *	data structures we'll use dk_xfer to fill in any
 *	missing disks.
E 5
E 2
 */
D 2
long		dk_xfer[DK_NDRIVE] ;
int		dk_active[DK_NDRIVE] ;
char		dk_name[DK_NDRIVE][DEV_SIZE] ;
E 2
I 2
extern long dk_xfer[DK_NDRIVE] ;
D 5
#endif
E 5
I 5
extern char dk_map[DK_NDRIVE] ;
E 5
E 2

/*
 *	Gather the static data (names of devices, physmem, etc).
 *
 *	Eventually the functions which collect names will be
 *	responseable for doing the handling the command line
 *	options like "disk=ra0,hp1,ra2".
 */
collect_disk(op)
OPTION	*op ;
{
D 5
	register	i, dk ;
#ifdef	mips
	char		device[DEV_SIZE+1], *digit, *name, *find_digit() ;
#endif
#ifdef	vax
	float		dk_mspw[DK_NDRIVE] ;
E 5
I 5
	register i, dk ;
	float	 dk_mspw[DK_NDRIVE] ;
E 5

	/*
I 5
	 *	Clear the dk_map[] array.
	 */
	for(i = 0; i < DK_NDRIVE; i++)
		dk_map[i] = 0 ;

	/*
E 5
	 *	Determine what disks are available from looking
	 *	at the configuration.
	 */
D 5
	uba_devices(op);	/* Unibus/Qbus disks */
E 5
I 5
	uba_disks(op);		/* Unibus/Qbus disks */
E 5

D 5
	mba_devices();		/* MASSBUS disks */
E 5
I 5
	mba_disks();		/* MASSBUS disks */
E 5

I 8
	/*
	 *	This will get to go away in a V4 only version
	 *	one of these days.
	 */
E 8
I 5
	scsi_disks() ;		/* Whatever is left over. */

#ifdef	vax
E 5
	/*
	 *	It's assumed that once a disk is configured the
	 *	transfer speed doesn't change.  This is probably
	 *	bogus.
	 */
	readk((long)namelist[NM_DK_MSPW].n_value, (char *)dk_mspw,
		sizeof(dk_mspw));

	for(i = 0; i < n_disk ; i++) {
		dk = disk[i].mon_dk ;
		disk[i].mon_mspw = dk_mspw[dk] ;
	}
D 5
#endif	vax

/*
 *	Life gets interesting.  The disks on the PMAX don't like
 *	disks on previous version so a lot of hand waving must
 *	take place.  This is how monitor will behave (or misbehave).
 *
 *	If a disk is on the command line list of "interesting" disks
 *	then monitor will collect data for it, EVEN IF it doesn't
 *	appear active (the user knows best).  The only requirement
 *	is that the disk name must be "rz" or "dk" and the dk number
 *	be less than DK_NDRIVE.
 *
 *	If the list is empty then the only drives that will be watched
 *	are those that appear active.  Active in this case means that
 *	the number transfers are non-zero.  (Note: iostat(1) uses the
 *	number of words tranfered as the criteria, but that's bogus
 *	because the number of words transfered has a better chance of
 *	rolling over and there can appear to be zero even though it's
 *	not.  Bloody unlikely, but possible).
 */
#ifdef	mips
	/*
	 *	If the list is empty.
	 */
D 4
	if( disk_list.list_nel == 0 ) {
E 4
I 4
	if( disk_list.nel == 0 ) {
E 4
		/*
		 *	Get the transfer data struture.
		 */
		readk((long)namelist[NM_DK_XFER].n_value, (char *)dk_xfer,
			sizeof(dk_xfer)) ;

		for(i = 0; i < DK_NDRIVE; i++)
			if( dk_xfer[i] != 0 ) {
				fill_disk(n_disk, "rz", i, i) ;
				n_disk++ ;
			}
	}
	/*
	 *	Other use the command line list.
	 */
	else {
D 4
		for(dk = 0; dk < disk_list.list_nel; dk++) {
			name = disk_list.list_base[dk] ;
E 4
I 4
		for(dk = 0; dk < disk_list.nel; dk++) {
			name = disk_list.base[dk] ;
E 4

			if((digit = find_digit(name)) != NULL ) {
				for(i = 0; name[i] != *digit && i < DEV_SIZE; i++)
					device[i] = name[i] ;

				device[i] = '\0' ;

				fill_disk(n_disk, device, atoi(digit), dk) ;

				n_disk++ ;
			}
		}
	}
#endif
E 5
I 5
#elif	mips
	for(i = 0; i < n_disk ; i++)
		disk[i].mon_mspw = 0.0 ;
#endif
E 5
}

D 5
#ifdef	mips

#include <ctype.h>

E 5
/*
 *	Fill a disk structure.
 */
D 8
fill_disk(i, name, unit, dk)
D 5
int	i, unit, dk ;
E 5
I 5
unsigned i ;
E 8
I 8
static fill_disk(current, name, unit, dk)
unsigned current ;
E 8
int	unit, dk ;
E 5
char	*name ;
{
D 8
	disk[i].mon_length = MON$S_DISK ;
	disk[i].mon_type = MON$C_DISK ;
D 3
	disk[i].mon_flag = 1 ;
E 3
I 3
	disk[i].mon_flag = MON$M_VALID ;
E 8
I 8
	register i ;
E 8
E 3

D 8
	disk[i].mon_index = i ; 
	disk[i].mon_dk = dk ;
	disk[i].mon_unit = unit ;
	disk[i].mon_name[DEV_SIZE] = '\0' ;
E 8
I 8
	/*
	 *	Prevent duplicate disk names, whether the user
	 *	wants them or not.
	 */
	for(i = 0; i < current; i++) {
		if( unit == disk[i].mon_unit && strcmp(name, disk[i].mon_name) == 0 )
			return 0 ;
	}
E 8

D 8
	(void)strcpy(disk[i].mon_name, name) ;
E 8
I 8
	disk[current].mon_length = MON$S_DISK ;
	disk[current].mon_type = MON$C_DISK ;
	disk[current].mon_flag = MON$M_VALID ;

	disk[current].mon_index = i ; 
	disk[current].mon_dk = dk ;
	disk[current].mon_unit = unit ;
	disk[current].mon_name[DEV_SIZE] = '\0' ;

	(void)strcpy(disk[current].mon_name, name) ;

	return 1 ;
E 8
}

/*
 *	A device name is supposed to have a series of non-digits
 *	followed by a series of digits (rz0, ra1, foobar666).
 *
 *	This function return the address of the first digit or
 *	NULL if there isn't one.
 */
char	*find_digit(name)
char	*name ;
{
	register char *p ;

	if( name == NULL )
		panic("NULL device name in find_digit().\n", module) ;

	for(p = name; *p != '\0'; p++)
		if( isdigit(*p))
			return p ;

	info("Device name doesn't contain a digit: %s.\n", module, name) ;

	return NULL ;
}
D 5
#endif
E 5
I 2

E 2
/*
 *	Read UNIBUS device names from kernel.
 *
 *	To simplify the view of the world Ultrix seems to think that
 *	there are two kinds of busses.  The MASSBUS and the UNIBUS.
 *	All Q-BUS devices and most VAXBI nodes are made to look like
 *	UNIBUS devices.  For example:
 *
 *		The KDA50 looks like a UDA50.
 *		The KDB50 looks like a UDA50 on its own UNIBUS.
 *
 *	Since there must be an exception to this rule the PMAX chose 
 *	not to maintain this tradition.  It is quite true since the 
 *	PMAX is a busless machine.  So are the VS2000, MicroVAX 2000 
 *	and PVAX.  At least in the case of the VS2000 the tradition 
 *	has worked quite well and >>>I<<< don't see the need to change 
 *	it since it just complicted the way monitor must handle such 
 *	things.
 */

/*
 *	Walk through the UNIBUS device list.
 */
D 5
uba_devices(op)
E 5
I 5
uba_disks(op)
E 5
OPTION	*op ;
{
D 5
#ifdef	vax
E 5
	struct	uba_device uba_device, *up ;
	char	device[DEV_SIZE+1] ;
	int	unit ;

	device[DEV_SIZE] = '\0' ;

	/*
	 *	Make sure the beginning of the list is a reasonable
	 *	place.
	 */
	if((up = (struct uba_device *)namelist[NM_UBDINIT].n_value) == 0 )
		return ;

	for ( ; ; ) {
		/*
		 * Read the next uba_device structure from the kernel.
		 */
		readk((long)up++, (char *)&uba_device, sizeof(uba_device));

		/*
		 * If the driver entry is 0, then we're at end of the list.
		 */
		if( uba_device.ui_driver == 0 )
			break ;

		/*
		 *	If the dk and slave number is -1 then
		 *	the device is probably a communication
		 *	device that we're not interested in.
		 */
		if( uba_device.ui_dk == -1 || op->opt_disk == 0 )
			continue ;

		/*
		 *	Read the device name and save the unit number.
		 */
		readk((long)uba_device.ui_devname, device, DEV_SIZE);

		unit = uba_device.ui_unit ;

		/*
		 *	If the device is not "alive" goto the next device.
		 */
		if( !uba_device.ui_alive )
			continue ;

		/*
		 *	See if this is an "interesting" device.
		 */
		if( find_value(&disk_list, device, unit) == 0 )
			continue ;

D 5
		disk[n_disk].mon_length = MON$S_DISK ;
		disk[n_disk].mon_index = n_disk ;
		disk[n_disk].mon_type = MON$C_DISK ;
D 3
		disk[n_disk].mon_flag = 1 ;
E 3
I 3
		disk[n_disk].mon_flag = MON$M_VALID ;
E 5
I 5
		if( uba_device.ui_dk >= 0 && uba_device.ui_dk < DK_NDRIVE )
			dk_map[uba_device.ui_dk] = 1 ;
E 5
E 3

D 5
		disk[n_disk].mon_name[DEV_SIZE] = '\0' ;

		(void)strcpy(disk[n_disk].mon_name, device);

		disk[n_disk].mon_dk = uba_device.ui_dk ;
		disk[n_disk].mon_unit = unit ;

E 5
I 5
D 8
		fill_disk(n_disk, device, unit, uba_device.ui_dk) ;
E 5
		n_disk++ ;
E 8
I 8
		if( fill_disk(n_disk, device, unit, uba_device.ui_dk) == 1 )
			n_disk++ ;
E 8
	}
D 5
#endif
E 5
}

/*
 *	Walk down the MASSBUS device list.
 */
D 5
mba_devices()
E 5
I 5
mba_disks()
E 5
{
D 5
#ifdef	vax
E 5
	struct	mba_device mba_device, *mp ;
	struct	mba_driver driver ;
	char	device[DEV_SIZE+1] ;

	/*
	 *	Make sure the beginning of the list is a reasonable
	 *	place to start.
	 */
	if((mp = (struct mba_device *)namelist[NM_MBDINIT].n_value) == NULL )
		return ;

	for( ; ; ) {
		/*
		 *	Read the next mba_device structure.
		 */
		readk((long)mp++, (char *)&mba_device, sizeof(mba_device));

		/*
		 *	If the driver entry is 0 then we're done.
		 */
		if( mba_device.mi_driver == 0 )
			break ;

		/*
		 *	The only type of interesting MASSBUS "device" are
		 *	disks, so skip the device if it's dk number is -1.
		 */
		if( mba_device.mi_dk == -1 )
			continue ;

		/*
		 *	Read the driver structure and device name.
		 */
		readk((long)mba_device.mi_driver, (char *)&driver, sizeof(driver));

		readk((long)driver.md_dname, (char *)device, DEV_SIZE);

		/*
		 *	If the device isn't alive skip it.
		 */
		if( !mba_device.mi_alive )
			continue ;

		/*
		 *	Check to see if this is an interesting device.
		 */
		if( find_value(&disk_list, device, mba_device.mi_unit) == 0 )
			continue ;

I 5
		if( mba_device.mi_dk >= 0 && mba_device.mi_dk < DK_NDRIVE )
			dk_map[mba_device.mi_dk] = 1 ;

D 8
		fill_disk(n_disk, device, mba_device.mi_unit, mba_device.mi_dk) ;
		n_disk++ ;
E 8
I 8
		if( fill_disk(n_disk, device, mba_device.mi_unit, mba_device.mi_dk) == 1 )
			n_disk++ ;
E 8
	}
}

/*
 *	Life gets interesting.  The disks on the PMAX don't like
 *	disks on previous version so a lot of hand waving must
 *	take place.  This is how monitor will behave (or misbehave).
 *
 *	If a disk is on the command line list of "interesting" disks
 *	then monitor will collect data for it, EVEN IF it doesn't
 *	appear active (the user knows best).  The only requirement
 *	is that the disk name must be "rz" or "dk" and the dk number
 *	be less than DK_NDRIVE.
 *
 *	If the list is empty then the only drives that will be watched
 *	are those that appear active.  Active in this case means that
 *	the number transfers are non-zero.  (Note: iostat(1) uses the
 *	number of words tranfered as the criteria, but that's bogus
 *	because the number of words transfered has a better chance of
 *	rolling over and there can appear to be zero even though it's
 *	not.  Very unlikely, but possible).
 */
scsi_disks()
{
	register i, dk ;
	char	 device[DEV_SIZE+1], *digit, *name, *find_digit() ;

	/*
	 *	If the list is empty.
	 */
	if( disk_list.nel == 0 ) {
E 5
		/*
D 5
		 *	Save the static device information.
E 5
I 5
		 *	Get the transfer data struture.
E 5
		 */
D 5
		disk[n_disk].mon_length = MON$S_DISK ;
		disk[n_disk].mon_index = n_disk ;
		disk[n_disk].mon_type = MON$C_DISK ;
D 3
		disk[n_disk].mon_flag = 1 ;
E 3
I 3
		disk[n_disk].mon_flag = MON$M_VALID ;
E 5
I 5
		readk((long)namelist[NM_DK_XFER].n_value, (char *)dk_xfer,
			sizeof(dk_xfer)) ;
E 5
E 3

D 5
		disk[n_disk].mon_name[DEV_SIZE] = '\0' ;
E 5
I 5
		for(i = 0; i < DK_NDRIVE; i++) {
			if( dk_map[i] || dk_xfer[i] == 0 )
				continue ;
E 5

D 5
		(void)strcpy(disk[n_disk].mon_name, device);
	
		disk[n_disk].mon_dk = mba_device.mi_dk ;
		disk[n_disk].mon_unit = mba_device.mi_unit ;

		n_disk++ ;
E 5
I 5
D 8
			fill_disk(n_disk, "rz", i, i) ;
			n_disk++ ;
E 8
I 8
			if( fill_disk(n_disk, "rz", i, i) == 1 )
				n_disk++ ;
E 8
		}
E 5
	}
D 5
#endif
E 5
I 5
	/*
	 *	Other use the command line list.
	 */
	else {
		for(dk = 0; dk < disk_list.nel; dk++) {
			name = disk_list.base[dk] ;

			if((digit = find_digit(name)) != NULL ) {
				for(i = 0; name[i] != *digit && i < DEV_SIZE; i++)
					device[i] = name[i] ;

				device[i] = '\0' ;

				/*
				 *
				 */
				if( allow_devices(device) == 0 )
					continue ;

D 8
				fill_disk(n_disk, device, atoi(digit), dk) ;
				n_disk++ ;
E 8
I 8
				if( fill_disk(n_disk, device, atoi(digit), dk) == 1 )
					n_disk++ ;
E 8
			}
		}
	}
}

/*
 *	List of devices to be allowed from the command line.
 */
static char *allowed_list[] = {
	"dk",
	"rz",
	"tz",
} ;

allow_devices(name)
char	*name ;
{
	register i ;

	for(i = 0; i < sizeof(allowed_list)/sizeof(allowed_list[0]); i++)
		if( strcmp(name, allowed_list[i]) == 0 )
			return 1 ;

	return 0 ;
E 5
}
E 1
