extproc perl -S -x

#!perl

sub move_if_change { system "move-if-change @_[0] @_[1]"; }
&move_if_change("config/i386/xm-os2.h", "config.h");
&move_if_change("config/i386/xm-os2.h", "hconfig.h");
&move_if_change("config/i386/xm-os2.h", "tconfig.h");
&move_if_change("config/i386/os2.h", "tm.h");
&move_if_change("config/i386/i386.md", "md");
&move_if_change("config/i386/i386.c", "aux-output.c");

open (MAKEFILE, ">Makefile");

print MAKEFILE <<MAKESTART;
# Makefile generated by "configure.cmd"
.PHONY: all install objc.lib clean clean.os2 clean.unix
all: xgcc.exe cccp.exe xcc1.exe cc1plus.exe cc1obj.exe gcc.lib objc.lib float.h-nat
install:
	cp cccp.exe /gcc2/bin/cpp.exe
	cp xcc1.exe /gcc2/bin/cc1.exe
	cp xgcc.exe /gcc2/bin/gcc.exe
	cp cc1plus.exe cc1obj.exe /gcc2/bin
	cp gcc.lib /gcc2/lib/gcc.lib
	rm -f /gcc2/gccincl/float.h
	cp float.h-nat /gcc2/gccincl/float.h
	make -C objc -fmakefile.os2 install
objc.lib:
	\$(MAKE) -C objc -fmakefile.os2 objc.lib
clean: clean.os2 clean.unix
clean.os2:
	-rm -f gcc.lib
	\$(MAKE) -C objc -fmakefile.os2 clean
.SUFFIXES: .obj
LDFLAGS=-static
MAKESTART

open (VERSION, "<version.c");
$x = <VERSION>;
close (VERSION);
if ($x =~ /^[^\"]*\"([^\"]+)\"[^\"]*$/) {
    $version = $1;
} else {
    print STDERR "Unable to parse version.c!  Aborting...\n";
    exit 1;
}

open (MAKEFILE_IN, "<Makefile.in");
while (<MAKEFILE_IN>)
{
    s/^\s*clean\s*:/clean.unix:/;
    s/config.status// if (/\.o\s*:/);
    $_ = "target=gcc\n" if (/^target=/);
    s/^xmake_file=.*/xmake_file=i386\/xm-os2.h/;
    s/^tmake_file=.*/tmake_file=i386\/os2.h/;
    $_ = "version=$version\n" if (/^version=/);
    s/CC = cc/CC = gcc/;
    s/^USE_ALLOCA=.*/USE_ALLOCA=/;
    s/^USE_HOST_ALLOCA=.*/USE_HOST_ALLOCA=/;
    s/^USE_HOST_MALLOC=.*/USE_HOST_MALLOC=/;
    s/^USE_HOST_OBSTACK=.*/USE_HOST_OBSTACK=\${HOST_PREFIX}\${HOST_OBSTACK}/;
    s/\`echo \$\(srcdir\)\///g;
    s/ \| sed \'s,\^\\\.\/..\'\`//g;
    s/^\tcd \$\(srcdir\)\s*;/\t/;

    s/\$\(GCC_PARTS\)//g if (/^enquire\s*:/);
    s/\$\(GCC_PASSES\)//g if (/^enquire.o\s*:/);
    $_ = "GCC_FOR_TARGET = gcc\n" if (/^GCC_FOR_TARGET =/);
    s/;\s*@true//;
    s/-D([^=]+=)\\(\".*)\\(\")/-D$1$2$3/g;
    s/\.o/.obj/g;
    s/^\t\.\//\t/;
    s/^\t-\.\//\t-/;
    s/^\t\$\(srcdir\)\//\t\$\(srcdir\)\\/;
    s/\b(gen[a-z]+|cc1plus|cc1obj|cccp|xgcc)($|\b[^.])/$1.exe$2/g;
    s/\b(cc1)($|\b[^.])/x$1.exe$2/g;
    s/^CFLAGS = -g$/CFLAGS = -O2 -D__BSD_NET2__/g;
    s/\blibgcc2\.a\b/gcc.lib/g;
    s/all\s*:/unix.all:/;
    s/install\s*:/unix.install:/;
    s/libgcc2.ready// if (/^gcc.lib:/);
    s/\benquire\b([^\\.])/enquire.exe$1/;

    if (/^stamp-attrtab/) {
	print MAKEFILE $_;
	while (<MAKEFILE_IN>) {
	    last if (/move-if-change/);
	    next if (/\\/ || /fi/);
	    die "Configure needs updating\n";
	}
	print MAKEFILE "\tgenattrtab md > tmp-attrtab.c\n";
	redo;
    }

    if (/^gcc\.lib\s*:/) {
	while (/\\$/) {
	    s/config.status//;
	    print MAKEFILE $_;
	    $_ = <MAKEFILE_IN>;
	}
	s/config.status//;
	print MAKEFILE $_;
	print MAKEFILE <<BUILD_LIBGCC2;
	rm -f gcc.lib
	\$(foreach name, \$(LIB2FUNCS), echo Building \$(name)...; \$(GCC_FOR_TARGET) \$(LIBGCC2_CFLAGS) \$(INCLUDES) -c -DL\$(name) \$(srcdir)/libgcc2.c -o \$(name).obj;)
	glib gcc.lib \$(addprefix -a , \$(addsuffix .obj,\$(filter-out _exit, \$(filter-out __main, \$(LIB2FUNCS)))))
BUILD_LIBGCC2
	while (<MAKEFILE_IN>) {
	    next if (/^\s*#/ || /^\t/);
            last;
	}
    }

    print MAKEFILE $_;
}
close (MAKEFILE_IN);
close (MAKEFILE);

# Now fix up the makefile in the objc directory
open (MAKEFILE_IN, "<objc/Makefile");
open (MAKEFILE, ">objc/Makefile.os2");
print MAKEFILE <<OBJMAKEFILE;
# This file is generated automatically by ../configure.cmd
# DO NOT EDIT THIS FILE
srcdir=..
.PHONY: install
install: copy-headers
	cp objc.lib /gcc2/lib
OBJMAKEFILE
while (<MAKEFILE_IN>)
{
    s/\.o\b/.obj/g;
    s/libobjc\.a/objc.lib/g;
    s/\$\(GCC_FOR_TARGET\)/gcc -D__BSD_NET2__/g;

    if (/^copy-headers:/) {
	print MAKEFILE $_, <<OBJCOPYHEADERS;
	-rm -rf /gcc2/objcincl/objc
	mkdir \\gcc2\\objcincl\\objc
	cp \$(OBJC_H) /gcc2/objcincl/objc
OBJCOPYHEADERS
	while (<MAKEFILE_IN>) {
	    last if (!/^\t/);
	}
	redo;
    }

    if (/^all:/) {
	print MAKEFILE $_, "\t\$(MAKE) -C .. objc.lib";
	while (<MAKEFILE_IN>) {
	    last if (!/^\t/);
	}
	redo;
    }

    $_ = "\tglib $1 \$(addprefix -a , $2)\n"
	if (/^\t\$\(AR\)\s+rc\s+(\S+)\s+(.*)$/);

    print MAKEFILE $_;
}
close (MAKEFILE_IN);
close (MAKEFILE);

0;
