/*
** Arr_fake.t contains fake items, items which aren't real and exist only
** so that the player can ask other people about them.
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

// This is the ship which can be seen through the house windows
fake_ship: distantItem, floatingItem
    noun = 'ship' 'spaceship'
    adjective = 'silvery'
    location = {
        if (Me.location.hasShip)
            return Me.location;
        return nil;
    }
    sdesc = "silvery spaceship"
    ldesc = "It hunkers down on your lawn, its glinting surface barely
        dulled by the gigantic distances the ship must have come. "
    verIoTellAbout(actor) = {}
    verIoAskAbout(actor) = {}
    verDoWhatis(actor) = { "It&rsquo;s a spaceship. "; }
;

// The fake ho-hos exist so that the player can ask people for/about them
fake_hohos: item
    noun = 'ho-hos' 'ho-ho' 'hohos' 'hoho'
    sdesc = "ho-hos"
    ldesc = "Pay no attention to those ho-hos which you shouldn't be able to
        see. <i>{Error}</i> "
    whatdesc = "Ho-hos are chocolate snack cakes wrapped around a filling of
        ooey gooey creme goodness. "
;

// Some wiseacre player may want to look at the missing mosquitos in the back
//  yard
fake_mosquitos: fixeditem
    noun = 'mosquito' 'mosquitos' 'mosquitoes'
    location = backyard
    sdesc = "mosquitos"
    ldesc = "Thankfully, there aren&rsquo;t any out tonight. They must be at
        some mosquito picnic or something.\b
        Come to think of it, aren&rsquo;t you normally their picnic? "
    whatdesc = "Biting, parasitic insects which drink blood. "
    dobjGen(a, v, i, p) = {
        if (v != askVerb && v != tellVerb && v != inspectVerb && !v.issysverb) {
            "There aren&rsquo;t any mosquitos out tonight. Don&rsquo;t press
                your luck by thinking too much about them. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

// fake_water exists only to let the player type "turn on water" in the
// backyard. It's a floatingItem as well.
fake_water: fixeditem, floatingItem
    noun = 'water'
    location = {
        if (!backyard_faucet.ison || (garden_hose.attachedToFaucet &&
            garden_hose.attachedToShip))
            return backyard;
        return nil;
    }
    sdesc = "water"
    ldesc = "There&rsquo;s no water here. "
    doTurnon -> backyard_faucet
    doTurnoff -> backyard_faucet
    dobjGen(a, v, i, p) = {
        "I don't see any water here. ";
        exit;
    }
    iobjGen(a, v, d, p) = {
        "I don't see any water here. ";
        exit;
    }
;

// A group of things for the player to ask about
fake_captain: item
    noun = 'dangerous'
    adjective = 'captain' 'cap\'n'
    sdesc = "Captain Dangerous"
    ldesc = "You are obviously disobeying your parents if you can see the
        Cap&rsquo;n. <i>{Error}</i> "
    verDoWhatis(actor) = { "\^<<self.thedesc>> <<self.isdesc>>n&rsquo;t
        really a what. "; }
    verDoWhois(actor) = {}
    doWhois(actor) = (self.whodesc)
    whodesc = "Cap&rsquo;n is the greatest astronaut ever. He does stuff
        you&rsquo;d kill to do. And he probably never has to wash dishes. "
;

fake_billy_bob: item
    noun = 'bob' 'sidekick'
    adjective = 'billy'
    sdesc = "Billy Bob"
    ldesc = "You are obviously disobeying your parents if you can see Billy
        Bob. <i>{Error}</i> "
    verDoWhatis(actor) = { "\^<<self.thedesc>> <<self.isdesc>>n&rsquo;t
        really a what. "; }
    verDoWhois(actor) = {}
    doWhois(actor) = (self.whodesc)
    whodesc = "Billy Bob helps Captain Dangerous fight the forces of evil and
        godless socialism whereever they appear. "
;

fake_couches: fixeditem
    isThem = true
    noun = 'couch' 'couches'
    location = slumber_chamber
    sdesc = "couches"
    ldesc = "I said the ovoids are the size of couches, not that they
        are couches. Good grief. "
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb)
        {
            "There aren&rsquo;t any couches for you to interact with,
                really. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) =
    {
            "There aren&rsquo;t any couches for you to interact with,
                really. ";
        exit;
    }

;

