/*
** GndDeb.t holds all the definitions etc. for Deb
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

debMe: basicMe
    sdesc_pointer = &d_sdesc
    ldesc_pointer = &d_ldesc
    ldesc1_pointer = &d_ldesc1
    kitchenFoundBillfold = nil // Did Deb find billfold for Jeanie?
    kitchenPresetBag = nil     // Bag's loc in the kitchen when Deb enters
    jeanieGone = nil           // Has Jeanie left the building?
    jeanieActionList = []
    pendingAction = ''
    currentAction = 1          // Which action we're looking at
    acceptingActions = nil
    justTalkedToJeanie = nil   // Did Deb initiate conversation?
    actionChunk = 2            // Max actions we'll chunk together
    talkedToFrank = nil        // Have I tried talking to Frank?
    heardHorn = nil            // Have I heard April honk for Jeanie?
    jMentionedDinner = nil     // Has Jeanie reminded us about dinner?
    promptedJeanie = nil       // Did I ask Jeanie to put up groceries?
    jPutUpGroceriesB4 = nil    // Have I checked to see if I asked Jeanie
                               //  to put up the groceries?
    toldJAboutRoast = nil      // Did I mention the roast to Jeanie?
    jRespondedToRoast = nil    // If so, did she say thanks?
    // jeanieTalkList is the list of conversation threads w/Jeanie
    jeanieTalkList = [ &conversationj3, &conversationj4a ]
    jeanieCurrentTalk = 1      // Which possible conversation thread w/Jeanie
                               // are we on?
    kludgyFlagIClear = true    // Print a '\b' in frankAsksAboutJeanie()?

    d_sdesc = "you"
    d_ldesc = {
	"Your slacks have seen better days, but you were only going
	 to the Piggly Wiggly. ";
	if (carried_groceries.location == self)
	    "Your arms are filled with sacks from the store. ";
    }
    frankAsksAboutJeanie = {
	if (parserGetMe() != debMe)  // In case we double-tap
	    return;
	if (kludgyFlagIClear)
	    "\b";
	"A cough at the door makes you turn around. Frank's there,
	 leaning against the frame. <q>Did, um, did Jeanie say where
	 she was going?</q>
	 \b<q>Not really.</q> These days, does she ever? When she gets
	 back you'll have to talk to her about it.\b";
	reprepareForJeanie();
    }
    queueAction(act) = {
	if (!global.pauseRecorder && self.acceptingActions) {
	    // If we have a horn honk or roast mention in the queue, write
	    // it instead of dumping it
	    if (substr(self.pendingAction, 1, 1) == 'H' ||
		substr(self.pendingAction, 1 ,1) == 'R')
		self.addAction;
	    self.pendingAction = act;
	}
    }
    addAction = {
	if (self.pendingAction != '') {
	    self.jeanieActionList += self.pendingAction;
	    self.pendingAction = '';
	}
	else {
	    if (jeanieMe.isIn(kitchen))
		self.jeanieActionList += 'Z';  // Z for wait
	    else self.jeanieActionList += 'A'; // A for absent
	}
    }
    conversationTookPlace(code) = {
	local i = self.currentAction, len = length(self.jeanieActionList);

	while (i < self.currentAction + 3 && i <= len &&
	       self.jeanieActionList[i] != code)
	    i++;
	return (i <= len && self.jeanieActionList[i] == code);
    }
    advanceJResponses = {
	local i = 0, ch = '', action, len = length(self.jeanieActionList);
	local loop = true, randNum;

	if (self.currentAction > len || parserGetMe() != self) {
	    unnotify(self, &advanceJResponses);
	    return;
	}

	// Deb skips over chunks of 'A' and 'Z'
	while (i < self.actionChunk && loop &&
	       self.currentAction + i <= len) {
	    loop = nil;          // Reset the looping flag
	    action = self.jeanieActionList[self.currentAction + i];
	    ch = substr(action, 1, 1);
	    switch (ch) {
	      case 'A':          // Jeanie's not here
	      case 'Z':          // Jeanie waits around
		loop = true;
		break;
	      case 'L':          // Jeanie leaves
		jeanie.moveInto(nil);
		"\bJeanie heads out of the kitchen. ";
		break;
	      case 'E':          // Jeanie enters
		jeanie.moveInto(kitchen);
		"\bJeanie comes slouching into the room. ";
		break;
	      case 'P':          // Jeanie picks up bag
		flowerdy_bag.moveInto(jeanie);
		"\bJeanie picks up her flowery bag";
		if (_rand(100) < 40)
		    " and slings it over her shoulder";
		". ";
		break;
	      case 'G':          // Jeanie puts up groceries
		"\bJeanie <<(_rand(100) < 40) ? 'grabs' : 'picks up'>> some
		 of the groceries and puts them ";
		if (_rand(100) < 30) {
		    randNum = _rand(100);
		    if (randNum < 25)
			"in the refrigerator";
		    else if (randNum < 50)
			"up";
		    else if (randNum < 75)
			"in the cabinets";
		    else "on the counter";
		}
		else "away";
		". ";
		if (!self.jPutUpGroceriesB4) {
		    self.jPutUpGroceriesB4 = true;
		    if (!self.promptedJeanie)
			"You didn't even have to ask her to. ";
		}
		break;
	      case 'B':          // Jeanie has left the building
		"\bYou hear Jeanie go clomping out the front door. She
		 slams it shut hard enough to make the dishes shake. Was
		 she mad? ";
		notify(self, &frankAsksAboutJeanie, 2);
		self.jeanieGone = true;
		break;
	      case 'H':          // April honks her horn
		self.heardHorn = true;
		switch (substr(action, 2, 1)) {
		  case '0':      // First honk; we talk to Jeanie
		  case '1':      // First honk
		    "\bOutside you hear someone honking. Jeanie's ride
		     must be here. ";
		    if (substr(action, 2, 1) == '0')
			"<q>You have a good time tonight, okay?</q> you
			 tell her. ";
		    break;
		  case '2':      // Second honk
		    "\bThe car horn honks again. Jeanie needs to get out
		     there before that horn disturbs the whole
		     neighborhood. ";
		    break;
		  case '3':      // Third honk
		    "\bWhoever is giving Jeanie a ride honks for a while.
		     You hear the Winstons' dog start barking next door.
		     <q>Coming!</q> Jeanie yells, as if she can be heard
		     over the horn. On her way out she slams the door hard
		     enough to make the dishes shake. ";
		    notify(self, &frankAsksAboutJeanie, 2);
		    self.jeanieGone = true;
		    break;
		}
		break;
	      case 'D':          // Jeanie drops her bag
		"\bJeanie ";
		switch (substr(action, 2, 1)) {
		  case 'K':      //  ...in kitchen
		    flowerdy_bag.moveInto(kitchen);
		    "dumps her <<flowerdy_bag.sdesc>> on the floor. ";
		    break;
		  case 'T':      //  ...on the table
		    flowerdy_bag.moveInto(kitchen_table);
		    "puts her <<flowerdy_bag.sdesc>> on the table,
		     pushing the groceries aside. ";
		    break;
		  case 'C':      //  ...on the counter
		    flowerdy_bag.moveInto(kitchen_counters);
		    "lifts her <<flowerdy_bag.sdesc>> onto the
		     counters. ";
		    break;
		}
		break;
	      case 'R':          // Deb mentions the roast to Jeanie
		if (jeanie.location == kitchen) { // Just to be sure
		    if (self.jMentionedDinner)
			"\bEven if Jeanie won't be here for dinner,
			 she can have leftovers later. ";
		    else "\bSeeing Jeanie standing there reminds you
			  about dinner, which she's going to miss.
			  Again. ";
		    "<q>I'll leave you some roast for dinner when
		     you get back, ok?</q> Jeanie just nods in
		     response. ";
		}
		break;
	      case 'C':          // Jeanie talks to Deb
		switch (substr(action, 2, 1)) {
		  case '1':      // "What'd you get at the store?"
		    if (self.justTalkedToJeanie)
			i--;     // Since we just talked to Jeanie,
		                 // wait a turn before talking
		    else {
			"\b<q>What all'd you get at the store?</q> Jeanie
			 asks, rooting around in the sacks. ";
			self.setResponse(&conversationj1a, jeanie);
		    }
		    break;
		  case '2':      // The supper conversation
		    switch (substr(action, 3, 1)) {
		      case 'a':  // "Won't be here for supper."
			if (self.justTalkedToJeanie)
			    i--; // Since we just talked to Jeanie,
			         // wait a turn before talking
			else {
			    "\b<q>You know I won't be here for supper,
			     right?</q> Jeanie tells you. ";
			    self.jMentionedDinner = true;
			    self.setResponse(&conversationj2a, jeanie);
			}
			break;
		      case 'b':  // "But I *do* eat here!
			if (deb.respondedTod2a)  // Already responded
			    break;
			"\b<q>Right?</q> Jeanie says again.
			 \b<q>I know,</q> you say. How could you forget?
			 She's seldom here for dinner these days. <q>Too
			 bad you'll miss dinner again.</q>
			 \b<q>Uh!</q> Jeanie pouts. <q>I eat here a
			 lot!</q> ";
			self.setResponse(&conversationj2b, jeanie);
			break;
		      case 'c':   // "I can't be here all the time."
			if (deb.respondedTod2b)
			    break;
			"\b<q>I do, you know,</q> Jeanie mutters.
			 \b<q>I know,</q> you sigh. <q>I can't help it that
			 I like us to eat together as a family.</q>
			 \bJeanie snorts. <q>Right. Like a family.</q> ";
			self.clearResponse;
			break;
		    }
		    break;
		}
		break;
	    }
	    i++;
	}
	self.currentAction += i;
	// The 'just talked to' flag can now be reset
	self.justTalkedToJeanie = nil;
    }
    talkTo(person) = {
	if (self.makeResponse(person)) return;
	if (person == frank) {
	    if (!self.talkedToFrank) {
		"<q>Frank? I'm back, Frank.</q> He's working so hard on
		 that broken toaster that he doesn't hear you. ";
		self.talkedToFrank = true;
	    }
	    else "You stop yourself just before you say anything else
		  to Frank. He's got a better chance of finishing the
		  toaster tonight if you don't bother him. ";
	    return;
	}
	if (person == jeanie) {
	    if (self.heardHorn)
		"She's about to leave. Anything you've got to say will
		 have to wait until she gets home. ";
	    else if (self.jeanieCurrentTalk > length(self.jeanieTalkList))
		"She seems so distracted, it's probably best just to let
		 her be for now. ";
	    else {
		self.(self.jeanieTalkList[self.jeanieCurrentTalk]);
		self.jeanieCurrentTalk++;
	    }
	}
	else if (person == self)
	    "You had an aunt once who talked to herself, and she ended
	     up having to be locked away. ";
	else "Hey! How come you can talk to <<person.sdesc>>?
	      <i>{Error}</i>. ";
    }
    askFrankAboutBoots = {
	if (!self.talkedToFrank) {
	    "<q>Frank? You left your boots out again, Frank.
	     Frank?</q> He\'s so absorbed in that toaster that he
	     doesn\'t even hear you. ";
	    self.talkedToFrank = true;
	}
	else "You stop yourself just before you say anything else to
	      Frank. He's got a better chance of finishing the
	      toaster tonight if you don't bother him. ";
	return true;
    }
    askJeanieForHelp = {
	if (self.jPutUpGroceriesB4)   // True if Jeanie's put up groceries
	    return nil;               // and if so, don't handle conversation
	"You smile. <q>Care to help me put up the groceries?</q> ";
	// See if Jeanie responded to this question the first time around
	if (self.conversationTookPlace('C0'))
	    "\b<q>Uh, I guess,</q> Jeanie answers. ";
	self.promptedJeanie = true;
	self.clearResponse;
	return true;
    }
    conversationj1a = {
	"<q>Well, for one thing, I got you some Wheat Thins,</q> you
	 tell Jeanie. ";
	self.clearResponse;
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj2a = {
	"<q>I know,</q> you say to Jeanie. How could you forget?
	 She's seldom here for dinner these days. <q>Too bad you'll
	 miss dinner again.</q> ";
	if (self.conversationTookPlace('C2b')) {
	    "\b<q>Uh!</q> Jeanie pouts. <q>I eat here a lot!</q> ";
	    self.setResponse(&conversationj2b, jeanie);
	}
	else self.clearResponse;
	deb.respondedTod2a = true;
	return true;
    }
    conversationj2b = {
	"<q>I know you do,</q> you sigh. <q>I can't help it that I
	 like us to eat together as a family.</q> ";
	if (self.conversationTookPlace('C2c'))
	    "\bJeanie snorts. <q>Right. Like a family.</q> ";
	self.clearResponse;
	deb.respondedTod2b = true;
	return true;
    }
    conversationj3 = {
	"<q>I'll leave some roast in the refrigerator in case you
	 want some when you get home,</q> you say to Jeanie. ";
	if (!self.toldJAboutRoast || self.jRespondedToRoast) {
	    "\bJeanie shrugs. <q>Okay.</q> ";
	    self.setResponse('<q>You\'re welcome.</q> You smile; you know
			      she\'ll be thankful later. ', jeanie);
	}
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj4a = {
	"You ask Jeanie, <q>Where are you going tonight?</q>
	 \bShe glances at the floor. <q>Dunno. Probably just the
	 movies.</q> ";
	self.setResponse(&conversationj4b, jeanie);
	self.justTalkedToJeanie = true;
	return true;
    }
    conversationj4b = {
	"<q>Movies, huh? Well, be sure you dress warmly.</q> That plaid
	 shirt of hers is pretty warm, but her jean shorts won't be much
	 good against the wind. <q>It's supposed to turn chilly tonight.</q>
	 \b<q>I'll be fine,</q> she says. ";
	self.clearResponse;
	self.justTalkedToJeanie = true;
	return true;
    }
;

deb: Actor
    isHer = true
    // Conversation flags for debMe
    respondedTod2a = nil
    respondedTod2b = nil
    noun = 'deb' 'deborah' 'wife' 'mom'
    j_sdesc = "mom"
    f_sdesc = "Deb"
    j_ldesc = {
	"Mom's wearing her plaid summer dress and has her brown
	 hair up in a bun. She's putting groceries away right
	 now. ";
    }
    thedesc = (self.sdesc)
    adesc = (self.sdesc)
    actorDesc = "\^<<self.sdesc>> is here putting groceries away. "
    takedesc = "You can't pick mom up. "
    verDoRub(actor) = {
	if (actor == jeanieMe)
	    "That'd be a little strange. ";
	else "This is one of those things Man Was Not Meant To See.
	      <I>{Error}</I> ";
    }
    enterKitchenWithGroceries = {
	if (self.location != nil)  // We've already shown up in the kitchen
	    return;
	if (jeanieMe.location != kitchen) {
	    notify(self, &enterKitchenWithGroceries, 1);
	    return;
	}
	self.moveInto(kitchen);
	groceries.moveInto(kitchen_table);
	"\bMom comes bustling in the kitchen with a bunch of groceries,
	 which she plops down on the table. <q>Hey, Jeanie,</q> she says. ";
	if (jeanieMe.lookingForBillfold) {
	    "She must see the worried look on your face, because she
	     asks, <q>Oh, are you looking for your billfold? I think
	     it fell down under the table.</q> ";
	    kitchen_table.doLookunder(jeanieMe);
	    debMe.kitchenFoundBillfold = true;
	    // In this case, since we were called by a daemon, the next
	    // turn is one daemon call away.
	    notify(self, &momAsksForHelp, 1);
	}
	// Here, however, the next turn is two daemon calls away.
	else notify(self, &momAsksForHelp, 2);

	// Record if the bag is in the kitchen or in Jeanie, for when the
	// player is later Deb.
	if (flowerdy_bag.isIn(kitchen) && !flowerdy_bag.isIn(jeanieMe))
	    debMe.kitchenPresetBag = flowerdy_bag.location;
	else if (flowerdy_bag.isIn(jeanieMe))
	    debMe.kitchenPresentBag = jeanie;
	debMe.acceptingActions = true;  // Turn on action recording

	notify(self, &mentionRoast, 10);
	notify(jeanieMe, &hearHorn, 15);
    }
    momAsksForHelp = {
	if (jeanieMe.helpCount > 0)
	    return;
	if (jeanieMe.location != kitchen) {
	    notify(self, &momAsksForHelp, 1);
	    return;
	}
	"\b<q>Could you help me put the groceries up?</q> mom asks you. ";
	jeanieMe.setResponse(&conversationd0, deb);
    }
    mentionRoast = {
	if (jeanieMe.location != kitchen) {
	    if (jeanieMe.location != nil)   // We've still got a chance
		notify(self, &mentionRoast, 1);
	    return;
	}
	"\bMom says, <q>Jeanie dear, I'm making roast tonight. If
	 you're still hungry when you get home, there should be some
	 left in the fridge.</q> ";
	jeanieMe.setResponse(&conversationdr, deb);
	debMe.toldJAboutRoast = true;
    }
    verDoHelp(actor) = {
	if (actor == frankMe)
	    "This shouldn't happen. <i>{Error}</i>";
    }
    doHelp(actor) = {
	execCommand(actor, takeVerb, groceries, nil, nil, 0);
    }
    verDoKiss(actor) = {
	if (actor == jeanieMe) {
	    if (actor.hornCount == 0)
		"You love your mom and all, but still, it's not like you're
		 leaving right now or anything. ";
	    else if (actor.kissedDeb)
		"Um, once was probably enough. ";
	}
    }
    doKiss(actor) = {
	"You lean forward to hug mom and give her a kiss on her
	 cheek. She smiles at you. ";
	actor.kissedDeb = true;
    }
    verDoTouch(actor) = {
	if (actor == jeanieMe)
	    "Um, that's kind of weird. ";
	else pass verDoTouch;
    }
    ioGiveTo(actor, dobj) = {
	if (actor == jeanieMe)
	    "There's nothing you really want to give her. ";
    }
    ioSynonym('GiveTo') = 'ThrowTo'
    verDoAttack(actor) = {
	if (actor == jeanieMe)
	    "She bugs you sometimes, but you just can't see hitting
	     her. ";
    }
    doSynonym('Attack') = 'Kick' 'Push' 'Pull' 'Poke'
    verIoThrowAt(actor) = ( self.verDoAttack(actor))
;

// Here's where we do everything we need to do to the house in order to
// prepare for switching the player from Frank to Deb
prepareForDeb: function
{
    toaster.moveInto(nil);
    junk_box.moveInto(nil);
    screwdriver.moveInto(nil);
    multimeter.moveInto(nil);
    stereo_power_cord.moveInto(nil);
    frank_fridge_food.moveInto(nil);
    fake_billfold.moveInto(nil);

    broken_appliances.moveInto(little_desk);
    broken_toaster.moveInto(little_desk);

    franks_boots.moveInto(living_room);
    carpet_paths.moveInto(living_room);
    banister.moveInto(nil);

    single_can.moveInto(nil);

    fridge_contents.moveInto(refrigerator);

    unnotify(frankMe, &advanceJResponses);
    frankMe.respondingToJeanie = nil;

    frankMe.moveInto(nil);
    jeanie.moveInto(kitchen);
    frank.moveInto(living_room);
    parserSetMe(debMe);
    debMe.moveInto(garage);

    morePrompt();
    clearscreen();
    if (global.canDoGraphics)
	gprintf('three.png', 'alt="Three"');
    else "\(Three\)\n";
    "\nThe nice thing about going grocery shopping this late is that
     the store isn't too crowded and you can check out quickly. It would
     have been better if Julie Morgan hadn't been there, making those snide
     comments of hers, but all in all it wasn't too bad. Now maybe Frank or
     Jeanie can help you put the groceries away.\b";
    execCommand(debMe, lookVerb, nil, nil, nil, 0);
}

franks_boots: fixeditem
    triedToTake = nil
    noun = 'boot' 'boots' 'shoe' 'shoes'
    adjective = 'frank\'s' 'steel-toed'
    location = living_room
    sdesc = "steel-toed boots"
    j_ldesc = "Frank's always leaving his boots around. "
    d_ldesc = "Frank's left his boots in the middle of the floor again. "
    takedesc = {
	if (actorObject() == jeanieMe) {
	    "What for? ";
	    return;
	}
	"No. Absolutely not. You've asked him time and time again
	 to put those boots away when he gets home, and if you
	 pick them up, he'll never learn to do it himself. ";
	if (!self.triedToTake) {
	    self.triedToTake = true;
	    debMe.setResponse(&askFrankAboutBoots, frank);
	}
    }
    heredesc = {
	if (parserGetMe() == debMe)
	    "\n\tFrank's boots are sitting in the middle of the floor
	     again. ";
    }
    verDoWear(actor) = {
	if (actor == jeanieMe)
	    "Ew. They're all stinky. ";
	else "No. Definitely not. ";
    }
;

key_ring: keyItem
    noun = 'ring' 'key' 'keys'
    adjective = 'key' 'your'
    location = debMe
    sdesc = "key ring"
    adesc = "your key ring"
    thedesc = "your key ring"
    ldesc = "The key ring's got keys on it for the house and the station
	     wagon. "
    verifyRemove(actor) = {
	if (self.isIn(debMe))
	    "Best you hang on to those. ";
    }
    doTake(actor) = {
	if (carried_groceries.isIn(debMe))
	    "It's tough bending down and getting your keys without
	     spilling groceries out of the sacks, but you manage it. ";
	else "Taken. ";
	self.moveInto(actor);
    }
;

groceries: fixeditem
    isListed = true
    noun = 'groceries' 'sack' 'sacks' 'food' 'pile' 'bag' 'bags'
    adjective = 'pile'
    sdesc = "pile of groceries"
    j_ldesc = "Sacks full of food that mom wants you to help put up. "
    d_ldesc = "Food that you bought at the supermarket. "
    verDoTake(actor) = {}
    doTake(actor) = {
	if (actor == jeanieMe) {
	    "You grab some of the groceries and put them up. ";
	    self.jeaniePutsAway;
	}
	else {
	    if (debMe.jeanieGone)
		self.finishGroceries;
	    else "You take some of the groceries and put them where
		  they belong. ";
	}
    }
    // finishGroceries is called when Jeanie has left and Deb is done
    // putting groceries away
    finishGroceries = {
	"You put up the last of the groceries and put the left-over
	 sacks away. ";
	self.moveInto(nil);
    }
    // jeaniePutsAway is necessary to centralize both how the message
    // that Jeanie put up groceries is passed to Deb and the count of
    // times Jeanie's helped Deb.
    jeaniePutsAway = {
	debMe.queueAction('G');
	jeanieMe.helpCount++;
	if (jeanieMe.helpCount == 8)
	    jeanieMe.hearHorn;
    }
    doSynonym('Take') = 'Move'
    verDoPutIn(actor, io) = {
	if (io != kitchen_cabinets && io != refrigerator) {
	    if (actor == jeanieMe)
		"The groceries don't go in there. ";
	    else "You almost went and put the groceries in <<io.thedesc>>. ";
	}
    }
    doPutIn(actor, io) = {
	if (actor == jeanieMe) {
	    "You shove some of the groceries into <<io.thedesc>>. ";
	    self.jeaniePutsAway;
	}
	else {
	    if (debMe.jeanieGone)
		self.finishGroceries;
	    else "You take some of the items that belong in <<
		  io.thedesc>> and put them there. ";
	}
    }
    verDoPutOn(actor, io) = {
	if (io == kitchen_table)
	    "That's where they are now. ";
	else if (io != kitchen_counters) {
	    if (actor == jeanieMe)
		"The groceries don't belong on there. ";
	    else "You almost went and put the groceries on <<io.thedesc>>. ";
	}
    }
    doPutOn(actor, io) = {
	if (actor == debMe && debMe.jeanieGone)
	    self.finishGroceries;
	else "You <<actor == jeanieMe ? "throw" : "put">> some of the 
	      groceries on the counter. ";
	self.jeaniePutsAway;     // If we're Deb, this won't have an effect
    }
    verDoSearch(actor) = {
	if (actor == jeanieMe)
	    "Looks like mom bought mostly decent stuff. ";
	else "Why? You know what you bought. ";
    }
;

carried_groceries: item
    noun = 'groceries' 'sack' 'sacks' 'food' 'bag' 'bags'
    adjective = 'several'
    location = debMe
    sdesc = "sacks of groceries"
    adesc = "sacks of groceries"
    ldesc = "You must be holding some five or six sacks. But it was either
	     that or make several trips from the car, and as tired as you
	     are, you'd just as soon get this chore done quickly. "
    dropDisavow = "You don't want to set them down until you're in the
		   kitchen, since you're not sure you could pick them
		   up again. "
    setupGroceries(dest) = {
	"You lift the sacks and pile them on the kitchen table. ";
	groceries.moveInto(dest);
	self.moveInto(nil);
	notify(debMe, &advanceJResponses, 0);
    }
    verDoDrop(actor) = {
	if (actor.location != kitchen)
	    self.dropDisavow;
    }
    doDrop(actor) = (self.setupGroceries(kitchen_table))
    verDoMove(actor) = {
	if (actor.location != kitchen)
	    "The only place you want to move those groceries is into the
	     kitchen. ";
    }
    doMove(actor) = {
	self.setupGroceries(kitchen_table);
	"Then you put some of the groceries away. ";
    }
    verDoPutIn(actor, io) = {}
    doPutIn(actor, io) = {
	if (actor.location != kitchen)
	    self.dropDisavow;
	else self.setupGroceries(kitchen_table);
    }
    verDoPutOn(actor, io) = {}
    doPutOn(actor, io) = {
	if (actor.location != kitchen)
	    self.dropDisavow;
	else self.setupGroceries(io);
    }
    verDoThrow(actor) = { "There's no call for that. "; }
    verDoThrowAt(actor, io) = (self.verDoThrow(actor))
    verDoThrowTo(actor, io) = (self.verDoThrow(actor))
;

fridge_contents: fixeditem
    noun = 'food' 'contents'
    adjective = 'bunch' 'refrigerator' 'fridge'
    sdesc = "refrigerator contents"
    ldesc = "There's enough food in the fridge for the rest of the week. "
    takedesc = "You're putting groceries away right now, not taking
		them back out. "
;
