/*
** GndAdv.t exists because I wanted to alter all of the default
** responses to make them more individual for each player object.
**
** Copyright (c) 1999 Stephen Granade. All rights reserved.
*/

#pragma C+

modify movableActor
    actorAction(v, d, p, i) =
    {
	if (self == frank) {
	    if (parserGetMe() == jeanieMe)
		"Like Frank ever does what you ask him to. ";
	    else "He's busy working on the toaster right now. ";
	}
	else if (self == jeanie) {
	    if (parserGetMe() == frankMe)
		"She's not been one to do what you ask for a while. ";
	    else "You'd just as soon not bother her tonight. ";
	}
	else "You're not into trying to boss mom around. ";
        exit;
    }
    verGrab(item) =
    {
	if (self == jeanie) {
	    if (parserGetMe() == frankMe)
		"She's not carrying anything you particularly want. ";
	    else "There's nothing of hers you really need. ";
	}
	else if (self == frank) {
	    if (parserGetMe() == jeanieMe)
		"Might as well not try to take stuff from Frank. ";
	    else "You'd rather not disturb him while he's working on
		  the toaster. ";
	}
	else {
	    if (parserGetMe() == jeanieMe)
		"Mom doesn't have anything you want. ";
	    else "Deb's not carrying anything you need right now. ";
	}
    }
    verDoFollow(actor) = {
        "\^<<self.thedesc>>'s right here already. ";
    }
    verIoGiveTo(actor) =
    {
        if (actor == self)
            "That wouldn't do much. ";
    }
    disavow = "<q>I don't know much about that.</q>"
;

modify basicStrObj
    sdesc = "<q><<value>></q>"
    adesc = "<q><<value>></q>"
    thedesc = "<q><<value>></q>"
    doTypeOn(actor, io) = { "<q>Tap, tap, tap, tap...</q> "; }
    doSay(actor) = {
        "Okay, <q>"; say( self.value ); "</q>.";
    }
;

modify chairitem
    noexit = {
        "%You're% not leaving until %you%
        get%s% <<outOfPrep>> <<thedesc>>. ";
        return nil;
    }
    verDoSiton(actor) = {
        if (actor.location == self)
        {
            "%You're% already on <<self.thedesc>>. ";
        }
    }
    doSiton(actor) = {
	if (actor == jeanieMe)
	    "You plop down on <<self.thedesc>>. ";
	else if (actor == frankMe)
	    "You slowly lower yourself down on <<self.thedesc>>. ";
        else "You sit down on <<self.thedesc>>. ";
        actor.travelTo(self);
    }
;

modify beditem
    doLieon(actor) = {
	if (actor == jeanieMe || actor == debMe)
	    "You lie down on <<self.thedesc>>. ";
	else if (actor == frankMe)
	    "You lie down on <<self.thedesc>> with a sigh. ";
        actor.travelTo(self);
    }
;
    
modify thing
    actorAction(v, d, p, i) = {
	if (parserGetMe() == jeanieMe)
	    "You stopped talking to things like they'd talk back just
	     after you gave up Barbie dolls. ";
	else if (parserGetMe() == frankMe)
	    "You can yell at things all you want. It won't do any
	     good. ";
	else "That would be silly. ";
        exit;
    }
    verDoSave(actor) = {
        "Give the name of the game to save in double quotes,
        like SAVE <Q>GAME1</Q>. ";
    }
    verDoRestore(actor) = {
        "Give the name of the game to restore in double quotes,
        like RESTORE <Q>GAME1</Q>. ";
    }
    verDoScript(actor) = {
        "Give the name of a file to write the transcript to
        in quotes, like SCRIPT <Q>LOG1</Q>. ";
    }
    verDoSay(actor) = {
	"If you want to talk to someone, use TALK TO. ";
    }
    verDoPush(actor) = {
        "You push on <<self.thedesc>>, but it doesn't do anything. ";
    }
    verDoTake(actor) = {
        if (self.location == actor)
            "%You've% already got <<self.thedesc>>. ";
        else
            self.verifyRemove(actor);
    }
    doTake(actor) = {
        local totbulk, totweight;

        totbulk = addbulk(actor.contents) + self.bulk;
        totweight = addweight(actor.contents);
        if (!actor.isCarrying(self))
            totweight = totweight + self.weight + addweight(self.contents);

        if (totweight > actor.maxweight)
            "%You're% carrying too much stuff. ";
        else if (totbulk > actor.maxbulk)
            "%You've% already got %your% hands full. ";
        else {
            self.moveInto(actor);
            "Taken. ";
        }
    }
    verDoDrop(actor) = {
        if (!actor.isCarrying(self))
            "%You're% not carrying <<self.thedesc>>. ";
        else self.verifyRemove(actor);
    }
    verDoUnwear(actor) = {
        "%You're% not wearing <<self.thedesc>>. ";
    }
    verDoPutIn(actor, io) = {
        if (io == nil)
            return;
	
        if (self.location == io)
            "\^<<self.thedesc>><<self.isThem ? '\'re' : '\'s'>> already
	     in <<io.thedesc>>. ";
        else if (io == self)
            "%You% can't put <<self.thedesc>> in <<self.itselfdesc>>. ";
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove(actor);
    }
    verIoPutOn(actor) = {
        "There's no good place on <<self.thedesc>>. ";
    }
    verDoPutOn(actor, io) = {
        if (io == nil)
            return;

        if (self.location == io)
            "\^<<self.thedesc>><<self.isThem ? '\'re' : '\'s'>> already
	     on <<io.thedesc>>. ";
        else if (io == self)
            "%You% can't put <<self.thedesc>> on <<self.itselfdesc>>. ";
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove(actor);
    }
    verDoTakeOff(actor, io) =
    {
        if (io != nil && !self.isIn(io))
            "\^<<self.thedesc>> <<self.isntdesc>> on <<
	     io.thedesc>>. ";
        else self.verDoTake(actor);  /* ensure object can be taken at all */
    }
    verIoPlugIn(actor) =
    {
        "Nothing'll plug into <<self.thedesc>>. ";
    }
    thrudesc = { "%You% can't see through <<self.thedesc>>.\n"; }
    verDoRead(actor) =
    {
        "You can't read <<self.thedesc>>. ";
    }
    verDoLookbehind(actor) =
    {
        "Nothing's behind <<self.thedesc>>. ";
    }
    verDoTurn(actor) =
    {
        "Turning <<self.thedesc>> doesn't do anything. ";
    }
    verDoTurnWith(actor, io) =
    {
        "Turning <<self.thedesc>> doesn't do anything. ";
    }
    verDoTurnTo(actor, io) =
    {
        "Turning <<self.thedesc>> doesn't do anything. ";
    }
    verDoScrew(actor) = { "How're you going to do that? "; }
    verDoScrewWith(actor, iobj) = { "How're you going to do that? "; }
    verDoUnscrew(actor) = { "How're you going to do that? "; }
    verDoUnscrewWith(actor, iobj) = { "How're you going to do that? "; }
    verDoTellAbout(actor, io) = {
	"If you want to say something, use TALK TO. ";
    }
    verDoUnboard(actor) = {
        if (actor.location != self) {
	    "%You're% not <<self.statusPrep>> <<self.thedesc>>. ";
        }
        else if (self.location == nil) {
            "%You% can't leave <<self.thedesc>>. ";
        }
    }
    doUnboard(actor) =
    {
	"You get <<self.outOfPrep>> <<self.thedesc>>. ";
	self.leaveRoom(actor);
	actor.moveInto(self.location);
    }
    verIoAttackWith(actor) = {
	if (actor == jeanieMe)
	    "You got over temper tantrums years ago. ";
	else if (actor == frankMe)
            "You're trying to control your temper these days. ";
	else "What would people think if you went around attacking things? ";
    }
    verDoEat(actor) = {
        "\^<<self.thedesc>> <<self.doesdesc>>n't look appetizing. ";
    }
    verDoDrink(actor) = {
        "\^<<self.thedesc>> <<self.doesdesc>>n't look appetizing. ";
    }
    verDoPull(actor) = {
        "Pulling <<self.thedesc>> doesn't do anything. ";
    }
    verIoShowTo(actor) = {
	if (self == frank) {
	    if (parserGetMe() == jeanieMe)
	        "There's not much you want to show Frank. ";
	    else "You don't want to disturb Frank. ";
	}
	else if (self == jeanie) {
	    if (parserGetMe() == frankMe)
		"Jeanie wouldn't care. ";
	    else "Jeanie's got enough on her mind right now. ";
	}
	else if (self == deb)
	    "There's not much you want to show mom. ";
        else "\^<<self.thedesc>> <<self.doesdesc>>n't much care. ";
    }
    verIoMoveTo(actor) = {
        "That doesn't really get you anywhere. ";
    }
    verDoTouch(actor) = {
        "Touching <<self.thedesc>> doesn't seem to do much. ";
    }
    verDoPoke(actor) = {
        "Poking <<self.thedesc>> doesn't seem to do much. ";
    }
    doBreak(actor) = {
        "You've got to be more specific. ";
    }
    verDoSearch(actor) = {
        "%You% %do%n't find%s% much of anything. ";
    }
;

modify switchItem
    verDoTurnon(actor) =
    {
        /*
         *   You can't turn on something in the dark unless you're
         *   carrying it.  You also can't turn something on if it's
         *   already on.  
         */
        if (!actor.location.islit && !actor.isCarrying(self))
            "It's pitch black.";
        else if (self.isActive)
            "\^<<self.itisdesc>> already turned on. ";
    }
    verDoTurnoff(actor) =
    {
        if (!self.isActive)
            "\^<<self.itisdesc>> already turned off. ";
    }
;

modify theFloor
    ldesc = "It's below you. "
    doSiton(actor) = {
        "%You% sit%s% down on <<self.thedesc>>. ";
        self.sitloc = actor.location;
        actor.moveInto(self);
    }
;

modify basicMe
    verDoFollow(actor) = {
        if (actor == self)
            "You can't follow yourself. ";
    }
    ioGiveTo(actor, dobj) = {
        "%You% take%s% <<dobj.thedesc>> from <<actor.thedesc>>.";
        dobj.moveInto(parserGetMe());
    }
;

modify doorway
    verDoLock(actor) = {
        if (self.islocked)
            "\^<<self.itisdesc>> already locked. ";
        else if (!self.islockable)
            "\^<<self.itnomdesc>> can't be locked. ";
        else if (self.isopen)
            "%You%'ll have to close <<self.itobjdesc>> first. ";
    }
    verDoUnlock(actor) =
    {
        if (!self.islocked)
            "\^<<self.itisdesc>> not locked. ";
    }
    verDoUnlockWith(actor, io) =
    {
        if (!self.islocked)
            "\^<<self.itisdesc>> not locked. ";
        else if (self.mykey == nil)
            "%You% %do%n't need anything to unlock <<self.itobjdesc>>. ";
    }
;

modify openable
    verDoOpen(actor) =
    {
        if (self.isopen)
        {
            "\^<<self.thedesc>><<self.isThem ? '\'re' : '\'s'>> already
	     open. ";
        }
    }
    verDoClose(actor) =
    {
        if (!self.isopen)
        {
            "\^<<self.thedesc>><<self.isThem ? '\'re' : '\'s'>> already
	     closed. ";
        }
    }
;

modify lockable
    verDoLock(actor) =
    {
        if (self.islocked)
        {
            "\^<<self.itisdesc>> already locked. ";
        }
    }
    verDoUnlock(actor) =
    {
        if (!self.islocked)
            "\^<<self.itisdesc>> not locked. ";
    }
    verDoUnlockWith(actor, io) =
    {
        if (!self.islocked)
            "\^<<self.itisdesc>> not locked. ";
        else if (self.mykey == nil)
            "%You% %do%n't need anything to unlock << self.itobjdesc >>.";
    }
;

modify transparentItem
    verGrab(obj) = {
        if (self.isopenable && !self.isopen)
            "%You%'ll have to open <<self.thedesc>> first. ";
    }
;

modify jumpVerb
    action(actor) = {
	if (actor == jeanieMe)
	    "You gave up jumping a while ago. ";
	else if (actor == frankMe)
	    "You can't really jump too high these days. ";
	else "You've never been one to jump about. ";
    }
;
modify waitVerb
    action(actor) = {
	if (actor == jeanieMe)
	    "You wait a while.\n";
	else if (actor == frankMe)
	    "You stare off into space a bit.\n";
	else "You wait a spell.\n";
    }
;
/* This version of iVerb also fixes a bug */
modify iVerb
    action(actor) =
    {
        if (itemcnt(actor.contents))
        {
            /* use tall or wide mode, as appropriate */
            if (self.useInventoryTall)
            {
                /* use "tall" mode */
                "%You've% got:\n";
                nestlistcont(actor, 1);
            }
            else
            {
                /* use wide mode */
                "%You've% got "; listcont(actor); ". ";
                listcontcont(actor);
            }
        }
        else
            "%You've% got nothing.\n";
    }
;
modify standVerb
    action(actor) =
    {
        if (actor.location == nil || actor.location.location == nil)
            "%You're% already standing up. ";
        else
        {
            /* 
             *   silently check verDoUnboard, to see if we can get out of
             *   whatever object we're in 
             */
            self.outhideStatus = outhide(true);
            actor.location.verDoUnboard(actor);
            if (outhide(self.outhideStatus))
            {
                /* 
                 *   verification failed - run again, showing the message
                 *   this time 
                 */
                actor.location.verDoUnboard(actor);
            }
            else
            {
                /* verification succeeded - unboard */
                actor.location.doUnboard(actor);
            }
        }
    }
;
modify scriptVerb
    startScripting(actor) =
    {
        local scriptfile;
        
        scriptfile = askfile('File to write transcript to',
                              ASKFILE_PROMPT_SAVE, FILE_TYPE_LOG,
                              ASKFILE_EXT_RESULT);

        switch(scriptfile[1])
        {
        case ASKFILE_SUCCESS:
            logging(scriptfile[2]);
            "All text'll be saved to the script file.
            Type UNSCRIPT at any time to stop scripting.";
            break;

        case ASKFILE_CANCEL:
            "Canceled. ";
            break;

        case ASKFILE_FAILURE:
            "Failed. ";
            break;
        }
    }
;
modify restartVerb
    restartGame(actor) =
    {
        local yesno;
        while (true)
        {
            "You sure you want to start over? (YES or NO) > ";
            yesno = yorn();
            if (yesno == 1) {
                "\n";
                scoreStatus(0, 0);
                restart(initRestart, global.initRestartParam);
                break;
            }
            else if (yesno == 0)
            {
                "\nOkay.\n";
                break;
            }
        }
    }
;
modify debugVerb
    enterDebugger(actor) =
    {
        if (debugTrace())
            "If you think you found a bug, let Stephen know at
	     sgranade@phy.duke.edu. ";
    }
;
