//: c08:MultiInterfaces.java
// Two ways that a class can 
// implement multiple interfaces.
package c08;
import com.bruceeckel.simpletest.*;

interface A {}
interface B {}

class X implements A, B {}

class Y implements A {
  B makeB() {
    // Anonymous inner class:
    return new B() {};
  }
}

public class MultiInterfaces {
  static void takesA(A a) {}
  static void takesB(B b) {}
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("c08.MultiInterfaces");
    X x = new X();
    Y y = new Y();
    takesA(x);
    takesA(y);
    takesB(x);
    takesB(y.makeB());
    monitor.expect(new String[] {
    });
  }
} ///:~