//: c04:Overloading.java
// Demonstration of both constructor
// and ordinary method overloading.
import com.bruceeckel.simpletest.*;
import java.util.*;

class Tree {
  int height;
  Tree() {
    prt("Planting a seedling");
    height = 0;
  }
  Tree(int i) {
    prt("Creating new Tree that is "
        + i + " feet tall");
    height = i;
  }
  void info() {
    prt("Tree is " + height
        + " feet tall");
  }
  void info(String s) {
    prt(s + ": Tree is "
        + height + " feet tall");
  }
  static void prt(String s) {
    System.out.println(s);
  }
}

public class Overloading {
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("Overloading");
    for(int i = 0; i < 5; i++) {
      Tree t = new Tree(i);
      t.info();
      t.info("overloaded method");
    }
    // Overloaded constructor:
    new Tree();
    monitor.expect(new String[] {
      "Creating new Tree that is 0 feet tall",
      "Tree is 0 feet tall",
      "overloaded method: Tree is 0 feet tall",
      "Creating new Tree that is 1 feet tall",
      "Tree is 1 feet tall",
      "overloaded method: Tree is 1 feet tall",
      "Creating new Tree that is 2 feet tall",
      "Tree is 2 feet tall",
      "overloaded method: Tree is 2 feet tall",
      "Creating new Tree that is 3 feet tall",
      "Tree is 3 feet tall",
      "overloaded method: Tree is 3 feet tall",
      "Creating new Tree that is 4 feet tall",
      "Tree is 4 feet tall",
      "overloaded method: Tree is 4 feet tall",
      "Planting a seedling"
    });
  }
} ///:~