
 
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*      April 1991                                                          */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

/*
 *     etherif4.c -- NIT interface module for Sun OS 4.x.
 *
 */

/* CHANGES:
 *      Rel 3.0:
 *    ISI:  Move TRACEF code to separate interface routine testif.c
 *    ISI:  Split etherif.c into separate routines for Sun OS 3, Sun OS4:
 *               etherif3.c, etherif4.c [ISI]
 *
 */
  
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <net/if.h>
#include <net/nit.h>

#include <sys/stream.h>
#include <sys/stropts.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>
#include <net/packetfilt.h>

#include "stat.h"
    /* Following needed for packet (size)  */
#include "packet.h"

/****  #define DEBUG  ***/

#define CHUNKSIZE       3072    /* was 8192 */
#define BUFSPACE        4*CHUNKSIZE
#define ALIGNMENT        4   /* align on integer boundaries */
#define NIT_DEV         "/dev/nit"
#define FBUFSIZE        600000

int  if_fd = -1;

#define TFLAG      /* NI_TIMESTAMP is set */
#define DFLAG      /* NI_DROPS is set */
/* NI_LEN is set since snaplen > 0 */
        
u_long  chunksize;
u_long  snaplen = ((sizeof(struct ether_header) 
                    + 64 /* Max IP hdr */
                    + sizeof(union ip_data)
            + 3) / 4) * 4; /* even 4-byte boundary */
/* sizeof headers (20) + snaplen (108) = 128 */
/* (snaplen + nit headers) should ideally divide chunksize */

u_char  *buf;   /* Buffer is malloc'd */
int ndebug = 0;
u_long  NIT_drops = 0;

readether()
{
    register u_char *bp, *bufstop, *cp;
    int cc, datalen, len;
    struct timeval  *tvp;   /*  = NULL; */
    
    struct nit_bufhdr  *hdrp;
    struct nit_iftime  *ntp;
    struct nit_ifdrops *ndp;
    struct nit_iflen   *nlp;
    int header_size =  sizeof(*nlp) + sizeof(*hdrp);

#ifdef TFLAG
    header_size += sizeof(*ntp);
#endif
#ifdef DFLAG
    header_size += sizeof(*ndp);
#endif
    
    bp =  buf;
    len = 0;  /* buffer is empty */
            
    if (if_fd < 0) return;
        
    if ((cc = read(if_fd, (u_char *)buf+len, (int)chunksize-len)) < 0) {
        /* attempt to clear the error condition */
        lseek(if_fd, 0, 0);
        if ((cc = read(if_fd, (u_char *)buf+len, (int)chunksize-len)) < 0) {
            perror("Packet buffer read");
            exit(1);
        }
    }
    len += cc;
    if (len == 0) { 
        return; 
    }        

        /*
         *   Loop through the buffer, obeying alignment rule. 
         */
    bufstop = buf + len;                     
    for (bp = buf; bp < bufstop; bp += hdrp->nhb_totlen) {

        cp = bp;
        tvp = NULL;
        
        hdrp = (struct nit_bufhdr *)cp;
        cp += sizeof *hdrp;
        
#ifdef DFLAG
        ntp = (struct nit_iftime *)cp;
        cp += sizeof *ntp;
        tvp = &ntp->nh_timestamp;
#endif

#ifdef DFLAG
        ndp = (struct nit_ifdrops *)cp;
        cp += sizeof *ndp;
        NIT_drops += ndp->nh_drops;
#endif

        nlp = (struct nit_iflen *)cp;
        cp += sizeof *nlp;

        datalen = hdrp->nhb_totlen - header_size;

        if (datalen <= 16) { /* Only Ethernet header? */
           /* This is sure sign of 4.0 NIT bug, fixed by Van Jacobson.
              Fixed nit_if.o available for anonymous FTP from ISI.
              Fixed in Sun OS 4.1.  */
           fprintf(stderr, "NNStat: Fatal NIT error");
           fprintf(stderr, "Statspy depends upon bug fix in nit_if.o");
           exit(1);
           }
           
        parse( cp, datalen, nlp->nh_pktlen, *tvp);

#ifdef DEBUG               
        if (ndebug==1) {
            fprintf(stdout,
               "cc: %d, snaplen: %d, datalen: %d, pktlen: %d, drops: %d\n",
                cc,snaplen,datalen,nlp->nh_pktlen,drops);
       }
#endif

    }  /* end loop through buffer */
        
   return;
} /* readether */


/*
 *   Create Network Interface Tap (NIT) Protocol socket and initialize it.
 *        Note: This version cannot for specified Ethernet type.
 *
 */
initdevice(EtherType)
    int EtherType;
    {
    extern char *EtherIface;
    struct strioctl si;
    struct ifreq    ifr;
    struct timeval  timeout;
    u_long if_flags = 0;

    chunksize = CHUNKSIZE;
        
    if ((buf = (u_char *) malloc(chunksize)) == NULL) {
        printf("MEMORY SHORTAGE: packet buf\n");
        exit(1);
    }      
    
        /* Open NIT device */     

    if ((if_fd = open(NIT_DEV, O_RDONLY)) < 0) {
            perror("nit open");
            exit (1);
    }
        /*
         * Arrange to get discrete messages from the stream.
         *      RMSGD is Message-discard mode.
         */
    if (ioctl(if_fd, I_SRDOPT, (char *)RMSGD) < 0) {
        perror("ioctl (I_SRDOPT)");
        exit (1);
    }

    si.ic_timout = INFTIM;

        /*
         * Push and configure the buffering module.
         */
    if (ioctl(if_fd, I_PUSH, "nbuf") < 0) {
        perror("ioctl (I_PUSH \"nbuf\")");
        exit (1);
    }
             /* Could push the filter module to look for specific
              *   Ethernet type.  Not implemented yet.
              */
              
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    si.ic_cmd = NIOCSTIME;
    si.ic_len = sizeof timeout;
    si.ic_dp = (char *)&timeout;
    if (ioctl(if_fd, I_STR, (char *)&si) < 0) {
        perror("ioctl (I_STR: NIOCSTIME)");
        exit (1);
    }

    si.ic_cmd = NIOCSCHUNK;
    si.ic_len = sizeof chunksize;
    si.ic_dp = (char *)&chunksize;
    if (ioctl(if_fd, I_STR, (char *)&si) < 0) {
        perror("ioctl (I_STR: NIOCSCHUNK)");
        exit (1);
    }

        /*
         * Configure the nit device, binding it to the proper
         * underlying interface, setting the snapshot length,
         * and setting nit_if-level flags.
         */
    (void) strncpy(ifr.ifr_name, EtherIface, sizeof ifr.ifr_name);
    ifr.ifr_name[sizeof ifr.ifr_name - 1] = '\0';
    si.ic_cmd = NIOCBIND;
    si.ic_len = sizeof ifr;
    si.ic_dp = (char *)&ifr;
    if (ioctl(if_fd, I_STR, (char *)&si) < 0) {
        perror("ioctl (I_STR: NIOCBIND)");
        exit(1);
    }
        /* Set snaplen */
    si.ic_cmd = NIOCSSNAP;
    si.ic_len = sizeof snaplen;
    si.ic_dp = (char *)&snaplen;
    if (ioctl(if_fd, I_STR, (char *)&si) < 0) {
        perror("ioctl (I_STR: NIOCSSNAP)");
        exit (1);
    }

    if_flags = NI_PROMISC | NI_LEN;
#ifdef TFLAG
    if_flags |= NI_TIMESTAMP;
#endif
#ifdef DFLAG
    if_flags |= NI_DROPS;
#endif

    si.ic_cmd = NIOCSFLAGS;
    si.ic_len = sizeof if_flags;
    si.ic_dp = (char *)&if_flags;
    if (ioctl(if_fd, I_STR, (char *)&si) < 0) {
        perror("ioctl (I_STR: NIOCSFLAGS)");
        exit (1);
    }
        /*
         * Flush the read queue, to get rid of anything that
         * accumulated before the device reached its final configuration.
         */
/* *** Don't do this; there is a kernel bug that effectively sets the
     snaplen to 0 whenever there is an I_FLUSH.
     
    if (ioctl(if_fd, I_FLUSH, (char *)FLUSHR) < 0) {
        perror("ioctl (I_FLUSH)");
        exit(1);
    }
*****/

} /* initdevice */


deinitdevice()
{
    close(if_fd);
    if_fd = -1;
    free(buf);
}
    
      
/*
 * returns TRUE IFF something interesting to report.
 *    Doesn't reference "outp" if it returns FALSE.
 */
boolean if_stats(outp)
char *outp;
{
    /****  Does not seem to return anything sensible... I suppose it is
                                another NIT bug!
    if (NIT_drops) {
        (void)sprintf(outp, "NIT interface drops= %d\n", NIT_drops);
        return(TRUE);
    }
    ****/
    return(FALSE);
}
