char rcsid[] =
	"$Id: main.c,v 3.0.1.4 90/04/04 14:50:44 craig Exp $";
/*
 * main.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	main.c,v $
 * Revision 3.0.1.4  90/04/04  14:50:44  craig
 * patch5: Removed check of return value of times().
 * 
 * Revision 3.0.1.3  90/03/07  21:33:09  craig
 * patch4: Return value of times() is now checked.
 * patch4: Workers is externed iff LINDA is defined.
 * 
 * Revision 3.0.1.2  89/12/07  22:54:39  craig
 * patch2: Renamed utime and stime to avoid name clashes.
 * 
 * Revision 3.0.1.1  89/11/16  18:28:21  craig
 * patch1: Statistics are now reported in Linda implementation.
 * 
 * Revision 3.0  89/10/27  17:05:45  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include <signal.h>
#ifdef SYSV
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#else
#ifndef AZTEC_C
#include <sys/time.h>
#include <sys/resource.h>
#endif
#endif
#include "constants.h"
#include "typedefs.h"
#include "defaults.h"

unsigned long	EyeRays,	/* # of eye rays spawned */
		ShadowRays,	/* # of shadow rays spawned */
		ReflectRays,	/* # of reflected rays */
		RefractRays,	/* # of refracted rays */
		HitRays,	/* # of rays which hit something. */
		BVTests,	/* # of bounding volume tests. */
		SuperSampled;	/* # of supersampled pixels. */
double		ftmp;		/* Used by fabs() macro. */
double		Utime, Stime;	/* user, system CPU time */
FILE		*fstats;	/* Statistics file */

/*
 * LINDA silliness.
 */
#ifdef LINDA
rayshade_main(argc, argv)
#else
main(argc, argv)
#endif
int argc;
char **argv;
{
	unsigned long TotalRays;
	extern int Verbose, Cache, Jittered;
	extern unsigned long CacheWorked, CacheFailed, ShadowHits;
#ifdef LINDA
	extern int Workers;
#endif

	/*
 	 * Initialize variables, etc.
	 */
	setup();
	/*
	 * Parse options from command line.
	 */
	parse_options(argc, argv);
	/*
	 * Process input file.
	 */
	if (Verbose) {
		print_version();
		fprintf(fstats,"Reading input file...\n");
		fflush(fstats);
	}
	read_input_file();
	/*
	 * Set variables which weren't set on command line
	 * or in input file.
	 */
	cleanup();
	/*
	 * Start new picture.
	 */
	startpic();
	/*
	 * Set up viewing parameters.
	 */
	viewing();
	/*
	 * Set up world.
	 */
	if (Verbose)
		fprintf(fstats,"Setting up voxels...\n");
	SetupWorld();
	get_cpu_time(&Utime, &Stime);
	fprintf(fstats,"Preprocessing time:\t");
	fprintf(fstats,"%2.2lfu  %2.2lfs\n",Utime, Stime);
	fprintf(fstats,"Starting trace.\n");
	fflush(fstats);
	/*
	 * Trace the image.
	 */
	raytrace();
	/*
	 * Close the image file.
	 */
	endpic();
#ifndef LINDA
	get_cpu_time(&Utime, &Stime);
#endif

	TotalRays = EyeRays + ShadowRays + ReflectRays + RefractRays;
	ShadowHits += CacheWorked;
	HitRays += ShadowHits;
#ifdef LINDA
	fprintf(fstats,"Workers:\t\t\t%d\n",Workers);
#endif
	fprintf(fstats,"Eye rays:\t\t\t%ld\n", EyeRays);
	fprintf(fstats,"Shadow rays:\t\t\t%ld\n",ShadowRays);
	fprintf(fstats,"Reflected rays:\t\t\t%ld\n",ReflectRays);
	fprintf(fstats,"Refracted rays:\t\t\t%ld\n",RefractRays);
	fprintf(fstats,"Total rays:\t\t\t%ld\n", TotalRays);
	if (TotalRays != 0.)
		fprintf(fstats,"Intersecting rays:\t\t%ld (%3.3f%%)\n",
			HitRays, 100. * (float)HitRays / (float)TotalRays);
	if (ShadowRays != 0) {
		if (Cache)
			fprintf(fstats,"Shadow cache hits:\t\t%ld (%ld misses)\n",
				CacheWorked, CacheFailed);
		fprintf(fstats,"Total shadow hits:\t\t%ld (%3.3f%%)\n",
			ShadowHits, 100.*(float)ShadowHits / (float)ShadowRays);
	}
	if (!Jittered)
		fprintf(fstats,"Supersampled pixels:\t\t%ld\n",SuperSampled);
	fprintf(fstats,"B.V. intersection tests:\t%ld\n", BVTests);
	print_prim_stats();
#ifdef LINDA
	fprintf(fstats,"Average CPU time/processor:\t");
#else
	fprintf(fstats,"Total CPU time (sec):\t\t");
#endif
	fprintf(fstats,"%2.2lf (%2.2lfu + %2.2lfs)\n",Utime+Stime, Utime, Stime);
	if (TotalRays != 0.)
		fprintf(fstats,"Seconds / ray:\t\t\t%4.4lf\n",
				(Utime + Stime) / (double)TotalRays);
	if (HitRays != 0.)
		fprintf(fstats, "Seconds / intersecting ray:\t%4.4lf\n",
				(Utime + Stime) / (double)HitRays);
	PrintMemoryStats();
	exit(0);
}

#ifdef SYSV
get_cpu_time(usertime, systime)
double *usertime, *systime;
{
	struct tms time;

	(void)times(&time);
	*usertime = (double)time.tms_utime / (double)HZ;
	*systime = (double)time.tms_stime / (double)HZ;
}
#else
#ifdef AZTEC_C
get_cpu_time()
{
}
#else	/* !SYSV && !AZTEC_C */
get_cpu_time(usertime, systime)
double *usertime, *systime;
{
	struct rusage usage;

	getrusage(RUSAGE_SELF, &usage);

	*usertime = (double)usage.ru_utime.tv_sec +
			(double)usage.ru_utime.tv_usec / 1000000.;
	*systime = (double)usage.ru_stime.tv_sec +
			(double)usage.ru_stime.tv_usec / 1000000.;
}
#endif
#endif
