/*
 * datatypes.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: datatypes.h,v 3.0.1.1 89/11/16 20:41:39 craig Exp Locker: craig $
 *
 * $Log:	datatypes.h,v $
 * Revision 3.0.1.1  89/11/16  20:41:39  craig
 * patch1: Moved atmospheric declarations to atmosphere.h.
 * 
 * Revision 3.0  89/10/27  02:05:49  craig
 * Baseline for first official release.
 * 
 */

#ifdef NOVOID
typedef int void;
#endif

typedef struct {
	double u, v;			/* 2D point */
} Vec2d;

typedef struct Vector {
	double x, y, z;			/* 3D point */
} Vector;

typedef struct Ray {
	Vector pos;			/* Origin */
	Vector 	dir;			/* Direction */
	char shadow;
	struct SurfaceList *media;	/* Medium ray is passing through */
} Ray;

typedef struct Color {
	double r, g, b;			/* Red, green, blue. */
} Color;

typedef struct {
	double matrix[3][3];		/* Rotation matrix */
	Vector translate;		/* Translation */
} TransInfo;

typedef struct Trans {
	TransInfo world2obj,	/* worldspace --> object space */
		  obj2world;	/* object space --> world space */
} Trans;

typedef struct {
	struct ObjList *list;		/* List of prims/objs. in object */
	struct ObjList *unbounded;	/* List of unbounded prims. */
	double bounds[2][3];		/* Bounding box of object */
} List;

typedef struct {
	short xsize, ysize, zsize;	/* # of voxels along each axis */
	double bounds[2][3];		/* bounding box */
	double voxsize[3];		/* size of a voxel */
	struct ObjList ****cells;	/* Voxels */
	struct ObjList *unbounded;	/* Unbounded objects */
} Grid;

/*
 * Surface definition.
 */
typedef struct Surface {
	char *name;			/* Name */
	struct Color amb;		/* Ambient color */
	struct Color diff;		/* Diffuse color */
	struct Color spec;		/* Specular color */
	double coef;			/* Phong shading coef. */
	double refl;			/* Reflectivity (0-1) */
	double transp;			/* Transparency (0-1) */
	double kref;			/* Index of refraction */
	double translucency;		/* translucency (0-1) */
	double stcoef;			/* Phong coef. for transmitted light */
} Surface;

typedef struct SurfaceList {
	Surface *surf;
	struct SurfaceList *next;
} SurfaceList;

typedef struct ObjList {
	struct Object *data;		/* Pointer to object data */
	struct ObjList *next;		/* Next in list */
} ObjList;

typedef struct PointList {
	Vector vec;			/* Vector data */
	struct PointList *next;		/* Next in list */
} PointList;

/*
 * Data about point of intersection.
 * (May be modified by texture mapping.)
 */
typedef struct HitInfo {
	Vector	pos,		/* Location of intersection */
		norm;		/* Normal to surface at int. point */
	struct Primitive *prim; /* Pointer to primitive hit. */
	struct Surface surf;	/* Surface to be used. */
	TransInfo *totaltrans;
} HitInfo;

/*
 * General-purpose texture structure.  The (bad) idea is to
 * have one structure which every texturing function will use.
 */
typedef struct Texture {
	char type;		/* Texture type */
	Surface *surf1;		/* Alternate surface */
	double size;		/* Scale/size factor */
	double *args;		/* Random arguments. */
	Color *colormap;	/* Colormap */
	Trans *trans;		/* Transformation matrices. */
	struct Texture *next;	/* Pointer to next texture. */
} Texture;
