/*
 * File: main_loop.lr3.c
 *   By: Dave Hiebeler
 *       July 1989
 *
 * Generate a transition-table for linear (r=3) neighborhood
 */

#include <stdio.h>
#include <math.h>
#include "nborhood.h"

#define add_index(k)	index <<= L;  index |= k

func_ptr update_function;

main()
{
    char    *ta;			/* t-table array       */
    FILE   *fopen(), *fp;
    int L, N, TSIZE, index, AMASK;
    int     lll, ll, l, c, r, rr, rrr;
    lr3_nbors nbors;


    L = (short) (log((double) NSTATES) / log((double) 2.0));
    N = 7;
    TSIZE = 1 << (L*N);
    AMASK = NSTATES-1;
    if ((ta=(char *)malloc(TSIZE))==NULL) {
	fprintf(stderr,"Couldn't malloc memory for table\n");
	exit(1);
    }
    printf("NSTATES = %d\n",NSTATES);
    init_function();
    for (lll = 0; lll < NSTATES; lll++)
      for (ll = 0; ll < NSTATES; ll++)
        for (l = 0; l < NSTATES; l++)
	  for (c = 0; c < NSTATES; c++)
	    for (r = 0; r < NSTATES; r++)
	      for (rr = 0; rr < NSTATES; rr++)
		for (rrr = 0; rrr < NSTATES; rrr++) {

		    index = 0;
		    add_index(lll);
		    add_index(ll);
		    add_index(l);
		    add_index(c);
		    add_index(r);
		    add_index(rr);
		    add_index(rrr);

		    nbors.lll = lll;
		    nbors.ll = ll;
		    nbors.l = l;
		    nbors.c = c;
		    nbors.r = r;
		    nbors.rr = rr;
		    nbors.rrr = rrr;
		    ta[index] = (update_function(&nbors) & AMASK);

		}


    fp = fopen(OUTPUT, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

}
