/*
 * File: main_loop.lr2.c
 *   By: Dave Hiebeler
 *       July 1989
 *
 * Generate a transition-table for linear (r=2) neighborhood
 */

#include <stdio.h>
#include <math.h>
#include "nborhood.h"

#define add_index(k)	index <<= L;  index |= k

func_ptr update_function;

main()
{
    char    *ta;			/* t-table array       */
    FILE   *fopen(), *fp;
    int L, N, TSIZE, index, AMASK;
    int     ll, l, c, r, rr;
    lr2_nbors nbors;


    L = (short) (log((double) NSTATES) / log((double) 2.0));
    N = 5;
    TSIZE = 1 << (L*N);
    AMASK = NSTATES -1;
    if ((ta=(char *)malloc(TSIZE))==NULL) {
	fprintf(stderr,"Couldn't malloc memory for table\n");
	exit(1);
    }
    printf("NSTATES = %d\n",NSTATES);
    init_function();
    for (ll = 0; ll < NSTATES; ll++)
      for (l = 0; l < NSTATES; l++)
	for (c = 0; c < NSTATES; c++)
	  for (r = 0; r < NSTATES; r++)
	    for (rr = 0; rr < NSTATES; rr++) {

		index = 0;
		add_index(ll);
		add_index(l);
		add_index(c);
		add_index(r);
		add_index(rr);

		nbors.ll = ll;
		nbors.l = l;
		nbors.c = c;
		nbors.r = r;
		nbors.rr = rr;
		ta[index] = (update_function(&nbors) & AMASK);

	    }


    fp = fopen(OUTPUT, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

}
