/* Author : Arun Jagota 1/8/90 

		COPY RIGHT agreement
This software is given free of charge for research/academic purposes. 
Any changes may be made to the software for research purposes. 
It is recommended that publications stemming from using it cite
[1], [2] or both.

This software may be distributed anywhere for academic/research 
purposes as long as the terms outlined here are adhered to. This text 
must accompany the distribution. If there is any public installation
of this s/w, "Arun Jagota" should be listed as the author in the
'man' pages, if any.

Before any commercial use of this s/w (direct or indirect), Arun Jagota
must be consulted.  (jagota@cs.buffalo.edu)

[1] A new Hopfield-style network for content-addressable memories 
- Arun Jagota

[2] Knowledge Representation in a multi-layered hopfield network
- Arun Jagota, Oleg Jakubowicz, (IJCNN-89, Wash DC)

*/
/* This performs the Hopfield algorithm using dynamic programming 
which is 'fast' on a sequential computer
*/
#include <stdio.h>
#include "std.h"
#include "main.h"
#include "utils.h"

/* Remove all multiplications and << or >> in computing neti if using 
   BOOLEAN units in NEG_PULSE, RESET_PULSE, NET_I, DELTA_NET_I. 
   DELTA_EMAX requires extensive change which is documented just prior 
   to it 
*/

#define CLAMP_ACTIVE_ON(pnl,p_not_low,p_clamped,curr_clamped) \
 { \
  curr_clamped = 0; \
  for (pnl = p_not_low; pnl != NULL; pnl = pnl->next) { \
     p_clamped[curr_clamped] = pnl->index; \
     curr_clamped++; \
  } \
 } \

#define NEG_PULSE(pi,p_clamped_low,curr_clamped_low,wi,pj,neti,curr_p,max_p) \
 { \
  for (pi = 0; pi < curr_clamped_low; pi++) { \
       wi = p_clamped_low[pi]*max_p; \
       for (pj = 0; pj < curr_p; pj++) neti[pj] -= (w[wi+pj] << HIGH_POWER); \
   } \
 } \


#define RESET_PULSE(pi,p_clamped_low,curr_clamped_low,wi,pj,neti,curr_p,max_p) \
 { \
  for (pi = 0; pi < curr_clamped_low; pi++) { \
       wi = p_clamped_low[pi]*max_p; \
       for (pj = 0; pj < curr_p; pj++) neti[pj] += (w[wi+pj] << HIGH_POWER); \
   } \
 } \


#define NET_I(pnl,p_not_low,wi,pj,neti,curr_p,max_p,skip_clamped) \
 { \
  for (pnl = p_not_low; pnl != NULL; pnl = pnl->next) { \
    if (skip_clamped && (p[pnl->index] == CLAMPED_HIGH)) continue; \
    wi = (pnl->index)*max_p; \
    for (pj = 0; pj < curr_p; pj++) neti[pj] += ((w[wi+pj]*p[pnl->index]) >> HIGH_POWER); \
  } \
 } \


#define DELTA_NET_I(wi,pj,amount_of_switch,neti,curr_p) \
 { \
      for (pj = 0; pj < curr_p; pj++) neti[pj] += ((w[wi+pj] * amount_of_switch) >> HIGH_POWER); \
} \

/* CLAMPED_LOW, CLAMPED_HIGH as values in 'p' to keep a record of
   clamped units will only work in the discrete case, ie when there
   is NO MULTIPLICATION
*/
/* If units are to have values in the interval [0,1], rather than
   {0,1}, then

   del_E = (p[pj] > LOW) ? (neti[pj] + r[pj]) : (-neti[pj] + r[pj]); \
   if (del_E < del_Emax) {		\
     del_Emax = del_E;		\
     unit_to_switch = pj;		\
   }		\

   will have to be changed to


   { del_E must be an unsigned int }

*/

#define DELTA_EMAX(pj,curr_p,del_E,del_Emax,V,switch_direction,test_mode) \
{ \
 del_Emax = 0;		\
 pj = 0;		\
 for (pj = 0; pj < curr_p; pj++) {		\
   if ((p[pj] == CLAMPED_HIGH) || (p[pj] == CLAMPED_LOW))   \
    continue;		\
   if ((neti[pj] > 0) && ( p[pj] < HIGH)) V = 1; \
   else if ((neti[pj] < 0) && (p[pj] > LOW)) V = -1; \
   else V = 0; \
   if (test_mode == TEST_PROB) \
     del_E = (V*neti[pj]) + (abs(V)*r[pj]); \
   else \
     del_E = (V*neti[pj]) - (abs(V)*r[pj]); \
   if (del_E > del_Emax) {\
     del_Emax = del_E;\
     unit_to_switch = pj;\
     switch_direction = V;\
   }\
 }		\
} \

#define DELETE_FROM_LIST(prev,this,p_not_low) \
{ \
  prev = this = p_not_low;  \
  while (this->index != unit_to_switch) { \
    prev = this; \
    this  = this->next; \
  } \
  if (prev == this) p_not_low = this->next;  \
  else prev->next = this->next;  \
  free(this); \
}  \

find_energy_minimum(p,R,r,w,curr_p,max_p,p_not_lowp,p_clamped,p_clamped_low,curr_clampedp,curr_clamped_low,neti,skip_clamped, test_mode)
/* All arrays are wrt current layer */
int p[],R[],r[],p_clamped[],p_clamped_low[], curr_clamped_low,*curr_clampedp;
int w[],neti[];
int curr_p,max_p; /*Current number and max number of units in this layer */
struct pl_not_low **p_not_lowp;
boolean skip_clamped, test_mode;  
/* If skip_clamped then don't propagate activation from clamped unit */
/* if test_mode == TEST_OFF_ONLY then stop before the first unit can be 
   switched ON */
{int unit_to_switch, amount_of_switch;
 int del_Emax;
 /* Keeps track of successive cycles with no switches */
 int num_ns; 
 struct pl_not_low *new; 
 struct pl_not_low *prev,*this;  /* LOCAL variables in DELETE_FROM_LIST */
 struct pl_not_low *pnl;         /* Local variable in NET_I */
 int wi,pj,pi;                      /* Local variables in NET_I, DELTA_NET_I,
				    DELTA_EMAX */
 int del_E,V;			 /* Local variables in DELTA_EMAX */
 int switch_direction;           /* Required in DELTA_EMAX */
 boolean no_ON_switch_yet; /* The first time a unit switches ON,
			     clamp all active units to 1 - Useful
			     in multi-layered case */
  
  /* Initialise 'r' */
  for (pi = 0; pi < curr_p; pi++)  
     r[pi] = R[pi]; 

  no_ON_switch_yet = TRUE;
  NEG_PULSE(pi,p_clamped_low,curr_clamped_low,wi,pj,neti,curr_p,max_p)
  NET_I(pnl,(*p_not_lowp),wi,pj,neti,curr_p,max_p,skip_clamped)
  DELTA_EMAX(pj,curr_p,del_E,del_Emax,V,switch_direction,test_mode)
  RESET_PULSE(pi,p_clamped_low,curr_clamped_low,wi,pj,neti,curr_p,max_p)
  while (del_Emax != 0) {
    /* Switch a unit */

    if (no_ON_switch_yet && (switch_direction == 1)) {
       if (test_mode == TEST_OFF_ONLY) return;
       no_ON_switch_yet = FALSE;
       CLAMP_ACTIVE_ON(pnl,(*p_not_lowp),p_clamped,(*curr_clampedp))
    }

    /* Switch unit Discrete */
    /* p[unit_to_switch] = (p[unit_to_switch] == HIGH)? LOW : HIGH; */

#ifdef DEBUG
    /* Print neti - Debug mode */
    printf("unit switched = %d, switch direction = %d, neti = %d\n",
	    unit_to_switch,switch_direction,neti[unit_to_switch]);
#endif

    /* Check if add to p_not_low list */
    if ((p[unit_to_switch] == LOW) && (switch_direction == 1)) {
      /* Add to p_not_low list */
      new = (struct pl_not_low *) malloc(sizeof(*new));
      new->next = *p_not_lowp;
      new->index= unit_to_switch;
      *p_not_lowp = new;
    }
    else  if (switch_direction == -1) /* Delete from p_not_low list */
      DELETE_FROM_LIST(prev,this,(*p_not_lowp))

    /* Switch the unit */
    amount_of_switch  = (switch_direction == 1) ? (HIGH - p[unit_to_switch])
						: (LOW - p[unit_to_switch]);
    p[unit_to_switch] = (switch_direction == 1) ? HIGH : LOW; 
    
    wi = unit_to_switch*max_p;
    DELTA_NET_I(wi,pj,amount_of_switch,neti,curr_p)
    DELTA_EMAX(pj,curr_p,del_E,del_Emax,V,switch_direction,test_mode)
 }  /* while */

/* TBD - Add a loop to reduce 'r' and try again */
}

find_wta(p,curr_p,p_not_lowp)
/* Currently, find_wta returns multiple winners in case of a tie */
/* It builds a new list of winners and finally makes *p_not_lowp
point to it. It also frees all nodes in *p_not_lowp
*/
/* 'p' is wrt current layer */
int p[];
int curr_p; /*Current number of units in this layer */
struct pl_not_low **p_not_lowp;
{int max_val;
 struct pl_not_low *win_first,*win_new,*pnl; 

 if ((*p_not_lowp) == NULL) return;

 max_val = p[(*p_not_lowp)->index];
 win_first = (struct pl_not_low *) malloc(sizeof(*win_first));
 win_first->next = NULL;
 win_first->index = (*p_not_lowp)->index;
 for (pnl = (*p_not_lowp)->next; pnl != NULL; pnl = pnl->next) {		
   /* This can be thresholded */
   if (p[pnl->index] > max_val) {
    /* Start afresh to build a list of maxes */
     /* Imported from main.c */
     max_val = p[pnl->index];
     delete_list(win_first);
     win_first = (struct pl_not_low *) malloc(sizeof(*win_first));
     win_first->next = NULL;
     win_first->index = pnl->index;
     continue;
   }

   /* This can be thresholded */
   if (p[pnl->index] == max_val) {
   /* Add to list of maxes */
     win_new = (struct pl_not_low *) malloc(sizeof(*win_new));
     win_new->next = win_first;
     win_new->index = pnl->index;
     win_first = win_new;
   }
 }

 /* Now delete *p_not_lowp and then make it point to win_first */
 delete_list(*p_not_lowp);
 *p_not_lowp = win_first;
} 
