#include <stdio.h>
#include "std.h"
#include "utils.h"
#include "main.h"
#define ITEMS_ON_LINE 20
#define TERMINATE_WUP -1

save_p_names(fp,p_name_tbl)
FILE  *fp;
P_NAME_ENTRY *p_name_tbl[];
{int i;

   i = 0;
   while (p_name_tbl[i] != NULL) {
     fprintf(fp,"%s\n",p_name_tbl[i]->name);
     i++;
   }
  
}

restore_p_names(fp,p_name_tbl,curr_pp,max_p,l)
FILE  *fp;
P_NAME_ENTRY *p_name_tbl[];
int *curr_pp,max_p;
{int j,temp; 
 char name[WORD_SIZE];
	
    j = 0;
    while (fscanf(fp,"%s",name) != EOF) {
      if (j == (max_p-1)) {
	*curr_pp = j;
	fprintf(stderr,"limit of names for this layer \n");
        p_name_tbl[j] = NULL;
	return;
      }
      find_or_create_unit(p_name_tbl,name,CREATE_ONLY,curr_pp,&temp,max_p,l);
      j++;
    }
    *curr_pp      = j;
    p_name_tbl[j] = NULL;

}

save_R(fp,R,curr_p)
FILE  *fp;
int R[],curr_p;
{int i;

  for (i = 0; i < curr_p; i++) fprintf(fp,"%d ",R[i]);
  
  fprintf(fp,"\n");
}

restore_R(fp,R,curr_p)
FILE  *fp;
int R[],curr_p;
{int i;
      i = 0;
      while ((i < curr_p) && (fscanf(fp,"%d",&R[i]) != EOF)) i++;
      if (i > curr_p) fprintf(stderr,"restore_R : extra 'R' \n");
}

save_wup(fp,wup,curr_p)
FILE  *fp;
int curr_p;
struct wup_entry *wup[];
{int i;
 struct wup_entry *wupp;

  for (i = 0; i < curr_p; i++) {

    for (wupp = wup[i]; wupp != NULL; wupp = wupp->next)
      fprintf(fp,"%d %d ",wupp->index,wupp->value);

    fprintf(fp,"%d \n",TERMINATE_WUP);
  
  }
}

restore_wup(fp,wup,curr_p,num_up)
FILE  *fp;
int curr_p, num_up[];
struct wup_entry *wup[];
{int i, value, index;
 struct wup_entry *wupp;

  for (i = 0; i < curr_p; i++) {
    fscanf(fp,"%d",&index);

    while (index != TERMINATE_WUP) {
      wupp = (struct wup_entry *) malloc (sizeof *wupp);
      wupp->next = wup[i];
      wup[i] = wupp;
      wupp->index = index;
      num_up[index]++;
      fscanf(fp,"%d",&value);
      wupp->value = value;
      fscanf(fp,"%d",&index);
    }
  }
}

save_weights(fp,w,max_p,curr_p)
FILE  *fp;
int w[];
int   max_p,curr_p;
{int pi,pj,k,wi, num_lines, last_line;

    num_lines = curr_p / ITEMS_ON_LINE;
    last_line = curr_p % ITEMS_ON_LINE;
    for (pi = 0; pi < curr_p; pi++)
      {
      wi = pi*max_p;
      for (pj = 0; pj < num_lines; pj++) {
	for (k = 0 ; k < ITEMS_ON_LINE ; k++)
	  fprintf(fp,"%4d ",w[wi + pj*ITEMS_ON_LINE + k]);
        fprintf(fp,"\n");
      }

      /* Take care of last line */
      for (pj = 0; pj < last_line; pj++)
	  fprintf(fp,"%d ",w[wi + num_lines*ITEMS_ON_LINE + pj]);
      fprintf(fp,"\n");
      }
}

restore_weights(fp,w,max_p,curr_p)
FILE  *fp;
int w[];
int   max_p,curr_p;
{int pi,pj,wi;

    for (pi = 0; pi < curr_p; pi++)
      {
      wi = pi*max_p;
      for (pj = 0; pj < curr_p; pj++)
	fscanf(fp,"%d",&w[wi + pj]);
      }
}

save_rl_weights(fp,w,max_p,curr_p,vigilance,min_vigilance)
/* This saves weights by doing run-length encoding on vigilance values -
   Moreover, it only saves the triangular matrix since the matrix is 
   symmetric */
FILE  *fp;
int w[];
int   max_p,curr_p,vigilance,min_vigilance;
{int pi,pj,wi,rl;

    rl = min_vigilance;
    for (pi = 0; pi < curr_p; pi++)
      {
      wi = pi*max_p;
      for (pj = pi; pj < curr_p; pj++) {
	  if (w[wi+pj] == vigilance) {
	    rl--;
	    continue;
	  }

          /* The run of vigilance values has ended */

	  if (rl < min_vigilance) { /* First print the run-length */
	    fprintf(fp,"%d\n",rl);
	    rl = min_vigilance;
	  }
	  
	  /* Now print the non vigilance value */
	  fprintf(fp,"%d\n",w[wi+pj]);
      }

    }

  if (rl < min_vigilance) {
    fprintf(fp,"%d\n",rl);
    rl = min_vigilance;
  }
}

restore_rl_weights(fp,w,max_p,curr_p,vigilance,min_vigilance)
/* This procedure restores weights for which vigilance values have
been run-length encoded. Moreover, only the triangle matrix has been
stored since it is symmetric
*/

FILE  *fp;
int w[];
int   max_p,curr_p,vigilance,min_vigilance;
{int pi,pj,rli,rl,tw;

	pi = pj = 0;
	while (fscanf(fp,"%d",&tw) != EOF) {

	  if (tw < min_vigilance) {
	    rl = min_vigilance - tw;
	    for (rli = 0; rli < rl; rli++) {
	       w[pi*max_p + pj] = w[pj*max_p + pi] = vigilance;
	       if (pj == (curr_p-1)) {
		 pi++;
		 pj = pi;
	       }
	       else pj++;
	    }
	    continue;
	  }

	  w[pi*max_p + pj] = w[pj*max_p + pi] = tw;
          if (pj == (curr_p-1)) {
	     pi++;
	     pj = pi;
	  }
	  else pj++;
	}
}
