C----------------------------------------------------------------------
C
C  E Q C
C
C  COORDINATES IN THE ARRAY PLANET ARE CONVERTED INTO EQUATORIAL
C  COORDINATES AND STORED INTO OUTBUF
C
C----------------------------------------------------------------------
      SUBROUTINE EQC(T)
      REAL T
C
C  CONSTANTS
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C
      INTEGER MAXOBJ, MAXDAY, MMM, ORDER
      PARAMETER (MAXOBJ=10, MAXDAY=10000, ORDER=7, MMM=3)
C
C  
C
      REAL
     .    PLANET(3,MAXOBJ),      
     .    OLDPL(2,MAXOBJ)    
      INTEGER
     .    TODAY
      REAL
     .    OUTBUF(MAXDAY,3,MAXOBJ)      
C
      COMMON /OUT/ OUTBUF, PLANET, OLDPL, TODAY
C
C  LOCAL VARIABLES 
C 
      INTEGER
     .    I             
      REAL
     .    RA,DEC,DIST,  
     .    X0,Y0,Z0,DA
C
      X0=PLANET(1,2)
      Y0=PLANET(2,2)
      Z0=PLANET(3,2)

      CALL ANTIB(X0, Y0, Z0, T)

      DO 10 I=1,MAXOBJ
         IF (I. NE. 2) THEN
            CALL RADEC (
     .              PLANET(1,I), PLANET(2,I), PLANET(3,I),
     .              X0, Y0, Z0,
     .              OLDPL(1,I), OLDPL(2,I),
     .              1.0E+0, I, T,
     .              RA, DEC, DIST)
            IF (RA .LT. 0.0)  RA=RA+24
            OLDPL(1,I)=RA
            OLDPL(2,I)=DEC
            OUTBUF(TODAY,1,I) =RA
            OUTBUF(TODAY,2,I) =DEC
            OUTBUF(TODAY,3,I) =DIST
         ENDIF
 10   CONTINUE
C
C
      TODAY  = TODAY+1
      RETURN
      END
