      SUBROUTINE MOVEB

      IMPLICIT CHARACTER ( A-Z )

      COMMON/VELOC/VX,VY,VZ
      COMMON/STEPS/DT
      COMMON/ATOMS/NATM
      COMMON/ENERGY/V,K,W
      COMMON/FORCES/FX,FY,FZ

      INTEGER     NMAX
      PARAMETER ( NMAX = 60000 )

      REAL        DT, DT2
      REAL        V,K,W
      REAL        VX(NMAX), VY(NMAX), VZ(NMAX)
      REAL        FX(NMAX), FY(NMAX), FZ(NMAX)

      INTEGER     I, NATM

C    *******************************************************************
C     SECOND PART OF VELOCITY VERLET ALGORITHM
C    *******************************************************************

      DT2   = DT/2.0
      K   = 0.0

      DO 100 I = 1, NATM

C**     INTEGRATE VELOCITIES HALF A TIMESTEP

        VX(I) = VX(I)+DT2*FX(I)
        VY(I) = VY(I)+DT2*FY(I)
        VZ(I) = VZ(I)+DT2*FZ(I)

C**     SUM KINETIC ENERGY

        K = K+VX(I)*VX(I)+VY(I)*VY(I)+VZ(I)*VZ(I)
100     CONTINUE

      K = 0.5*K

      RETURN
      END
