      SUBROUTINE MOVEA

      IMPLICIT CHARACTER ( A-Z )

      COMMON/COORS/RX,RY,RZ
      COMMON/VELOC/VX,VY,VZ
      COMMON/STEPS/DT
      COMMON/ATOMS/NATM
      COMMON/FORCES/FX,FY,FZ

C    *******************************************************************
C    ** FIRST PART OF THE VELOCITY VERLET ALGORITHM                   **
C    *******************************************************************

      INTEGER     NMAX
      PARAMETER ( NMAX = 60000 )

      REAL        DT, DT2, DTSQ2
      REAL        RX(NMAX), RY(NMAX), RZ(NMAX)
      REAL        VX(NMAX), VY(NMAX), VZ(NMAX)
      REAL        FX(NMAX), FY(NMAX), FZ(NMAX)

      INTEGER     I, NATM

      DT2   = DT/2.0
      DTSQ2 = DT*DT2

      DO 100 I = 1, NATM

C**     INTEGRATE COORDINATES A COMPLETE TIMESTEP

         RX(I) = RX(I)+DT*VX(I)+DTSQ2*FX(I)
         RY(I) = RY(I)+DT*VY(I)+DTSQ2*FY(I)
         RZ(I) = RZ(I)+DT*VZ(I)+DTSQ2*FZ(I)

         RX(I) = RX(I)-AINT(RX(I)+RX(I))
         RY(I) = RY(I)-AINT(RY(I)+RY(I))
         RZ(I) = RZ(I)-AINT(RZ(I)+RZ(I))

C**     INTEGRATE VELOCITIES HALF A TIMESTEP

         VX(I) = VX(I)+DT2*FX(I)
         VY(I) = VY(I)+DT2*FY(I)
         VZ(I) = VZ(I)+DT2*FZ(I)
100   CONTINUE

      RETURN
      END
