      SUBROUTINE FCC(NC)

C*********************************************************************
C**   ROUTINE TO CREATE AN FCC CONFIGUATION 
C*********************************************************************

      IMPLICIT CHARACTER ( A - Z )

      INTEGER     NMAX

      PARAMETER ( NMAX = 60000 )

      COMMON/ATOMS/NATM
      COMMON/COORS/RX,RY,RZ
      COMMON/VELOC/VX,VY,VZ

      REAL        RX(NMAX), RY(NMAX), RZ(NMAX)
      REAL        VX(NMAX), VY(NMAX), VZ(NMAX)

      INTEGER     IS,NC
      INTEGER     NATM
      INTEGER     LX,LY,LZ

      NATM = 0
C**   SEED FOR RANDOM NUMBER GENERATOR

      IS = 2215

C**   TRIPLE LOOP TO CREATE LATTICE

      DO 40 LZ=0,NC-1
        DO 50 LY=0,NC-1
          DO 60 LX=0,NC-1

C**   COORDINATES S.T. THEY WITHIN SIMULATION BOX
C**   RANDOM VELICITIES

            NATM = NATM+1
            RX(NATM) = REAL(LX)/REAL(NC)+1.0E-6-0.5
            RY(NATM) = REAL(LY)/REAL(NC)+1.0E-6-0.5
            RZ(NATM) = REAL(LZ)/REAL(NC)+1.0E-6-0.5

            CALL SRAND(IS,VX(NATM))
            CALL SRAND(IS,VY(NATM))
            CALL SRAND(IS,VZ(NATM))

            NATM = NATM+1
            RX(NATM) = (REAL(LX)+0.5)/REAL(NC)-1.0E-6-0.5
            RY(NATM) = REAL(LY)/REAL(NC)+1.0E-6-0.5
            RZ(NATM) = (REAL(LZ)+0.5)/REAL(NC)-1.0E-6-0.5
            VX(NATM) = 0.0-VX(NATM-1)
            VY(NATM) = 0.0-VY(NATM-1)
            VZ(NATM) = 0.0-VZ(NATM-1)

            NATM = NATM+1
            RX(NATM) = (REAL(LX)+0.5)/REAL(NC)-1.0E-6-0.5
            RY(NATM) = (REAL(LY)+0.5)/REAL(NC)-1.0E-6-0.5
            RZ(NATM) = REAL(LZ)/REAL(NC)+1.0E-6-0.5
            CALL SRAND(IS,VX(NATM))
            CALL SRAND(IS,VY(NATM))
            CALL SRAND(IS,VZ(NATM))

            NATM = NATM+1
            RX(NATM) = REAL(LX)/REAL(NC)+1.0E-6-0.5
            RY(NATM) = (REAL(LY)+0.5)/REAL(NC)-1.0E-6-0.5
            RZ(NATM) = (REAL(LZ)+0.5)/REAL(NC)-1.0E-6-0.5
            VX(NATM) = 0.0-VX(NATM-1)
            VY(NATM) = 0.0-VY(NATM-1)
            VZ(NATM) = 0.0-VZ(NATM-1)

 60         CONTINUE
 50       CONTINUE
 40     CONTINUE

      RETURN
      END
