C=======================================================================
C     THIS PROGRAM RE-ASSIGN THE WAVE FUNCTION COMPONENTS FOR THE CASE
C     OF RE-STARTING WITH A DIFFERENT GRID OR CUTOFF.
C=======================================================================
      SUBROUTINE REASSN(NKPTS,VKPT,
     &              NRPLWV,  NGX,     NGY,     NGZ,    ENMAX,
     &              NRPLWO,  NGXO,    NGYO,    NGZO,   ENMAXO,
     &              LPCTX,   LPCTY,   LPCTZ,   RECC,   RECO,
     &              IASSGN,  CWORK,   CPTWFP,  NBANDS, IPRINT)
      IMPLICIT COMPLEX (C)
      DIMENSION VKPT(3,*)
      DIMENSION RECC(3,*),RECO(3,*)
      DIMENSION LPCTX(*),LPCTY(*),LPCTZ(*)
      DIMENSION IASSGN(*),CWORK(*)
      DIMENSION CPTWFP(NRPLWV,NBANDS)
C=======================================================================
C                       THE DATA STATEMENTS
C TPI = (NOT SURPRISINGLY) 2*PI
C HSQDTM = (PLANCK'S CONSTANT/(2*PI))**2/(2*ELECTRON MASS)
C=======================================================================
      DATA TPI,HSQDTM /6.283185307,3.810033/
      DO 2000 N=1,NKPTS
C=======================================================================
C FIRST, WE FIND FOR EVERY G-POINTS IN TNE NEW GRID, ITS CORRESPONDING 
C POINT AT THE OLD GRID
C=======================================================================
        NBOX=0
        NBOXO=0
        DO 2010 NZ=1,NGZ
          GZX =RECC(3,1)*(LPCTZ(NZ)+VKPT(3,N))
          GZY =RECC(3,2)*(LPCTZ(NZ)+VKPT(3,N))
          GZZ =RECC(3,3)*(LPCTZ(NZ)+VKPT(3,N))
          GZXO=RECO(3,1)*(LPCTZ(NZ)+VKPT(3,N))
          GZYO=RECO(3,2)*(LPCTZ(NZ)+VKPT(3,N))
          GZZO=RECO(3,3)*(LPCTZ(NZ)+VKPT(3,N))
          DO 2011 NY=1,NGY
            GYX =RECC(2,1)*(LPCTY(NY)+VKPT(2,N))
            GYY =RECC(2,2)*(LPCTY(NY)+VKPT(2,N))
            GYZ =RECC(2,3)*(LPCTY(NY)+VKPT(2,N))
            GYXO=RECO(2,1)*(LPCTY(NY)+VKPT(2,N))
            GYYO=RECO(2,2)*(LPCTY(NY)+VKPT(2,N))
            GYZO=RECO(2,3)*(LPCTY(NY)+VKPT(2,N))
            DO 2012 NX=1,NGX
              GXX =RECC(1,1)*(LPCTX(NX)+VKPT(1,N))
              GXY =RECC(1,2)*(LPCTX(NX)+VKPT(1,N))
              GXZ =RECC(1,3)*(LPCTX(NX)+VKPT(1,N))
              GXXO=RECO(1,1)*(LPCTX(NX)+VKPT(1,N))
              GXYO=RECO(1,2)*(LPCTX(NX)+VKPT(1,N))
              GXZO=RECO(1,3)*(LPCTX(NX)+VKPT(1,N))
              GX=GXX+GYX+GZX
              GY=GXY+GYY+GZY
              GZ=GXZ+GYZ+GZZ
              GXO=GXXO+GYXO+GZXO
              GYO=GXYO+GYYO+GZYO
              GZO=GXZO+GYZO+GZZO
C
              ENERG =HSQDTM*(GX**2+GY**2+GZ**2)
              ENERGO=HSQDTM*(GXO**2+GYO**2+GZO**2)
C
              IF(ENERG.LT.ENMAX) NBOX=NBOX+1
              IF(ENERGO.LT.ENMAXO) NBOXO=NBOXO+1
C
              IF(ENERG.GE.ENMAX) GOTO 2012
C
              IF(ENERGO.LT.ENMAXO) THEN
                IASSGN(NBOX)=NBOXO
              ELSE
                IASSGN(NBOX)=0
              END IF
C
 2012       CONTINUE
 2011     CONTINUE
 2010   CONTINUE
      WRITE(*,100) N,NBOX,NBOXO
  100 FORMAT(/,' IN REASSN: NKP=',I2,'  NBOX=',I5,'  NBOXold=',I5)
C      WRITE(*,101) (I,IASSGN(I),I=1,NBOX)
  101 FORMAT(2I6)
C=======================================================================
C NOW READ IN THE OLD WAVE FUNCTIONS, AND RE-WRITE THEM ACCORDING TO THE
C NEW SEQUENCE
C=======================================================================
      NPUNIT=19+N
      REWIND NPUNIT
      READ(NPUNIT) ((CPTWFP(I,J),I=1,NRPLWO),J=1,NBANDS)
      DO 60 NB=1,NBANDS
      DO 70 M=1,NRPLWO
      CWORK(M)=CPTWFP(M,NB)
      CPTWFP(M,NB)=CMPLX(0.0,0.0)
   70 CONTINUE
C
      DO 80 M=1,NRPLWV
      IF(IASSGN(M).EQ.0) THEN
         CPTWFP(M,NB)=CMPLX(0.0,0.0)
      ELSE
         CPTWFP(M,NB)=CWORK(IASSGN(M))
      END IF
   80 CONTINUE
   60 CONTINUE
      REWIND NPUNIT
      WRITE(NPUNIT) ((CPTWFP(I,J),I=1,NRPLWV),J=1,NBANDS)
C
 2000 CONTINUE
      RETURN
      END
