C     MODIFICATIONS MADE BY X WENG:
C
C     16-MAR-90  COPIED FROM S.K. RANCHU'S SUBROUTINE FNLELD.
C     16-MAR-90  SPLITED INTO TWO SUBROUTINES
C	         1) NLCV:   SETUP CV0, CV1, CV2, ETC.
C	 	 2) VNLWAV: Vnl*WAV FOR one BAND
C		            REDUCE CFORCE(NRPLWV,NBANDS) TO CFORCE(NRPLWV)
C
C     16-JUN-90  SOME IF STATEMENTS ARE REARRANGED TO ENHANCE SPEED.
C
C     17-JUN-90  CV0, CV1, AND CV2 ARE REDUCED TO ONE K-POINT A TIME
C                TO REDUCE THE DEMAND ON MEMORY SPACE. THIS WILL NOT 
C                RESULT AN INCREASE IN COMPTUTIONAL TIME FOR DYNAMIC 
C                SIMULATION, BUT WILL DO SO FOR THE STATIC CALCULATION,
C                WHERE CV0 ETC REMAIN THE SAME.
C		 TESTED AND WORKED
C
C
C      26-JUN-90 NLCV is separated into two subroutines, one for V(q)
C                and the other for exp(iq.R)
C
C
C      05-JUN-90 CHANGED TO NON-ORTHOGONAL UNIT CELL
C                 
C
C==========================================================================
C  
C    SUBROUTINE PHASGR CALCULATES
C
C    CPHSGR(NRPLWV,NIONS) = exp(iq.Rn)
C
C    N.B. DNLG IS IN UNITS OF INV(ANGSTROM) AND
C         POSION IS IN UNITS OF DIRECT SPACE VECTOR DIRC(I,J)
C         TWO PI IS INCLUDED.
C
      SUBROUTINE PHASGR(NRPLWV,NSPEC,NIONSP,NIONS,NPLWKP,DNLG,POSION,
     &                  DIRC, CPHSGR,IVPTYN)
      IMPLICIT COMPLEX (C)
      DIMENSION NIONSP(NSPEC), POSION(3,NIONS,NSPEC), DNLG(NRPLWV,3)
      DIMENSION CPHSGR(NRPLWV,NIONS,NSPEC), DIRC(3,3)
      DIMENSION IVPTYN(NSPEC)
      DATA TWOPI/6.2831853090/
C
      DO 10 NSP=1,NSPEC
        IF (IVPTYN(NSP).EQ.0) GO TO 10
        DO 20 MU=1,NIONSP(NSP)
C
C     CONVERT ATOMIC POSITION INTO CARTESIAN COORDINATE
C     (IN UNITS OF ANGSTROM)
C
          X = POSION(1,MU,NSP) * DIRC(1,1) +
     &      POSION(2,MU,NSP) * DIRC(2,1) + POSION(3,MU,NSP) * DIRC(3,1)
          Y = POSION(1,MU,NSP) * DIRC(1,2) + 
     &      POSION(2,MU,NSP) * DIRC(2,2) + POSION(3,MU,NSP) * DIRC(3,2)
          Z = POSION(1,MU,NSP) * DIRC(1,3) + 
     &      POSION(2,MU,NSP) * DIRC(2,3) + POSION(3,MU,NSP) * DIRC(3,3)
C
          DO 30 M=1,NPLWKP
            GDOTR = DNLG(M,1) * X  +  DNLG(M,2) * Y  +  DNLG(M,3) * Z
            CPHSGR(M,MU,NSP) = CEXP( CMPLX(0.0, GDOTR) )
  30      CONTINUE
  20    CONTINUE
  10  CONTINUE
C
      RETURN
      END
C=====================================================================
C     SUBROUTINE NLV SETS UP  VGNL(NRPLWV)=V(G)
C     05-JUN-90 CHANGED TO NON-ORTHOGONAL UNIT CELL
C
      SUBROUTINE SETVG(NRPLWV,NSPEC,NPSPTS,NIONSP,NPLWKP,DNLKG,
     &                 VQ,VSCA,QMAX,VGNL,DVGNL,NPSPTN,IVPTYN)
      IMPLICIT COMPLEX (C)
      DIMENSION NIONSP(NSPEC), NPSPTN(NSPEC), IVPTYN(NSPEC)
      DIMENSION DNLKG(NRPLWV,0:3)
      DIMENSION VQ(NPSPTS,0:2,NSPEC)
      DIMENSION QMAX(NSPEC),VSCA(0:2,NSPEC)
      DIMENSION VGNL(NRPLWV,0:2,NSPEC),DVGNL(NRPLWV,0:2,NSPEC)
C
      SIXTH = 1.0 / 6.0
C
      DO 10 NSP = 1,NSPEC
        IF (IVPTYN(NSP).EQ.0) GO TO 10
        NPSPT2 = NPSPTN(NSP) - 2
        ARGSC = ( NPSPTN(NSP) - 1 ) / QMAX(NSP)
        DO 20 L = 0,2
C=====================================================================
C     SET TO V(G)=0.0  FOR THE LOCAL ONE
C=====================================================================
C     IF(LOCAL(NSP).NE.L) GOTO 35
C
C THE FOLLOWING CHANGES IS MADE TO TAKE INTO ACCONT THE CASE WHERE WE
C HAVE ONLY 1 NON-LOCAL PART. SUCH AS IN CARBON, WE SET p-POTETNITAL 
C TO BE LOCAL, AND NO NON-LOCAL FOR d EITHER.
C						30-NOV-90
C
          IF (ABS (VSCA(L,NSP) ).GE.1.E-6)  GOTO 35
          DO 30 M = 1,NPLWKP
            VGNL(M,L,NSP) = 0.0
  30      CONTINUE
          GOTO 20
C=====================================================================
C     SET UP V(L,G,NSPEC)
C=====================================================================
  35      CONTINUE
          DO 40 M = 1,NPLWKP
            Q = DNLKG(M,0)
            ARG = ( ARGSC * Q ) + 1.0
            NADDR = INT(ARG)
            REM = ARG - NADDR
C=====================================================================
C     IF G .GT. QMAX, V(G)=0.0
C=====================================================================
            IF (NADDR.GT.NPSPT2) THEN
              VGNL(M,L,NSP)  = 0.0
              DVGNL(M,L,NSP) = 0.0
            GOTO 40
            END IF
C=====================================================================
C     INTERPOLATE V(G)
C=====================================================================
            IF (NADDR.EQ.1) THEN
              VGNL(M,L,NSP) = VQ(1,L,NSP)
            ELSE
              V1 = VQ(NADDR-1,L,NSP)
              V2 = VQ(NADDR,  L,NSP)
              V3 = VQ(NADDR+1,L,NSP)
              V4 = VQ(NADDR+2,L,NSP)
              T0 = V2
              T1 = ( (6.0*V3) - (2.0*V1) - (3.0*V2) - V4 ) * SIXTH
              T2 = ( V1 + V3 - (2.0*V2) ) / 2.0
              T3 = ( V4 - V1 + (3.0 * (V2-V3) ) ) * SIXTH
              VGNL(M,L,NSP) = (T0 + REM * ( T1 + REM * (T2+REM*T3) ) )
C=======================================================================
C     INTERPOLATE ITS DERIVATIVE
C=======================================================================
              DVGNL(M,L,NSP) = ARGSC * 
     &                  ( T1 + REM * ( (2.0*T2) + (3.0 * REM * T3) ) )
            ENDIF
  40      CONTINUE
  20    CONTINUE
  10  CONTINUE
      RETURN
      END
C=========================================================================
C    THIS SUBROUTINE CALCULATES
C    
C    Vnl |PSI(n,k)> 
C
C    THE RESULT IS IN RECIPROCAL SPACE, SUCH THAT
C
C			____
C    Vnl |PSI(n,k)> =   \      CFORCE(G) |G>
C			/___
C			  G				
C
C            ->     ----
C    CFORCE( G ) =  \    <G| Vnl |PSI(n,k)>
C                   /___
C		      l	
C
C	    	    ____
C    ASSUMING THAT  \      |G> <G|   IS COMPLETE.
C		    /___
C		     G				
C
C ---------------------------------------------------------------------
C
C  N.B. 1 ) MUST BE PROCEEDED WITH SUBROUTINE CPHSGR AND VGNL !
C       2 ) FOR ONE BAND ONLY, I.E. BAND No. NN 
C
C
      SUBROUTINE VNLWAV(NRPLWV,NIONS,NSPEC,NIONSP,NPLWKP,DNLKG,
     &           VOL,VSCA,CPTWFP,C0,C1,C2A,C2B,
     &           CPHSGR,VGNL,CFORCE,CWORK1,CWORK2,NN,IVPTYN)
C
      IMPLICIT COMPLEX (C)
C
      DIMENSION NIONSP(NSPEC),IVPTYN(NSPEC)
      DIMENSION DNLKG(NRPLWV,0:3)
      DIMENSION VSCA(0:2,NSPEC)
      DIMENSION C0(NIONS),C1(3,NIONS),C2A(NIONS),C2B(3,3,NIONS)
      DIMENSION CPHSGR(NRPLWV,NIONS,NSPEC), VGNL(NRPLWV,0:2,NSPEC)
      DIMENSION CPTWFP(*)
      DIMENSION CFORCE(NRPLWV)
      DIMENSION CWORK1(*),CWORK2(*)
      DATA TWOPI/6.28318531/
C
      NINDW = NRPLWV * ( NN - 1 )
C
      DO 98 J = 1,NRPLWV
        CFORCE(J) = (0.0,0.0)
98    CONTINUE
C
      DO 100 NSP = 1,NSPEC
C
        IF (IVPTYN(NSP).EQ.0) GO TO 100
C
        IF (ABS(VSCA(0,NSP)).GE.1.E-6)  THEN
          SCA0 = 2.0 * TWOPI / VOL / VSCA(0,NSP)
        ELSE
          SCA0 = 0.0
        ENDIF
C
        IF (ABS(VSCA(1,NSP)).GE.1.E-6)  THEN
          SCA1 = 6.0 * TWOPI / VOL / VSCA(1,NSP)
        ELSE
          SCA1 = 0.0
        ENDIF
C
        IF (ABS(VSCA(2,NSP)).GE.1.E-6)  THEN
          SCA2A = - 5.0 * TWOPI / VOL / VSCA(2,NSP)
          SCA2B =  15.0 * TWOPI / VOL / VSCA(2,NSP)
        ELSE
          SCA2A = 0.0
          SCA2B = 0.0
        ENDIF
C======================================================================
C THIS SECOND PART PRODUCES THE SUM OVER G OF THE
C PSEUDOPOT*EXP(IG.R)*CG*GEOMETRICAL FACTOR. 
C======================================================================
        DO 3000 MU = 1,NIONSP(NSP)
C
          C0(MU) = (0.0,0.0)
          C2A(MU) = (0.0,0.0)
          DO 3001 I = 1,3
            C1(I,MU) = (0.0,0.0)
            DO 3002 J = 1,3
              C2B(I,J,MU) = (0.0,0.0)
3002        CONTINUE
3001      CONTINUE
C
          DO 3030 M = 1,NPLWKP
            CWORK1(M) = CONJG (CPHSGR(M,MU,NSP)) * CPTWFP(M+NINDW)
 3030     CONTINUE
C======================================================================
C     for L=0
C     CVWV = V*EXP(iq.R)*WAVEFUNCTION(RADIAL PART)
C======================================================================
C     IF (LOCAL(NSP).EQ.0) GOTO 3005
          IF (ABS(VSCA(0,NSP)).LT.1.E-6) GOTO 3005
          DO 3003 M = 1,NPLWKP
            C0(MU) = C0(MU) + CWORK1(M) * VGNL(M,0,NSP)
3003      CONTINUE
3005      CONTINUE
C======================================================================
C     for L=1
C======================================================================
C     IF (LOCAL(NSP).EQ.1) GOTO 3015
          IF (ABS(VSCA(1,NSP)).LT.1.E-6) GOTO 3015
          DO 3010 M = 1,NPLWKP
            CWORK2(M) = CWORK1(M) * VGNL(M,1,NSP)
 3010     CONTINUE
          DO 3011 I = 1,3
            DO 3011 M = 1,NPLWKP
              C1(I,MU) = C1(I,MU) + CWORK2(M) * DNLKG(M,I)
3011      CONTINUE
3015      CONTINUE
C======================================================================
C     for L=2
C======================================================================
C     IF (LOCAL(NSP).EQ.2) GOTO 3000
          IF (ABS(VSCA(2,NSP)).LT.1.E-6) GOTO 3000
          DO 3020 M = 1,NPLWKP
            CWORK2(M) = CWORK1(M) * VGNL(M,2,NSP)
            C2A(MU)   = C2A(MU) + CWORK2(M)
 3020     CONTINUE
          DO 3025 J = 1,3
            DO 3024 I = 1,3
              DO 3021 M = 1,NPLWKP
                C2B(I,J,MU) = C2B(I,J,MU) + 
     &                        CWORK2(M) * DNLKG(M,I) * DNLKG(M,J) 
 3021         CONTINUE
 3024       CONTINUE
 3025     CONTINUE
C
 3000   CONTINUE
C======================================================================
C THIS THIRD PART DOES THE SUMS OVER ATOMS AND COMPONENTS TO
C GIVE THE "FORCE" ON THE PLANE WAVE COEFFICIENT C(G,BAND,K-POINT).
C THE DIAGONAL CONTRIBUTION IS CALCULATED SEPARATELY.
C======================================================================
C
C======================================================================
C     for L=0
C======================================================================
C     IF (LOCAL(NSP).EQ.0) GOTO 4015
        IF (ABS(VSCA(0,NSP)).LT.1.E-6) GOTO 4015
        DO 4010 M = 1,NPLWKP
          CWORK1(M) = (0.0,0.0)
 4010   CONTINUE
        DO 4012 MU = 1,NIONSP(NSP)
          DO 4011 M = 1,NPLWKP
            CWORK1(M) = CWORK1(M) + CPHSGR(M,MU,NSP) * C0(MU)
 4011     CONTINUE
 4012   CONTINUE
        DO 4013 M = 1,NPLWKP
          CFORCE(M) = CFORCE(M) + SCA0 * VGNL(M,0,NSP) * CWORK1(M)
 4013   CONTINUE
C======================================================================
C     for L=1
C======================================================================
4015    CONTINUE
C     IF (LOCAL(NSP).EQ.1) GOTO 4025
        IF (ABS(VSCA(1,NSP)).LT.1.E-6) GOTO 4025
        DO 4020 M = 1,NPLWKP
          CWORK1(M) = (0.0,0.0)
 4020   CONTINUE
        DO 4023 MU = 1,NIONSP(NSP)
          DO 4022 I = 1,3
            DO 4021 M = 1,NPLWKP
              CWORK1(M) = CWORK1(M) + 
     &                    CPHSGR(M,MU,NSP) * C1(I,MU) * DNLKG(M,I)
 4021       CONTINUE
 4022     CONTINUE
 4023   CONTINUE
        DO 4024 M = 1,NPLWKP
          CFORCE(M) = CFORCE(M) + SCA1 * VGNL(M,1,NSP) * CWORK1(M)
 4024   CONTINUE
C======================================================================
C     for L=2
C======================================================================
4025  CONTINUE
C     IF (LOCAL(NSP).EQ.2) GOTO 4037
        IF (ABS(VSCA(2,NSP)).LT.1.E-6) GOTO 4037
        DO 4030 M = 1,NPLWKP
          CWORK1(M) = (0.0,0.0)
          CWORK2(M) = (0.0,0.0)
 4030   CONTINUE
        DO 4035 MU = 1,NIONSP(NSP)
          DO 4031 M = 1,NPLWKP
            CWORK1(M) = CWORK1(M) + CPHSGR(M,MU,NSP) * C2A(MU)
 4031     CONTINUE
          DO 4034 J = 1,3
            DO 4033 I = 1,3
              DO 4032 M = 1,NPLWKP
                CWORK2(M) = CWORK2(M) + CPHSGR(M,MU,NSP) *
     &                      C2B(I,J,MU) * DNLKG(M,I) * DNLKG(M,J)
 4032         CONTINUE
 4033       CONTINUE
 4034     CONTINUE
 4035   CONTINUE
        DO 4036 M = 1,NPLWKP
          CFORCE(M) = CFORCE(M) + VGNL(M,2,NSP) * ( SCA2A * CWORK1(M) +
     &                            SCA2B * CWORK2(M) )
 4036   CONTINUE
 4037   CONTINUE
C
 100  CONTINUE
C
      RETURN
      END
C                                          
C
C
C
C
C !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
C
      SUBROUTINE FNLFOR(NBANDS,NRPLWV,NIONSP,NPLWKP,NIONS,
     &           VOL,VSCA, CPHSGR,VGNL,DNLG,DNLKG,CPTWFP,FORCE,
     &           OCC,CWORK1,CWORK2)
C
      IMPLICIT COMPLEX (C)
C
      DIMENSION CPHSGR(NRPLWV,NIONS), VGNL(NRPLWV,0:2)
      DIMENSION DNLG(NRPLWV,3),DNLKG(NRPLWV,0:3)
      DIMENSION VSCA(0:2)
      DIMENSION CPTWFP(*), OCC(*)
      DIMENSION FORCE(3,NIONS)
      DIMENSION C0(0:3),C1(3,0:3),C2A(0:3),C2B(3,3,0:3)
      DIMENSION CF0(3),CF1(3),CF2A(3),CF2B(3)
      DIMENSION CWORK1(*), CWORK2(*)
C
      DATA TWOPI/6.28318531/
      CI = (0.0,-1.0)
C
C     VOL=SIZEX*SIZEY*SIZEZ
C
C     IF (LOCAL.NE.0) THEN
      IF (ABS(VSCA(0)).GE.1.E-6) THEN
        SCA0 = 2.0 * TWOPI / VOL / VSCA(0)
      ELSE
        SCA0 = 0.0
      ENDIF
C
C     IF (LOCAL.NE.1) THEN
      IF (ABS(VSCA(1)).GE.1.E-6) THEN
        SCA1 = 6.0 * TWOPI / VOL / VSCA(1)
      ELSE
        SCA1 = 0.0
      ENDIF
C
C     IF (LOCAL.NE.2) THEN
      IF (ABS(VSCA(2)).GE.1.E-6) THEN
        SCA2A = - 5.0 * TWOPI / VOL / VSCA(2)
        SCA2B =  15.0 * TWOPI / VOL / VSCA(2)
      ELSE
        SCA2A = 0.0
        SCA2B = 0.0
      ENDIF
C
      DO 500 MU = 1,NIONSP
        DO 501 I = 1,3
          FORCE(I,MU) = 0.0
501     CONTINUE
500   CONTINUE
C
      DO 999 MU = 1,NIONSP
C
        DO 502 I = 1,3
          CF0(I)  = 0.0
          CF1(I)  = 0.0
          CF2A(I) = 0.0
          CF2B(I) = 0.0
502     CONTINUE
C
        DO 1001 NN = 1,NBANDS
C
          NINDW = NRPLWV * ( NN - 1 )
C
          DO 600 K = 0,3
            C0(K)  = 0.0
            C2A(K) = 0.0
            DO 601 I = 1,3
              C1(I,K) = 0.0
              DO 602 J = 1,3
                C2B(J,I,K) = 0.0
602           CONTINUE
601         CONTINUE
600       CONTINUE
          DO 604 M = 1,NPLWKP
            CWORK1(M) = CONJG(CPHSGR(M,MU)) * CPTWFP(NINDW+M)
 604      CONTINUE
C==========================================================================
C     FOR L=0
C==========================================================================
C     IF (LOCAL.EQ.0) GOTO 2100
          IF (ABS(VSCA(0)).LT.1.E-6) GOTO 2100
          DO 2001 M = 1,NPLWKP
            CDUM  = CWORK1(M) * VGNL(M,0)
            C0(0) = C0(0) + CDUM
            C0(1) = C0(1) + CDUM * DNLG(M,1)
            C0(2) = C0(2) + CDUM * DNLG(M,2)
            C0(3) = C0(3) + CDUM * DNLG(M,3)
2001      CONTINUE
C==========================================================================
C     FOR L=1
C==========================================================================
2100      CONTINUE
C     IF (LOCAL.EQ.1) GOTO 2200
          IF (ABS(VSCA(1)).LT.1.E-6) GOTO 2200
          DO 2101 M = 1,NPLWKP
            CWORK2(M) = CWORK1(M) * VGNL(M,1)
 2101     CONTINUE
          DO 2103 I = 1,3
            DO 2102 M = 1,NPLWKP
              CDUM = CWORK2(M) * DNLKG(M,I)
              C1(I,0) = C1(I,0) + CDUM
              C1(I,1) = C1(I,1) + CDUM * DNLG(M,1)
              C1(I,2) = C1(I,2) + CDUM * DNLG(M,2)
              C1(I,3) = C1(I,3) + CDUM * DNLG(M,3)
2102        CONTINUE
2103      CONTINUE
C==========================================================================
C     FOR L=2
C==========================================================================
2200      CONTINUE
C     IF (LOCAL.EQ.2) GOTO 2300
          IF (ABS(VSCA(2)).LT.1.E-6) GOTO 2300
          DO 2201 M = 1,NPLWKP
            CDUM  = CWORK1(M) * VGNL(M,2)
            CWORK2(M) = CDUM
            C2A(0) = C2A(0) + CDUM
            C2A(1) = C2A(1) + CDUM * DNLG(M,1)
            C2A(2) = C2A(2) + CDUM * DNLG(M,2)
            C2A(3) = C2A(3) + CDUM * DNLG(M,3)
 2201     CONTINUE
          DO 2204 I = 1,3
            DO 2203 J = 1,3
              DO 2202 M = 1,NPLWKP      
                CDUM = CWORK2(M) * DNLKG(M,I) * DNLKG(M,J)
                C2B(J,I,0) = C2B(J,I,0) + CDUM
                C2B(J,I,1) = C2B(J,I,1) + CDUM * DNLG(M,1)
                C2B(J,I,2) = C2B(J,I,2) + CDUM * DNLG(M,2)
                C2B(J,I,3) = C2B(J,I,3) + CDUM * DNLG(M,3)
 2202         CONTINUE
 2203       CONTINUE
 2204     CONTINUE
C==========================================================================
C NOW WE ADD UP THE CONTRIBUTATION TO THE Fx, Fy, Fz OF EACH BANDS
C PARTIAL OCCUPATNCY IS INCLUDED HERE
C==========================================================================
2300      CONTINUE
C
C     IF (LOCAL.NE.0) THEN
          IF (ABS(VSCA(0)).GE.1.E-6) THEN
            CDUM = CI * C0(0) * OCC(NN)
            DO 3003 I = 1,3
              CF0(I) = CF0(I) + CONJG(C0(I)) * CDUM
 3003       CONTINUE
          ENDIF
C
C     IF (LOCAL.NE.1) THEN
          IF (ABS(VSCA(1)).GE.1.E-6) THEN
            DO 3000 I = 1,3
              CDUM = CI * OCC(NN) * C1(I,0)
              DO 3005 J = 1,3
                CF1(J) = CF1(J) + CONJG(C1(I,J)) * CDUM
3005          CONTINUE
3000        CONTINUE
          ENDIF
C
C     IF (LOCAL.NE.2) THEN
          IF (ABS(VSCA(2)).GE.1.E-6) THEN
            CDUM = CI * C2A(0) * OCC(NN)
            DO 3004 I = 1,3
              CF2A(I) = CF2A(I) + CONJG(C2A(I)) * CDUM
 3004       CONTINUE
            DO 3001 I = 1,3
              DO 3002 J = 1,3
                CDUM = CI * C2B(J,I,0) * OCC(NN)
                DO 3006 K = 1,3
                  CF2B(K) = CF2B(K) + CONJG(C2B(J,I,K)) * CDUM
 3006           CONTINUE
 3002         CONTINUE
 3001       CONTINUE
          ENDIF
C
1001    CONTINUE
C
        DO 4000 I = 1,3
          FORCE(I,MU) = SCA0  * ( CF0(I)  + CONJG(CF0(I))  ) +
     &                  SCA1  * ( CF1(I)  + CONJG(CF1(I))  ) +
     &                  SCA2A * ( CF2A(I) + CONJG(CF2A(I)) ) +
     &                  SCA2B * ( CF2B(I) + CONJG(CF2B(I)) )
          FORCE(I,MU)=FORCE(I,MU)*2.0
C
4000    CONTINUE
C
999   CONTINUE
C
      RETURN
      END
C=======================================================================
C    THIS SUBROUTINE CALCULATES THE STRESS ON THE UNIT CELL (FOR THE 
C    NONLOCAL COMPONENTS OF THE PSEUDOPOTENTIAL) DUE TO THE CHANGE IN  
C    THE ELECTRON-ION ENERGY ON CHANGING THE SIZE OF THE CELL
C=======================================================================
C    
C
      SUBROUTINE FSIGNL(NRPLWV,NIONS,NSPEC,NIONSP,NPLWKP,DNLKG,VOLC,
     &           VSCA,CPTWFP,CPHSGR,VGNL,DVGNL,NBANDS,VNL,OCC,
     &           SIG,C01,C02,C11,C12,C13,C21,C22,C23,C24,C25,IVPTYN)
C
      IMPLICIT COMPLEX (C)
      DIMENSION NIONSP(NSPEC),IVPTYN(NSPEC)
      DIMENSION DNLKG(NRPLWV,0:3)
      DIMENSION VSCA(0:2,NSPEC)
      DIMENSION CPHSGR(NRPLWV,NIONS,NSPEC)
      DIMENSION VGNL(NRPLWV,0:2,NSPEC)
      DIMENSION DVGNL(NRPLWV,0:2,NSPEC)
      DIMENSION VNL(NBANDS)
      DIMENSION OCC(NBANDS)
      DIMENSION SIG(6)
      DIMENSION CPTWFP(*)
      DIMENSION C01(NBANDS,NIONS),C02(NBANDS,NIONS,6)
      DIMENSION C11(NBANDS,NIONS,3),C12(NBANDS,NIONS,6,3)
      DIMENSION C13(NBANDS,NIONS,6,3),C21(NBANDS,NIONS,3,3)
      DIMENSION C22(NBANDS,NIONS,6,3,3),C23(NBANDS,NIONS)
      DIMENSION C24(NBANDS,NIONS,6),C25(NBANDS,NIONS,6,3,3)
      DIMENSION CDUM0(6),CDUM1(6),CDUM2(6)
      DIMENSION CNG(6),CNGG(6,3),CNGGG(6,3,3)
      DIMENSION CNGG1(6,3),CNGGG1(6,3,3),CW0(4,6),CW1(6)
C
      DATA TWOPI/6.28318531/
C
C=======================================================================
C     INITIALISE STRESS ARRAY 
C=======================================================================
      DO 10 N=1,6
        SIG(N)=0.0
   10 CONTINUE
C=======================================================================
C     FIRST PART OF EINL : VGNL(K+G),VGNL(K+G'),PL(COS(K+G,K+G'))
C=======================================================================
C     START LOOP OVER ION SPECIES
C=======================================================================
      DO 20 NSP = 1,NSPEC
C
        IF (IVPTYN(NSP).EQ.0) GO TO 20
C
C=======================================================================
        IF (ABS(VSCA(0,NSP)).GE.1.E-6) THEN
          SCA0 = 4.0 * TWOPI / VOLC / VSCA(0,NSP)
        ELSE
          SCA0 = 0.0
        ENDIF
        IF (ABS(VSCA(1,NSP)).GE.1.E-6) THEN
          SCA1 = 12.0 * TWOPI / VOLC / VSCA(1,NSP)
        ELSE
          SCA1 = 0.0
        ENDIF
        IF (ABS(VSCA(2,NSP)).GE.1.E-6) THEN
          SCA2 = 10.0 * TWOPI / VOLC / VSCA(2,NSP)
        ELSE
          SCA2 = 0.0
        ENDIF
C=======================================================================
C     START LOOP OVER NIONSP,NBANDS
C=======================================================================
        DO 30 NB = 1,NBANDS
          NINDW = NRPLWV * ( NB - 1 )
C
          DO 40 NI = 1,NIONSP(NSP)
C=======================================================================
C     INITIALISE WORK VARIABLES
C=======================================================================
            C01(NB,NI) = (0.0,0.0)
            C23(NB,NI) = (0.0,0.0)
            DO 50 I = 1,6
              C02(NB,NI,I) = (0.0,0.0)
              C24(NB,NI,I) = (0.0,0.0)
              DO 60 J = 1,3
                C12(NB,NI,I,J) = (0.0,0.0)
                C13(NB,NI,I,J) = (0.0,0.0)
                DO 70 K = 1,3
                  C22(NB,NI,I,J,K) = (0.0,0.0)
                  C25(NB,NI,I,J,K) = (0.0,0.0)
   70           CONTINUE
   60         CONTINUE
   50       CONTINUE
C
            DO 80 I = 1,3
              C11(NB,NI,I) = (0.0,0.0)
              DO 90 J = 1,3
                C21(NB,NI,I,J) = (0.0,0.0)
   90         CONTINUE
   80       CONTINUE
C=======================================================================
C     THIS PART PRODUCES SUM OVER G
C=======================================================================
C     L=0
C=======================================================================
            IF (ABS(VSCA(0,NSP)).LT.1.E-6) GOTO 100
            DO 110 NG=1,NPLWKP
C
              C0NG  = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                VGNL(NG,0,NSP)
              C0DNG = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                DVGNL(NG,0,NSP) * DNLKG(NG,0)
C
              C01(NB,NI)   = C01(NB,NI)   + C0NG
              C02(NB,NI,1) = C02(NB,NI,1) + C0DNG * DNLKG(NG,1) *
     &                                      DNLKG(NG,1)
              C02(NB,NI,2) = C02(NB,NI,2) + C0DNG * DNLKG(NG,2) *
     &                                      DNLKG(NG,2)
              C02(NB,NI,3) = C02(NB,NI,3) + C0DNG * DNLKG(NG,3) *
     &                                      DNLKG(NG,3)
              C02(NB,NI,4) = C02(NB,NI,4) + C0DNG * DNLKG(NG,2) *
     &                                      DNLKG(NG,3)
              C02(NB,NI,5) = C02(NB,NI,5) + C0DNG * DNLKG(NG,3) *
     &                                      DNLKG(NG,1)
              C02(NB,NI,6) = C02(NB,NI,6) + C0DNG * DNLKG(NG,1) *
     &                                      DNLKG(NG,2)
C
  110       CONTINUE
  100       CONTINUE
C=======================================================================
C     L=1
C=======================================================================
            IF (ABS(VSCA(1,NSP)).LT.1.E-6) GOTO 120
            DO 130 NG = 1,NPLWKP
C
              C1NG  = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                VGNL(NG,1,NSP)
              C1DNG = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                DVGNL(NG,1,NSP) * DNLKG(NG,0)
C
              DO 140 J = 1,3
                CNJ = C1NG * DNLKG(NG,J)
                C11(NB,NI,J)   = C11(NB,NI,J)   + CNJ
                C13(NB,NI,1,J) = C13(NB,NI,1,J) + CNJ * DNLKG(NG,1) *
     &                                            DNLKG(NG,1)
                C13(NB,NI,2,J) = C13(NB,NI,2,J) + CNJ * DNLKG(NG,2) *
     &                                            DNLKG(NG,2)
                C13(NB,NI,3,J) = C13(NB,NI,3,J) + CNJ * DNLKG(NG,3) *
     &                                            DNLKG(NG,3)
                C13(NB,NI,4,J) = C13(NB,NI,4,J) + CNJ * DNLKG(NG,2) *
     &                                            DNLKG(NG,3)
                C13(NB,NI,5,J) = C13(NB,NI,5,J) + CNJ * DNLKG(NG,3) *
     &                                            DNLKG(NG,1)
                C13(NB,NI,6,J) = C13(NB,NI,6,J) + CNJ * DNLKG(NG,1) *
     &                                            DNLKG(NG,2)
  140         CONTINUE
              DO 150 J=1,3
                CDNJ = C1DNG * DNLKG(NG,J)
                C12(NB,NI,1,J) = C12(NB,NI,1,J) + CDNJ * 
     &                      DNLKG(NG,1) * DNLKG(NG,1) 
                C12(NB,NI,2,J) = C12(NB,NI,2,J) + CDNJ * 
     &                      DNLKG(NG,2) * DNLKG(NG,2) 
                C12(NB,NI,3,J) = C12(NB,NI,3,J) + CDNJ * 
     &                      DNLKG(NG,3) * DNLKG(NG,3) 
                C12(NB,NI,4,J) = C12(NB,NI,4,J) + CDNJ * 
     &                      DNLKG(NG,2) * DNLKG(NG,3) 
                C12(NB,NI,5,J) = C12(NB,NI,5,J) + CDNJ * 
     &                      DNLKG(NG,3) * DNLKG(NG,1) 
                C12(NB,NI,6,J) = C12(NB,NI,6,J) + CDNJ * 
     &                      DNLKG(NG,1) * DNLKG(NG,2) 
  150         CONTINUE
C
  130       CONTINUE
  120       CONTINUE
C=======================================================================
C     L=2
C=======================================================================
            IF (ABS(VSCA(2,NSP)).LT.1.E-6) GOTO 160
            DO 170 NG=1,NPLWKP
C
              C2NG  = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                VGNL(NG,2,NSP)
              C2DNG = CONJG(CPHSGR(NG,NI,NSP)) * CPTWFP(NG+NINDW) *
     &                DVGNL(NG,2,NSP) * DNLKG(NG,0)
C
              C23(NB,NI) = C23(NB,NI) + C2NG
              DO 180 J=1,3
                DO 190 K=1,3
                  CNJK = C2NG * DNLKG(NG,J) * DNLKG(NG,K)
                  C21(NB,NI,J,K)   = C21(NB,NI,J,K)   + CNJK
                  C25(NB,NI,1,J,K) = C25(NB,NI,1,J,K) + CNJK *
     &                               DNLKG(NG,1) * DNLKG(NG,1)
                  C25(NB,NI,2,J,K) = C25(NB,NI,2,J,K) + CNJK *
     &                               DNLKG(NG,2) * DNLKG(NG,2)
                  C25(NB,NI,3,J,K) = C25(NB,NI,3,J,K) + CNJK *
     &                               DNLKG(NG,3) * DNLKG(NG,3)
                  C25(NB,NI,4,J,K) = C25(NB,NI,4,J,K) + CNJK *
     &                               DNLKG(NG,2) * DNLKG(NG,3)
                  C25(NB,NI,5,J,K) = C25(NB,NI,5,J,K) + CNJK *
     &                               DNLKG(NG,3) * DNLKG(NG,1)
                  C25(NB,NI,6,J,K) = C25(NB,NI,6,J,K) + CNJK *
     &                               DNLKG(NG,1) * DNLKG(NG,2)
  190           CONTINUE
  180         CONTINUE
              CW1(1) = C2DNG * DNLKG(NG,1) * DNLKG(NG,1)
              CW1(2) = C2DNG * DNLKG(NG,2) * DNLKG(NG,2)
              CW1(3) = C2DNG * DNLKG(NG,3) * DNLKG(NG,3)
              CW1(4) = C2DNG * DNLKG(NG,2) * DNLKG(NG,3)
              CW1(5) = C2DNG * DNLKG(NG,3) * DNLKG(NG,1)
              CW1(6) = C2DNG * DNLKG(NG,1) * DNLKG(NG,2)
              DO 200 I = 1,6
                C24(NB,NI,I) = C24(NB,NI,I) + CW1(I)
                DO 210 J = 1,3
                  DO 220 K = 1,3
                    C22(NB,NI,I,J,K) = C22(NB,NI,I,J,K) + CW1(I) *
     &                                 DNLKG(NG,J) * DNLKG(NG,K)
  220             CONTINUE
  210           CONTINUE
  200         CONTINUE
C
  170       CONTINUE
  160       CONTINUE
C=======================================================================
   40     CONTINUE
C=======================================================================
   30   CONTINUE
C=======================================================================
C     NOW SUM OVER G'
C=======================================================================
        DO 230 I=1,6
          CDUM0(I) = (0.0,0.0)
          CDUM1(I) = (0.0,0.0)
          CDUM2(I) = (0.0,0.0)
  230   CONTINUE
C=======================================================================
C     L=0
C=======================================================================
        IF (ABS(VSCA(0,NSP)).LT.1.E-6) GOTO 240
        DO 250 MG=1,NPLWKP
C
          CN = (0.0,0.0)
          DO 260 I=1,6
            CNG(I) = (0.0,0.0)
  260     CONTINUE
C
          DO 270 NB=1,NBANDS
            NINDW = NRPLWV * ( NB - 1 )
C
            DO 280 NI = 1,NIONSP(NSP)
              CSPHI = CPHSGR(MG,NI,NSP) * 
     &                CONJG(CPTWFP(MG+NINDW)) * OCC(NB)
C
              CN = CN + C01(NB,NI) * CSPHI
              DO 290 I=1,6
                CNG(I) = CNG(I) + C02(NB,NI,I) * CSPHI
  290         CONTINUE
C
  280       CONTINUE
  270     CONTINUE
C
          C0DMG = DVGNL(MG,0,NSP) * DNLKG(MG,0) * CN
C
          DO 300 I=1,6
            CDUM0(I) = CDUM0(I) + CNG(I) * VGNL(MG,0,NSP)
  300     CONTINUE
C      
          CDUM0(1) = CDUM0(1) + C0DMG * DNLKG(MG,1) * DNLKG(MG,1)
          CDUM0(2) = CDUM0(2) + C0DMG * DNLKG(MG,2) * DNLKG(MG,2)
          CDUM0(3) = CDUM0(3) + C0DMG * DNLKG(MG,3) * DNLKG(MG,3)
          CDUM0(4) = CDUM0(4) + C0DMG * DNLKG(MG,2) * DNLKG(MG,3)
          CDUM0(5) = CDUM0(5) + C0DMG * DNLKG(MG,3) * DNLKG(MG,1)
          CDUM0(6) = CDUM0(6) + C0DMG * DNLKG(MG,1) * DNLKG(MG,2)
C
  250   CONTINUE
  240   CONTINUE
C=======================================================================
C     L=1
C=======================================================================
        IF (ABS(VSCA(1,NSP)).LT.1.E-6) GOTO 310
        DO 320 MG=1,NPLWKP
C
          DO 330 I=1,6
            CNG(I) = (0.0,0.0)
            DO 340 J=1,3
              CNGG(I,J)  = (0.0,0.0)
              CNGG1(I,J) = (0.0,0.0)
  340       CONTINUE
  330     CONTINUE
C
          DO 350 NB=1,NBANDS
            NINDW = NRPLWV * ( NB - 1 )
C
            DO 360 NI=1,NIONSP(NSP)
              CSPHI = CPHSGR(MG,NI,NSP) * 
     &                CONJG(CPTWFP(MG+NINDW)) * OCC(NB)
C
              DO 370 I=1,3
                CNG(I) = CNG(I) + C11(NB,NI,I) * CSPHI
  370         CONTINUE
              DO 380 I=1,6
                DO 390 J=1,3
                  CNGG(I,J)  = CNGG(I,J)  + C12(NB,NI,I,J) * CSPHI
                  CNGG1(I,J) = CNGG1(I,J) + C13(NB,NI,I,J) * CSPHI
  390           CONTINUE
  380         CONTINUE
C
  360       CONTINUE
  350     CONTINUE
          C1DMG = DVGNL(MG,1,NSP) * DNLKG(MG,0) - VGNL(MG,1,NSP) 
C
          DO 400 I=1,3
            DO 410 J=1,6
              CW0(I,J) = (0.0,0.0)
  410       CONTINUE
  400     CONTINUE
C
          DO 420 I=1,6
            DO 430 J=1,3
              CW0(1,I) = CW0(1,I) + CNG(J)     * DNLKG(MG,J)
              CW0(2,I) = CW0(2,I) + CNGG(I,J)  * DNLKG(MG,J)
              CW0(3,I) = CW0(3,I) + CNGG1(I,J) * DNLKG(MG,J)
  430       CONTINUE
  420     CONTINUE
C
          CW1(1) = DNLKG(MG,1) * DNLKG(MG,1)
          CW1(2) = DNLKG(MG,2) * DNLKG(MG,2)
          CW1(3) = DNLKG(MG,3) * DNLKG(MG,3)
          CW1(4) = DNLKG(MG,2) * DNLKG(MG,3)
          CW1(5) = DNLKG(MG,3) * DNLKG(MG,1)
          CW1(6) = DNLKG(MG,1) * DNLKG(MG,2)
C
          DO 440 I=1,6
            CDUM1(I)=CDUM1(I) + CW0(1,I) * CW1(I) * C1DMG +
     &               VGNL(MG,1,NSP) * ( CW0(2,I) - CW0(3,I) )
  440     CONTINUE
C
          CDUM1(1) = CDUM1(1) + 
     &               2.0 * VGNL(MG,1,NSP) * CNG(1) * DNLKG(MG,1)
          CDUM1(2) = CDUM1(2) + 
     &               2.0 * VGNL(MG,1,NSP) * CNG(2) * DNLKG(MG,2)
          CDUM1(3) = CDUM1(3) + 
     &               2.0 * VGNL(MG,1,NSP) * CNG(3) * DNLKG(MG,3)
          CDUM1(4) = CDUM1(4) + VGNL(MG,1,NSP) * 
     &               ( CNG(2) * DNLKG(MG,3) + DNLKG(MG,2) * CNG(3) )
          CDUM1(5) = CDUM1(5) + VGNL(MG,1,NSP) * 
     &               ( CNG(3) * DNLKG(MG,1) + DNLKG(MG,3) * CNG(1) )
          CDUM1(6) = CDUM1(6) + VGNL(MG,1,NSP) * 
     &               ( CNG(1) * DNLKG(MG,2) + DNLKG(MG,1) * CNG(2) )
C
  320   CONTINUE
  310   CONTINUE
C=======================================================================
C     L=2
C=======================================================================
        IF (ABS(VSCA(2,NSP)).LT.1.E-6) GOTO 450
        DO 460 MG=1,NPLWKP
C
          CN = (0.0,0.0)
          DO 470 I=1,6
            CNG(I) = (0.0,0.0)
            DO 480 J=1,3
              CNGG(I,J) = (0.0,0.0)
              DO 490 K=1,3
                CNGGG(I,J,K) = (0.0,0.0)
                CNGGG1(I,J,K) = (0.0,0.0)
  490         CONTINUE
  480       CONTINUE
  470     CONTINUE
C
          DO 500 NB=1,NBANDS
            NINDW = NRPLWV * ( NB - 1 )
C
            DO 510 NI=1,NIONSP(NSP)
              CSPHI = CPHSGR(MG,NI,NSP) * 
     &                CONJG(CPTWFP(MG+NINDW)) * OCC(NB)
C
              CN = CN + C23(NB,NI) * CSPHI
              DO 520 I=1,6
                CNG(I) = CNG(I) + C24(NB,NI,I) * CSPHI
                DO 530 J=1,3
                  DO 540 K=1,3
                    CNGGG(I,J,K)  = CNGGG(I,J,K) + 
     &                              C22(NB,NI,I,J,K) * CSPHI
                    CNGGG1(I,J,K) = CNGGG1(I,J,K) + 
     &                              C25(NB,NI,I,J,K) * CSPHI
  540             CONTINUE
  530           CONTINUE
  520         CONTINUE
C
              DO 550 I=1,3
                DO 560 J=1,3
                  CNGG(I,J) = CNGG(I,J) + C21(NB,NI,I,J) * CSPHI
  560           CONTINUE
  550         CONTINUE
C
  510       CONTINUE
  500     CONTINUE
C
          C2DMG = DVGNL(MG,2,NSP) * DNLKG(MG,0)
C
          DO 570 I=1,4
            DO 580 J=1,6
              CW0(I,J) = (0.0,0.0)
  580       CONTINUE
  570     CONTINUE
C
          DO 590 I=1,6
            DO 600 J=1,3
              DO 610 K=1,3
                DUM = DNLKG(MG,J) * DNLKG(MG,K)
                CW0(1,I) = CW0(1,I) + CNGG(J,K) * DUM
                CW0(2,I) = CW0(2,I) + CNGGG(I,J,K) * DUM
                CW0(4,I) = CW0(4,I) + CNGGG1(I,J,K) * DUM
  610         CONTINUE
  600       CONTINUE
  590     CONTINUE
          DO 620 I=1,3
            DO 630 J=1,3
              CW0(3,I) = CW0(3,I) + CNGG(I,J) * DNLKG(MG,J)
  630       CONTINUE
  620     CONTINUE
C
          CW1(1) = DNLKG(MG,1) * DNLKG(MG,1)
          CW1(2) = DNLKG(MG,2) * DNLKG(MG,2)
          CW1(3) = DNLKG(MG,3) * DNLKG(MG,3)
          CW1(4) = DNLKG(MG,2) * DNLKG(MG,3)
          CW1(5) = DNLKG(MG,3) * DNLKG(MG,1)
          CW1(6) = DNLKG(MG,1) * DNLKG(MG,2)
C
          DO 640 I = 1,6
            CDUM2(I) = CDUM2(I) + 3.0 * CW0(1,I) * CW1(I) * 
     &                 ( C2DMG - 2.0 * VGNL(MG,2,NSP) ) +
     &      VGNL(MG,2,NSP) * ( 3.0 * CW0(2,I) - CNG(I) - 6.0 *CW0(4,I) )
     &      - CN * C2DMG * CW1(I)
  640     CONTINUE
C
          CDUM2(1) = CDUM2(1) +
     &               12.0 * VGNL(MG,2,NSP) * CW0(3,1) * DNLKG(MG,1)
          CDUM2(2) = CDUM2(2) +
     &               12.0 * VGNL(MG,2,NSP) * CW0(3,2) * DNLKG(MG,2)
          CDUM2(3) = CDUM2(3) +
     &               12.0 * VGNL(MG,2,NSP) * CW0(3,3) * DNLKG(MG,3)
          CDUM2(4) = CDUM2(4) + 6.0 * VGNL(MG,2,NSP) *
     &               ( CW0(3,2) * DNLKG(MG,3) + DNLKG(MG,2) * CW0(3,3) )
          CDUM2(5) = CDUM2(5) + 6.0 * VGNL(MG,2,NSP) *
     &               ( CW0(3,3) * DNLKG(MG,1) + DNLKG(MG,3) * CW0(3,1) )
          CDUM2(6) = CDUM2(6) + 6.0 * VGNL(MG,2,NSP)*
     &               ( CW0(3,1) * DNLKG(MG,2) + DNLKG(MG,1) * CW0(3,2) )
C
  460   CONTINUE
  450   CONTINUE
C=======================================================================
C     SUM UP
C=======================================================================
        DO 650 I = 1,6
          SIG(I) = SIG(I) + 
     &         REAL(SCA0 * CDUM0(I) + SCA1 * CDUM1(I) + SCA2 * CDUM2(I))
  650   CONTINUE
C=======================================================================
   20 CONTINUE
C=======================================================================
C     SECOND PART OF EINL : 1/VOL DEPENDENCE OF VNL
C=======================================================================
      DO 660 NB = 1,NBANDS
        DO 670 I = 1,3
          SIG(I) = SIG(I) + 2.0 * VNL(NB) * OCC(NB)
  670   CONTINUE
  660 CONTINUE
C=======================================================================
      DO 680 I = 1,6
        SIG(I) = - SIG(I) / VOLC
  680 CONTINUE
C=======================================================================
      RETURN
      END
