C***********************************************************************
C FILE FSTFTR.FOR
C
C HISTORY 23/2/90: COPIED FROM FSTFGB.FOR
C                  FSTF16() CHANGED TO FSTFTR()
C***********************************************************************
      SUBROUTINE FSTFTR(NGX,NGY,NGZ,NIONS,NPLWV,POSION,CSTRF,
     &     LPCTX,LPCTY,LPCTZ)
C=======================================================================
C
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE FSTF16 }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C
C THIS SUBROUTINE CALCULATES THE STRUCTURE FACTOR ON THE GRID OF
C RECIPROCAL LATTICE VECTORS
C CSTRF(G) = SUM OVER IONS (EXP(IG.R)) WHERE R IS THE POSITION OF THE
C ION
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION POSION(3,*)
      DIMENSION CSTRF(*)
      DIMENSION LPCTX(*),LPCTY(*),LPCTZ(*)
      DATA CITPI /(0.0,6.2831853072)/
C=======================================================================
C INITIALISE THE STRUCTURE FACTORE TO ZERO
C=======================================================================
      DO 4001 N=1,NPLWV
        CSTRF(N)=(0.0,0.0)
 4001 CONTINUE
      DO 4002 M=1,NIONS
C=======================================================================
C READ IN THE POSITION OF THE ION
C=======================================================================
        GXDX=POSION(1,M)
        GYDY=POSION(2,M)
        GZDZ=POSION(3,M)
C=======================================================================
C ADD THE CONTRIBUTION TO THE STRUCTURE FACTOR FROM THE ION
C=======================================================================
        NG=1
        DO 4003 N=1,NGZ
          GDZ=GZDZ*LPCTZ(N)
          DO 4004 NN=1,NGY
            GDY=GYDY*LPCTY(NN)
            DO 4005 NNN=1,NGX
              GDX=GXDX*LPCTX(NNN)
              CGDR=CITPI*(GDZ+GDY+GDX)
              CSTRF(NG)=CSTRF(NG)+CEXP(CGDR)
              NG=NG+1
 4005       CONTINUE
 4004     CONTINUE
 4003   CONTINUE
 4002 CONTINUE
      RETURN
      END
