 /*
  * Front end to the ULTRIX miscd service. The front end logs the remote host
  * name and then invokes the real miscd daemon. Install as "/usr/etc/miscd",
  * after moving the real miscd daemon to the "/usr/etc/..." directory.
  * Connections and diagnostics are logged through syslog(3).
  * 
  * The Ultrix miscd program implements the systat service, which pipes the
  * output from who(1) to stdout. This information is potentially useful to
  * systems crackers.
  * 
  * Compile with -DHOSTS_ACCESS in order to enable access control. See the
  * hosts_access(5) manual page for details.
  * 
  * Author: Wietse Venema, Eindhoven University of Technology, The Netherlands.
  */

#ifndef lint
static char sccsid[] = "@(#) miscd.c 1.1 91/01/06 22:30:32";
#endif

#include <stdio.h>
#include <syslog.h>

/* The following specifies where the vendor-provided daemon should go. */

#define REAL_DAEMON	"/usr/etc/.../miscd"

main(argc, argv)
int     argc;
char  **argv;
{
    char   *fromhost();
    char   *host_name;

    /*
     * Open a channel to the syslog daemon. Older versions of openlog()
     * require only two arguments.
     */

#ifdef LOG_MAIL
    (void) openlog(argv[0], LOG_PID, LOG_MAIL);
#else
    (void) openlog(argv[0], LOG_PID);
#endif

    /* Find out and report the remote host name. */

    if ((host_name = fromhost()) == 0)
	host_name = "unknown";
    syslog(LOG_INFO, "connect from %s", host_name);

    /* Check whether this host can access the service in argv[0]. */

#ifdef HOSTS_ACCESS
    hosts_access(argv[0], host_name);
#endif

    /* Invoke the real daemon program. */

    (void) execv(REAL_DAEMON, argv);
    syslog(LOG_ERR, "%s: %m", REAL_DAEMON);
    return (1);
}
