/* tai_args.c - Argument processing routines */

#ifndef lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/dsap/common/RCS/tai_args.c,v 8.0 91/07/17 12:25:52 isode Rel $";
#endif

/*
 * $Header: /a/vulcan/xtel/isode/isode-master/dsap/common/RCS/tai_args.c,v 8.0 91/07/17 12:25:52 isode Rel $
 *
 *
 * $Log:	tai_args.c,v $
 * Revision 8.0  91/07/17  12:25:52  isode
 * Release 7.0
 * 
 * 
 */

/*
 *                                NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include "quipu/util.h"
#include "quipu/attr.h"

extern char *oidtable,
	    *tailfile,
	    *myname;

extern LLog *log_dsap;

char        *usage = "[flags]";
char        *options = "T:t:c:";

tai_args (acptr,avptr)
int *acptr;
char ***avptr;
{
register char ** av;

int cnt;
register char *cp;

	if (acptr == (int *)NULL)
		return;

	if (*acptr <= 1)
		return;

	av = *avptr;
	av++, cnt = 1;

	while ((cp = *av) && *cp == '-') {
		switch (*++cp) {
			case 'T': oidtable = *++av;
				  cnt++;
					break;
			case 'c': myname = *++av;
				  cnt++;
					break;
			case 't': tailfile = *++av;
				  cnt++;
					break;

			default:
				LLOG (log_dsap,LLOG_FATAL,("Usage: %s %s\n",*avptr[0],usage));
				fatal(-1,"Usage...");
		}
		av++;
		cnt++;
	}

	*acptr -= cnt;
	*avptr = av;
}
