/* template.c - your comments here */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/bind.c,v 8.0 91/07/17 13:18:35 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/bind.c,v 8.0 91/07/17 13:18:35 isode Rel $
 *
 *
 * $Log:	bind.c,v $
 * Revision 8.0  91/07/17  13:18:35  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/*****************************************************************************

  bind.c -

*****************************************************************************/

#include <stdio.h>
#include "bind.h"
#include "quipu/common.h"
#include "quipu/bind.h"
#include "quipu/dap2.h"
#include "logger.h"

extern char *dsa_address;
extern char *username;

extern int boundToDSA;

extern LLog *de_log;

/* this is not the way to do it */
extern int dsap_ad;

struct DAPconnect         dc;
struct DAPindication      di;

static int bindres;
/*
 * bind_to_ds - Bind to directory
 *
 */
/* ARGSUSED */
int init_bind_to_ds(argc, argv, assoc)
int argc;
char ** argv;
int * assoc;
{
struct ds_bind_arg bind_arg;
struct PSAPaddr             *addr;
void exit();

  bind_arg.dba_version = DBA_VERSION_V1988;
  bind_arg.dba_auth_type = DBA_AUTH_SIMPLE;

  if (initialisations() == NOTOK)
    return NOTOK;

  bind_arg.dba_dn = str2dn(username);

  bind_arg.dba_passwd[0] = '\0';
  bind_arg.dba_passwd_len = 0;

  if ((addr = str2paddr (dsa_address)) == NULLPA) {
    (void) fprintf(stderr, "str2paddr problem\n");
    exit(-1);
  }
  bindres = DapAsynBindRequest(addr, &bind_arg, &dc, &di, ROS_ASYNC);
  if (bindres == NOTOK){
    (void) fprintf(stderr, "Directory server temporarily unavailable\n");
    return NOTOK;
  }
  *assoc = dc.dc_sd;
  dsap_ad = dc.dc_sd;
  return OK;
}


int wait_bind_to_ds(assoc, wantToBlock)
int assoc;
int wantToBlock;
{
  struct PSAPindication   pi_s;
  struct PSAPindication   * pi = &(pi_s);
  int     nfds, nevents;
  fd_set  rfds;
  fd_set  wfds;


  while ((bindres == CONNECTING_1) || (bindres == CONNECTING_2)) 
  {

    FD_ZERO (&rfds);
    FD_ZERO (&wfds);

    if ((bindres == CONNECTING_2) && (wantToBlock == FALSE))
      return CONNECTING_2;

    if (bindres == CONNECTING_1) 
    {
      if (PSelectMask (assoc, &wfds, &nfds, pi) == NOTOK) 
      {
         (void) fprintf(stderr, "PSelectMask (write) failed\n");
         return NOTOK;
      }
    }

    if (bindres == CONNECTING_2) 
    {
      if (PSelectMask (assoc, &rfds, &nfds, pi) == NOTOK) 
      {
        (void) fprintf(stderr, "PSelectMask (read) failed\n");
        return NOTOK;
      }
    }

    nevents = xselect (nfds, &rfds, &wfds, NULLFD, NOTOK);
  
    if (nevents == NOTOK) 
    {
      (void) fprintf(stderr, "xselect failed\n");
      return NOTOK;
    } 
    else 
    {
      /*
       * Hack coming up: nevents is number of events, we only asked for
       * one event, so unless there are no events we go ahead without
       * checking those horrid fd things, which would be safer.
       */
       if (nevents != OK) 
         bindres = DapAsynBindRetry(assoc, 0, &dc, &di);
    }
  
    if (bindres == DONE)
    {
      boundToDSA = TRUE;
      (void) ll_log (de_log, LLOG_NOTICE, NULLCP, "Bound:");
      return OK;
    }
  }
  return NOTOK; /* exit this way if can't talk to access point */
} /* bind_to_ds */

de_unbind()
{
  (void) ll_log (de_log, LLOG_NOTICE, NULLCP, "Unbind:");
  (void) ds_unbind();
}
