;  DSP-93 Serial 94.09.20
;  Version for TAPR/AMSAT DSP-93, 
;
;  Module Name:
;       SERIAL.ASM
;  Creator:
;       Mike Zingman N4IRR
;  Purpose:
;       Define syblols used in configuring the serial port for the DSP-93.
;       The symbols in this file describe the 16550 UART.  Programers
;       should use this file instead of using magic numbers in their programs.
;  Used in:
;       Any file configuring the serial port
;  Expected warnings:
;       None
;  Revision history:
;       Created: 94.08.20 By Mike Zingman N4IRR
;
; Copyright (c) 1994 by Tucson Amateur Packet Radio Corporation
; 
; This document, and it executable, are the property of the Tucson Amateur
; Packet Radio Corp., a Arizona non-profit corporation, and all are copyright
; 1994.  Permission is hereby granted for the non-commercial use of these
; properties only by licensed amateur radio operators.  All other rights are
; reserved  by the Tucson Amateur Packet Radio Corp. 
; 
; This software is provided for use only to non-commercial amateur radio
; users.  Commercial inquiries should be made to Tucson Amateur Packet Radio
; Corp.
; 
; TAPR (Tucson Amateur Packet Radio Corporation) makes no warranty of any
; kind, express or implied, including without limitation, any warranties
; and/or fitness for a particular purpose of this software.  TAPR shall not be
; liable for any damages, whether direct, indirect, special or consequential
; arising from a failure of this software to operate in the manner desired by
; the user.  TAPR shall not be liable for any damage to data or property that
; may be caused directly or indirectly by using the software.
; 
; IN NO EVENT WILL TUCSON AMATEUR PACKET RADIO CORP. BE LIABLE FOR ANY
; INCIDENTAL OR CONSEQUENTIAL DAMAGE ARISING OUT OF USE OR INABILITY TO USE
; THE PROGRAM, OR FOR ANY CLAIM BY ANY OTHER PARTY.
;

; UART Register Selects
                                ;  DLAB  A2  A1  A0    Register
UART_SEL_RX     .EQU    0000h   ;    0    0   0   0    Receive Buffer (read) Transmitter Holding Reg. (write)
UART_SEL_IER    .EQU    0100h   ;    0    0   0   1    Interrupt Enable
UART_SEL_IIR    .EQU    0200h   ;    x    0   1   0    Interrupt Identification (read)
UART_SEL_FCR    .EQU    0200h   ;    x    0   1   0    FIFO Control (write) [undefined on the 16450. CB]
UART_SEL_LCR    .EQU    0300h   ;    x    0   1   1    Line Control
UART_SEL_MCR    .EQU    0400h   ;    x    1   0   0    Modem Control
UART_SEL_LSR    .EQU    0500h   ;    x    1   0   1    Line Status
UART_SEL_MSR    .EQU    0600h   ;    x    1   1   0    Modem Status
UART_SEL_SR     .EQU    0700h   ;    x    1   1   1    Scratch [special use on some boards. CB]
UART_SEL_DL_MSB .EQU    0000h   ;    1    0   0   0    Divisor Latch (LSB)
UART_SEL_DL_LSB .EQU    0001h   ;    1    0   0   1    Divisor Latch (MSB)


; Interrupt Enable Register

UART_IER_EDSSI  .EQU    0008h   ; Modem status interupt enabled
UART_IER_ELSI   .EQU    0004h   ; Status Interupt enabled
UART_IER_ETBEI  .EQU    0002h   ; THR Empty is enabled
UART_IER_ERBFI  .EQU    0001h   ; Data Ready interupt is enabled


; Interrupt Identification Register

UART_IIR_FEN1   .EQU    0080h   ;
UART_IIR_FEN2   .EQU    0040h   ;
UART_IIR_IID2   .EQU    0008h   ;
UART_IIR_IID1   .EQU    0004h   ;
UART_IIR_IID0   .EQU    0002h   ;
UART_IIR_PEND   .EQU    0001h   ;

; FIFO Control Register (w/o, 16550+ only)

UART_FCR_DMAS   .EQU    0008h   ;
UART_FCR_XF     .EQU    0004h   ;
UART_FCR_RF     .EQU    0002h   ;
UART_FCR_EN     .EQU    0001h   ;

; Line Control Register

UART_LCR_DLAB   .EQU    0080h   ; Divisor latch
UART_LCR_SBR    .EQU    0040h   ; SOUT
UART_LCR_SPAR   .EQU    0038h   ; Space Parity
UART_LCR_MPAR   .EQU    0028h   ; Mark Parity
UART_LCR_EPAR   .EQU    0018h   ; Even parity
UART_LCR_OPAR   .EQU    0008h   ; Odd parity
UART_LCR_NPAR   .EQU    0000h   ; No parity
UART_LCR_STBIT2 .EQU    0004h   ; 2 stop bit
UART_LCR_STBIT1 .EQU    0000h   ; 1 stop bit
UART_LCR_WL8    .EQU    0003h   ; Word Length = 8
UART_LCR_WL7    .EQU    0002h   ; Word Length = 7
UART_LCR_WL6    .EQU    0001h   ; Word Length = 6
UART_LCR_WL5    .EQU    0000h   ; Word Length = 5

; Modem Control Register

UART_MCR_LOOP   .EQU    0010h   ; Local loopback
UART_MCR_OUT2   .EQU    0008h   ; Interupts are routed to ICU
UART_MCR_OUT1   .EQU    0004h   ; Interupts routed
UART_MCR_RTS    .EQU    0002h   ; If set RTS pin goes high
UART_MCR_DTR    .EQU    0001h   ; If set DTR pin goes high

; Line Status Register

UART_LSR_FERR   .EQU    0080h   ; FIFO error
UART_LSR_TEMT   .EQU    0040h   ; Transmitter Empty (TEMT). 
UART_LSR_THRE   .EQU    0020h   ; Transmitter Holding Register Empty (THRE).
UART_LSR_BRK    .EQU    0010h   ; Break Indicator (BI). Reset by LSR.
UART_LSR_FE     .EQU    0008h   ; Framing Error (FE). Reset by LSR.
UART_LSR_PE     .EQU    0004h   ; Parity Error (PE). Reset by LSR.
UART_LSR_OE     .EQU    0002h   ; Overrun Error (OE). Reset by reading LSR.
UART_LSR_RBF    .EQU    0001h   ; Data ready, reset by reading Rec Buffer Reg

; Modem Status Register

UART_MSR_DCD    .EQU    0080h   ; DCD
UART_MSR_RI     .EQU    0040h   ; RI. If loopback is selected, it shows the state of OUT1.
UART_MSR_DSR    .EQU    0020h   ; DSR.  1 if high at port
UART_MSR_CTS    .EQU    0010h   ; CTS.  1 if high at port
UART_MSR_DDCD   .EQU    0008h   ; Delta DCD. Set if DCD has changed state since last reading.
UART_MSR_TERI   .EQU    0004h   ; TERI. Set if -RI has changed from low to high
UART_MSR_DDSR   .EQU    0002h   ; Delta DSR. Set if DSR has changed state since last reading.
UART_MSR_DCTS   .EQU    0001h   ; Delta CTS. Set if CTS has changed state since last reading.


