/*
	following is the block of global variables
	used by all of the subroutines
	these variables are defined here with their default
	values which are modified by reading a configuration
	file named settim.cfg.  this is done by subroutine setcfg.
*/
#include <stdio.h>
int utcdif = -7;   /* local standard time - utc in hours */
int dsflag = 1;    /* daylight savings time? 1 = yes, 0 = no */
int cmport = 0;    /* 0 for com1 port, 1 for com2 port */
char number[30] = { 'A','T','D','T','9',',','4','9','4','4','7','7','4',
	           '\r', 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
	             0 , 0 , 0 , 0 };  /* telephone number to dial */
int atflag = 1;    /* AT-type machine? 1=yes, 0=no */
int debug  = 0;    /* list diagnostic messages? 1=yes, 0=no */
int echo   = 1;    /* expect echoes from modem? 1=yes, 0=no  */
int hs     = 1;    /* 1200 baud dialing? 1=yes, 0=no, use 300*/
int lpt    = 0;    /* pulse lpt1 on time? 1=yes, 0=no */
int lpadr  = 0x37a; /* default command register for line printer */
int setclk   = 1;     /* 1=set clock, 0=check time only          */
int wrtdif   = 0;     /* 1=archive time dif to file, 0= do not   */
FILE *jop;            /* file handle for writing difference */
main(argc,argv)
int argc;
char *argv[];
{
/*
	this is the main program named rdline for task nbstime.
*/
#include <dos.h>
char buf[280],ichar;
void wrtbuf(),inilin(),hangup(),sndptr(),diftim(),arcdif();
int rdbuf();
void wait(),parset(),setcfg();
int dial();
int j,param;
int len;
int lim;
int tmo  = 0;
char ie1 = '*';
char ie2 = '#';
char ie3 = -120;
char ie3a= 'M';
/*
	see if there is a switch on the command line
*/
	if( (argc > 1) && (*argv[1] == '-') )
	{
	argv[1]++;
	if(*argv[1] == 'd') debug = 1;
	}
	printf("\nVersion of %s \n",__DATE__);
	
/*
	open configuration file and set global parameters
*/
	setcfg();
	if(hs == 1) lim=12;
	else        lim=9999;
	if(debug != 0)
	{
	printf("\n input configuration \n %s",number);
	printf("\n utcdif= %d",utcdif);
	printf("\n cmport= COM%1d",cmport+1);
	printf("\n atflag= %d",atflag);
	printf("\n dsflag= %d",dsflag);
	printf("\n echo  = %d",echo);
	printf("\n hs    = %d",hs);
	printf("\n lpt1  = %d",lpt);
	printf("\n lp adr= %x",lpadr);
	printf("\n set clk ?, (1=y)= %d",setclk);
	printf("\n wrt to file (1=y)=%d",wrtdif);
	}
	if( (setclk == 0) || (hs == 0) )
	      printf("\n Computer clock will not be set.");
/*
	initialize com line
*/
	inilin();
/*
	now dial number -- continue if dial status shows connect
*/
	if(dial() == 1)
	{
/*
	now start reading from line
	note that 6 lines will be read at 1200 baud followed by a
	time-set. at 300 baud lim is essentially infinite so that
	this loop continues until it is ended by a timeout caused when
	the NBS folks hang up.
*/
	for(j=0; j<lim; j++)
	   {
	   len=rdbuf(buf,ie1,ie2,ie3a,-6);
	   if( (len > 0) && (buf[0] > 0) )
	      {
	      if(lpt != 0) sndptr();  /* pulse strobe of lpt1*/
	      wrtbuf(&buf[len-1]);    /* echo terminating character */
	      printf("\n %s",buf);
	      }
	   else
	      {
	      tmo=1;     /* show exit on time out */
	      break;     /* get out of loop on a time-out*/
	      }
	   }
/*
	write difference to archive file if enabled
*/
	len=rdbuf(buf,ie1,ie2,ie3,-3);
	if( (len > 0) && (buf[0] > 0) )
	{
	if(lpt != 0) sndptr();
	wrtbuf(&buf[len-1]);
	if(wrtdif == 1) arcdif(buf);
	}
/*
	now read next line, parse and set time if enabled
*/
	len=rdbuf(buf,ie1,ie2,ie3,-3);
	if( (len > 0) && (buf[0] > 0) )
	{
	if(lpt != 0) sndptr();
	wrtbuf(&buf[len-1]);
	if(setclk == 1) parset(buf);
	}
/*
	now read next line and then check the time
*/
	if(tmo == 0)
	{
	len=rdbuf(buf,ie1,ie2,ie3,-3);
	if( (len > 0) && (buf[0] > 0) )
	   {
	   if(lpt != 0) sndptr();
	   wrtbuf(&buf[len-1]);
	   diftim(buf);
	   }
	else
	   tmo = 1;
	}
/*
	if lpt is on, then continue reading lines until ended
	by a timeout and if we have not had a timeout yet
*/
	if( (lpt != 0) && (tmo == 0) )
	{
	   do
	      {
	      len=rdbuf(buf,ie1,ie2,ie3,-3);
	      if( (len > 0) && (buf[0] > 0) )
	         {
	         sndptr();
	         wrtbuf(&buf[len-1]);
	         printf("\n %s",buf);
	         }
	       } while (len > 0);     /* loop until nothing more read */
	}
	hangup();
	}
}
