% Read raw data and construct Allan variance from data file.
% Data are collected using rawstats and NTP simulator.
% Only peer included is lan.
%
% Extract/filter real data.
%
clear;
fid = fopen('lan', 'r');
[table, count] = fscanf(fid, '%f %f %f %f %f');
x1 = table(1:5:count) * 86400 + table(2:5:count);
x1 = x1 - x1(1);
y1 = table(3:5:count) * 1000000;
x = x1; y = y1;
%
% Fix rollover and occasional tick interrupt and a spike or two.
%
d = 0;
for i = 2:length(x)
        if ((y1(i - 1) - y1(i)) > 500000)
                d = d + 1000000;
        elseif ((y1(i - 1) - y1(i)) < -500000)
                d = d - 1000000;
        end
        y(i) = y1(i) + d;
        if ((y(i - 1) - y(i)) > 5000)
                y(i) = y(i) + 10000;
        end
end
y = y / 1000000;
%
% Construct allan deviation. Note min 20 intervals averaged.
%
i = 1; d = 16;
while length(y) >= 20 
	u = diff(y) / d;
	v = diff(u);
	z1(i) = sqrt(sum(v .* v) / (2 * length(u)));
	m1(i) = d;
	y = y(1:2:length(y));
	i = i + 1; d = d * 2;
end
save lan.txt m1 z1 -ascii
%
% Construct Allan deviation from sythetic data.
%
fid = fopen('synth_lan', 'r');
[table, count] = fscanf(fid, '%f %f %f');
a = table(1:3:count); b = table(2:3:count);
x1 = a - a(1); y1 = b / 1000000;
x = x1; y = y1;
%
% Fix rollover and occasional tick interrupt and a spike or two.
%
d = 0;
for i = 2:length(x)
	if ((y1(i - 1) - y1(i)) > .5)
		d = d + 1;
	elseif ((y1(i - 1) - y1(i)) < -.5)
                d = d - 1;
	end
	y(i) = y(i) + d;
end
%
% Construct allan deviation. Note min 10 intervals averaged.
%
i = 1; d = 2;
while length(y) >= 10 
	u = diff(y) / d;
	v = diff(u);
	z2(i) = sqrt(sum(v .* v) / (2 * length(u)));
	m2(i) = d;
	y = y(1:2:length(y));
	i = i + 1; d = d * 2;
end
save synth_lan.txt m2 z2 -ascii
