(*
   StripMultiServer.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: StripMultiServer.m3,v 1.3 1992/04/02 02:42:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * StripMultiServer:
 *   Used with stub files generated from
 *       m3rpcgen -p [-f] stripmultiprog.x
 *       m3rpcgen -p [-f] stripmultidefns.x
 *)

IMPORT RPC, RPCSun, stripmultiprog, stripmultidefns, Time, Thread;
IMPORT Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted, RPCSun.Erred *>

TYPE
  MyMulti1 = stripmultiprog.Vers_1 OBJECT OVERRIDES Add := Add1; END;
  MyMulti2 = stripmultiprog.Vers_2 OBJECT
             OVERRIDES
               Add     := Add2;
               AddList := AddList;
             END;


PROCEDURE Add1 (<*UNUSED*> o: MyMulti1; inParm: stripmultidefns.TwoInts):
  INTEGER RAISES {RPC.Failed, Thread.Alerted} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Add1(%s, %s) -> %s\n", Fmt.Int(inParm.a),
                    Fmt.Int(inParm.b), Fmt.Int(inParm.a + inParm.b)));
    Wr.Flush(stdout);
    RETURN inParm.a + inParm.b;
  END Add1;


PROCEDURE Add2 (<*UNUSED*> o: MyMulti2; inParm: stripmultidefns.TwoInts):
  INTEGER RAISES {RPC.Failed, Thread.Alerted} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Add2(%s, %s) -> %s\n", Fmt.Int(inParm.a),
                    Fmt.Int(inParm.b), Fmt.Int(inParm.a + inParm.b)));
    Wr.Flush(stdout);
    RETURN inParm.a + inParm.b;
  END Add2;


PROCEDURE AddList (<*UNUSED*> o: MyMulti2; inParm: stripmultidefns.IntList):
  INTEGER RAISES {RPC.Failed, Thread.Alerted} =
  VAR sum: INTEGER := 0;
  BEGIN
    Wr.PutText(stdout, "AddList2(");
    FOR i := 0 TO NUMBER(inParm^) - 1 DO
      Wr.PutText(stdout, Fmt.F("%s", Fmt.Int(inParm[i])));
      IF i # (NUMBER(inParm^) - 1) THEN
        Wr.PutText(stdout, ", ");
      ELSE
        Wr.PutText(stdout, ") -> ");
      END;
      sum := sum + inParm[i];
    END;
    Wr.PutText(stdout, Fmt.F("%s\n", Fmt.Int(sum)));
    Wr.Flush(stdout);
    RETURN sum;
  END AddList;


(*
 * Main
 *)
BEGIN
  TRY
    Wr.PutText(stdout, "Start of StripMultiServer\n");
    Wr.Flush(stdout);

    EVAL
      RPCSun.Export(stripmultiprog.GetVers_1ServerProc(NEW(MyMulti1)),
                    stripmultiprog.MultiProg_prognum,
                    stripmultiprog.Vers_1_versnum, RPCSun.Protocol.UDP);
    Wr.PutText(stdout, "Exported stripmultprog, version 1 via UDP.\n");

    EVAL
      RPCSun.Export(stripmultiprog.GetVers_2ServerProc(NEW(MyMulti2)),
                    stripmultiprog.MultiProg_prognum,
                    stripmultiprog.Vers_2_versnum, RPCSun.Protocol.UDP);

    Wr.PutText(stdout, "Exported stripmultprog, version 2 via UDP.\n");
    Wr.Flush(stdout);

    LOOP Time.LongPause(1000); END;
  EXCEPT
    RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
