(*
   RecoverableSimpleServer.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: RecoverableSimpleServer.m3,v 1.3 1992/04/02 02:42:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * RecoverableSimpleServer:
 *   Used with stub files generated from
 *       m3rpcgen [-f] rsimple.x
 *)

IMPORT RPC, RPCSun, rsimple, Thread, Time;
IMPORT Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted, RPCSun.Erred *>

TYPE MySimple1 = rsimple.Vers_1 OBJECT OVERRIDES Incr := Increment; END;


PROCEDURE Increment (<*UNUSED*> o: MySimple1; i: INTEGER): INTEGER
  RAISES {} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Increment(%s) -> %s\n", Fmt.Int(i), Fmt.Int(i + 1)));
    Wr.Flush(stdout);
    RETURN i + 1;
  END Increment;


(*
 * Main
 *)
BEGIN
  TRY
    Wr.PutText(stdout, "Start of RecoverableSimpleServer\n");
    Wr.Flush(stdout);

    EVAL RPCSun.Export(rsimple.GetVers_1ServerProc(NEW(MySimple1)),
                       rsimple.Simple_prognum, rsimple.Vers_1_versnum,
                       RPCSun.Protocol.UDP);

    Wr.PutText(stdout, "Exported rsimple via UDP.\n");
    Wr.Flush(stdout);

    LOOP Time.LongPause(1000); END;
  EXCEPT
    RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
