(*
   MultiServer.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: MultiServer.m3,v 1.3 1992/04/02 02:42:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * MultiServer:
 *   Used with stub files generated from
 *       m3rpcgen [-f] multiprog.x
 *       m3rpcgen [-f] multidefns.x
 *)

IMPORT RPC, RPCSun, multiprog, multidefns, Time, Thread;
IMPORT Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted, RPCSun.Erred *>

TYPE
  MyMulti1 =
    multiprog.multiprog_Vers_1 OBJECT OVERRIDES multiprog_Add := Add1; END;
  MyMulti2 = multiprog.multiprog_Vers_2 OBJECT
             OVERRIDES
               multiprog_Add     := Add2;
               multiprog_AddList := AddList;
             END;


PROCEDURE Add1 (<*UNUSED*> o     : MyMulti1;
                           inParm: multidefns.multidefns_TwoInts): INTEGER
  RAISES {RPC.Failed, Thread.Alerted} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Add1(%s, %s) -> %s\n", Fmt.Int(inParm.a),
                    Fmt.Int(inParm.b), Fmt.Int(inParm.a + inParm.b)));
    Wr.Flush(stdout);
    RETURN inParm.a + inParm.b;
  END Add1;


PROCEDURE Add2 (<*UNUSED*> o     : MyMulti2;
                           inParm: multidefns.multidefns_TwoInts): INTEGER
  RAISES {RPC.Failed, Thread.Alerted} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Add2(%s, %s) -> %s\n", Fmt.Int(inParm.a),
                    Fmt.Int(inParm.b), Fmt.Int(inParm.a + inParm.b)));
    Wr.Flush(stdout);
    RETURN inParm.a + inParm.b;
  END Add2;


PROCEDURE AddList (<*UNUSED*> o     : MyMulti2;
                              inParm: multidefns.multidefns_IntList):
  INTEGER RAISES {RPC.Failed, Thread.Alerted} =
  VAR sum: INTEGER := 0;
  BEGIN
    Wr.PutText(stdout, "AddList2(");
    FOR i := 0 TO NUMBER(inParm^) - 1 DO
      Wr.PutText(stdout, Fmt.F("%s", Fmt.Int(inParm[i])));
      IF i # (NUMBER(inParm^) - 1) THEN
        Wr.PutText(stdout, ", ");
      ELSE
        Wr.PutText(stdout, ") -> ");
      END;
      sum := sum + inParm[i];
    END;
    Wr.PutText(stdout, Fmt.F("%s\n", Fmt.Int(sum)));
    Wr.Flush(stdout);
    RETURN sum;
  END AddList;


(*
 * Main
 *)
BEGIN
  TRY
    Wr.PutText(stdout, "Start of MultiServer\n");
    Wr.Flush(stdout);

    EVAL RPCSun.Export(
           multiprog.Getmultiprog_Vers_1ServerProc(NEW(MyMulti1)),
           multiprog.multiprog_MultiProg_prognum,
           multiprog.multiprog_Vers_1_versnum, RPCSun.Protocol.UDP);
    Wr.PutText(stdout, "Exported multiprog, version 1 via UDP.\n");

    EVAL RPCSun.Export(
           multiprog.Getmultiprog_Vers_2ServerProc(NEW(MyMulti2)),
           multiprog.multiprog_MultiProg_prognum,
           multiprog.multiprog_Vers_2_versnum, RPCSun.Protocol.UDP);

    Wr.PutText(stdout, "Exported multiprog, version 2 via UDP.\n");
    Wr.Flush(stdout);

    LOOP Time.LongPause(1000); END;
  EXCEPT
    RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
