/*************************************************************/
/*							     */
/*							     */
/*			TANGOMAIN.C			     */
/*							     */
/*							     */
/*************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko      */

#include "tangolocal.h"
#include "tangofsa.h"

double cosine();  /* kludges since can't dynload math functions */
double sine();
double logbase2();

int    Tango_debug = 0;

main(argc,argv)
   int argc;
   char *argv[];
{
   ASH_WINDOW window;
   WIN_COORD  lx,by,rx,ty;
   char      *s;
   int	      loadlib, mode, blting, clearval, clearset, plainwindow;


   loadlib = mode = blting = clearset = plainwindow = 0;

   argc = MSGset_application(argc,argv);
   argc = ASHset_application(argc,argv);

   while ((--argc > 0) && ((*++argv)[0] == '-'))
      for (s=argv[0]+1; *s != '\0'; s++)
	 switch(*s) {
	    case 'L':
	       loadlib = 1;
	       break;
	    case 'D':
	       Tango_debug = 1;
	       break;
	    case 'B':
	       blting = 1;
	       break;
	    case 'F':
	       mode = 1;
	       clearset = 0;  /* implied */
	       break;
	    case 'S':
	       mode = 2;
	       clearset = 0;  /* implied */
	       break;
	    case 'P':
	       plainwindow = 1;
	       break;
	    case 'C':
	       clearset = 1;
	       clearval = 0;
	       for (s++; (*s >= '0') && (*s <= '9'); ++s)
		  clearval = 10 * clearval + *s - '0';
	       s--; /* went one pos too far */
	       mode = 0;    /* implied */
	       break;
	    default:
	       fprintf(stderr,"tango: illegal option %c\n",*s);
	       argc = 0;
	       break;
	 }

   if (argc != 1)
      { fprintf(stderr,"Usage: tango [-B][-C#][-D][-F][-L][-P][-S] animname\n");
	exit(-1);
      }
   else
      { printf("Loading . . .");
	fflush(stdout);

	if (read_anim(*argv,loadlib,&lx,&by,&rx,&ty))
	   { ASHinit(ASH_MODE_INQUIRE,0);
	     window = ASHinq_top();
	     if (!plainwindow)
		TANGO_layout_window(window,lx,by,rx,ty,mode,blting);
	     else
		TANGO_layout_plainwindow(window,lx,by,rx,ty,mode,blting);
	     if (clearset)
		TANGO_clearset(clearval);
	   }
	else
	   exit(-1);
      }

   printf("Ready!\n");
   while (1)
      RIPuser_pick(NULL);
}




double
cosine(rad)
   double rad;
{
   return( cos(rad) );
}


double
sine(rad)
   double rad;
{
   return( sin(rad) );
}


double
logbase2(num)
   double num;
{
#ifdef sun
   return( log2(num) );
#else
   return( log(num) / log(2) );
#endif
}


