/***************************************************************/
/*							       */
/*			TANGOFSA.H			       */
/*							       */
/***************************************************************/

#define  MAXSIZE	 50

/***************************************************************/
/**********	      local data types		      **********/
/***************************************************************/

typedef struct _INTNODE
{
   int num;
   struct _INTNODE *next;
} *INTNODE_PTR;


typedef struct _ALGOEVT
{
   int	   num;
   char    name[STRINGLENGTH];
   int	   params;
   int	   callback; /* true if synchronous & expecting return string */
   char    pat[STRINGLENGTH];
} ALGOEVT;

typedef struct _ANIMPROC
{
   int	  num;
   char   name[STRINGLENGTH];
   int	  (*addr)();
} ANIMPROC;



typedef struct _NFASTATE
{
   int trans;	       /* trans out of this state      */
   int final;	       /* boolean		       */
   int nextstate;      /* next NFA state	       */
   INTNODE_PTR procs;  /* animation procedures to call */
} NFASTATE;

typedef struct _DFASTATE
{
   unsigned long lo;  /* sets of NFA states in bits */
   unsigned long hi;
   int		 num;
   struct _DFASTATE *next;
} *DFASTATE_PTR;

typedef struct _TRANSITION
{
   DFASTATE_PTR from;
   DFASTATE_PTR to;
   int		transevt;
   INTNODE_PTR	actions;
   struct _TRANSITION *next;
} *TRANSITION_PTR;





/***************************************************************/
/**********	      local entry points	      **********/
/***************************************************************/

char *	      get_next_token();      /* in tangoparse.c */
int	      read_anim();	     /* in tangoparse.c */

int	      read_mappings();	     /* in tangofsa.c	*/

int	      fct_receive_event();   /* in tangomsg.c	*/



/***************************************************************/
/**********	     global variables		      **********/
/***************************************************************/

extern	int		 Tango_debug;

extern	ALGOEVT 	 Algoevts[MAXSIZE];
extern	int		 Num_algoevts;
extern	ANIMPROC	 Animprocs[MAXSIZE];
extern	int		 Num_animprocs;

extern	NFASTATE	 NFAstate[MAXSIZE];
extern	int		 NFAstates_num;
extern	INTNODE_PTR	 NFAstart_states;

extern	DFASTATE_PTR	 DFAstates;
extern	int		 DFAstates_num;

extern	TRANSITION_PTR	 Transitions;

extern	TRANSITION_PTR	 Trans_table[MAXSIZE][MAXSIZE];

extern	int		 State;
