/***************************************************************/
/*							       */
/*			     TANGO.H			       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

/***************************************************************/
/**********	 constant definitions & types	      **********/
/***************************************************************/

typedef enum
{
   TANGO_IMAGE_TYPE_LINE,
   TANGO_IMAGE_TYPE_RECTANGLE,
   TANGO_IMAGE_TYPE_CIRCLE,
   TANGO_IMAGE_TYPE_POLYLINE,
   TANGO_IMAGE_TYPE_POLYGON,
   TANGO_IMAGE_TYPE_ELLIPSE,
   TANGO_IMAGE_TYPE_SPLINE,
   TANGO_IMAGE_TYPE_TEXT,
   TANGO_IMAGE_TYPE_COMPOSITE
} TANGO_IMAGE_TYPE;



typedef enum
{
   TANGO_TRANS_TYPE_VISIBLE,
   TANGO_TRANS_TYPE_FILL,
   TANGO_TRANS_TYPE_MOVE,
   TANGO_TRANS_TYPE_RESIZE,
   TANGO_TRANS_TYPE_RESIZE1,
   TANGO_TRANS_TYPE_RESIZE2,
   TANGO_TRANS_TYPE_RESIZE3,
   TANGO_TRANS_TYPE_RESIZE4,
   TANGO_TRANS_TYPE_RESIZE5,
   TANGO_TRANS_TYPE_RESIZE6,
   TANGO_TRANS_TYPE_RESIZE7,
   TANGO_TRANS_TYPE_GRAB1,
   TANGO_TRANS_TYPE_GRAB2,
   TANGO_TRANS_TYPE_GRAB3,
   TANGO_TRANS_TYPE_GRAB4,
   TANGO_TRANS_TYPE_GRAB5,
   TANGO_TRANS_TYPE_GRAB6,
   TANGO_TRANS_TYPE_GRAB7,
   TANGO_TRANS_TYPE_COLOR,
   TANGO_TRANS_TYPE_RAISE,
   TANGO_TRANS_TYPE_LOWER,
   TANGO_TRANS_TYPE_DELAY,
   TANGO_TRANS_TYPE_REFRESH
}  TANGO_TRANS_TYPE;



#define  TANGO_COLOR_WHITE	-1
#define  TANGO_COLOR_BLACK	-2
#define  TANGO_COLOR_RED	-3
#define  TANGO_COLOR_ORANGE	-4
#define  TANGO_COLOR_YELLOW	-5
#define  TANGO_COLOR_GREEN	-6
#define  TANGO_COLOR_BLUE	-7
#define  TANGO_COLOR_MAROON	-8


#define  TANGO_PATH_TYPE_STRAIGHT	   0
#define  TANGO_PATH_TYPE_CLOCKWISE	   1
#define  TANGO_PATH_TYPE_COUNTERCLOCKWISE  2


#define  TANGO_PART_TYPE_C	      0
#define  TANGO_PART_TYPE_NW	      1
#define  TANGO_PART_TYPE_N	      2
#define  TANGO_PART_TYPE_NE	      3
#define  TANGO_PART_TYPE_E	      4
#define  TANGO_PART_TYPE_SE	      5
#define  TANGO_PART_TYPE_S	      6
#define  TANGO_PART_TYPE_SW	      7
#define  TANGO_PART_TYPE_W	      8

typedef  int   TANGO_PATH_TYPE;
typedef  int   TANGO_PATH_MOTION;
typedef  int   TANGO_PART_TYPE;

typedef struct _LOC	*TANGO_LOC;

typedef struct _IMAGE	*TANGO_IMAGE;

typedef struct _PATH	*TANGO_PATH;

typedef struct _TRANS	*TANGO_TRANS;

typedef struct _IMAGE_COMP
{
   TANGO_IMAGE_TYPE    type;
   char 	      *args;
} TANGO_IMAGE_COMPONENT;


/***************************************************************/
/**********	       entry points		      **********/
/***************************************************************/

extern	void		TANGOinit();

extern	TANGO_LOC	TANGOloc_create();
extern	double		TANGOloc_X();
extern	double		TANGOloc_Y();
extern	void		TANGOloc_inquire();
extern	TANGO_LOC	TANGOloc_modify();
extern	int		TANGOloc_equal();

extern	TANGO_IMAGE	TANGOimage_create();
extern	TANGO_LOC	TANGOimage_loc();

extern	TANGO_PATH	TANGOpath_create();
extern	TANGO_PATH	TANGOpath_load();
extern	TANGO_PATH	TANGOpath_store();
extern	int		TANGOpath_length();
extern	double		TANGOpath_dx();
extern	double		TANGOpath_dy();
extern	TANGO_PATH	TANGOpath_rotate();
extern	TANGO_PATH	TANGOpath_interpolate();
extern	TANGO_PATH	TANGOpath_scale();
extern	TANGO_PATH	TANGOpath_extend();
extern	TANGO_PATH	TANGOpath_null();
extern	TANGO_PATH	TANGOpath_type();
extern	TANGO_PATH	TANGOpath_color();
extern	TANGO_PATH	TANGOpath_add_head();
extern	TANGO_PATH	TANGOpath_add_tail();
extern	TANGO_PATH	TANGOpath_delete_head();
extern	TANGO_PATH	TANGOpath_delete_tail();
extern	TANGO_PATH	TANGOpath_smooth();
extern	TANGO_PATH	TANGOpath_copy();
extern	TANGO_PATH	TANGOpath_example();
extern	TANGO_PATH	TANGOpath_motion();
extern	TANGO_PATH	TANGOpath_distance();
extern	TANGO_PATH	TANGOpath_concatenate();
extern	TANGO_PATH	TANGOpath_iterate();
extern	TANGO_PATH	TANGOpath_compose();
extern	void		TANGOpath_free();

extern	TANGO_TRANS	TANGOtrans_create();
extern	TANGO_TRANS	TANGOtrans_concatenate();
extern	TANGO_TRANS	TANGOtrans_iterate();
extern	TANGO_TRANS	TANGOtrans_compose();
extern	void		TANGOtrans_perform();
extern	void		TANGOtrans_free();

extern	int		TANGOinput_coord();
extern	int		TANGOinput_image();


extern	void		TWISTcreate_loc_array();
extern	void		TWISTcreate_2d_loc_array();
extern	void		TWISTcreate_image_array();
extern	void		TWISTcreate_graph();
extern	void		TWISTcreate_bintree();


extern	void		ASSOCinit();
extern	void		ASSOCmake();
extern	void		ASSOCset();
extern	int		ASSOCget();

