#include <stdio.h>
#include <datatypes.h>
#include <msg.h>
#include <math.h>

#define INFINITY  1000.0
#define UNSEEN	  0
#define FRINGE	  1
#define INTREE	  2

#define TOPS 25

#define SQUARE(A)  ((A) * (A))
#define MIN(A,B)   ((A) < (B) ? (A) : (B))


main()
{
   int i,j,n, status[TOPS], from[TOPS], numbeento, next, start,end;
   double loc[TOPS][2],dist[TOPS],edge[TOPS][TOPS],min;
   char *reply;

   MSGsenda("IE Init * * 0");

   printf("SHORTEST PATH \n");
   printf("Interactively draw the graph with the mouse.\n");
   printf("Click to select a vertex position (click in STOP to stop)\n");
   n=0;
   for (;;)
      { reply = MSGcalla("IE Vertex * * 0 %d",n);
	sscanf(reply,"%lf %lf",&(loc[n][0]),&(loc[n][1]));
	if (!reply || (*reply=='\0')) break;
	n++;
	free(reply);
      }

   for (i=0; i<n; ++i)
      for (j=0; j<n; ++j)
	 edge[i][j] = INFINITY;

   printf("Select pairs of vertices for edges.  (Click STOP to stop.)\n");
   for (;;)
      { reply = MSGcalla("IE Edge * * 0");
	if (reply && *reply)
	   { sscanf(reply,"%d %d",&i,&j);
	     if (i == -1) break;
	     edge[i][j] = sqrt( SQUARE(loc[i][0]-loc[j][0]) + SQUARE(loc[i][1]-loc[j][1]) );
	     edge[j][i] = edge[i][j];	/* undirected for now */
	   }
      }

   for (i=0; i<n; ++i)
      { status[i] = UNSEEN;
	dist[i] = INFINITY;
	from[i] = 0;
      }

   printf("Select the start vertex\n");
   reply = MSGcalla("IE GetStart * * 0");
   sscanf(reply,"%d",&start);

   printf("Select the end vertex\n");
   reply = MSGcalla("IE GetEnd * * 0");
   sscanf(reply,"%d",&end);

   status[start] = INTREE;
   dist[start] = 0.0;
   from[start] = start;
   numbeento = 1;
   MSGsenda("IE AddFringe * * 0 %d %d",start,start);
   MSGsenda("IE Add * * 0 %d",start);

   for (i=0; i<n; ++i)
      if ((status[i] == UNSEEN) && (edge[start][i] != INFINITY))
	 { status[i] = FRINGE;
	   from[i] = start;
	   dist[i] = edge[start][i];
	   MSGsenda("IE AddFringe * * 0 %d %d",start,i);
	 }

   while (numbeento < n)
      { min = INFINITY;
	for (i=0; i<n; ++i)
	   if (status[i] == FRINGE)
	      { MSGsenda("IE Examine * * 0 %d %d",from[i],i);
		if (dist[i] < min)
		   { MSGsenda("IE NewMin * * 0 %d %d",from[i],i);
		     min  = dist[i];
		     next = i;
		   }
	      }
	MSGsenda("IE Add * * 0 %d",next);
	status[next] = INTREE;
	numbeento++;
	if (next == end)
	   break;

	for (i=0; i<n; ++i)
	   if ((status[i] == UNSEEN) && (edge[next][i] != INFINITY))
	      { MSGsenda("IE AddFringe * * 0 %d %d",next,i);
		status[i] = FRINGE;
		from[i] = next;
		dist[i] = dist[next] + edge[next][i];
	      }
	   else if (status[i] == FRINGE)
	      { if (dist[next]+edge[next][i] < dist[i])  /* better way of */
		   { dist[i] = dist[next]+edge[next][i];  /* getting there */
		     from[i] = next;
		     MSGsenda("IE Shorter * * 0 %d %d",next,i);
		   }
	      }
      }
}
