#include <stdio.h>
#include <tango.h>

scene1()
{
   TANGO_IMAGE l1,l2,l3,l4;
   TANGO_LOC end, center;
   TANGO_PATH p1, p2, p3, p4, p5, p6;
   TANGO_TRANS re2a,mo4a,re4a,mo3a,re3a;
   TANGO_TRANS re2b,mo4b,re4b,mo3b,re3b;
   TANGO_TRANS delay, fold, expand, seq;

   TANGO_PATH half, flip, loop1, loop2, flier;
   TANGO_TRANS	fly1, fly2, fly3, fly4, both, cycle;


   l1 = TANGOimage_create(TANGO_IMAGE_TYPE_LINE,0.3,0.4,1,TANGO_COLOR_BLACK,-0.2,0.0,0.0,1.0,0);
   l2 = TANGOimage_create(TANGO_IMAGE_TYPE_LINE,0.1,0.4,1,TANGO_COLOR_BLACK,0.0,0.2,0.0,1.0,0);
   l3 = TANGOimage_create(TANGO_IMAGE_TYPE_LINE,0.1,0.6,1,TANGO_COLOR_BLACK,0.2,0.0,0.0,1.0,0);
   l4 = TANGOimage_create(TANGO_IMAGE_TYPE_LINE,0.3,0.6,1,TANGO_COLOR_BLACK,0.0,-0.2,0.0,1.0,0);

   delay = TANGOtrans_create(TANGO_TRANS_TYPE_DELAY, NULL, TANGOpath_null(25) );
   TANGOtrans_perform( delay );
   /* gets the images up there for a little */

   center = TANGOloc_create(0.2, 0.5);
   end = TANGOimage_loc(l2, TANGO_PART_TYPE_S);
   p1 = TANGOpath_distance(end, center, 0.001);
   p2 = TANGOpath_scale(p1, -1.0, 1.0);
   p3 = TANGOpath_scale(p2, -1.0, -1.0);
   p4 = TANGOpath_scale(p2, 2.0, 0.0);

   re2a = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l2, p1);
   mo3a = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l3, p1);
   re3a = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l3, p4);
   mo4a = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l4, p2);
   re4a = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l4, p3);

   fold = TANGOtrans_compose(5, re2a, mo4a, re4a, mo3a, re3a);

   /* create the opposites */
   p5 = TANGOpath_scale(p1, -1.0, -1.0);
       /* p2 and p3 are already opposites */
   p6 = TANGOpath_scale(p4, -1.0, -1.0);

   re2b = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l2, p5);
   mo3b = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l3, p5);
   re3b = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l3, p6);
   mo4b = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l4, p3);
   re4b = TANGOtrans_create(TANGO_TRANS_TYPE_RESIZE, l4, p2);

   expand = TANGOtrans_compose(5, re2b, mo4b, re4b, mo3b, re3b);
   seq = TANGOtrans_concatenate(3, fold, delay, expand);

   half = TANGOpath_motion(center,TANGOloc_create(0.8,0.5),TANGO_PATH_TYPE_CLOCKWISE);
   flip = TANGOpath_rotate(half, 180);
   loop1 = TANGOpath_concatenate(2, half, flip);
   loop2 = TANGOpath_interpolate(loop1, (2.0*TANGOpath_length(p1) + 10) /
				    TANGOpath_length(loop1));

   fly1 = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l1, loop2);
   fly2 = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l2, loop2);
   fly3 = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l3, loop2);
   fly4 = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE, l4, loop2);

   both = TANGOtrans_compose(5, seq, fly1, fly2, fly3, fly4);

   cycle = TANGOtrans_iterate(both, 3);
   TANGOtrans_perform(cycle);
}






