/***************************************************************/
/*							       */
/*		    DANCE PACKAGE (vis) 		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include <dancelocal.h>


#ifndef sun
#define usleep BPIOwait
#endif

/***************************************************************/
/*   new_display - a new object has arrived on the screen.     */
/*	This routine keeps track of all the objects.  This     */
/*	routine also displays a little text banner for each    */
/*	object that is pickable.			       */
/***************************************************************/

DISPLAY_PTR
new_display(type,object,vname,x,y)
   DEMO_OBJ_TYPE type;
   int object;
   char *vname;
   int x,y;
{
   ASH_FONT oldfont;
   ASH_COLOR fgcolor,bgcolor;
   DISPLAY_PTR disp;
   int basex,basey,dx,dy;

   disp = (DISPLAY_PTR) malloc( sizeof( struct _DISPLAY));
   disp->type = type;
   disp->object = object;
   strcpy(disp->vname,vname);

   if (type == DEMO_OBJ_IMAGE)	  /* determine placement of label */
      place_name_at(object/*image*/, &(disp->vx), &(disp->vy) );
   else if (type == DEMO_OBJ_LOC)
      { disp->vx = x-5;
	disp->vy = y-10;
      }
   else if (type == DEMO_OBJ_PATH)
      { disp->vx = x+2;
	disp->vy = y-3;
      }
   else if (type == DEMO_OBJ_TRANS)
      { disp->vx = x+20;
	disp->vy = y-3;
      }
   else
      { disp->vx = x;
	disp->vy = y;
      }

   oldfont = ASHfont(AnimWindow,LabelFont);
   fgcolor = ASHtext_color(AnimWindow,Color[DANCE_BLACK]);
   bgcolor = ASHtext_background_color(AnimWindow,Color[DANCE_YELLOW]);
   ASHinq_text_offset(LabelFont,vname,&dx,&dy);
   basex = disp->vx - dx;
   basey = disp->vy + dy;
   ASHtext(AnimWindow,disp->vx,disp->vy,vname);
   fgcolor = ASHtext_color(AnimWindow,fgcolor);
   bgcolor = ASHtext_background_color(AnimWindow,bgcolor);
   ASHfont(AnimWindow,oldfont);

   ASHinq_text_extent(LabelFont,vname,&dx,&dy);
   disp->lx = basex;
   disp->rx = basex+dx;
   disp->by = basey;
   disp->ty = basey-dy;

   disp->marked = 0;
   disp->next = NULL;
   disp->prev = SceneCurrent->display_tail;
   if (SceneCurrent->displays)
      SceneCurrent->display_tail->next = disp;
   else
      SceneCurrent->displays = disp;
   SceneCurrent->display_tail = disp;
   return(disp);
}



/***************************************************************/
/*   draw_all_images - First draw the funct name and	       */
/*	"Transitions:" header.  Then run down the display list */
/*	twice.	Draw all the paths and visible images first.   */
/*	Then draw all the labels for the objects.	       */
/***************************************************************/

void
draw_all_images(doall)
   int doall;
{
   char 	    header[MAXSTRINGLENGTH];
   DISPLAY_PTR	    d;
   ASH_FONT	    oldfont;
   ASH_COLOR	    oldcolor,textcolor,bgdcol;
   ASH_FILL_STYLE   oldfill;
   ASH_LINE_STYLE   oldstyle;
   DEMO_IMAGE	    image;
   TANGO_LOC	    loc;
   DEMO_TRANS	    trans;

   if (!SceneCurrent) return;

   if (doall)
      { if (TransSet)
	   ASHtext(AnimWindow, TransX, 15, "Transitions:");
	sprintf(header,"Defining scene:  %s(",SceneCurrent->name);
	ASHtext(AnimWindow, 5, 15, header);

	ASHtext(AnimWindow,SceneCurrent->endx,15,")");
      }

   for (d=SceneCurrent->displays; d; d=d->next)
      { if (d->type == DEMO_OBJ_IMAGE)
	   { image = (DEMO_IMAGE) d->object;
	     if ((doall || d->marked) && image->visible)
		{ oldcolor = ASHcolor(AnimWindow,image->ashcolor);
		  switch(image->type)
		  {
		     case DEMO_OBJ_LINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHline(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			addin_arrows(image);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_RECT:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHbox(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);

			else
			   { oldfill = ASHfill(AnimWindow,image->ashfill);
			     ASHrectangle(AnimWindow, image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_CIRCLE:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHcircle(AnimWindow,image->pixelx[0], image->pixely[0], image->pixelx[1]);
			else
			   { oldfill = ASHfill(AnimWindow,image->ashfill);
			     ASHfilled_circle(AnimWindow, image->pixelx[0], image->pixely[0], image->pixelx[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_ELLIPSE:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHellipse(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);

			else
			   { oldfill = ASHfill(AnimWindow,image->ashfill);
			     ASHfilled_ellipse(AnimWindow, image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_POLYLINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHpolyline(AnimWindow,image->vertices,image->pixelx,image->pixely);
			addin_arrows(image);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_POLYGON:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   { image->pixelx[image->vertices] = image->pixelx[0];
			     image->pixely[image->vertices] = image->pixely[0];
			     ASHpolyline(AnimWindow,image->vertices+1,image->pixelx,image->pixely);
			   }
			else
			   { oldfill = ASHfill(AnimWindow,image->ashfill);
			     ASHpolygon(AnimWindow,image->vertices,image->pixelx,image->pixely);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_SPLINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHspline(AnimWindow,image->vertices,image->pixelx,image->pixely);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_TEXT:
			textcolor = ASHtext_color(AnimWindow,image->ashcolor);
			bgdcol = ASHtext_background_color(AnimWindow,-1);
			ASHtext(AnimWindow,image->pixelx[0],image->pixely[0],image->string);
			ASHtext_color(AnimWindow,textcolor);
			ASHtext_background_color(AnimWindow,bgdcol);
			break;
		     default:
			break;
		  }
		  ASHcolor(AnimWindow,oldcolor);
		}
	   }
	else if ((d->type == DEMO_OBJ_PATH) && doall)
	   draw_path(d->object,((TANGO_PATH)(d->object))->startx,((TANGO_PATH)(d->object))->starty);
	else if ((d->type == DEMO_OBJ_LOC) && doall)
	   { loc = (TANGO_LOC) d->object;
	     ASHfilled_circle(AnimWindow,ABSOL(loc->x),ABSOL(loc->y),2);
	   }
	else if ((d->type == DEMO_OBJ_TRANS) && doall)
	   { trans = (DEMO_TRANS) d->object;
	     textcolor = ASHtext_color(AnimWindow,Color[DANCE_WHITE]);
	     bgdcol = ASHtext_background_color(AnimWindow,Color[DANCE_BLACK]);
	     ASHicon_draw(AnimWindow,trans->x,trans->y,trans->iconstr);
	     ASHtext_color(AnimWindow,textcolor);
	     ASHtext_background_color(AnimWindow,bgdcol);
	   }
      }

   if (doall)
      for (d=SceneCurrent->displays; d; d=d->next)
	 { oldfont = ASHfont(AnimWindow,LabelFont);
	   textcolor = ASHtext_color(AnimWindow,Color[DANCE_BLACK]);
	   bgdcol = ASHtext_background_color(AnimWindow,Color[DANCE_YELLOW]);
	   ASHtext(AnimWindow,d->vx,d->vy,d->vname);
	   ASHtext_color(AnimWindow,textcolor);
	   ASHtext_background_color(AnimWindow,bgdcol);
	   ASHfont(AnimWindow,oldfont);
	 }
}



/***************************************************************/
/*   clear_images - For any images that are marked, clear      */
/*	them by drawing them in white (background color).      */
/***************************************************************/

void
clear_images()
{
   DISPLAY_PTR	  d;
   DEMO_IMAGE	  image;
   ASH_FONT	  oldfont;
   ASH_COLOR	  oldcolor,textcolor,bgdcol;
   ASH_FILL_STYLE oldfill;
   ASH_LINE_STYLE oldstyle;

   oldcolor = ASHcolor(AnimWindow,Color[DANCE_WHITE]); /* white */
   for (d=SceneCurrent->displays; d; d=d->next)
      { if ((d->type == DEMO_OBJ_IMAGE) && (d->marked))
	   { image = (DEMO_IMAGE) d->object;
	     if (image->visible)
		switch(image->type)
		  {
		     case DEMO_OBJ_LINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHline(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			addin_arrows(image);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_RECT:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHbox(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);

			else
			   { oldfill = ASHfill(AnimWindow,TANGO_FILL_FULL);
			     ASHrectangle(AnimWindow, image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_CIRCLE:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHcircle(AnimWindow,image->pixelx[0], image->pixely[0], image->pixelx[1]);
			else
			   { oldfill = ASHfill(AnimWindow,TANGO_FILL_FULL);
			     ASHfilled_circle(AnimWindow, image->pixelx[0], image->pixely[0], image->pixelx[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_ELLIPSE:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   ASHellipse(AnimWindow,image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);

			else
			   { oldfill = ASHfill(AnimWindow,TANGO_FILL_FULL);
			     ASHfilled_ellipse(AnimWindow, image->pixelx[0], image->pixely[0],
				   image->pixelx[1], image->pixely[1]);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_POLYLINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHpolyline(AnimWindow,image->vertices,image->pixelx,image->pixely);
			addin_arrows(image);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_POLYGON:
			if (image->ashfill == TANGO_FILL_OUTLINE)
			   { image->pixelx[image->vertices] = image->pixelx[0];
/* X kludge */		     image->pixely[image->vertices] = image->pixely[0];
			     ASHpolyline(AnimWindow, image->vertices+1, image->pixelx,
				   image->pixely);
			   }
			else
			   { oldfill = ASHfill(AnimWindow,image->ashfill);
			     ASHpolygon(AnimWindow, image->vertices, image->pixelx,
				   image->pixely);
			     ASHfill(AnimWindow,oldfill);
			   }
			break;
		     case DEMO_OBJ_SPLINE:
			oldstyle = ASHline_style(AnimWindow,image->linestyle);
			ASHspline(AnimWindow,image->vertices,image->pixelx,image->pixely);
			ASHline_style(AnimWindow,oldstyle);
			break;
		     case DEMO_OBJ_TEXT:
			textcolor = ASHtext_color(AnimWindow,Color[DANCE_WHITE]);
			bgdcol = ASHtext_background_color(AnimWindow,-1);
			ASHtext(AnimWindow,image->pixelx[0],image->pixely[0],image->string);
			ASHtext_color(AnimWindow,textcolor);
			ASHtext_background_color(AnimWindow,bgdcol);
			break;
		     default:
			break;
		  }
	   }
      }
   ASHcolor(AnimWindow,oldcolor);
}



/***************************************************************/
/*   update_label_positions - images may have moved, so update */
/*	all the label positions according to the new positions */
/***************************************************************/

void
update_label_positions()
{
   DISPLAY_PTR d;
   DEMO_IMAGE image;
   int x,y,dx,dy,sx,sy;

   for (d=SceneCurrent->displays; d; d=d->next)
      if (d->type == DEMO_OBJ_IMAGE)
	 { image = (DEMO_IMAGE) d->object;
	   place_name_at(image,&x,&y);
	   d->vx = x;
	   d->vy = y;

	   ASHinq_text_offset(LabelFont,d->vname,&dx,&dy);
	   ASHinq_text_extent(LabelFont,d->vname,&sx,&sy);
	   d->lx = x-dx;
	   d->rx = x+sx;
	   d->by = y+dy;
	   d->ty = y-sy;
	 }
}



/***************************************************************/
/*   which_object - given an (x,y) point, return the object    */
/*	(if any) whose text banner resides there.	       */
/***************************************************************/

DISPLAY_PTR
which_object(x,y)
   int x,y;
{
   DISPLAY_PTR dp,got;
   ASH_COLOR textcolor,bgdcol;
   ASH_FONT oldfont;

   /* want to always get last valid one in list because it will be on
      viewing plane closest to user */
   got = NULL;
   for (dp=SceneCurrent->displays; dp; dp=dp->next)
      if ((dp->lx <= x) && (x <= dp->rx) && (dp->ty <= y) && (y <= dp->by))
	 got = dp;

   /* invert the label briefly */
   if (got)
      { oldfont = ASHfont(AnimWindow,LabelFont);
	textcolor = ASHtext_color(AnimWindow,Color[DANCE_YELLOW]);
	bgdcol = ASHtext_background_color(AnimWindow,Color[DANCE_BLACK]);
	ASHtext(AnimWindow,got->vx,got->vy,got->vname);
	usleep(50000);	/* delay to show the effect */
	ASHtext_color(AnimWindow,Color[DANCE_BLACK]);
	ASHtext_background_color(AnimWindow,Color[DANCE_YELLOW]);
	ASHtext(AnimWindow,got->vx,got->vy,got->vname);
	/* reset */
	ASHtext_color(AnimWindow,textcolor);
	ASHtext_background_color(AnimWindow,bgdcol);
	ASHfont(AnimWindow,oldfont);
      }

   return(got);
}




/***************************************************************/
/*   get_point - return an (x,y) window position.  It's        */
/*	entered by tracking the mouse and clicking.	       */
/***************************************************************/

PT_PTR
get_point()
{
   PT_PTR pt;

   pt = (PT_PTR) malloc( sizeof( struct _PT));
   ASHset_user_data(AnimWindow,pt);
   RIPtrack(loc_rtn,-1,AnimWindow,0);

   return(pt);
}


/***************************************************************/
/*   loc_rtn - routine RIP calls to get a down click	       */
/*	designating a point choice.			       */
/***************************************************************/

int
loc_rtn(x,y,n,trans,max,window)
   int x,y,n;
   RIP_TRANS trans;
   int max;
   ASH_WINDOW window;
{
   PT_PTR pt;

   if ((trans==RIP_TRANS_DOWN) || (trans==RIP_TRANS_TAP))
      { pt = (PT_PTR) ASHinq_user_data(AnimWindow);
	pt->x = x;
	pt->y = y;
	return(0);
      }
   return(1);
}




/***************************************************************/
/*   query_point - get an (x,y) window position same as        */
/*	get_point, but this routine allows the user to cancel  */
/*	by striking a key.				       */
/***************************************************************/

PT_PTR
query_point()
{
   PT_PTR pt;

   pt = (PT_PTR) malloc( sizeof( struct _PT));
   ASHset_user_data(AnimWindow,pt);
   RIPtrack(track_rtn,-1,AnimWindow,0);

   return(pt);
}



/***************************************************************/
/*   track_rtn - routine RIP calls to get a down click	       */
/*	designating a point choice.  If a char is hit, put -1  */
/*	in the point coordinates.			       */
/***************************************************************/

int
track_rtn(x,y,n,trans,max,window)
   int x,y,n;
   RIP_TRANS trans;
   int max;
   ASH_WINDOW window;
{
   PT_PTR pt;

   if ((trans==RIP_TRANS_DOWN) || (trans==RIP_TRANS_TAP))
      { pt = (PT_PTR) ASHinq_user_data(AnimWindow);
	pt->x = x;
	pt->y = y;
	return(0);
      }
   else if (trans == RIP_TRANS_CHAR)
      { pt = (PT_PTR) ASHinq_user_data(AnimWindow);
	pt->x = pt->y = -1;
	return(0);
      }
   return(1);
}



/***************************************************************/
/*   get_object - query the user to select an object in the    */
/*	demo window (by picking its text banner).  If the user */
/*	cancelled, return NULL.  While no object is chosen,    */
/*	keep trying.					       */
/***************************************************************/

DISPLAY_PTR
get_object()
{
   DISPLAY_PTR disp;
   PT_PTR pt;

   do
      { pt = query_point();
	if ((pt->x == -1) && (pt->y == -1))
	   return(NULL);
	else
	   { disp = which_object(pt->x,pt->y);
	   }
	if (!disp)
	   RIPprompt("No object selected. Try again. (press key to cancel)");
      }
   while (!disp);
   return(disp);
}




