/***************************************************************/
/*							       */
/*		    DANCE PACKAGE (trans)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include <dancelocal.h>

int   TransSet = 0;
int   TransX,TransY;


/***************************************************************/
/*   fctTransCreate - create a trans in one of the basic types */
/*	(move, color, etc.) Utilizes image and path.	       */
/***************************************************************/

int
fctTransCreate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   DISPLAY_PTR obj1,obj2;
   CALL_PTR call;
   TANGO_TRANS_TYPE ttype;
   char ttypestr[MAXSTRINGLENGTH];
   int x,y;
   int tnum;
   char iconstr[20];
   DEMO_TRANS trans;
   static char *format0[4] =
      { "\nTrans type\n%0.0o Move\n%0.1o Resize\n%0.2o Visible",
	"%0.3o Color\n%0.4o Fill\n%0.5o Raise\n%0.6o Lower\n%0.7o Delay\n",
	"\n%a          %c",
	NULL };
   char *format1 = "\nSave result transition on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   tnum = 0;
   if (!STEMdialog(AnimWindow,format0,&tnum))
      return(1);

   RIPprompt("Pick image for use in transition. (Press key to cancel.)");
   do
      { obj1 = get_object();
	if (!obj1 || (obj1->type == DEMO_OBJ_IMAGE)) break;
	RIPprompt("Sorry, that's not an image. Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!obj1) return(1);

   RIPprompt("Pick path for use in transition. (Press key to cancel.)");
   do
      { obj2 = get_object();
	if (!obj2 || (obj2->type == DEMO_OBJ_PATH)) break;
	RIPprompt("Sorry, that's not a path. Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!obj2) return(1);

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_TRANS);
	ttype = get_trans_type(tnum,ttypestr,iconstr);
	sprintf(call->callstr,"%s = TANGOtrans_create(%s, %s, %s);",var,
		   ttypestr, obj1->vname, obj2->vname);
	show_transition(&x,&y,iconstr);
	trans = demo_trans_create(ttype,obj1->object,obj2->object,obj1);
	trans->x = x; trans->y = y;
	strcpy(trans->iconstr,iconstr);
	new_display(DEMO_OBJ_TRANS,trans,var,x,y);
      }

   return(1);
}




/***************************************************************/
/*   fctTransIterate - repeat a transition a certain number of */
/*	times.						       */
/***************************************************************/

int
fctTransIterate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   DISPLAY_PTR obj1;
   CALL_PTR call;
   int times;
   int x,y;
   DEMO_TRANS trans;
   static char *format1[3] = {
       "\nIterate how many times\n%0.32d\n",
       "Save result transition on var name?\n%1.32t\n\n%a             %c",
       NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Pick trans to iterate.  (key to cancel.)");
   do
      { obj1 = get_object();
	if (!obj1 || (obj1->type == DEMO_OBJ_TRANS)) break;
	RIPprompt("Sorry, not a transition.  Try again.  (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!obj1) return(1);

   var[0] = '\0';
   times = 1;
   if (STEMdialog(AnimWindow,format1,&times,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_TRANS);
	sprintf(call->callstr,"%s = TANGOtrans_iterate(%s, %d);",
		     var,obj1->vname,times);
	show_transition(&x,&y,"iterate");
	trans = demo_trans_iterate(obj1->object,times);
	trans->x = x; trans->y = y;
	strcpy(trans->iconstr,"iterate");
	new_display(DEMO_OBJ_TRANS,trans,var,x,y);
      }
   return(1);
}



/***************************************************************/
/*   fctTransCompose - do a set of transitions all "at the     */
/*	same time."                                            */
/***************************************************************/

int
fctTransCompose(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   char transstr[200];
   char tail[MAXSTRINGLENGTH];
   DISPLAY_PTR obj1;
   CALL_PTR call;
   int count;
   int x,y;
   DEMO_TRANS trans,t[11];
   char *format1 = "\nSave result transition on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Pick transitions to compose. (key to terminate.)");
   transstr[0] = '\0';
   count = 0;
   do
      { obj1 = get_object();
	if (!obj1) break;
	if (obj1->type == DEMO_OBJ_TRANS)
	   { sprintf(tail,", %s",obj1->vname);
	     strcat(transstr,tail);
	     count++;
	     t[count] = (DEMO_TRANS)(obj1->object);
	     RIPprompt("Next compose transition. (key to end)");
	   }
	else
	   RIPprompt("Sorry, not an transition. Try again. (key to terminate)");
      }
   while (1==1);
   RIPprompt(" ");

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_TRANS);
	sprintf(call->callstr,"%s = TANGOtrans_compose(%d%s);", var,count,transstr);
	show_transition(&x,&y,"compose");
	trans = demo_trans_compose(count,t[1],t[2],t[3],t[4],t[5],t[6],t[7],
				      t[8],t[9],t[10]);
	trans->x = x; trans->y = y;
	strcpy(trans->iconstr,"compose");
	new_display(DEMO_OBJ_TRANS,trans,var,x,y);
      }
   return(1);
}



/***************************************************************/
/*   fctTransConcat - do a set of transitions one after        */
/*	another.					       */
/***************************************************************/

int
fctTransConcat(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   char transstr[200];
   char tail[MAXSTRINGLENGTH];
   DISPLAY_PTR obj1;
   CALL_PTR call;
   int count;
   int x,y;
   DEMO_TRANS trans,t[11];
   char *format1 = "\nSave result transition on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Pick transitions to concatenate. (key to terminate.)");
   transstr[0] = '\0';
   count = 0;
   do
      { obj1 = get_object();
	if (!obj1) break;
	if (obj1->type == DEMO_OBJ_TRANS)
	   { sprintf(tail,", %s",obj1->vname);
	     strcat(transstr,tail);
	     count++;
	     t[count] = (DEMO_TRANS)(obj1->object);
	     RIPprompt("Next concatenate transition. (key to end)");
	   }
	else
	   RIPprompt("Sorry, not an transition. Try again. (key to terminate)");
      }
   while (1==1);
   RIPprompt(" ");

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_TRANS);
	sprintf(call->callstr,"%s = TANGOtrans_concatenate(%d%s);", var,count,transstr);
	show_transition(&x,&y,"concatenate");
	trans = demo_trans_concatenate(count,t[1],t[2],t[3],t[4],t[5],t[6],t[7],
				      t[8],t[9],t[10]);
	trans->x = x; trans->y = y;
	strcpy(trans->iconstr,"concatenate");
	new_display(DEMO_OBJ_TRANS,trans,var,x,y);
      }
   return(1);
}



/***************************************************************/
/*   fctTransPerform - get a certain transitions to perform.   */
/*	In addition to allocating the call for printing,       */
/*	actually perform the corresponding actions.	       */
/***************************************************************/

int
fctTransPerform(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR obj1;
   CALL_PTR call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose the transition to perform.  (Press key to cancel.)");
   do
      { obj1 = get_object();
	if (!obj1 || (obj1->type == DEMO_OBJ_TRANS)) break;
	RIPprompt("Sorry, that's not a transition.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!obj1) return(1);

   call = new_call(DEMO_OBJ_TRANS);
   sprintf(call->callstr,"TANGOtrans_perform(%s);", obj1->vname);
   demo_trans_perform(obj1->object);
   return(1);
}






/***************************************************************/
/*   get_trans_type - given a menu button pick, return the     */
/*	TANGO_TRANS_TYPE that should be put in the	       */
/*	TANGOtrans_create call. 			       */
/***************************************************************/

TANGO_TRANS_TYPE
get_trans_type(val,str,iconstr)
   int val;
   char *str, *iconstr;
{
   switch (val) {
      case 0:
	 sprintf(str,"TANGO_TRANS_TYPE_MOVE");
	 strcpy(iconstr,"move");
	 return(TANGO_TRANS_TYPE_MOVE);
      case 1:
	 sprintf(str,"TANGO_TRANS_TYPE_RESIZE");
	 strcpy(iconstr,"resize");
	 return(TANGO_TRANS_TYPE_RESIZE);
      case 2:
	 sprintf(str,"TANGO_TRANS_TYPE_VISIBLE");
	 strcpy(iconstr,"visible");
	 return(TANGO_TRANS_TYPE_VISIBLE);
      case 3:
	 sprintf(str,"TANGO_TRANS_TYPE_COLOR");
	 strcpy(iconstr,"color");
	 return(TANGO_TRANS_TYPE_COLOR);
      case 4:
	 sprintf(str,"TANGO_TRANS_TYPE_FILL");
	 strcpy(iconstr,"fill");
	 return(TANGO_TRANS_TYPE_FILL);
      case 5:
	 sprintf(str,"TANGO_TRANS_TYPE_RAISE");
	 strcpy(iconstr,"raise");
	 return(TANGO_TRANS_TYPE_RAISE);
      case 6:
	 sprintf(str,"TANGO_TRANS_TYPE_LOWER");
	 strcpy(iconstr,"lower");
	 return(TANGO_TRANS_TYPE_LOWER);
      case 7:
	 sprintf(str,"TANGO_TRANS_TYPE_DELAY");
	 strcpy(iconstr,"delay");
	 return(TANGO_TRANS_TYPE_DELAY);
      default:
	 sprintf(str,"TANGO_TRANS_TYPE_MOVE");
	 strcpy(iconstr,"move");
	 return(TANGO_TRANS_TYPE_MOVE);
      }
}



/***************************************************************/
/*   show_transition - figure where to put the given trans     */
/*	name in the trans variable display area;  return the   */
/*	x,y coords.					       */
/***************************************************************/

void
show_transition(x,y,iconstr)
   int *x,*y;
   char *iconstr;
{
   int dx,dy;
   ASH_FONT oldfont;
   ASH_COLOR fg,bg;

   if (!TransSet)
      { TransX = Side-100;
	TransY = 15;
	ASHtext(AnimWindow,TransX,TransY,"Transitions:");
	TransSet = 1;
	TransY += 20;  /* give it some room */
      }

   *x = TransX;
   *y = TransY;

   fg = ASHtext_color(AnimWindow,Color[DANCE_WHITE]);
   bg = ASHtext_background_color(AnimWindow,Color[DANCE_BLACK]);
   ASHicon_draw(AnimWindow,TransX,TransY,iconstr);
   ASHtext_color(AnimWindow,fg);
   ASHtext_background_color(AnimWindow,bg);

   TransY += 20;   /* icons are 16 pixels high */
}



/***************************************************************/
/*   demo_trans_create - return a transition of the given type,*/
/*	that modifies the given image along the given path.    */
/*	The DISPLAY_PTR is needed for marking modified images  */
/*	in the demo_trans_perform function.		       */
/***************************************************************/

DEMO_TRANS
demo_trans_create(type,image,path,display)
   TANGO_TRANS_TYPE    type;
   DEMO_IMAGE	       image;
   TANGO_PATH	       path;
   DISPLAY_PTR	       display;
{
   DEMO_TRANS	     trans;
   DEMO_FRAME_PTR    frame,fhead,ftail;
   int		     count;
   OFFSET_PTR	     op;
   DEMO_ACTION_PTR   action;

   trans = demo_get_transition();

   count = 0;
   fhead = ftail = NULL;
   for (op=path->head; op; op=op->nexto)
      { count++;
	frame = demo_get_frame(type);
	frame->frame_num = count;
	frame->dx = op->dx;
	frame->dy = op->dy;

	if (!fhead)
	   fhead = frame;
	else
	   ftail->nextf = frame;
	frame->prevf = ftail;
	frame->nextf = NULL;
	ftail = frame;
      }
   action = demo_get_action(type);
   action->fhead = fhead;
   action->ftail = ftail;
   action->display = display;
   action->image = image;
   action->nexta = NULL;

   trans->num_frames = count;
   trans->actions = action;

   return(trans);
}




/***************************************************************/
/*   demo_trans_iterate - return a transition which is the     */
/*	given transition repeated num times.		       */
/***************************************************************/

DEMO_TRANS
demo_trans_iterate(trans,num)
   DEMO_TRANS trans;
   int num;
{
   DEMO_TRANS	    ittrans;
   DEMO_ACTION_PTR  act,last_action,new_action;
   int		    it;

   ittrans = demo_get_transition();

   last_action = NULL;
   for (it=0; it<num; ++it)
      for (act=trans->actions; act; act=act->nexta)
	 { new_action = demo_copy_action_shift(act,it*trans->num_frames);
	   if (last_action)
	      last_action->nexta = new_action;
	   else
	      ittrans->actions = new_action;
	   last_action = new_action;
	 }
   ittrans->num_frames = num * trans->num_frames;

   return(ittrans);
}



/***************************************************************/
/*   demo_trans_concatenate - return a transition that is the  */
/*	concatenation of given transitions one after the other.*/
/***************************************************************/

DEMO_TRANS
demo_trans_concatenate(num,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10)
   int num;
   DEMO_TRANS t1,t2,t3,t4,t5,t6,t7,t8,t9,t10;
{
   DEMO_TRANS	   transitions[10],contrans;
   DEMO_ACTION_PTR act,last_action,new_action;
   int		   frame_count,tnum;

   transitions[0] = t1;
   transitions[1] = t2;
   transitions[2] = t3;
   transitions[3] = t4;
   transitions[4] = t5;
   transitions[5] = t6;
   transitions[6] = t7;
   transitions[7] = t8;
   transitions[8] = t9;
   transitions[9] = t10;
   contrans = demo_get_transition();

   last_action = NULL;
   frame_count = 0;
   for (tnum=0; tnum<num; ++tnum)
      { for (act=transitions[tnum]->actions; act; act=act->nexta)
	   { new_action = demo_copy_action_shift(act,frame_count);
	     if (last_action)
		last_action->nexta = new_action;
	     else
		contrans->actions = new_action;
	     last_action = new_action;
	   }
	frame_count += transitions[tnum]->num_frames;
      }

   contrans->num_frames = frame_count;

   return(contrans);
}



/***************************************************************/
/*   demo_trans_compose - return a transition which is the     */
/*	composition of given transitions.  By composition, we  */
/*	mean the concurrent execution of all the transitions.  */
/***************************************************************/

DEMO_TRANS
demo_trans_compose(num,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10)
   int num;
   DEMO_TRANS t1,t2,t3,t4,t5,t6,t7,t8,t9,t10;
{
   int		   max,tnum;
   DEMO_TRANS	   comtrans,transitions[11];
   DEMO_ACTION_PTR act,last_action,new_action;

   transitions[0] = t1;
   transitions[1] = t2;
   transitions[2] = t3;
   transitions[3] = t4;
   transitions[4] = t5;
   transitions[5] = t6;
   transitions[6] = t7;
   transitions[7] = t8;
   transitions[8] = t9;
   transitions[9] = t10;
   max = 0;
   for (tnum=0; tnum<num; ++tnum)
      if (transitions[tnum]->num_frames > max)
	 max = transitions[tnum]->num_frames;

   comtrans = demo_get_transition();

   last_action = NULL;
   for (tnum=0; tnum<num; ++tnum)
      { for (act=transitions[tnum]->actions; act; act=act->nexta)
	   { new_action = demo_copy_action_shift(act,0);
	     if (new_action->fhead)  /* if no frames added, bag this action */
		{ if (last_action)
		     last_action->nexta = new_action;
		  else
		     comtrans->actions = new_action;
		  last_action = new_action;
		}
	     else
		free(new_action);
	   }
      }

   comtrans->num_frames = max;

   return(comtrans);
}



/***************************************************************/
/*   demo_trans_perform - do a given transition. Right now this*/
/*	is implemented by changing only the images affected    */
/*	while the transition is performing, then doing a       */
/*	total redraw at the end.  Images are modified by       */
/*	drawing them in white at the old position, then normal */
/*	at their new position.				       */
/***************************************************************/

void
demo_trans_perform(trans)
   DEMO_TRANS trans;
{
   register DEMO_ACTION_PTR act;
	    int 	    fnum;
	    DISPLAY_PTR     d;

   for (act=trans->actions; act; act=act->nexta)
      act->doing = act->fhead;	/* reset pointers to execute frames */

   for (fnum=1; fnum<=trans->num_frames; ++fnum)
      { for (act=trans->actions; act; act=act->nexta)
	   if ((act->doing) && (act->doing->frame_num == fnum))
	      act->display->marked = 1;
	clear_images();  /* get rid of old images, only those modified */

	for (act=trans->actions; act; act=act->nexta)
	   if ((act->doing) && (act->doing->frame_num == fnum))
	      { switch (act->type)
		{ case TANGO_TRANS_TYPE_MOVE:
		     move_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_FILL:
		     fill_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_COLOR:
		     color_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_VISIBLE:
		     visible_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_RESIZE:
		     resize_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_RAISE:
		     raise_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  case TANGO_TRANS_TYPE_LOWER:
		     lower_image(act->image,act->doing->dx,act->doing->dy);
		     break;
		  default:
		     break;
		}
		act->display->marked = 1;  /* mark this image as changed */
		act->doing = act->doing->nextf;
	      }
	draw_all_images(0);    /* update to new positions, only those that have changed */

	for (d=SceneCurrent->displays; d; d=d->next)
	   d->marked = 0;   /* unmark all visible objects */
      }
   update_label_positions();  /* images may have moved */
   ASHclear(AnimWindow);
   draw_all_images(1);	/* draw everything back */
}




/***************************************************************/
/*   demo_get_transition - allocate and return a transition    */
/*	structure.  All the fields are set to their default    */
/*	initial values. 				       */
/***************************************************************/

DEMO_TRANS
demo_get_transition()
{
   DEMO_TRANS trans;

   trans = (DEMO_TRANS) malloc( sizeof( struct _DEMO_TRANS));
   trans->num_frames = 1;
   trans->actions = NULL;
   trans->next = NULL;
   return(trans);
}



/***************************************************************/
/*   demo_get_action - allocate and return an action structure.*/
/*	All the fields are set to their default initial        */
/*	values.  An action contains frames which affect an     */
/*	object in a transition.  (Because of		       */
/*	composition, one transition may affect many objects.)  */
/***************************************************************/

DEMO_ACTION_PTR
demo_get_action(type)
   TANGO_TRANS_TYPE type;
{
   DEMO_ACTION_PTR act;

   act = (DEMO_ACTION_PTR) malloc( sizeof( struct _DEMO_ACTION));
   act->type = type;
   act->image = NULL;
   act->doing = NULL;
   act->fhead = act->ftail = NULL;
   act->nexta = NULL;
   return(act);
}




/***************************************************************/
/*   demo_get_frame - allocate and return a frame structure.   */
/*	All the fields are set to their default initial        */
/*	values.  A frame is one logical time unit of action    */
/*	in a transition.  The frame_num field is very important*/
/*	for the execution of transitions.		       */
/***************************************************************/

DEMO_FRAME_PTR
demo_get_frame(type)
   TANGO_TRANS_TYPE type;
{
   DEMO_FRAME_PTR frame;

   frame = (DEMO_FRAME_PTR) malloc( sizeof( struct _DEMO_FRAME));
   frame->type = type;
   frame->frame_num = 1;
   frame->dx = ZERO;
   frame->dy = ZERO;
   frame->nextf = frame->prevf = NULL;
   return(frame);
}



/***************************************************************/
/*   demo_copy_frames_shift - copy all the frames from the     */
/*	list, and return the appropriate head and tail ptrs.   */
/*	The frame_numbers are supplemented by the additional   */
/*	start_num.					       */
/***************************************************************/

void
demo_copy_frames_shift(frames,start_num,head,tail)
   DEMO_FRAME_PTR  frames;
   int		   start_num;
   DEMO_FRAME_PTR *head;
   DEMO_FRAME_PTR *tail;
{
   DEMO_FRAME_PTR fra,new_frame;
   DEMO_FRAME_PTR h,t;

   h = t = NULL;
   for (fra=frames; fra; fra=fra->nextf)
      { new_frame = (DEMO_FRAME_PTR) malloc( sizeof( struct _DEMO_FRAME));
	new_frame->type = fra->type;
	new_frame->dx = fra->dx;
	new_frame->dy = fra ->dy;
	new_frame->frame_num = fra->frame_num + start_num;
	if (h)
	   t->nextf = new_frame;
	else
	   h = new_frame;
	new_frame->prevf = t;
	new_frame->nextf = NULL;
	t = new_frame;
      }
   *head = h;
   *tail = t;
}




/***************************************************************/
/*   demo_copy_action_shift - copy the given action (and its   */
/*	subframes) into a new action which has the framenumbers*/
/*	supplemented by start_frame.  Return the ACTION_PTR.   */
/***************************************************************/

DEMO_ACTION_PTR
demo_copy_action_shift(action,start_frame)
   DEMO_ACTION_PTR action;
   int	      start_frame;
{
   DEMO_ACTION_PTR new_action;
   DEMO_FRAME_PTR  head,tail;

   new_action = (DEMO_ACTION_PTR) malloc( sizeof( struct _DEMO_ACTION));
   new_action->type = action->type;
   new_action->image = action->image;
   new_action->display = action->display;
   new_action->doing = NULL;
   new_action->nexta = NULL;

   demo_copy_frames_shift(action->fhead,start_frame,&head,&tail);
   new_action->fhead = head;
   new_action->ftail = tail;
   return(new_action);
}



/***************************************************************/
/*   demo_transition_free - free up the allocated structures   */
/*	associated with a transition.			       */
/***************************************************************/

void
demo_transition_free(trans)
   DEMO_TRANS trans;
{
   DEMO_FRAME_PTR  f,old_f;
   DEMO_ACTION_PTR act,old_act;

   if (!trans) return;
   act = trans->actions;
   while (act)
      { f = act->fhead;
	while (f)
	   { old_f = f;
	     f = f->nextf;
	     free(old_f);
	   }
	old_act = act;
	act = act->nexta;
	free(old_act);
      }
   free(trans);
}



/***************************************************************/
/*   move_image - move the given image the given dx and dy     */
/*	values. 					       */
/***************************************************************/

void
move_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   int i;

   image->x[0] += dx;
   image->y[0] += dy;
   image->pixelx[0] = ABSOL(image->x[0]);
   image->pixely[0] = ABSOL(image->y[0]);
   if ((image->type == DEMO_OBJ_LINE) || (image->type == DEMO_OBJ_RECT))
      { image->x[1] += dx;
	image->y[1] += dy;
	image->pixelx[1] = ABSOL(image->x[1]);
	image->pixely[1] = ABSOL(image->y[1]);
      }
   if ((image->type == DEMO_OBJ_POLYGON) || (image->type == DEMO_OBJ_POLYLINE) ||
	  (image->type == DEMO_OBJ_SPLINE))
      for (i=1; i<image->vertices; ++i)
	 { image->x[i] += dx;
	   image->y[i] += dy;
	   image->pixelx[i] = ABSOL(image->x[i]);
	   image->pixely[i] = ABSOL(image->y[i]);
	 }
}



/***************************************************************/
/*   resize_image - resize the image by the given dx,dy pair.  */
/*	Note that images have different methods for this.      */
/***************************************************************/

void
resize_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   int i;
   double fx,fy,bx,by;

   if (image->type == DEMO_OBJ_LINE)
      { image->x[1] += dx;
	image->y[1] += dy;
	image->pixelx[1] = ABSOL(image->x[1]);
	image->pixely[1] = ABSOL(image->y[1]);
	if ((image->arrow & 0x1) != 0)
	   { find_arrow_offsets(image->x[1]-image->x[0],image->y[1]-image->y[0],&(image->arrowloc[0][0]),&(image->arrowloc[0][1]),
				       &(image->arrowloc[1][0]),&(image->arrowloc[1][1]));
	     make_arrow_integer(image,0);
	   }
	if ((image->arrow & 0x2) != 0)
	   { find_arrow_offsets(image->x[0]-image->x[1],image->y[0]-image->y[1],&(image->arrowloc[2][0]),&(image->arrowloc[2][1]),
				       &(image->arrowloc[3][0]),&(image->arrowloc[3][1]));
	     make_arrow_integer(image,2);
	   }
      }
   else if (image->type == DEMO_OBJ_RECT)
      { if (image->x[0] < image->x[1])
	   { image->x[1] += dx;
	     if (image->x[1] < image->x[0])
		image->x[1] = image->x[0];
	     image->pixelx[1] = ABSOL(image->x[1]);
	   }
	else
	   { image->x[0] += dx;
	     if (image->x[0] < image->x[1])
		image->x[0] = image->x[1];
	     image->pixelx[0] = ABSOL(image->x[0]);
	   }
	if (image->y[0] < image->y[1])
	   { image->y[1] += dy;
	     if (image->y[1] < image->y[0])
		image->y[1] = image->y[0];
	     image->pixely[1] = ABSOL(image->y[1]);
	   }
	else
	   { image->y[0] += dy;
	     if (image->y[0] < image->y[1])
		image->y[0] = image->y[1];
	     image->pixely[0] = ABSOL(image->y[0]);
	   }
      }
   else if (image->type == DEMO_OBJ_CIRCLE)
      { image->x[1] += dx;
	image->pixelx[1] = ABSOL(image->x[1]);
	if (image->x[1] < 0.0)
	   { image->x[1] = 0.0;
	     image->pixelx[1] = 0;
	   }
      }
   else if (image->type == DEMO_OBJ_ELLIPSE)
      { image->x[1] += dx;
	image->y[1] += dy;
	image->pixelx[1] = ABSOL(image->x[1]);
	image->pixely[1] = ABSOL(image->y[1]);
	if (image->x[1] < 0.0)
	   { image->x[1] = 0.0;
	     image->pixelx[1] = 0;
	   }
	if (image->y[1] < 0.0)
	   { image->y[1] = 0.0;
	     image->pixely[1] = 0;
	   }
      }
   else if ((image->type == DEMO_OBJ_POLYGON) || (image->type == DEMO_OBJ_POLYLINE) ||
	       (image->type == DEMO_OBJ_SPLINE))
      { for (i=1; i<image->vertices; ++i)
	   { image->x[i] += dx;
	     image->y[i] += dy;
	     image->pixelx[i] = ABSOL(image->x[i]);
	     image->pixely[i] = ABSOL(image->y[i]);
	   }
	if (image->type == DEMO_OBJ_POLYLINE)
	   { if (image->arrow != 0)
		polyline_arrow_dir(image,&fx,&fy,&bx,&by);
	     if ((image->arrow & 0x1) != 0)
		{ find_arrow_offsets(fx,fy,&(image->arrowloc[0][0]),&(image->arrowloc[0][1]),
					    &(image->arrowloc[1][0]),&(image->arrowloc[1][1]));
		  make_arrow_integer(image,0);
		}
	     if ((image->arrow & 0x2) != 0)
		{ find_arrow_offsets(bx,by,&(image->arrowloc[2][0]),&(image->arrowloc[2][1]),
					    &(image->arrowloc[3][0]),&(image->arrowloc[3][1]));
		  make_arrow_integer(image,2);
		}
	   }
      }
   else if (image->type == DEMO_OBJ_TEXT)
      { /* do nothing for now */;
      }
}



/***************************************************************/
/*   visible_image - toggle the visibility of the given image  */
/***************************************************************/

void
visible_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   image->visible = !(image->visible);
}


/***************************************************************/
/*   fill_image - alter the fill of the given object by the    */
/*	given dx value. 				       */
/***************************************************************/

void
fill_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   if (image->type == DEMO_OBJ_LINE)
      { image->width += dx;
	image->style += dy;
	if (image->width < 0.0)
	   image->width = 0.0;
	else if (image->width > 1.0)
	   image->width = 1.0;
	if (image->style < 0.0)
	   image->style = 0.0;
	else if (image->style > 1.0)
	   image->style = 1.0;
	image->linestyle = get_linestyle(image->width,image->style);
      } 			/* defined in tangoimage.c */
   else
      { image->fill += dx;
	if (image->fill < 0.0)
	   image->fill = 0.0;
	else if (image->fill > 1.0)
	   image->fill = 1.0;
	image->ashfill = get_fillstyle(image->fill);  /* defined in tangoimage.c */
      }
}



/***************************************************************/
/*   color_image - change the image to the color designated    */
/*	by the (x,y) pair.				       */
/***************************************************************/

void
color_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   int tangocolor;

   tangocolor = inquire_pathcolor(dx,dy);    /* defined in tangoimage.c */
   switch (tangocolor)
   { case TANGO_COLOR_WHITE:
	image->ashcolor = Color[DANCE_WHITE];
	break;
     case TANGO_COLOR_BLACK:
	image->ashcolor = Color[DANCE_BLACK];
	break;
     case TANGO_COLOR_RED:
	image->ashcolor = Color[DANCE_RED];
	break;
     case TANGO_COLOR_ORANGE:
	image->ashcolor = Color[DANCE_ORANGE];
	break;
     case TANGO_COLOR_YELLOW:
	image->ashcolor = Color[DANCE_YELLOW];
	break;
     case TANGO_COLOR_GREEN:
	image->ashcolor = Color[DANCE_GREEN];
	break;
     case TANGO_COLOR_BLUE:
	image->ashcolor = Color[DANCE_BLUE];
	break;
     case TANGO_COLOR_MAROON:
	image->ashcolor = Color[DANCE_MAROON];
	break;
     default:
	image->ashcolor = Color[DANCE_BLACK];
   }
}



/***************************************************************/
/*   raise_image - put the given image at the end of the       */
/*	current fct's image list.  (it will be drawn last)     */
/***************************************************************/

void
raise_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   DISPLAY_PTR d;

   for (d=SceneCurrent->displays; d; d=d->next)
      if ((DEMO_IMAGE)(d->object) == image) break;
   if (!d) return;  /* some kind of error */

   if (d == SceneCurrent->display_tail) return;

   if (d == SceneCurrent->displays)
      SceneCurrent->displays = d->next;
   else
      d->prev->next = d->next;

   d->next->prev = d->prev;
   d->prev = SceneCurrent->display_tail;
   SceneCurrent->display_tail->next = d;
   SceneCurrent->display_tail = d;
   d->next = NULL;
}



/***************************************************************/
/*   lower_image - put the given image at the beginning of the */
/*	current fct's image list.  (it will be drawn first)    */
/***************************************************************/

void
lower_image(image,dx,dy)
   DEMO_IMAGE image;
   double dx,dy;
{
   DISPLAY_PTR d;

   for (d=SceneCurrent->displays; d; d=d->next)
      if ((DEMO_IMAGE)(d->object) == image) break;
   if (!d) return;  /* some kind of error */

   if (d == SceneCurrent->displays) return;

   if (d == SceneCurrent->display_tail)
      SceneCurrent->display_tail = d->prev;
   else
      d->next->prev = d->prev;

   d->prev->next = d->next;
   d->next = SceneCurrent->displays;
   SceneCurrent->displays->prev = d;
   SceneCurrent->displays = d;
   d->prev = NULL;
}



