/***************************************************************/
/*							       */
/*		    DANCE PACKAGE (path)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include <dancelocal.h>


/***************************************************************/
/*   fctPathStore - allow the user store a TANGO_PATH in a     */
/*	file.						       */
/***************************************************************/

int
fctPathStore(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char file[32];
   char *format = "\nFile name\n%0.32t\n\n%a             %c";
   CALL_PTR call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to store.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   file[0] = '\0';
   if (STEMdialog1(AnimWindow,format,file) && (file[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"TANGOpath_store(%s, \"%s\");",disp->vname,file);
	TANGOpath_store(disp->object,file);
      }
   return(1);
}





/***************************************************************/
/*   fctPathLoad - allow the user to load a path from a file.  */
/***************************************************************/

int
fctPathLoad(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   TANGO_PATH path;
   char var[32],file[32];
   char *format = "\nLoad file name\n%0.32t\n\nOnto path var's name\n%1.32t\n\n%a             %c";
   CALL_PTR call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   var[0] = file[0] = '\0';
   if (STEMdialog1(AnimWindow,format,file,var) && (var[0] != '\0') && (file[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_load(\"%s\");",var,file);

	if (path = TANGOpath_load(file))
	   { display_path(path);
	     new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
	   }
	else
	   { ASHbell();
	     RIPinput_track(AnimWindow,"Unable to load path, so click down and drag to draw example",
		    get_a_path,-1);
	     path = (TANGO_PATH) ASHinq_user_data(AnimWindow);
	     new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
	   }

      }
   return(1);
}





/***************************************************************/
/*   fctPathMake - allow the user to create a path (mouse      */
/*	picks or drag) and save its form for later use.        */
/***************************************************************/

int
fctPathMake(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   TANGO_PATH path;
   char var[32];
   char *format = "\nPath's variable name\n%0.32t\n\n%a             %c";
   CALL_PTR call;
   DISPLAY_PTR disp;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   if (strcmp(button,"Make (pick)") == 0)
      RIPinput_track_down(AnimWindow,"Click down to define path offsets",get_a_pick_path,-1);
   else if (strcmp(button,"Make (drag)") == 0)
      RIPinput_track_down(AnimWindow,"Click down and drag to define path",get_a_path,-1);
   path = (TANGO_PATH) ASHinq_user_data(AnimWindow);  /* set in get_a_path */
   if (!path) return(1);
   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_create(%d, %s_x, %s_y);",
		   var,path->count,var,var);

	disp = new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
	call->special = disp;	/* have to set aside 2 double arrays as
				    local vars in fct definition */
      }
   else
     erase_path(path);
   return(1);
}




/***************************************************************/
/*   get_a_path - tracks the mouse and saves the movements as  */
/*	a group of (x,y) offsets.  RIP calls this routine.     */
/***************************************************************/

int
get_a_path(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int	      startx,starty;
   static OFFSET_PTR  head,tail;
	  OFFSET_PTR  offset;
   static int	      count;
	  TANGO_PATH   path;
   char *format = "\nEdit path?\n%0.0o  Yes\n%0.1o  No\n\n   %a";
   int	 reply;

  if (evt_num)
     { ASHcircle(AnimWindow,x,y,2);
       if (trans == RIP_TRANS_DOWN)
	  { startx = x; starty = y;
	    count  = 0;
	    head = tail = NULL;
	    ASHdraw_hilite(AnimWindow,1);
	    RIPprompt("Trace out the path. Release button to quit");
	  }
       else /* trans == MOVE or UP */
	  { offset = (OFFSET_PTR) malloc (sizeof (struct OFFSET));
	    offset->absx = x;
	    offset->absy = y;
	    if (!head)
	       head = offset;
	    else
	       tail->nexto = offset;
	    offset->prevo = tail;
	    offset->nexto = NULL;
	    tail = offset;
	    count++;
	  }
       if (trans == RIP_TRANS_UP)
	  { path = alloc_path(head,tail,count,startx,starty);
	    ASHset_user_data(AnimWindow,path);
	    reply = 1;
	    STEMdialog1(AnimWindow,format,&reply);
	    if (reply == 0)
	       RIPinput_track(AnimWindow,"Click & drag to move offset (char to quit)",edit_path,-1);
	    ASHdraw_hilite(AnimWindow,0);
	    convert_path(path);
	    return(0);
	  }
     }
  return(1);
}



/***************************************************************/
/*   get_a_pick_path - each click down designates a new spot   */
/*	for an offset in a path.			       */
/***************************************************************/

int
get_a_pick_path(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int	      startx,starty;
   static OFFSET_PTR  head,tail;
	  OFFSET_PTR  offset;
   static int	      count = -1;
	  TANGO_PATH   path;
   char *format = "\nEdit path?\n%0.0o  Yes\n%0.1o  No\n\n   %a";
   int	 reply;

  if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	  { if (count == -1) /* starting offset */
	       { ASHcircle(AnimWindow,x,y,2);
		 startx = x; starty = y;
		 count	= 0;
		 head = tail = NULL;
		 ASHdraw_hilite(AnimWindow,1);
		 RIPprompt("Pick offset points. Type char to quit");
	       }
	    else /* not starting offset */
	       { ASHcircle(AnimWindow,x,y,2);
		 offset = (OFFSET_PTR) malloc (sizeof (struct OFFSET));
		 offset->absx = x;
		 offset->absy = y;
		 if (!head)
		    head = offset;
		 else
		    tail->nexto = offset;
		 offset->prevo = tail;
		 offset->nexto = NULL;
		 tail = offset;
		 count++;
	       }
	  }
       else if (trans == RIP_TRANS_CHAR) /* ender */
	  { if ((count == 0) || (count == -1))
	       { ASHset_user_data(AnimWindow,NULL);
		 ASHdraw_hilite(AnimWindow,0);
		 count = -1;
		 return(0);
	       }
	    path = alloc_path(head,tail,count,startx,starty);
	    ASHset_user_data(AnimWindow,path);
	    reply = 1;
	    STEMdialog1(AnimWindow,format,&reply);
	    if (reply == 0)
	       RIPinput_track(AnimWindow,"Click & drag to move offset (char to quit)",edit_path,-1);
	    ASHdraw_hilite(AnimWindow,0);
	    convert_path(path);
	    count = -1;
	    return(0);
	  }
     }
  return(1);
}



/***************************************************************/
/*   edit_path - allows the user to move the control points    */
/*	that make up a path.				       */
/***************************************************************/

int
edit_path(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static   OFFSET_PTR point = NULL;
	    TANGO_PATH	path;
   register OFFSET_PTR op,prev;

   switch (trans)
   {
      case RIP_TRANS_MOVE :
	 if (point)
	    { ASHcircle(AnimWindow,point->absx,point->absy,2);
	      point->absx = x;
	      point->absy = y;
	      ASHcircle(AnimWindow,x,y,2);
	    }
	 return(1);
      case RIP_TRANS_DOWN :
	 path = (TANGO_PATH) ASHinq_user_data(AnimWindow);
	 for (op = path->head; op; op = op->nexto)
	    if ((SAME(x,op->absx)) && (SAME(y,op->absy)))
	       { point = op;
		 break;
	       }
	 return(1);
      case RIP_TRANS_UP :
	 if (point)
	    { ASHcircle(AnimWindow,point->absx,point->absy,2);
	      point->absx = x;
	      point->absy = y;
	      ASHcircle(AnimWindow,x,y,2);
	    }

	 point = NULL;
	 return(1);
      case RIP_TRANS_CHAR :
	 point = NULL;
	 return(0);
      default :
	 return(1);
   }
}


/***************************************************************/
/*   fctPathType - allows the user to generate a path of one   */
/*	of the three basic types.			       */
/***************************************************************/

int
fctPathType(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   TANGO_PATH path;
   TANGO_PATH_TYPE ptype;
   int type;
   char *typestr;
   CALL_PTR call;
   static char *format1[3] =
      { "\nPath type\n%0.0o straight\n%0.1o clockwise\n%0.2o counterclockwise\n",
	"Save path on var name?\n%1.32t\n\n\n%a          %c",
	NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);

   var[0] = '\0';
   type = 0;
   if (STEMdialog(AnimWindow,format1,&type,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	if (type == 0)
	   { ptype = TANGO_PATH_TYPE_STRAIGHT;
	     typestr = "TANGO_PATH_TYPE_STRAIGHT";
	   }
	else if (type == 1)
	   { ptype = TANGO_PATH_TYPE_CLOCKWISE;
	     typestr = "TANGO_PATH_TYPE_CLOCKWISE";
	   }
	else if (type == 2)
	   { ptype = TANGO_PATH_TYPE_COUNTERCLOCKWISE;
	     typestr = "TANGO_PATH_TYPE_COUNTERCLOCKWISE";
	   }

	sprintf(call->callstr,"%s = TANGOpath_type(%s);",var,typestr);
	path = TANGOpath_type(ptype);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }

   return(1);
}




/***************************************************************/
/*   fctPathCopy - allows the user to copy a path onto a new   */
/*	path variable name.				       */
/***************************************************************/

int
fctPathCopy(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   CALL_PTR call;
   char to[32];
   char *format1 = "\nCopy to new path var name?\n%0.32t\n\n%a         %c";
   TANGO_PATH path;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to copy.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   to[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,to) && (to[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_copy(%s);",to,disp->vname);
	path = TANGOpath_copy(disp->object);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,to,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathSmooth - allows the user to smooth out a given     */
/*	path (avg offsets with neighboring offsets.)	       */
/***************************************************************/

int
fctPathSmooth(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   CALL_PTR call;
   char to[32];
   char *format1 = "\nSmoothed path var name?\n%0.32t\n\n%a         %c";
   TANGO_PATH path;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to smooth.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   to[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,to) && (to[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_smooth(%s);",to,disp->vname);
	path = TANGOpath_smooth(disp->object);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,to,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathNull - create a path with a certain number of      */
/*	null (0.0, 0.0) offsets.			       */
/***************************************************************/

int
fctPathNull(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   TANGO_PATH path;
   char var[32];
   int offsets;
   static char *format[4] = {
      "\nNumber of offsets\n%0.32d\n",
      "Path's variable name\n%1.32t\n",
      "%a             %c",
      NULL};
   CALL_PTR call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   offsets = 1;
   var[0] = '\0';
   if (STEMdialog(AnimWindow,format,&offsets,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_null(%d);",var,offsets);
	path = TANGOpath_null(offsets);
	display_path(path);

	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathColor - create a path that will change an image	*/
/*	to a different color.				       */
/***************************************************************/

int
fctPathColor(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   TANGO_PATH path;
   char var[32];
   char colorstr[MAXSTRINGLENGTH];
   int ashcolor,tangocolor;
   char *format = "\nPath's variable name\n%0.32t\n\n%a             %c";
   CALL_PTR call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   get_a_color(colorstr,&tangocolor,&ashcolor);
   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_color(%s);",var,colorstr);
	path = TANGOpath_color(tangocolor);
	display_path(path);

	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathRotate - allows the user to rotate a given path by */
/*	a certain number of degrees.			       */
/***************************************************************/

int
fctPathRotate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char var[32];
   TANGO_PATH path;
   int degrees;
   CALL_PTR call;
   static char *format1[4] = {
      "\nRotate by how many degrees? (int)\n%0.32d\n",
      "Save result path on var name?\n%1.32t\n",
      "\n%a             %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to rotate.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   var[0] = '\0';
   degrees = 0;
   if (STEMdialog(AnimWindow,format1,&degrees,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_rotate(%s, %d);",var,disp->vname,degrees);
	path = TANGOpath_rotate(disp->object,degrees);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathInterpolate - allows the user to interpolate the   */
/*	number of offsets in a path.			       */
/***************************************************************/

int
fctPathInterpolate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char var[32];
   TANGO_PATH path;
   double factor;
   CALL_PTR call;
   static char *format1[4] = {
      "\nInterpolation factor? (real)\n%0.32h\n",
      "Save result path on var name?\n%1.32t\n",
      "\n%a             %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to interpolate.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   var[0] = '\0';
   factor = 1.0;
   if (STEMdialog(AnimWindow,format1,&factor,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_interpolate(%s, %lf);",var,disp->vname,factor);
	path = TANGOpath_interpolate(disp->object,factor);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathScale - allows the user to scale a path by factors */
/*	in x and y.					       */
/***************************************************************/

int
fctPathScale(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char var[32];
   TANGO_PATH path;
   double dx,dy;
   CALL_PTR call;
   static char *format1[5] = {
      "\nScale factor in x? (real)\n%0.32h\n",
      "Scale factor in y? (real)\n%1.32h\n",
      "Save result path on var name?\n%2.32t\n",
      "\n%a             %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to scale.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   var[0] = '\0';
   dx = dy = 1.0;
   if (STEMdialog(AnimWindow,format1,&dx,&dy,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_scale(%s, %lf, %lf);",var,disp->vname,dx,dy);
	path = TANGOpath_scale(disp->object,dx,dy);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathExtend - allows the user to add x and y values to  */
/*	each offset.					       */
/***************************************************************/

int
fctPathExtend(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char var[32];
   TANGO_PATH path;
   double dx,dy;
   CALL_PTR call;
   static char *format1[5] = {
      "\nExtend factor in x? (real)\n%0.32h\n",
      "Extend factor in y? (real)\n%1.32h\n",
      "Save result path on var name?\n%2.32t\n",
      "\n%a             %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to extend.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   var[0] = '\0';
   dx = dy = 1.0;
   if (STEMdialog(AnimWindow,format1,&dx,&dy,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_extend(%s, %lf, %lf);",var,disp->vname,dx,dy);
	path = TANGOpath_extend(disp->object,dx,dy);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathIterate - allows the user to iterate a path a      */
/*	a certain number of times.			       */
/***************************************************************/

int
fctPathIterate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   DISPLAY_PTR disp;
   char var[32];
   TANGO_PATH path;
   double times;
   CALL_PTR call;
   static char *format1[4] = {
      "\nIterate how many times? (real)\n%0.32h\n",
      "Save result path on var name?\n%1.32t\n",
      "\n%a             %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to iterate.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   var[0] = '\0';
   times = 1.0;
   if (STEMdialog(AnimWindow,format1,&times,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_iterate(%s, %lf);",var,disp->vname,times);
	path = TANGOpath_iterate(disp->object,times);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathConcat - allows the user to concatenate a set of   */
/*	paths into one new path.			       */
/***************************************************************/

int
fctPathConcat(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   char pathstr[200];
   char tail[MAXSTRINGLENGTH];
   DISPLAY_PTR obj1;
   CALL_PTR call;
   int count;
   int x,y;
   TANGO_PATH path,p[11];
   char *format1 = "\nSave result path on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Pick paths to concatenate. (key to terminate.)");
   pathstr[0] = '\0';
   count = 0;
   do
      { obj1 = get_object();
	if (!obj1) break;
	if (obj1->type == DEMO_OBJ_PATH)
	   { sprintf(tail,", %s",obj1->vname);
	     strcat(pathstr,tail);
	     count++;
	     p[count] = (TANGO_PATH)(obj1->object);
	     RIPprompt("Next concat path. (key to end)");
	   }
	else
	   RIPprompt("Sorry, not a path. Try again. (key to terminate)");
      }
   while (1==1);
   RIPprompt(" ");

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_concatenate(%d%s);", var,count,pathstr);
	path = TANGOpath_concatenate(count,p[1],p[2],p[3],p[4],p[5],p[6],p[7],
				      p[8],p[9],p[10]);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathCompose - allows the user to compose a set of      */
/*	paths into one new path.			       */
/***************************************************************/

int
fctPathCompose(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   char pathstr[200];
   char tail[MAXSTRINGLENGTH];
   DISPLAY_PTR obj1;
   CALL_PTR call;
   int count;
   int x,y;
   TANGO_PATH path,p[11];
   char *format1 = "\nSave result path on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Pick paths to compose. (key to terminate.)");
   pathstr[0] = '\0';
   count = 0;
   do
      { obj1 = get_object();
	if (!obj1) break;
	if (obj1->type == DEMO_OBJ_PATH)
	   { sprintf(tail,", %s",obj1->vname);
	     strcat(pathstr,tail);
	     count++;
	     p[count] = (TANGO_PATH)(obj1->object);
	     RIPprompt("Next compose path. (key to end)");
	   }
	else
	   RIPprompt("Sorry, not a path. Try again. (key to terminate)");
      }
   while (1==1);
   RIPprompt(" ");

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_compose(%d%s);", var,count,pathstr);
	path = TANGOpath_compose(count,p[1],p[2],p[3],p[4],p[5],p[6],p[7],
				      p[8],p[9],p[10]);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}







/***************************************************************/
/*   fctPathExample - allows the user to utilize a path as an  */
/*	example in order to generate a path moving between     */
/*	two new locations.				       */
/***************************************************************/

int
fctPathExample(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   TANGO_PATH path;
   DISPLAY_PTR disp;
   DISPLAY_PTR loc1,loc2;
   CALL_PTR call;
   char *format1 = "\nSave result path on var name?\n%0.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose path to use as example.  (Press key to cancel.)");
   do
      { disp = get_object();
	if (!disp) break;
	if (disp->type == DEMO_OBJ_PATH) break;
	RIPprompt("Sorry, that's not a path.  Try again.  (press key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   RIPprompt("Choose the `from' location object (key to cancel)");
   do
      { loc1 = get_object();
	if (!loc1) break;
	if (loc1->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc1) return(1);

   RIPprompt("Choose the `to' location object (key to cancel)");
   do
      { loc2 = get_object();
	if (!loc2) break;
	if (loc2->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc2) return(1);

   var[0] = '\0';
   if (STEMdialog1(AnimWindow,format1,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_example(%s, %s, %s);",var,
		   loc1->vname,loc2->vname,disp->vname);
	path = TANGOpath_example(loc1->object,loc2->object,disp->object);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}




/***************************************************************/
/*   fctPathDistance - allows the user to generate a straight  */
/*	path given that a certain distance is maintained       */
/*	between subsequent offsets.			       */
/***************************************************************/

int
fctPathDistance(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   TANGO_PATH path;
   double distance;
   DISPLAY_PTR loc1,loc2;
   CALL_PTR call;
   char *format1 = "\nDistance between offsets?\n%0.32h\n\nSave result path on var name?\n%1.32t\n\n%a             %c";

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose the `from' location object (key to cancel)");
   do
      { loc1 = get_object();
	if (!loc1) break;
	if (loc1->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc1) return(1);

   RIPprompt("Choose the `to' location object (key to cancel)");
   do
      { loc2 = get_object();
	if (!loc2) break;
	if (loc2->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc2) return(1);

   var[0] = '\0';
   distance = 0.02;
   if (STEMdialog1(AnimWindow,format1,&distance,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	sprintf(call->callstr,"%s = TANGOpath_distance(%s, %s, %lf);",
		   var,loc1->vname,loc2->vname,distance);
	path = TANGOpath_distance(loc1->object,loc2->object,distance);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }
   return(1);
}



/***************************************************************/
/*   fctPathMotion - allows the user to generate a path of a   */
/*	certain motion moving between 2 given points.	       */
/***************************************************************/

int
fctPathMotion(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char var[32];
   TANGO_PATH path;
   TANGO_PATH_TYPE ptype;
   int motion;
   char *motionstr;
   DISPLAY_PTR loc1,loc2;
   CALL_PTR call;
   static char *format1[3] =
      { "\nPath motion\n%0.0o straight\n%0.1o clockwise\n%0.2o counter clockwise\n",
	"Save path on var name?\n%1.32t\n\n\n%a          %c",
	NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Choose the `from' location object (key to cancel)");
   do
      { loc1 = get_object();
	if (!loc1) break;
	if (loc1->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc1) return(1);

   RIPprompt("Choose the `to' location object (key to cancel)");
   do
      { loc2 = get_object();
	if (!loc2) break;
	if (loc2->type == DEMO_OBJ_LOC) break;
	RIPprompt("Sorry, that's not a loc.  Try again. (key to cancel)");
      }
   while (1==1);
   RIPprompt(" ");
   if (!loc2) return(1);

   var[0] = '\0';
   motion = 0;
   if (STEMdialog(AnimWindow,format1,&motion,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_PATH);
	if (motion == 0)
	   { ptype = TANGO_PATH_TYPE_STRAIGHT;
	     motionstr = "TANGO_PATH_TYPE_STRAIGHT";
	   }
	else if (motion == 1)
	   { ptype = TANGO_PATH_TYPE_CLOCKWISE;
	     motionstr = "TANGO_PATH_TYPE_CLOCKWISE";
	   }
	else if (motion == 2)
	   { ptype = TANGO_PATH_TYPE_COUNTERCLOCKWISE;
	     motionstr = "TANGO_PATH_TYPE_COUNTERCLOCKWISE";
	   }

	sprintf(call->callstr,"%s = TANGOpath_motion(%s, %s, %s);",
		   var,loc1->vname,loc2->vname,motionstr);
	path = TANGOpath_motion(loc1->object,loc2->object,ptype);
	display_path(path);
	new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
      }

   return(1);
}




/***************************************************************/
/*   convert_path - take a path that has been drawn on the     */
/*	screen (all absolute pixel coordinates) and convert it */
/*	to logical 0.0->1.0 coordinates.		       */
/***************************************************************/

void
convert_path(path)
   TANGO_PATH path;
{
  OFFSET_PTR off;
  int prevx,prevy;

  prevx = path->startx;
  prevy = path->starty;

  for (off=path->head; off; off=off->nexto)
     { off->dx = (double) (off->absx - prevx) / (double) Side;
       off->dy = (double) (off->absy - prevy) / (double) Side;
       prevx = off->absx;
       prevy = off->absy;
     }
}





/***************************************************************/
/*   display_path - receive a path that is in relative window  */
/*	coords, query the user on where to place it, then draw */
/*	it on the window.  (Give it abolute pixel coords.)     */
/***************************************************************/

void
display_path(path)
   TANGO_PATH path;
{
   PT_PTR pt;

   RIPprompt("Select position to begin drawing of path");
   pt = get_point();
   RIPprompt(" ");
   draw_path(path,pt->x,pt->y);
}



/***************************************************************/
/*   center_path - receive a path that is in relative window   */
/*	coords and display it centered on the screen.  (Give   */
/*	it abolute pixel coords.)			       */
/***************************************************************/

void
center_path(path)
   TANGO_PATH path;
{
   WIN_COORD dx,dy;
   int xchange,ychange,x,y;
   OFFSET_PTR op;

   dx = dy = 0.0;
   for (op=path->head; op; op=op->nexto)
      { dx += op->dx;
	dy += op->dy;
      }

   xchange = (int)(dx * (double)Side);
   ychange = (int)(dy * (double)Side);

   /* want to center the display of the path */
   x = (Side-xchange) / 2;
   y = (Side-ychange) / 2;

   draw_path(path,x,y);
}




/***************************************************************/
/*   draw_path - receive a path that is in relative window     */
/*	coords plus a starting position, then draw the path    */
/*	there.						       */
/***************************************************************/

void
draw_path(path,x,y)
   TANGO_PATH path;
   int x,y;
{
   int xchange,ychange,oldx,oldy;
   OFFSET_PTR op;

   oldx = path->startx = x;
   oldy = path->starty = y;
   ASHcircle(AnimWindow,x,y,2);
   for (op=path->head; op; op=op->nexto)
      { xchange = (int)(op->dx * (double)Side);
	ychange = (int)(op->dy * (double)Side);
	op->absx = oldx + xchange;
	op->absy = oldy + ychange;
	oldx = op->absx;
	oldy = op->absy;
	ASHcircle(AnimWindow,op->absx,op->absy,2);
      }
}




/***************************************************************/
/*   erase_path - remove the given path from the screen.  Use  */
/*	the absolute pixel coords.			       */
/***************************************************************/

void
erase_path(path)
   TANGO_PATH path;
{
   OFFSET_PTR offset;

   ASHdraw_hilite(AnimWindow,1);
   ASHcircle(AnimWindow,path->startx,path->starty,2);
   for (offset = path->head; offset; offset = offset->nexto)
      ASHcircle(AnimWindow,offset->absx,offset->absy,2);
   ASHdraw_hilite(AnimWindow,0);
}




/***************************************************************/
/*   alloc_path - receive a list of offsets and save them as a	*/
/*	new path.					       */
/***************************************************************/

TANGO_PATH
alloc_path(head,tail,count,startx,starty)
   OFFSET_PTR head;
   OFFSET_PTR tail;
   int count;
   int startx,starty;
{
   TANGO_PATH new_path;

   new_path = (TANGO_PATH) malloc( sizeof (struct _PATH));
   new_path->head = head;
   new_path->tail = tail;
   new_path->count = count;
   new_path->startx = startx;
   new_path->starty = starty;
   new_path->nextp = NULL;
   new_path->prevp = NULL;
   return(new_path);
}


/***************************************************************/
/*   get_a_color - allow the user to get a color.  Return its  */
/*	string, TANGO color value, and ASH_COLOR value.        */
/***************************************************************/

void
get_a_color(colorstr,tangocolor,ashcolor)
   char *colorstr;
   int *tangocolor;
   ASH_COLOR *ashcolor;
{
   int color;
   char arr1[200];
   char *format[4];

   format[0] = "\nColor";
   sprintf(arr1,"%%0.0.%d.41o\n%%0.1.%d.41o\n%%0.2.%d.41o\n%%0.3.%d.41o\n%%0.4.%d.41o\n%%0.5.%d.41o\n%%0.6.%d.41o",
	Color[1],Color[2],Color[3],Color[4],Color[5],Color[6],Color[7]);
   format[1] = arr1;
   format[2] = "\n%a",
   format[3] = NULL;

   color = 0;
   STEMdialog(AnimWindow,format,&color);

   switch (color)
   {
      case 0:
	 sprintf(colorstr,"TANGO_COLOR_BLACK");
	 *tangocolor = TANGO_COLOR_BLACK;
	 *ashcolor = Color[DANCE_BLACK];
	 break;
      case 1:
	 sprintf(colorstr,"TANGO_COLOR_RED");
	 *tangocolor = TANGO_COLOR_RED;
	 *ashcolor = Color[DANCE_RED];
	 break;
      case 2:
	 sprintf(colorstr,"TANGO_COLOR_ORANGE");
	 *tangocolor = TANGO_COLOR_ORANGE;
	 *ashcolor = Color[DANCE_ORANGE];
	 break;
      case 3:
	 sprintf(colorstr,"TANGO_COLOR_YELLOW");
	 *tangocolor = TANGO_COLOR_YELLOW;
	 *ashcolor = Color[DANCE_YELLOW];
	 break;
      case 4:
	 sprintf(colorstr,"TANGO_COLOR_GREEN");
	 *tangocolor = TANGO_COLOR_GREEN;
	 *ashcolor = Color[DANCE_GREEN];
	 break;
      case 5:
	 sprintf(colorstr,"TANGO_COLOR_BLUE");
	 *tangocolor = TANGO_COLOR_BLUE;
	 *ashcolor = Color[DANCE_BLUE];
	 break;
      case 6:
	 sprintf(colorstr,"TANGO_COLOR_MAROON");
	 *tangocolor = TANGO_COLOR_MAROON;
	 *ashcolor = Color[DANCE_MAROON];
	 break;
   }
}

