/***************************************************************/
/*							       */
/*		    DANCE PACKAGE (fct) 		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include  <dancelocal.h>



/***************************************************************/
/*   fctSceneDefine - start defining an animation scene function.*/
/*	Get the scene name and its params.  Print them on      */
/*	the screen.					       */
/***************************************************************/

int
fctSceneDefine(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   int response;
   char *format1 = "\nEnd current scene\n%0.1o Yes       %0.0o No\n\n %a";
   char name[32],params[32];
   static char *format2[4] = {
      "\nScene name\n%0.32t\n",
      "\nParameters (d-int f-double)\n%1.32t\n",
      "\n %a            %c",
      NULL };
   char *ptr;
   int i;
   char header[MAXSTRINGLENGTH],tail[MAXSTRINGLENGTH];
   int xt,dx,dy;
   ASH_FONT font;

   if (DefiningScene)
      { response = 1;
	if (STEMdialog1(AnimWindow,format1,&response))
	   { if (response)
		fctSceneEnd(data,menu,button,window);
	   }
      }
   name[0] = params[0] = '\0';
   if (STEMdialog(AnimWindow,format2,name,params) && (name[0] != '\0'))
      { SceneCurrent = (SCENE_PTR) malloc( sizeof (struct _SCENE));
	strcpy(SceneCurrent->name,name);
	for (ptr=params,i=0; *ptr; ptr++)
	   if (*ptr == 'd')
	      SceneCurrent->params[i++] = 0;
	   else if (*ptr == 'f')
	      SceneCurrent->params[i++] = 1;
	SceneCurrent->num_params = i;
	SceneCurrent->num_calls = 0;
	SceneCurrent->calls = NULL;
	SceneCurrent->call_tail = NULL;
	SceneCurrent->displays = NULL;
	SceneCurrent->display_tail = NULL;
	SceneCurrent->next = NULL;

	xt = 5;
	sprintf(header,"Defining scene:  %s(",name);
	font = ASHinq_font(AnimWindow);
	ASHtext(AnimWindow,xt,15,header);
	ASHinq_text_next(font,header,&dx,&dy);
	xt += dx;

	for (i=1; i<=SceneCurrent->num_params; ++i)
	   { sprintf(tail,"p%d",i);
	     new_display(DEMO_OBJ_PARAM,0,tail,xt,15);
	     ASHinq_text_next(LabelFont,tail,&dx,&dy);
	     xt += dx;
	     if (i != SceneCurrent->num_params)
		xt += 5;
	   }
	ASHtext(AnimWindow,xt,15,")");
	SceneCurrent->endx = xt;

	DefiningScene = 1;
      }
   return(1);
}




/***************************************************************/
/*   fctSceneEnd - Clear the definition window and close off	 */
/*	the current scene.				       */
/***************************************************************/

int
fctSceneEnd(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   if (!DefiningScene)
      { RIPprompt("No scene currently defined");
	return(1);
      }

   ASHclear_box(AnimWindow,0,Side,Side,0);
   if (SceneHead)
      SceneTail->next = SceneCurrent;
   else
      SceneHead = SceneCurrent;
   SceneTail = SceneCurrent;
   SceneCurrent = NULL;
   DefiningScene = 0;
   TransSet = 0;  /* needed by show_transition to display trans labels */
}



/***************************************************************/
/*   check_scenebegin - A TANGO command has been chose from a	 */
/*	menu.  Check to see if a scene has been defined yet.   */
/*	If not, force a definition.			       */
/***************************************************************/

int
check_scenebegin(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   if (!DefiningScene)
      { ASHbell();
	RIPprompt("No scene defined yet. => Define now.");
	fctSceneDefine();
	RIPprompt(" ");
      }
   if (DefiningScene)
      return(1);
   else
      return(0);
}




/***************************************************************/
/*   free_scene - free the space associated with a scene.      */
/*	Free its display pointers.			       */
/***************************************************************/

void
free_scene(scene)
   SCENE_PTR scene;
{
   CALL_PTR call,oldcall;
   DISPLAY_PTR disp;

   oldcall = scene->calls;
   while (oldcall)
      { call = oldcall->next;
	free(oldcall);
	oldcall = call;
      };
   disp = scene->displays;
   while (disp)
      { scene->displays = disp->next;
	if (disp->type == DEMO_OBJ_IMAGE)
	   free((DEMO_IMAGE)(disp->object));
	else if (disp->type == DEMO_OBJ_LOC)
	   free((TANGO_LOC)(disp->object));
	else if (disp->type == DEMO_OBJ_PATH)
	   path_free((TANGO_PATH)(disp->object)); /* in tangopath.c */
	else if (disp->type == DEMO_OBJ_TRANS)
	   demo_transition_free((DEMO_TRANS)(disp->object));
	free(disp);
	disp = scene->displays;
      };
   free(scene);
}



/***************************************************************/
/*   new_call - allocate and return a new call in the	       */
/*	current scene.					       */
/***************************************************************/

CALL_PTR
new_call(type)
   DEMO_OBJ_TYPE type;
{
   CALL_PTR cp;

   cp = (CALL_PTR) malloc( sizeof (struct _CALL));
   cp->call_type = type;
   cp->callstr[0] = '\0';
   cp->special = NULL;
   cp->num = ++SceneCurrent->num_calls;
   cp->next = NULL;

   if (SceneCurrent->calls)
      SceneCurrent->call_tail->next = cp;
   else
      SceneCurrent->calls = cp;
   SceneCurrent->call_tail = cp;
   return(cp);
}



