/***************************************************************/
/*							       */
/*		    DANCE PACKAGE (assoc)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include <dancelocal.h>


/***************************************************************/
/*   fctAssocMake - allow the user to create a new association */
/*	and designate its number of parameters. 	       */
/***************************************************************/

int
fctAssocMake(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char name[32];
   static char *format1[4] = {
      "\nAssociation name\n %0.32t\n",
      "\nNumber of parameters\n %1.32d\n",
      "\n%a               %c",
      NULL };
   int p;
   CALL_PTR  call;

   if (!check_scenebegin(data,menu,button,window))
      return(1);

   p = 0;
   name[0] = '\0';
   if (STEMdialog(AnimWindow,format1,name,&p) && (name[0] != '\0'))
      { call = new_call(DEMO_OBJ_ASSOC);
	sprintf(call->callstr,"ASSOCmake(\"%s\", %d);",name,p);
      }
   return(1);
}




/***************************************************************/
/*   fctAssocStore - allow the user to store an object under   */
/*	an association with a set of parameters (objects       */
/*	picked by mouse hits.)				       */
/***************************************************************/

int
fctAssocStore(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char name[32], params[32];
   static char *format1[3] = {
      "\nAssociation name\n %0.32t\n",
      "\n%a               %c",
      NULL };
   CALL_PTR  call;
   DISPLAY_PTR disp;

   if (!check_scenebegin(data,menu,button,window))
      return(1);

   RIPprompt("Store what object?  Use mouse to select.  (Press key to cancel)");
   disp = get_object();
   RIPprompt(" ");
   if (!disp) return(1);

   name[0] = '\0';
   if (STEMdialog(AnimWindow,format1,name) && (name[0] != '\0'))
      { call = new_call(DEMO_OBJ_ASSOC);
	get_params(params);
	if (params[0])
	   sprintf(call->callstr,"ASSOCstore(\"%s\", %s, %s);",name,params,disp->vname);
	else
	   sprintf(call->callstr,"ASSOCstore(\"%s\", %s);",name,disp->vname);
      }
   return(1);
}




/***************************************************************/
/*   fctAssocRetrieve - allow the user to specify an	       */
/*	association and a set of parameters to use to retrieve */
/*	an object.  Instantiate the object that she expects to */
/*	receive.  (It will probably be used in other calls.)   */
/***************************************************************/

int
fctAssocRetrieve(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   PT_PTR pt;
   char name[32], params[32], var[32];
   static char *format1[4] = {
      "\nAssociation name\n %0.32t\n",
      "\nObject's variable name\n %1.32t\n\n",
      "\n%a               %c",
      NULL };
   TANGO_LOC  loc;
   TANGO_PATH path;
   int choice;
   int x,y;
   char *format2 = "\nObject type retrieved? \n %0.0o  image\n %0.1o  location\n %0.2o  path\n\n%a";
   double pt1[2],pt2[2];
   static char *format3[4] = {
      "\nImage type?\n%0.0o  line\n%0.1o  rectangle",
      "%0.2o  circle\n%0.3o  ellipse\n%0.4o  polyline",
      "%0.5o  polygon\n%0.6o  spline\n%0.7o  text\n\n%a",
      NULL};
   CALL_PTR   call;
   DEMO_IMAGE image;
   char *typecast;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   name[0] = '\0';
   var[0] = '\0';
   if (STEMdialog(AnimWindow,format1,name,var) && (name[0] != '\0') && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_ASSOC);
	get_params(params);

	RIPprompt("Instantiate retrieved object");
	ASHbell();
	choice = 0;
	STEMdialog1(AnimWindow,format2,&choice);
	if (choice == 0)
	   { STEMdialog(AnimWindow,format3,&choice);
	     if (choice == 0)
		image = get_line();
	     else if (choice == 1)
		image = get_rect();
	     else if (choice == 2)
		image = get_circle();
	     else if (choice == 3)
		image = get_ellipse();
	     else if (choice == 4)
		image = get_polyline();
	     else if (choice == 5)
		image = get_polygon();
	     else if (choice == 6)
		image = get_spline();
	     else if (choice == 7)
		image = get_text();
	     new_display(DEMO_OBJ_IMAGE,image,var,0,0);
	     typecast = "(TANGO_IMAGE)";
	   }
	else if (choice == 1)
	   { RIPprompt("Designate roughly where the location will be");
	     pt = get_point();
	     RIPprompt(" ");
	     ASHfilled_circle(AnimWindow,pt->x,pt->y,2);
	     loc = TANGOloc_create(COORD(pt->x),COORD(pt->y));
	     new_display(DEMO_OBJ_LOC,loc,var,pt->x,pt->y);
	     typecast = "(TANGO_LOC)";
	   }
	else if (choice == 2)
	   { RIPinput_track(AnimWindow,
		 "Click down and drag to sketch what path would look like",get_a_path,-1);
	     path = (TANGO_PATH) ASHinq_user_data(AnimWindow);
	     if (!path)
		path = TANGOpath_null(1);
	     new_display(DEMO_OBJ_PATH,path,var,path->startx,path->starty);
	     typecast = "(TANGO_PATH)";
	   }
	if (params[0])
	   sprintf(call->callstr,"%s = %s ASSOCretrieve(\"%s\", %s);",
		    var,typecast,name,params);
	else
	   sprintf(call->callstr,"%s = %s ASSOCretrieve(\"%s\");",
		    var,typecast,name);
      }

   return(1);
}




/***************************************************************/
/*   get_params - allow the user to specify the params to an   */
/*	association by picking objects currently defined in    */
/*	the demo window.  They are taken in order, with a key  */
/*	click delimiting the choices.			       */
/***************************************************************/

void
get_params(params)
   char params[];
{
   DISPLAY_PTR disp;
   char s[MAXSTRINGLENGTH];

   params[0] = '\0';
   RIPprompt("Select objects for assoc params (in order 1->n). Press key to stop");
   do
      { disp = get_object();
	if (disp)
	   { if (params[0])
		{ sprintf(s,", %s",disp->vname);
		  strcat(params,s);
		}
	     else
		  strcat(params,disp->vname);
	     RIPprompt("Next object?  (key to cancel)");
	   }
	else
	   break;
      }
   while (1);
   RIPprompt(" ");
}
